/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.init.DefaultConfig;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;

public class DefaultConfigChain
extends DefaultConfig
implements ConfigChain {
    private List<Config> configs = new ArrayList<Config>();

    public DefaultConfigChain() {
    }

    @Override
    public String toString() {
        String str = null;
        if (null != this.configs) {
            for (Config conf : this.configs) {
                if (null == conf) continue;
                if (null == str) {
                    str = conf.toString();
                    continue;
                }
                str = str + "," + conf.toString();
            }
        }
        return "[" + str + "]";
    }

    @Override
    public String cacheKey() {
        String str = null;
        if (null != this.configs) {
            for (Config conf : this.configs) {
                if (null == conf) continue;
                if (null == str) {
                    str = conf.cacheKey();
                    continue;
                }
                str = str + "," + conf.cacheKey();
            }
        }
        return str;
    }

    public DefaultConfigChain(String config) {
        if (null == config) {
            return;
        }
        String[] configs = config.split("\\|");
        int size = configs.length;
        for (int i = 0; i < size; ++i) {
            String next;
            String item = configs[i];
            if (i + 1 < size && !(next = configs[i + 1]).contains(":")) {
                item = item + "|" + next;
                ++i;
            }
            DefaultConfig conf = new DefaultConfig(item);
            conf.setJoin(" OR ");
            if (conf.isEmpty()) continue;
            this.configs.add(conf);
        }
    }

    @Override
    public Config getConfig(String id, String var) {
        if (BasicUtil.isEmpty((Object[])new Object[]{id, var})) {
            return null;
        }
        for (Config conf : this.configs) {
            String confId = conf.getPrefix();
            String confVar = conf.getVariable();
            if (!(BasicUtil.isEmpty((Object)id) ? var.equalsIgnoreCase(confVar) : (BasicUtil.isEmpty((Object)var) ? id.equalsIgnoreCase(confId) : id.equalsIgnoreCase(confId) && var.equalsIgnoreCase(confVar)))) continue;
            return conf;
        }
        return null;
    }

    @Override
    public Config getConfig(String prefix, String var, Compare type) {
        if (BasicUtil.isEmpty((Object[])new Object[]{prefix, var})) {
            return null;
        }
        for (Config conf : this.configs) {
            String confId = conf.getPrefix();
            String confVar = conf.getVariable();
            Compare confType = conf.getCompare();
            if (!(BasicUtil.isEmpty((Object)prefix) ? var.equalsIgnoreCase(confVar) && type == confType : (BasicUtil.isEmpty((Object)var) ? prefix.equalsIgnoreCase(confId) && type == confType : prefix.equalsIgnoreCase(confId) && var.equalsIgnoreCase(confVar) && type == confType))) continue;
            return conf;
        }
        return null;
    }

    @Override
    public ConfigChain removeConfig(String key, String var) {
        Config config = this.getConfig(key, var);
        return this.removeConfig(config);
    }

    @Override
    public ConfigChain removeConfig(String key, String var, Compare type) {
        Config config = this.getConfig(key, var, type);
        return this.removeConfig(config);
    }

    @Override
    public ConfigChain removeConfig(Config config) {
        if (null != config) {
            this.configs.remove(config);
        }
        return this;
    }

    @Override
    public void addConfig(Config config) {
        this.configs.add(config);
    }

    @Override
    public List<Object> getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Config config : this.configs) {
            values.addAll(config.getValues());
        }
        return values;
    }

    @Override
    public List<Config> getConfigs() {
        return this.configs;
    }

    @Override
    public ConditionChain createAutoConditionChain() {
        DefaultAutoConditionChain chain = new DefaultAutoConditionChain();
        for (Config config : this.configs) {
            Condition condition = config.createAutoCondition(chain);
            if (null == condition) continue;
            chain.addCondition(condition);
        }
        return chain;
    }

    @Override
    public void setValue(Map<String, Object> values) {
        for (Config config : this.configs) {
            config.setValue(values);
        }
    }
}

