/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.xml.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.SyntaxHelper;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.init.DefaultPrepare;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.prepare.xml.init.DefaultXMLCondition;
import org.anyline.data.prepare.xml.init.DefaultXMLConditionChain;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class DefaultXMLPrepare
extends DefaultPrepare
implements XMLPrepare {
    private String id;
    private String text;
    private boolean strict = true;
    private List<Variable> variables;

    public DefaultXMLPrepare() {
        this.chain = new DefaultXMLConditionChain();
    }

    @Override
    public RunPrepare init() {
        if (null == this.variables) {
            this.variables = new ArrayList<Variable>();
        }
        for (Variable variable : this.variables) {
            if (null == variable) continue;
            variable.init();
        }
        if (null != this.chain) {
            for (Condition condition : this.chain.getConditions()) {
                if (null == condition) continue;
                condition.init();
            }
        }
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultXMLPrepare clone = (DefaultXMLPrepare)super.clone();
        clone.chain = (ConditionChain)this.chain.clone();
        if (null != this.variables) {
            ArrayList<Variable> cVariables = new ArrayList<Variable>();
            for (Variable var : this.variables) {
                if (null == var) continue;
                cVariables.add((Variable)var.clone());
            }
            clone.variables = cVariables;
        }
        return clone;
    }

    @Override
    public RunPrepare setText(String text) {
        if (null == text) {
            return this;
        }
        this.text = text = text.replaceAll("--.*", "");
        this.parseText();
        return this;
    }

    @Override
    public RunPrepare addCondition(String condition) {
        if (BasicUtil.isEmpty((Object)condition)) {
            return this;
        }
        if (condition.contains(":")) {
            ParseResult parser = ConfigParser.parse(condition, false);
            String prefix = parser.getPrefix();
            String var = null;
            List<Object> value = ConfigParser.getValues(parser);
            if (prefix.contains(".")) {
                String[] keys = prefix.split(".");
                prefix = keys[0];
                if (keys.length > 1) {
                    var = keys[1];
                }
            }
            this.setConditionValue(prefix, var, value);
        }
        return this;
    }

    private void parseText() {
        if (null == this.text) {
            return;
        }
        try {
            List keys = RegularUtil.fetchs((String)this.text, (String)"(\\S+)\\s*\\(?(\\s*:+\\w+)(\\s|'|\\)|%|\\,)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            int type = 1;
            if (keys.size() == 0) {
                keys = RegularUtil.fetchs((String)this.text, (String)"([^\\s$]+)\\s*\\(?(\\s*\\$*{\\w+})(\\+|\\s|'|\\)|%)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
                type = 2;
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)keys)) {
                for (int i = 0; i < keys.size(); ++i) {
                    List keyItem = (List)keys.get(i);
                    Variable var = SyntaxHelper.buildVariable(type, (String)keyItem.get(0), (String)keyItem.get(1), (String)keyItem.get(2), (String)keyItem.get(3));
                    var.setRequired(true);
                    this.addVariable(var);
                }
            } else {
                List idxKeys = RegularUtil.fetch((String)this.text, (String)"\\?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN, (int)0);
                if (BasicUtil.isNotEmpty((boolean)true, (Object)idxKeys)) {
                    for (int i = 0; i < idxKeys.size(); ++i) {
                        DefaultVariable var = new DefaultVariable();
                        var.setType(0);
                        var.setRequired(true);
                        this.addVariable(var);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addVariable(Variable var) {
        if (null == this.variables) {
            this.variables = new ArrayList<Variable>();
        }
        this.variables.add(var);
    }

    @Override
    public RunPrepare setConditionValue(String condition, String variable, Object value) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (!v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        DefaultXMLCondition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    private DefaultXMLCondition getCondition(String id) {
        if (null == this.chain) {
            return null;
        }
        for (Condition con : this.chain.getConditions()) {
            if (!BasicUtil.equalsIgnoreCase((Object)id, (Object)con.getId())) continue;
            return (DefaultXMLCondition)con;
        }
        return null;
    }

    @Override
    public RunPrepare setDataSource(String ds) {
        this.id = ds;
        return this;
    }

    @Override
    public String getDataSource() {
        return this.id;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public List<Variable> getSQLVariables() {
        return this.variables;
    }

    @Override
    public String getTable() {
        return null;
    }

    @Override
    public List<String> getColumns() {
        return null;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

