/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.dao.init.springjdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.dao.AnylineDao;
import org.anyline.dao.init.BatchInsertStore;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Database;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.anyline.data.jdbc.util.SQLAdapterUtil;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.Procedure;
import org.anyline.data.prepare.ProcedureParam;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.exception.AnylineException;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.util.AdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.dao")
public class DefaultDao<E>
implements AnylineDao<E> {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDao.class);
    @Autowired(required=false)
    protected JdbcTemplate jdbc;
    @Autowired(required=false)
    protected DMListener listener;
    protected BatchInsertStore batchInsertStore = new BatchInsertStore();
    protected static boolean isBatchInsertRun = false;
    private static Map<String, Map<String, String>> table_maps = new HashMap<String, Map<String, String>>();

    public JdbcTemplate getJdbc() {
        return this.jdbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        List<Map<String, Object>> maps = null;
        try {
            JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + DataSourceHolder.getDataSource() + "]";
                log.warn(tmp);
            }
            if (run.isValid()) {
                if (null != this.listener) {
                    this.listener.beforeQuery((AnylineDao)this, run);
                }
                maps = this.maps(adapter, run.getFinalQuery(), run.getValues());
                if (null != this.listener) {
                    this.listener.afterQuery((AnylineDao)this, run, maps);
                }
                if (null != adapter) {
                    maps = adapter.process(maps);
                }
            } else {
                maps = new ArrayList<Map<String, Object>>();
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return maps;
    }

    @Override
    public List<Map<String, Object>> maps(RunPrepare prepare, String ... conditions) {
        return this.maps(prepare, (ConfigStore)null, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set = null;
        try {
            JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false]";
                String src = "";
                src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + DataSourceHolder.getDataSource() + "]";
                log.warn(tmp);
            }
            PageNavi navi = run.getPageNavi();
            int total = 0;
            if (run.isValid()) {
                if (null != navi) {
                    if (null != this.listener) {
                        this.listener.beforeTotal(this, run);
                    }
                    if (navi.getLastRow() == 0) {
                        total = 1;
                    } else if (navi.getTotalRow() == 0) {
                        total = this.getTotal(run.getTotalQuery(), run.getValues());
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != this.listener) {
                        this.listener.afterTotal(this, run, total);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            if (run.isValid() && (null == navi || total > 0)) {
                if (null != this.listener) {
                    this.listener.beforeQuery((AnylineDao)this, run);
                }
                set = this.select(adapter, run.getFinalQuery(), run.getValues());
                if (null != this.listener) {
                    this.listener.afterQuery((AnylineDao)this, run, set);
                }
            } else {
                set = new DataSet();
            }
            set.setDataSource(prepare.getDataSource());
            set.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return set;
    }

    @Override
    public <T> EntitySet<T> querys(Class<T> clazz, ConfigStore configs, String ... conditions) {
        DefaultTablePrepare prepare = new DefaultTablePrepare();
        return this.querys((RunPrepare)prepare, clazz, configs, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> EntitySet<T> querys(RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list = null;
        try {
            if (AdapterProxy.hasAdapter()) {
                prepare.setDataSource(AdapterProxy.table(clazz));
            }
            JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
            Run run = adapter.buildQueryRun(prepare, configs, conditions);
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled() && !run.isValid()) {
                String tmp = "[valid:false]";
                tmp = tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, clazz.getName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + DataSourceHolder.getDataSource() + "]";
                log.warn(tmp);
            }
            PageNavi navi = run.getPageNavi();
            int total = 0;
            if (run.isValid()) {
                if (null != navi) {
                    if (null != this.listener) {
                        this.listener.beforeTotal(this, run);
                    }
                    if (navi.getLastRow() == 0) {
                        total = 1;
                    } else if (navi.getTotalRow() == 0) {
                        total = this.getTotal(run.getTotalQuery(), run.getValues());
                        navi.setTotalRow(total);
                    } else {
                        total = navi.getTotalRow();
                    }
                    if (null != this.listener) {
                        this.listener.afterTotal(this, run, total);
                    }
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
                }
            }
            if (run.isValid() && (null == navi || total > 0)) {
                if (null != this.listener) {
                    this.listener.beforeQuery((AnylineDao)this, run);
                }
                list = this.select(adapter, clazz, run.getFinalQuery(), run.getValues());
                if (null != this.listener) {
                    this.listener.afterQuery((AnylineDao)this, run, list);
                }
            } else {
                list = new EntitySet<T>();
            }
            list.setNavi(navi);
            if (null != navi && navi.isLazy()) {
                PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return list;
    }

    @Override
    public DataSet querys(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(prepare, configs, conditions);
    }

    @Override
    public DataSet selects(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int count = -1;
        try {
            Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildQueryRun(prepare, configs, conditions);
            if (null != this.listener) {
                this.listener.beforeCount(this, run);
            }
            count = this.getTotal(run.getTotalQuery(), run.getValues());
            if (null != this.listener) {
                this.listener.afterCount(this, run, count);
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return count;
    }

    @Override
    public int count(RunPrepare prepare, String ... conditions) {
        return this.count(prepare, (ConfigStore)null, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        try {
            Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildQueryRun(prepare, configs, conditions);
            String txt = run.getFinalExists();
            List<Object> values = run.getValues();
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = DefaultDao.random();
                log.warn("{}[txt:\n{}\n]", (Object)random, (Object)txt);
                log.warn("{}[\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(values));
            }
            try {
                if (null != this.listener) {
                    this.listener.beforeExists(this, run);
                }
                Map map = null;
                map = null != values && values.size() > 0 ? this.getJdbc().queryForMap(txt, values.toArray()) : this.getJdbc().queryForMap(txt);
                result = null == map ? false : BasicUtil.parseBoolean(map.get("IS_EXISTS"), (Boolean)false);
                if (null != this.listener) {
                    this.listener.afterExists(this, run, result);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - fr, LogUtil.format((boolean)result, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.error("[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38", (int)33), prepare});
                    log.error("{}[\u53c2\u6570][param:{}]", (Object)random, (Object)this.paramLogFormat(values));
                }
                throw e;
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public boolean exists(RunPrepare prepare, String ... conditions) {
        return this.exists(prepare, (ConfigStore)null, conditions);
    }

    protected int getTotal(String sql, List<Object> values) {
        int total = 0;
        DataSet set = this.select(null, sql, values);
        total = set.getInt(0, "CNT", 0);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        int result = 0;
        if (data instanceof DataSet) {
            DataSet set = (DataSet)data;
            for (int i = 0; i < set.size(); ++i) {
                result += this.update(dest, (Object)set.getRow(i), configs, columns);
            }
            return result;
        }
        Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildUpdateRun(dest, data, configs, false, columns);
        String sql = run.getFinalUpdate();
        if (BasicUtil.isEmpty((Object)sql)) {
            log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)dest);
            return -1;
        }
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn(random + "[txt:\n{}\n]", (Object)sql);
            log.warn(random + "[\u53c2\u6570:{}]", (Object)this.paramLogFormat(run.getUpdateColumns(), values));
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeUpdate(this, run, dest, data, columns);
            }
            if (listenerResult) {
                result = this.getJdbc().update(sql, values.toArray());
                if (null != this.listener) {
                    this.listener.afterUpdate(this, run, result, dest, data, columns);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", (Object)(System.currentTimeMillis() - fr), (Object)LogUtil.format((int)result, (int)34));
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38", (int)33), sql});
                log.error("{}[\u53c2\u6570][param:{}]", (Object)random, (Object)this.paramLogFormat(run.getUpdateColumns(), values));
            }
            e.printStackTrace();
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38", e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int update(Object data, ConfigStore configs, String ... columns) {
        return this.update(null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, ConfigStore configs, List<String> columns) {
        return this.update(null, data, configs, columns);
    }

    @Override
    public int update(String dest, Object data, String ... columns) {
        return this.update(dest, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(Object data, String ... columns) {
        return this.update(null, data, (ConfigStore)null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int update(String dest, Object data, List<String> columns) {
        return this.update(dest, data, (ConfigStore)null, columns);
    }

    @Override
    public int update(Object data, List<String> columns) {
        return this.update(null, data, (ConfigStore)null, columns);
    }

    @Override
    public int save(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            int cnt = 0;
            for (Object item : items) {
                cnt += this.save(dest, item, checkPrimary, columns);
            }
            return cnt;
        }
        return this.saveObject(dest, data, checkPrimary, columns);
    }

    @Override
    public int save(Object data, boolean checkPrimary, String ... columns) {
        return this.save(null, data, checkPrimary, columns);
    }

    @Override
    public int save(String dest, Object data, String ... columns) {
        return this.save(dest, data, false, columns);
    }

    @Override
    public int save(Object data, String ... columns) {
        return this.save(null, data, false, columns);
    }

    protected int saveObject(String dest, Object data, boolean checkPrimary, String ... columns) {
        if (null == data) {
            return 0;
        }
        if (this.checkIsNew(data)) {
            return this.insert(dest, data, checkPrimary, columns);
        }
        return this.update(dest, data, columns);
    }

    protected boolean checkIsNew(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            return row.isNew();
        }
        if (AdapterProxy.hasAdapter()) {
            Map values = AdapterProxy.primaryValues((Object)obj);
            for (Map.Entry entry : values.entrySet()) {
                if (!BasicUtil.isNotEmpty(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(String dest, Object data, boolean checkPrimary, List<String> columns) {
        Run run;
        DataSet set;
        Map tags;
        JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
        if (null != data && data instanceof DataSet && null != (tags = (set = (DataSet)data).getTags()) && tags.size() > 0) {
            LinkedHashMap<String, PartitionTable> ptables = this.ptables(new MasterTable(dest), tags);
            if (ptables.size() != 1) {
                throw new SQLUpdateException("\u5206\u533a\u8868\u5b9a\u4f4d\u5f02\u5e38,\u4e3b\u8868:" + dest + ",\u6807\u7b7e:" + BeanUtil.map2json((Map)tags) + ",\u5206\u533a\u8868:" + BeanUtil.object2json(ptables.keySet()));
            }
            dest = ptables.values().iterator().next().getName();
        }
        if (null == (run = adapter.buildInsertRun(dest, data, checkPrimary, columns))) {
            return 0;
        }
        int cnt = 0;
        String sql = run.getFinalInsert();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn(random + "[txt:\n{}\n]", (Object)sql);
            log.warn(random + "[\u53c2\u6570:{}]", (Object)this.paramLogFormat(run.getInsertColumns(), values));
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeInsert(this, run, dest, data, checkPrimary, columns);
            }
            if (listenerResult) {
                cnt = adapter.insert(random, data, sql, values, null);
                if (null != this.listener) {
                    this.listener.afterInsert(this, run, cnt, dest, data, checkPrimary, columns);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - fr, LogUtil.format((int)cnt, (int)34)});
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38", (int)33), sql});
                log.error("{}[\u53c2\u6570][param:{}]", (Object)random, (Object)this.paramLogFormat(run.getInsertColumns(), values));
            }
            e.printStackTrace();
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38", e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return cnt;
    }

    @Override
    public int insert(Object data, boolean checkPrimary, List<String> columns) {
        return this.insert(null, data, checkPrimary, columns);
    }

    @Override
    public int insert(String dest, Object data, List<String> columns) {
        return this.insert(dest, data, false, columns);
    }

    @Override
    public int insert(Object data, List<String> columns) {
        return this.insert(null, data, false, columns);
    }

    @Override
    public int insert(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, boolean checkPrimary, String ... columns) {
        return this.insert(null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(String dest, Object data, String ... columns) {
        return this.insert(dest, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public int insert(Object data, String ... columns) {
        return this.insert(null, data, false, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int batchInsert(final String dest, Object data, final boolean checkPrimary, final String ... columns) {
        if (null == data) {
            return 0;
        }
        if (data instanceof DataSet) {
            DataSet set = (DataSet)data;
            int size = set.size();
            for (int i = 0; i < size; ++i) {
                this.batchInsert(dest, (Object)set.getRow(i), checkPrimary, columns);
            }
        }
        String table = DataSourceHolder.parseDataSource(dest, data);
        List<String> cols = SQLAdapterUtil.getAdapter(this.getJdbc()).confirmInsertColumns(dest, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
        String strCols = "";
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            String col = cols.get(i);
            strCols = strCols + "," + col;
        }
        final int sleep = ConfigTable.getInt((String)"BATCH_INSERT_SLEEP_MILLIS", (int)1000);
        BatchInsertStore batchInsertStore = this.batchInsertStore;
        synchronized (batchInsertStore) {
            this.batchInsertStore.addData(table, strCols, (DataRow)data);
            if (!isBatchInsertRun) {
                isBatchInsertRun = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                DataSet list;
                                if (null != (list = DefaultDao.this.batchInsertStore.getDatas()) && list.size() > 0) {
                                    boolean listenerResult = true;
                                    if (null != DefaultDao.this.listener) {
                                        listenerResult = DefaultDao.this.listener.beforeBatchInsert(DefaultDao.this, dest, list, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
                                    }
                                    if (!listenerResult) continue;
                                    int cnt = DefaultDao.this.insert(dest, (Object)list, checkPrimary, columns);
                                    if (null == DefaultDao.this.listener) continue;
                                    DefaultDao.this.listener.afterBatchInsert(DefaultDao.this, cnt, dest, list, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
                                    continue;
                                }
                                Thread.sleep(sleep);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }).start();
            }
        }
        return 0;
    }

    @Override
    public int batchInsert(Object data, boolean checkPrimary, String ... columns) {
        return this.batchInsert(null, data, checkPrimary, columns);
    }

    @Override
    public int batchInsert(String dest, Object data, String ... columns) {
        return this.batchInsert(dest, data, false, columns);
    }

    @Override
    public int batchInsert(Object data, String ... columns) {
        return this.batchInsert(null, data, false, columns);
    }

    protected List<Map<String, Object>> maps(JDBCAdapter adapter, String sql, List<Object> values) {
        List<Map<String, Object>> maps;
        block8: {
            maps = null;
            if (BasicUtil.isEmpty((Object)sql)) {
                throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
            }
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = DefaultDao.random();
                log.warn(random + "[txt:\n{}\n]", (Object)sql);
                log.warn(random + "[\u53c2\u6570:{}]", (Object)this.paramLogFormat(values));
            }
            try {
                maps = null != values && values.size() > 0 ? this.getJdbc().queryForList(sql, values.toArray()) : this.getJdbc().queryForList(sql);
                long mid = System.currentTimeMillis();
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u6267\u884c\u8017\u65f6:{}ms]", (Object)(mid - fr));
                }
                if (null != adapter) {
                    maps = adapter.process(maps);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", (Object)(System.currentTimeMillis() - mid), (Object)maps.size());
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.error("[{}][txt:\n{}\n]", new Object[]{LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38", (int)33), random, sql});
                    log.error("[{}][\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(values));
                }
                e.printStackTrace();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block8;
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38");
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return maps;
    }

    protected DataSet select(JDBCAdapter adapter, String sql, List<Object> values) {
        DataSet set;
        block9: {
            if (BasicUtil.isEmpty((Object)sql)) {
                throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
            }
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = DefaultDao.random();
                log.warn(random + "[txt:\n{}\n]", (Object)sql);
                log.warn(random + "[\u53c2\u6570:{}]", (Object)this.paramLogFormat(values));
            }
            set = new DataSet();
            try {
                List<Map<String, Object>> list = null;
                list = null != values && values.size() > 0 ? this.getJdbc().queryForList(sql, values.toArray()) : this.getJdbc().queryForList(sql);
                long mid = System.currentTimeMillis();
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u6267\u884c\u8017\u65f6:{}ms]", (Object)(mid - fr));
                }
                if (null != adapter) {
                    list = adapter.process(list);
                }
                for (Map map : list) {
                    DataRow row = new DataRow(map);
                    row.clearUpdateColumns();
                    set.add(row);
                }
                set.setDatalink(DataSourceHolder.getDataSource());
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", (Object)(System.currentTimeMillis() - mid), (Object)list.size());
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.error("[{}][txt:\n{}\n]", new Object[]{LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38", (int)33), random, sql});
                    log.error("[{}][\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(values));
                }
                e.printStackTrace();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block9;
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38", e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return set;
    }

    protected <T> EntitySet<T> select(JDBCAdapter adapter, Class<T> clazz, String sql, List<Object> values) {
        EntitySet set;
        block10: {
            if (BasicUtil.isEmpty((Object)sql)) {
                throw new SQLQueryException("\u672a\u6307\u5b9aSQL");
            }
            long fr = System.currentTimeMillis();
            String random = "";
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = DefaultDao.random();
                log.warn(random + "[txt:\n{}\n]", (Object)sql);
                log.warn(random + "[\u53c2\u6570:{}]", (Object)this.paramLogFormat(values));
            }
            set = new EntitySet();
            try {
                List<Map<String, Object>> list = null;
                list = null != values && values.size() > 0 ? this.getJdbc().queryForList(sql, values.toArray()) : this.getJdbc().queryForList(sql);
                long mid = System.currentTimeMillis();
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u6267\u884c\u8017\u65f6:{}ms]", (Object)(mid - fr));
                }
                if (null != adapter) {
                    list = adapter.process(list);
                }
                for (Map map : list) {
                    Object row;
                    if (AdapterProxy.hasAdapter()) {
                        row = AdapterProxy.entity(clazz, (Map)map);
                        set.add(row);
                        continue;
                    }
                    row = BeanUtil.map2object((Map)map, clazz, (String[])new String[0]);
                    set.add(row);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", (Object)(System.currentTimeMillis() - mid), (Object)list.size());
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                    log.error("{}[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38", (int)33), sql});
                    log.error("{}}[\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(values));
                }
                e.printStackTrace();
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block10;
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38", e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return set;
    }

    @Override
    public int execute(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        int result = -1;
        Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildExecuteRun(prepare, configs, conditions);
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false]");
            }
            return -1;
        }
        String txt = run.getFinalExecute();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn(random + "[txt:\n{}\n]", (Object)txt);
            log.warn(random + "[\u53c2\u6570:{}]", (Object)this.paramLogFormat(values));
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeExecute((AnylineDao)this, run);
            }
            if (listenerResult) {
                result = null != values && values.size() > 0 ? this.getJdbc().update(txt, values.toArray()) : this.getJdbc().update(txt);
                if (null != this.listener) {
                    this.listener.afterExecute((AnylineDao)this, run, result);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn(random + "[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", (Object)(System.currentTimeMillis() - fr), (Object)LogUtil.format((int)result, (int)34));
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{},[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"SQL\u6267\u884c\u5f02\u5e38", (int)33), prepare});
                log.error("{}[\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(values));
            }
            throw e;
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    @Override
    public int execute(RunPrepare prepare, String ... conditions) {
        return this.execute(prepare, (ConfigStore)null, conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(final Procedure procedure) {
        boolean result = false;
        ArrayList<Object> list = new ArrayList();
        final List<ProcedureParam> inputs = procedure.getInputs();
        final List<ProcedureParam> outputs = procedure.getOutputs();
        long fr = System.currentTimeMillis();
        String random = "";
        String sql = " {";
        boolean returnIndex = false;
        if (procedure.hasReturn()) {
            sql = sql + "? = ";
            returnIndex = true;
        }
        sql = sql + "call " + procedure.getName() + "(";
        final int sizeIn = inputs.size();
        final int sizeOut = outputs.size();
        int size = sizeIn + sizeOut;
        for (int i = 0; i < size; ++i) {
            sql = sql + "?";
            if (i >= size - 1) continue;
            sql = sql + ",";
        }
        sql = sql + ")}";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
            log.warn("{}[\u8f93\u5165\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(inputs));
            log.warn("{}[\u8f93\u51fa\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(outputs));
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeExecute((AnylineDao)this, procedure);
            }
            if (listenerResult) {
                list = (List)this.getJdbc().execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                    public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                        ProcedureParam param;
                        int i;
                        ArrayList<Object> result = new ArrayList<Object>();
                        int returnIndex = 0;
                        if (procedure.hasReturn()) {
                            returnIndex = 1;
                            cs.registerOutParameter(1, 12);
                        }
                        for (i = 1; i <= sizeIn; ++i) {
                            param = (ProcedureParam)inputs.get(i - 1);
                            Object value = param.getValue();
                            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                                value = null;
                            }
                            cs.setObject(i + returnIndex, value, (int)param.getType());
                        }
                        for (i = 1; i <= sizeOut; ++i) {
                            param = (ProcedureParam)outputs.get(i - 1);
                            if (null == param.getValue()) {
                                cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                                continue;
                            }
                            cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
                        }
                        cs.execute();
                        if (procedure.hasReturn()) {
                            result.add(cs.getObject(1));
                        }
                        if (sizeOut > 0) {
                            for (i = 1; i <= sizeOut; ++i) {
                                Object output = cs.getObject(sizeIn + returnIndex + i);
                                result.add(output);
                            }
                        }
                        return result;
                    }
                });
                procedure.setResult(list);
                result = true;
                if (null != this.listener) {
                    this.listener.afterExecute((AnylineDao)this, procedure, result);
                }
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(System.currentTimeMillis() - fr));
                    log.warn("{}[\u8f93\u51fa\u53c2\u6570:{}]", (Object)random, list);
                }
            }
        }
        catch (Exception e) {
            result = false;
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38", (int)33), sql});
                log.error("{}[\u8f93\u5165\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(inputs));
                log.error("{}[\u8f93\u51fa\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(outputs));
            }
            e.printStackTrace();
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("execute\u5f02\u5e38", e);
                ex.setSql(sql);
                throw ex;
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet querys(final Procedure procedure, final PageNavi navi) {
        final List<ProcedureParam> inputs = procedure.getInputs();
        final List<ProcedureParam> outputs = procedure.getOutputs();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)procedure.getName());
            log.warn("{}[\u8f93\u5165\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(inputs));
            log.warn("{}[\u8f93\u51fa\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(inputs));
        }
        final String rdm = random;
        DataSet set = null;
        try {
            if (null != this.listener) {
                this.listener.beforeQuery((AnylineDao)this, procedure);
            }
            set = (DataSet)this.getJdbc().execute(new CallableStatementCreator(){

                public CallableStatement createCallableStatement(Connection conn) throws SQLException {
                    ProcedureParam param;
                    int i;
                    String sql = "{call " + procedure.getName() + "(";
                    int sizeIn = inputs.size();
                    int sizeOut = outputs.size();
                    int size = sizeIn + sizeOut;
                    for (int i2 = 0; i2 < size; ++i2) {
                        sql = sql + "?";
                        if (i2 >= size - 1) continue;
                        sql = sql + ",";
                    }
                    sql = sql + ")}";
                    CallableStatement cs = conn.prepareCall(sql);
                    for (i = 1; i <= sizeIn; ++i) {
                        param = (ProcedureParam)inputs.get(i - 1);
                        Object value = param.getValue();
                        if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                            value = null;
                        }
                        cs.setObject(i, value, (int)param.getType());
                    }
                    for (i = 1; i <= sizeOut; ++i) {
                        param = (ProcedureParam)outputs.get(i - 1);
                        if (null == param.getValue()) {
                            cs.registerOutParameter(i + sizeIn, (int)param.getType());
                            continue;
                        }
                        cs.setObject(i, param.getValue(), (int)param.getType());
                    }
                    return cs;
                }
            }, (CallableStatementCallback)new CallableStatementCallback<Object>(){

                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    ResultSet rs = cs.executeQuery();
                    DataSet set = new DataSet();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int cols = rsmd.getColumnCount();
                    for (int i = 1; i <= cols; ++i) {
                        set.addHead(rsmd.getColumnName(i));
                    }
                    long mid = System.currentTimeMillis();
                    int index = 0;
                    int first = -1;
                    int last = -1;
                    if (null != navi) {
                        first = navi.getFirstRow();
                        last = navi.getLastRow();
                    }
                    while (rs.next()) {
                        if (first == -1 || index >= first && index <= last) {
                            DataRow row = new DataRow();
                            for (int i = 1; i <= cols; ++i) {
                                row.put(rsmd.getColumnName(i), rs.getObject(i));
                            }
                            set.addRow(row);
                        }
                        if (first == -1 || ++index <= last && (first != 0 || last != 0)) continue;
                    }
                    if (null != navi) {
                        navi.setTotalRow(index);
                        set.setNavi(navi);
                    }
                    set.setDatalink(DataSourceHolder.getDataSource());
                    if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                        log.warn("{}[\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, System.currentTimeMillis() - mid, set.size()});
                    }
                    return set;
                }
            });
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(System.currentTimeMillis() - fr));
            }
            if (null != this.listener) {
                this.listener.afterQuery((AnylineDao)this, procedure, set);
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38", (int)33), procedure.getName()});
                log.error("{}[\u8f93\u5165\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(inputs));
                log.error("{}[\u8f93\u51fa\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(inputs));
            }
            e.printStackTrace();
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38", e);
                throw ex;
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return set;
    }

    @Override
    public int deletes(String table, String key, Collection<Object> values) {
        Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDeleteRun(table, key, values);
        int result = this.exeDelete(run);
        return result;
    }

    @Override
    public int deletes(String table, String key, String ... values) {
        ArrayList<String> list = new ArrayList<String>();
        if (null != values) {
            for (String value : values) {
                list.add(value);
            }
        }
        Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDeleteRun(table, key, list);
        int result = this.exeDelete(run);
        return result;
    }

    @Override
    public int delete(String dest, Object obj, String ... columns) {
        int size = 0;
        if (null != obj) {
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                for (Object item : list) {
                    size += this.delete(dest, item, columns);
                }
                log.warn("[delete Collection][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((int)size, (int)34));
            } else {
                Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDeleteRun(dest, obj, columns);
                size = this.exeDelete(run);
            }
        }
        return size;
    }

    @Override
    public int delete(String table, ConfigStore configs, String ... conditions) {
        Run run = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDeleteRun(table, configs, conditions);
        int result = this.exeDelete(run);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int exeDelete(Run run) {
        int result = 0;
        String sql = run.getFinalDelete();
        List<Object> values = run.getValues();
        long fr = System.currentTimeMillis();
        String random = "";
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
            log.warn("{}[\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(values));
        }
        try {
            boolean listenerResult = true;
            if (null != this.listener) {
                listenerResult = this.listener.beforeDelete(this, run);
            }
            if (listenerResult) {
                result = null == values ? this.getJdbc().update(sql) : this.getJdbc().update(sql, values.toArray());
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - fr, LogUtil.format((int)result, (int)34)});
                }
                if (null != this.listener) {
                    this.listener.afterDelete(this, run, result);
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_SHOW_SQL_WHEN_ERROR) {
                log.error("{}[{}][txt:\n{}\n]", new Object[]{random, LogUtil.format((String)"\u5220\u9664\u5f02\u5e38", (int)33), sql});
                log.error("{}[\u53c2\u6570:{}]", (Object)random, (Object)this.paramLogFormat(values));
            }
            result = 0;
            e.printStackTrace();
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("delete\u5f02\u5e38", e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        finally {
            if (DataSourceHolder.isAutoDefault()) {
                DataSourceHolder.recoverDataSource();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Database> databases() {
        LinkedHashMap<String, Database> databases = new LinkedHashMap<String, Database>();
        DataSource ds = null;
        Connection con = null;
        JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
        String random = DefaultDao.random();
        try {
            long fr;
            block12: {
                fr = System.currentTimeMillis();
                ds = this.getJdbc().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                Map<String, String> table_map = table_maps.get(DataSourceHolder.getDataSource() + "");
                if (null == table_map) {
                    table_map = new HashMap<String, String>();
                    table_maps.put(DataSourceHolder.getDataSource() + "", table_map);
                }
                try {
                    List<String> sqls = adapter.buildQueryDatabaseRunSQL();
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(adapter, sql, null).toUpperKey();
                            databases = adapter.databases(idx++, true, databases, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block12;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.getMessage()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, databases.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return databases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Table> tables(String catalog, String schema, String pattern, String types) {
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        DataSource ds = null;
        Connection con = null;
        JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
        String random = DefaultDao.random();
        try {
            String[] tps;
            long fr;
            block21: {
                Map<String, String> table_map;
                fr = System.currentTimeMillis();
                ds = this.getJdbc().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                if (null == catalog) {
                    catalog = con.getCatalog();
                }
                if (null == schema) {
                    schema = con.getSchema();
                }
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                if (null == (table_map = table_maps.get(DataSourceHolder.getDataSource() + ""))) {
                    table_map = new HashMap<String, String>();
                    table_maps.put(DataSourceHolder.getDataSource() + "", table_map);
                }
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, Table> all = this.tables(catalog, schema, null, types);
                        for (Table table : all.values()) {
                            table_map.put(table.getName().toUpperCase(), table.getName());
                        }
                    }
                    if (table_map.containsKey(pattern.toUpperCase())) {
                        pattern = table_map.get(pattern.toUpperCase());
                    }
                }
                try {
                    List<String> sqls = adapter.buildQueryTableRunSQL(catalog, schema, pattern, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(adapter, sql, null).toUpperKey();
                            tables = adapter.tables(idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block21;
                    log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.getMessage()});
                }
            }
            try {
                ResultSet set = con.getMetaData().getTables(catalog, schema, pattern, tps);
                tables = adapter.tables(true, catalog, schema, tables, set);
            }
            catch (Exception e) {
                log.warn("{}[tables][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.getMessage()});
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, Table> tables(String schema, String name, String types) {
        return this.tables(null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(String name, String types) {
        return this.tables(null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables(String types) {
        return this.tables(null, null, null, types);
    }

    @Override
    public LinkedHashMap<String, Table> tables() {
        return this.tables(null, null, null, "TABLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, MasterTable> mtables(String catalog, String schema, String pattern, String types) {
        LinkedHashMap<String, MasterTable> tables = new LinkedHashMap<String, MasterTable>();
        DataSource ds = null;
        Connection con = null;
        JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
        String random = DefaultDao.random();
        try {
            String[] tps;
            long fr;
            block21: {
                Map<String, String> table_map;
                fr = System.currentTimeMillis();
                ds = this.getJdbc().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                if (null == catalog) {
                    catalog = con.getCatalog();
                }
                if (null == schema) {
                    schema = con.getSchema();
                }
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                if (null == (table_map = table_maps.get(DataSourceHolder.getDataSource() + ""))) {
                    table_map = new HashMap<String, String>();
                    table_maps.put(DataSourceHolder.getDataSource() + "", table_map);
                }
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, MasterTable> all = this.mtables(catalog, schema, null, types);
                        for (Table table : all.values()) {
                            table_map.put(table.getName().toUpperCase(), table.getName());
                        }
                    }
                    if (table_map.containsKey(pattern.toUpperCase())) {
                        pattern = table_map.get(pattern.toUpperCase());
                    }
                }
                try {
                    List<String> sqls = adapter.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
                    if (null != sqls) {
                        int idx = 0;
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(adapter, sql, null).toUpperKey();
                            tables = adapter.mtables(idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block21;
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.getMessage()});
                }
            }
            try {
                ResultSet set = con.getMetaData().getTables(catalog, schema, pattern, tps);
                tables = adapter.mtables(false, catalog, schema, tables, set);
            }
            catch (Exception e) {
                log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636ejdbc\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.getMessage()});
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[stables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(String schema, String name, String types) {
        return this.mtables(null, schema, name, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(String name, String types) {
        return this.mtables(null, null, name, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(String types) {
        return this.mtables(null, types);
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables() {
        return this.mtables("STABLE");
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String catalog, String schema, String master, String name) {
        MasterTable mtable = new MasterTable(catalog, schema, master);
        return this.ptables(mtable, null, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String schema, String master, String name) {
        return this.ptables(null, schema, master, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String master, String name) {
        return this.ptables(null, null, master, name);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(String master) {
        return this.ptables(null, null, master, null);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(MasterTable master) {
        return this.ptables(master, null);
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(MasterTable master, Map<String, Object> tags) {
        return this.ptables(master, tags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, PartitionTable> ptables(MasterTable master, Map<String, Object> tags, String name) {
        LinkedHashMap<String, PartitionTable> tables = new LinkedHashMap<String, PartitionTable>();
        DataSource ds = null;
        Connection con = null;
        JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
        String random = DefaultDao.random();
        try {
            long fr;
            block11: {
                fr = System.currentTimeMillis();
                ds = this.getJdbc().getDataSource();
                con = DataSourceUtils.getConnection((DataSource)ds);
                try {
                    List<String> sqls = adapter.buildQueryPartitionTableRunSQL(master, tags, name);
                    if (null != sqls) {
                        int idx = 0;
                        int total = sqls.size();
                        for (String sql : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)sql)) continue;
                            DataSet set = this.select(adapter, sql, null).toUpperKey();
                            tables = adapter.ptables(total, idx++, true, master, master.getCatalog(), master.getSchema(), tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block11;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.getMessage()});
                }
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, master.getName(), tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional(con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Column> columns(Table table) {
        ResultSet rs;
        String schema;
        String catalog;
        JDBCAdapter adapter;
        DatabaseMetaData metadata;
        String random;
        Connection con;
        DataSource ds;
        long fr;
        LinkedHashMap<String, Column> columns;
        block25: {
            List<String> sqls;
            block24: {
                columns = new LinkedHashMap<String, Column>();
                fr = System.currentTimeMillis();
                ds = null;
                con = null;
                random = null;
                metadata = null;
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = DefaultDao.random();
                }
                adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
                catalog = table.getCatalog();
                schema = table.getSchema();
                try {
                    ds = this.getJdbc().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    metadata = con.getMetaData();
                    if (null == catalog) {
                        catalog = con.getCatalog();
                        table.setCatalog(catalog);
                    }
                    if (null == schema) {
                        schema = con.getSchema();
                        table.setSchema(schema);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    sqls = adapter.buildQueryColumnRunSQL(table, true);
                    if (null != sqls) {
                        for (String string : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)string)) continue;
                            SqlRowSet set = this.getJdbc().queryForRowSet(string);
                            columns = adapter.columns(true, table, columns, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block24;
                    log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.getMessage()});
                }
            }
            try {
                sqls = adapter.buildQueryColumnRunSQL(table, false);
                if (null != sqls) {
                    int idx = 0;
                    for (String sql : sqls) {
                        if (BasicUtil.isNotEmpty((Object)sql)) {
                            DataSet set = this.select(adapter, sql, null);
                            columns = adapter.columns(idx, true, table, columns, set);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block25;
                log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.getMessage()});
            }
        }
        try {
            rs = metadata.getColumns(catalog, schema, table.getName(), null);
            columns = adapter.columns(true, table, columns, rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        try {
            rs = metadata.getPrimaryKeys(catalog, schema, table.getName());
            while (rs.next()) {
                String name = rs.getString(4);
                Column column = columns.get(name.toUpperCase());
                if (null == column) continue;
                column.setPrimaryKey(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[columns][catalog:{}][schema:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, System.currentTimeMillis() - fr});
        }
        return columns;
    }

    @Override
    public LinkedHashMap<String, Column> columns(String table) {
        return this.columns(null, null, table);
    }

    @Override
    public LinkedHashMap<String, Column> columns(String catalog, String schema, String table) {
        Table tab = new Table(catalog, schema, table);
        return this.columns(tab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Tag> tags(Table table) {
        ResultSet rs;
        String schema;
        String catalog;
        JDBCAdapter adapter;
        DatabaseMetaData metadata;
        String random;
        Connection con;
        DataSource ds;
        long fr;
        LinkedHashMap<String, Tag> tags;
        block25: {
            List<String> sqls;
            block24: {
                tags = new LinkedHashMap<String, Tag>();
                fr = System.currentTimeMillis();
                ds = null;
                con = null;
                random = null;
                metadata = null;
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    random = DefaultDao.random();
                }
                adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
                catalog = table.getCatalog();
                schema = table.getSchema();
                try {
                    ds = this.getJdbc().getDataSource();
                    con = DataSourceUtils.getConnection((DataSource)ds);
                    metadata = con.getMetaData();
                    if (null == catalog) {
                        catalog = con.getCatalog();
                        table.setCatalog(catalog);
                    }
                    if (null == schema) {
                        schema = con.getSchema();
                        table.setSchema(schema);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    sqls = adapter.buildQueryTagRunSQL(table, true);
                    if (null != sqls) {
                        for (String string : sqls) {
                            if (!BasicUtil.isNotEmpty((Object)string)) continue;
                            SqlRowSet set = this.getJdbc().queryForRowSet(string);
                            tags = adapter.tags(true, table, tags, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block24;
                    log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636emetadata\u89e3\u6790\u5931\u8d25", (int)33), catalog, schema, table, e.getMessage()});
                }
            }
            try {
                sqls = adapter.buildQueryTagRunSQL(table, false);
                if (null != sqls) {
                    int idx = 0;
                    for (String sql : sqls) {
                        if (BasicUtil.isNotEmpty((Object)sql)) {
                            DataSet set = this.select(adapter, sql, null).toUpperKey();
                            tags = adapter.tags(idx, true, table, tags, set);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_SHOW_SQL || !log.isWarnEnabled()) break block25;
                log.warn("{}[tags][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.getMessage()});
            }
        }
        try {
            rs = metadata.getColumns(catalog, schema, table.getName(), null);
            tags = adapter.tags(false, table, tags, rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        try {
            rs = metadata.getPrimaryKeys(catalog, schema, table.getName());
            while (rs.next()) {
                String name = rs.getString(4);
                Tag tag = tags.get(name.toUpperCase());
                if (null == tag) continue;
                tag.setPrimaryKey(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[tags][catalog:{}][schema:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, table, System.currentTimeMillis() - fr});
        }
        return tags;
    }

    @Override
    public LinkedHashMap<String, Tag> tags(String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.tags(tab);
    }

    @Override
    public LinkedHashMap<String, Tag> tags(String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.tags(tab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Index> indexs(Table table) {
        LinkedHashMap<String, Index> indexs = null;
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        String tab = table.getName();
        DataSource ds = null;
        Connection con = null;
        JDBCAdapter adapter = SQLAdapterUtil.getAdapter(this.getJdbc());
        try {
            ds = this.jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            if (null == catalog) {
                catalog = con.getCatalog();
                table.setCatalog(catalog);
            }
            if (null == schema) {
                schema = con.getSchema();
                table.setSchema(schema);
            }
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet set = metaData.getIndexInfo(catalog, schema, tab, false, false);
            indexs = adapter.indexs(true, table, indexs, set);
            table.setIndexs(indexs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return indexs;
    }

    @Override
    public LinkedHashMap<String, Index> indexs(String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.indexs(tab);
    }

    @Override
    public LinkedHashMap<String, Index> indexs(String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.indexs(tab);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(Table table) {
        return null;
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(String table) {
        Table tab = new Table();
        tab.setName(table);
        return this.constraints(tab);
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(String catalog, String schema, String table) {
        Table tab = new Table();
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        tab.setName(table);
        return this.constraints(tab);
    }

    @Override
    public boolean create(Table table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(table);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildCreateRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[create table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean alter(Table table) throws Exception {
        boolean result = false;
        Table update = table.getUpdate();
        LinkedHashMap<String, Column> columns = table.getColumns();
        LinkedHashMap<String, Column> ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        this.check(table);
        if (!name.equalsIgnoreCase(uname)) {
            String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildRenameRunSQL(table);
            String random = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = DefaultDao.random();
                log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
            }
            DDListener listener = table.getListener();
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeRename(table);
            }
            if (exe) {
                this.getJdbc().update(sql);
                result = true;
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[rename table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
            }
            if (null != listener) {
                listener.afterRename(table, result);
            }
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn);
                column.setService(table.getService());
                this.alter(column);
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
        }
        if (ConfigTable.IS_DDL_AUTO_DROP_COLUMN) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(Table table) {
        DataSource ds = null;
        Connection con = null;
        try {
            ds = this.getJdbc().getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            if (null == table.getCatalog()) {
                table.setCatalog(con.getCatalog());
            }
            if (null == table.getSchema()) {
                table.setSchema(con.getSchema());
            }
        }
        catch (Exception e) {
            log.warn("check table exception");
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
    }

    private void check(Column column) {
        Table table = column.getTable();
        if (null != table) {
            this.check(table);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
        }
    }

    private void check(Index index) {
        Table table = index.getTable();
        if (null != table) {
            this.check(table);
            index.setCatalog(table.getCatalog());
            index.setSchema(table.getSchema());
        }
    }

    private void check(Constraint constraint) {
        Table table = constraint.getTable();
        if (null != table) {
            this.check(table);
            constraint.setCatalog(table.getCatalog());
            constraint.setSchema(table.getSchema());
        }
    }

    @Override
    public boolean drop(Table table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(table);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDropRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean create(MasterTable table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(table);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildCreateRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[create master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean alter(MasterTable table) throws Exception {
        boolean result = false;
        this.check(table);
        Table update = table.getUpdate();
        LinkedHashMap<String, Column> columns = table.getColumns();
        LinkedHashMap<String, Column> ucolumns = update.getColumns();
        LinkedHashMap<String, Tag> tags = table.getTags();
        LinkedHashMap<String, Tag> utags = update.getTags();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildRenameRunSQL(table);
            String random = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = DefaultDao.random();
                log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
            }
            DDListener listener = table.getListener();
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeRename(table);
            }
            if (exe) {
                this.getJdbc().update(sql);
                result = true;
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[rename master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
            }
            if (null != listener) {
                listener.afterRename(table, result);
            }
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn);
                column.setService(table.getService());
                this.alter(column);
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
        }
        if (ConfigTable.IS_DDL_AUTO_DROP_COLUMN) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable(update);
                tag.setUpdate(utag);
                tag.setService(table.getService());
                this.alter(tag);
                continue;
            }
            utag.setTable(update);
            this.add(utag);
        }
        if (ConfigTable.IS_DDL_AUTO_DROP_COLUMN) {
            for (Tag tag : tags.values()) {
                Tag utag = utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable(update);
                this.drop(tag);
            }
        }
        return result;
    }

    @Override
    public boolean drop(MasterTable table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(table);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDropRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean create(PartitionTable table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(table);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildCreateRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[create partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean alter(PartitionTable table) throws Exception {
        boolean result = false;
        this.check(table);
        Table update = table.getUpdate();
        LinkedHashMap<String, Column> columns = table.getColumns();
        LinkedHashMap<String, Column> ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildRenameRunSQL(table);
            String random = null;
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                random = DefaultDao.random();
                log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
            }
            DDListener listener = table.getListener();
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeRename(table);
            }
            if (exe) {
                this.getJdbc().update(sql);
                result = true;
            }
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[rename partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
            }
            if (null != listener) {
                listener.afterRename(table, result);
            }
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn);
                column.setService(table.getService());
                this.alter(column);
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
        }
        if (ConfigTable.IS_DDL_AUTO_DROP_COLUMN) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
            }
        }
        return result;
    }

    @Override
    public boolean drop(PartitionTable table) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(table);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDropRunSQL(table);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = table.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(table);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(table, result);
        }
        return result;
    }

    @Override
    public boolean add(Column column) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        String random = null;
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAddRunSQL(column);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = column.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(column);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add column][table:{}][column:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(), column.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Column column) throws Exception {
        return this.alter(table, column, true);
    }

    @Override
    public boolean alter(Column column) throws Exception {
        Table table = column.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(column.getCatalog(), column.getSchema(), column.getTableName(), "TABLE");
            if (tables.size() == 0) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName());
            }
            table = tables.values().iterator().next();
        }
        return this.alter(table, column, true);
    }

    @Override
    public boolean drop(Column column) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(column);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDropRunSQL(column);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = column.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(column);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop column][table:{}][column:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(), column.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(column, result);
        }
        return result;
    }

    private boolean alter(Table table, Column column, boolean trigger) throws Exception {
        boolean result = true;
        long fr = System.currentTimeMillis();
        String random = null;
        this.check(column);
        List<String> sqls = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAlterRunSQL(column);
        random = DefaultDao.random();
        DDListener listener = column.getListener();
        try {
            for (String sql : sqls) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
                }
                boolean exe = true;
                if (null != listener) {
                    exe = listener.beforeAlter(column);
                }
                if (!exe) continue;
                this.getJdbc().update(sql);
                result = true;
            }
        }
        catch (Exception e) {
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.getMessage()});
            if (trigger && null != listener && !BasicUtil.equalsIgnoreCase((Object)column.getTypeName(), (Object)column.getUpdate().getTypeName())) {
                boolean exe = false;
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    exe = listener.afterAlterColumnException(table, column, e);
                }
                log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)exe);
                if (exe) {
                    result = this.alter(table, column, false);
                }
            }
            log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update column][table:{}][column:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, column.getTableName(), column.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean add(Tag tag) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        String random = null;
        this.check(tag);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAddRunSQL(tag);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = tag.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(tag);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add tag][table:{}][tag:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, tag.getTableName(), tag.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Tag tag) throws Exception {
        return this.alter(table, tag, true);
    }

    @Override
    public boolean alter(Tag tag) throws Exception {
        Table table = tag.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(tag.getCatalog(), tag.getSchema(), tag.getTableName(), "TABLE");
            if (tables.size() == 0) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName());
            }
            table = tables.values().iterator().next();
        }
        return this.alter(table, tag, true);
    }

    @Override
    public boolean drop(Tag tag) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(tag);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDropRunSQL(tag);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = tag.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(tag);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop tag][table:{}][tag:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, tag.getTableName(), tag.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(tag, result);
        }
        return result;
    }

    private boolean alter(Table table, Tag tag, boolean trigger) throws Exception {
        boolean result = true;
        long fr = System.currentTimeMillis();
        String random = null;
        this.check(tag);
        List<String> sqls = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAlterRunSQL(tag);
        random = DefaultDao.random();
        DDListener listener = tag.getListener();
        try {
            for (String sql : sqls) {
                if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                    log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
                }
                boolean exe = true;
                if (null != listener) {
                    exe = listener.beforeAlter(tag);
                }
                if (!exe) continue;
                this.getJdbc().update(sql);
                result = true;
            }
        }
        catch (Exception e) {
            log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539tag\u6267\u884c\u5f02\u5e38", (int)33), e.getMessage()});
            if (trigger && null != listener && !BasicUtil.equalsIgnoreCase((Object)tag.getTypeName(), (Object)tag.getUpdate().getTypeName())) {
                boolean exe = false;
                if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                    exe = listener.afterAlterColumnException(table, tag, e);
                }
                log.warn("{}[\u4fee\u6539tag\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)exe);
                if (exe) {
                    result = this.alter(table, tag, false);
                }
            }
            log.warn("{}[\u4fee\u6539tag\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
            result = false;
            throw e;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update tag][table:{}][tag:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, tag.getTableName(), tag.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean add(Index index) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        String random = null;
        this.check(index);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAddRunSQL(index);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = index.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(index);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add index][table:{}][index:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, index.getTableName(), index.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Index index) throws Exception {
        Table table = index.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(index.getCatalog(), index.getSchema(), index.getTableName(), "TABLE");
            if (tables.size() == 0) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + index.getTableName());
            }
            table = tables.values().iterator().next();
        }
        return this.alter(table, index);
    }

    @Override
    public boolean alter(Table table, Index index) throws Exception {
        boolean result = true;
        long fr = System.currentTimeMillis();
        String random = null;
        this.check(index);
        List<String> sqls = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAlterRunSQL(index);
        random = DefaultDao.random();
        DDListener listener = index.getListener();
        for (String sql : sqls) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
            }
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeAlter(index);
            }
            if (!exe) continue;
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update index][table:{}][index:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, index.getTableName(), index.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Index index) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(index);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDropRunSQL(index);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = index.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(index);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop index][table:{}][index:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, index.getTableName(), index.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(index, result);
        }
        return result;
    }

    @Override
    public boolean add(Constraint constraint) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        String random = null;
        this.check(constraint);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAddRunSQL(constraint);
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = constraint.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeAdd(constraint);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[add constraint][table:{}][constraint:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, constraint.getTableName(), constraint.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean alter(Constraint constraint) throws Exception {
        Table table = constraint.getTable();
        if (null == table) {
            LinkedHashMap<String, Table> tables = this.tables(constraint.getCatalog(), constraint.getSchema(), constraint.getTableName(), "TABLE");
            if (tables.size() == 0) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + constraint.getTableName());
            }
            table = tables.values().iterator().next();
        }
        return this.alter(table, constraint);
    }

    @Override
    public boolean alter(Table table, Constraint constraint) throws Exception {
        boolean result = true;
        long fr = System.currentTimeMillis();
        String random = null;
        this.check(constraint);
        List<String> sqls = SQLAdapterUtil.getAdapter(this.getJdbc()).buildAlterRunSQL(constraint);
        random = DefaultDao.random();
        DDListener listener = constraint.getListener();
        for (String sql : sqls) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
            }
            boolean exe = true;
            if (null != listener) {
                exe = listener.beforeAlter(constraint);
            }
            if (!exe) continue;
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[update constraint][table:{}][constraint:{}][qty:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, constraint.getTableName(), constraint.getName(), sqls.size(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    @Override
    public boolean drop(Constraint constraint) throws Exception {
        boolean result = false;
        long fr = System.currentTimeMillis();
        this.check(constraint);
        String sql = SQLAdapterUtil.getAdapter(this.getJdbc()).buildDropRunSQL(constraint);
        String random = null;
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            random = DefaultDao.random();
            log.warn("{}[txt:\n{}\n]", (Object)random, (Object)sql);
        }
        DDListener listener = constraint.getListener();
        boolean exe = true;
        if (null != listener) {
            exe = listener.beforeDrop(constraint);
        }
        if (exe) {
            this.getJdbc().update(sql);
            result = true;
        }
        if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
            log.warn("{}[drop constraint][table:{}][constraint:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, constraint.getTableName(), constraint.getName(), result, System.currentTimeMillis() - fr});
        }
        if (null != listener) {
            listener.afterDrop(constraint, result);
        }
        return result;
    }

    protected String paramLogFormat(List<?> params) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (null != params) {
            int idx = 0;
            for (Object param : params) {
                builder.append("param").append(idx++).append("=");
                builder.append(param);
                if (null != param) {
                    builder.append("(").append(param.getClass().getName()).append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    protected String paramLogFormat(List<?> keys, List<?> values) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (null != keys && null != values) {
            if (keys.size() == values.size()) {
                int size = keys.size();
                for (int i = 0; i < size; ++i) {
                    Object key = keys.get(i);
                    Object value = values.get(i);
                    builder.append(keys.get(i)).append("=");
                    builder.append(value);
                    if (null != value) {
                        builder.append("(").append(value.getClass().getName()).append(")");
                    }
                    builder.append("\n");
                }
            } else {
                return this.paramLogFormat(values);
            }
        }
        return builder.toString();
    }

    private static String random() {
        StringBuilder builder = new StringBuilder();
        builder.append("[SQL:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(DataSourceHolder.getDataSource()).append("]");
        return builder.toString();
    }
}

