/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.xml.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.init.DefaultCondition;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.data.run.RunValue;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class DefaultXMLCondition
extends DefaultCondition
implements Condition {
    private String text;
    private List<Variable> variables;

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultXMLCondition clone = (DefaultXMLCondition)super.clone();
        if (null != this.variables) {
            ArrayList<Variable> cVariables = new ArrayList<Variable>();
            for (Variable var : this.variables) {
                if (null == var) continue;
                cVariables.add((Variable)var.clone());
            }
            clone.setRequired(this.isRequired());
            clone.setStrictRequired(this.isStrictRequired());
            clone.variables = cVariables;
        }
        return clone;
    }

    public DefaultXMLCondition() {
        this.join = "";
    }

    public DefaultXMLCondition(String id, String text, boolean isStatic) {
        this.join = "";
        this.id = id;
        this.text = text;
        this.setVariableType(0);
        if (!isStatic) {
            this.parseText();
        } else {
            this.setVariableType(2);
        }
    }

    @Override
    public void init() {
        this.setActive(false);
        if (null == this.variables) {
            this.variables = new ArrayList<Variable>();
        }
        for (Variable variable : this.variables) {
            variable.init();
        }
    }

    @Override
    public void setValue(String variable, Object values) {
        this.runValuesMap.put(variable, values);
        if (null == variable || null == this.variables) {
            return;
        }
        for (Variable v : this.variables) {
            if (null == v || !variable.equalsIgnoreCase(v.getKey())) continue;
            v.setValue(values);
            if (!BasicUtil.isNotEmpty((boolean)true, (Object)values) && !v.isRequired() && !v.isStrictRequired()) continue;
            this.setActive(true);
        }
    }

    private void parseText() {
        try {
            List keys = RegularUtil.fetchs((String)this.text, (String)"(\\S+)\\s*\\(?(\\s*:+\\w+)(\\s|'|\\)|%|\\,)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            if (keys.size() == 0) {
                keys = RegularUtil.fetchs((String)this.text, (String)"([^\\s$]+)\\s*\\(?(\\s*\\$*{\\w+})(\\+|\\s|'|\\)|%)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)keys)) {
                this.setVariableType(1);
                int varType = 0;
                Compare compare = Compare.EQUAL;
                for (int i = 0; i < keys.size(); ++i) {
                    List keyItem = (List)keys.get(i);
                    String prefix = ((String)keyItem.get(1)).trim();
                    String fullKey = ((String)keyItem.get(2)).trim();
                    String typeChar = (String)keyItem.get(3);
                    String key = fullKey.replace(":", "").replace("${", "").replace("}", "");
                    if (fullKey.startsWith("::")) {
                        varType = 3;
                    } else if (BasicUtil.isNotEmpty((Object)typeChar) && ("'".equals(typeChar) || "%".equals(typeChar))) {
                        varType = 2;
                    } else {
                        varType = 1;
                        if (prefix.equalsIgnoreCase("IN") || prefix.equalsIgnoreCase("IN(")) {
                            compare = Compare.IN;
                        }
                    }
                    DefaultVariable var = new DefaultVariable();
                    var.setKey(key);
                    var.setType(varType);
                    var.setCompare(compare);
                    this.addVariable(var);
                }
            } else {
                List idxKeys = RegularUtil.fetch((String)this.text, (String)"\\?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN, (int)0);
                if (BasicUtil.isNotEmpty((boolean)true, (Object)idxKeys)) {
                    this.setVariableType(0);
                    int varType = 0;
                    for (int i = 0; i < idxKeys.size(); ++i) {
                        DefaultVariable var = new DefaultVariable();
                        var.setType(varType);
                        var.setKey(this.id);
                        this.addVariable(var);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addVariable(Variable variable) {
        if (null == this.variables) {
            this.variables = new ArrayList<Variable>();
        }
        this.variables.add(variable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getRunText(String prefix, JDBCAdapter adapter) {
        String value;
        List<Object> values;
        String result = this.text;
        this.runValues = new ArrayList();
        if (null == this.variables) {
            return result;
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 3) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = (String)values.get(0);
            }
            if (BasicUtil.isNotEmpty(value)) {
                result = result.replace("::" + var.getKey(), value);
                result = result.replace("${" + var.getKey() + "}", value);
                continue;
            }
            result = result.replace("::" + var.getKey(), "NULL");
            result = result.replace("${" + var.getKey() + "}", "NULL");
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 2) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = (String)values.get(0);
            }
            if (null != value) {
                result = result.replace(":" + var.getKey(), value);
                result = result.replace("${" + var.getKey() + "}", value);
                continue;
            }
            result = result.replace(":" + var.getKey(), "");
            result = result.replace("${" + var.getKey() + "}", "");
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 1) continue;
            List<Object> varValues = var.getValues();
            if (Compare.IN == var.getCompare()) {
                String inParam = "";
                for (int i = 0; i < varValues.size(); ++i) {
                    inParam = inParam + "?";
                    if (i >= varValues.size() - 1) continue;
                    inParam = inParam + ",";
                }
                result = result.replace(":" + var.getKey(), inParam);
                result = result.replace("${" + var.getKey() + "}", inParam);
                for (Object obj : varValues) {
                    this.runValues.add(new RunValue(var.getKey(), obj));
                }
                continue;
            }
            result = result.replace(":" + var.getKey(), "?");
            result = result.replace("${" + var.getKey() + "}", "?");
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                value = varValues.get(0).toString();
            }
            this.runValues.add(new RunValue(var.getKey(), value));
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 0) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = (String)values.get(0);
            }
            this.runValues.add(new RunValue(null, value));
        }
        return result;
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    public Variable getVariable(String var) {
        if (null == this.variables || null == var) {
            return null;
        }
        for (Variable variable : this.variables) {
            if (null == variable || !var.equalsIgnoreCase(variable.getKey())) continue;
            return variable;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (null != this.variables) {
            for (Variable variable : this.variables) {
                if (null == variable) continue;
                List<Object> values = variable.getValues();
                if (!this.isStrictRequired() || !BasicUtil.isEmpty((boolean)true, values)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Variable> getVariables() {
        return this.variables;
    }
}

