/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.anyline.data.entity.Join;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.GroupStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.init.DefaultGroupStore;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultPrepare
implements RunPrepare {
    protected static final Logger log = LoggerFactory.getLogger(DefaultPrepare.class);
    protected ConditionChain chain;
    protected OrderStore orders;
    protected GroupStore groups;
    protected PageNavi navi;
    protected List<String> primaryKeys = new ArrayList<String>();
    protected List<String> fetchKeys = new ArrayList<String>();
    protected boolean valid = true;
    protected String alias;
    protected Vector<Object> runValues;

    @Override
    public int getVersion() {
        return 0;
    }

    protected void initRunValues() {
        if (null == this.runValues) {
            this.runValues = new Vector();
        } else {
            this.runValues.clear();
        }
    }

    @Override
    public RunPrepare order(Order order) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(order);
        return this;
    }

    @Override
    public RunPrepare order(String order) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(order);
        return this;
    }

    @Override
    public RunPrepare order(String col, Order.TYPE type) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(col, type);
        return this;
    }

    protected String getOrderText(String delimiter) {
        if (null != this.orders) {
            return this.orders.getRunText(delimiter);
        }
        return "";
    }

    @Override
    public RunPrepare group(String group) {
        if (BasicUtil.isEmpty((Object)group)) {
            return this;
        }
        if (null == this.groups) {
            this.groups = new DefaultGroupStore();
        }
        group = group.trim().toUpperCase();
        this.groups.group(group);
        return this;
    }

    protected RunPrepare addRunValue(Object runValue) {
        if (null == this.runValues) {
            this.runValues = new Vector();
        }
        if (runValue != null && runValue instanceof Collection) {
            Collection collection = (Collection)runValue;
            this.runValues.addAll(collection);
        } else {
            this.runValues.add(runValue);
        }
        return this;
    }

    public List<Object> getRunValues() {
        return this.runValues;
    }

    public RunPrepare setConditionChain(ConditionChain chain) {
        this.chain = chain;
        return this;
    }

    @Override
    public RunPrepare addCondition(Condition condition) {
        this.chain.addCondition(condition);
        return this;
    }

    @Override
    public RunPrepare setConditionValue(String condition, String variable, Object value) {
        return this;
    }

    @Override
    public RunPrepare addCondition(String column, Object value, int compare) {
        return this;
    }

    @Override
    public RunPrepare setText(String text) {
        return this;
    }

    @Override
    public void setPageNavi(PageNavi navi) {
        this.navi = navi;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.navi;
    }

    @Override
    public GroupStore getGroups() {
        return this.groups;
    }

    @Override
    public OrderStore getOrders() {
        return this.orders;
    }

    @Override
    public void setOrders(OrderStore orders) {
        if (null != orders) {
            List list = orders.getOrders();
            for (Order order : list) {
                this.order(order);
            }
            for (Order order : orders.getOrders()) {
                orders.order(order);
            }
        } else {
            orders = this.orders;
        }
    }

    @Override
    public ConditionChain getConditionChain() {
        return this.chain;
    }

    @Override
    public RunPrepare addPrimaryKey(String ... primaryKeys) {
        if (null != primaryKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : primaryKeys) {
                list.add(pk);
            }
            return this.addPrimaryKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare addPrimaryKey(Collection<String> primaryKeys) {
        if (BasicUtil.isEmpty(primaryKeys)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        for (String item : primaryKeys) {
            if (BasicUtil.isEmpty((Object)item) || this.primaryKeys.contains(item = item.toUpperCase())) continue;
            this.primaryKeys.add(item);
        }
        return this;
    }

    @Override
    public RunPrepare setPrimaryKey(String ... primaryKeys) {
        if (null != primaryKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : primaryKeys) {
                list.add(pk);
            }
            return this.setPrimaryKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare setPrimaryKey(Collection<String> primaryKeys) {
        if (BasicUtil.isEmpty(primaryKeys)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        } else {
            this.primaryKeys.clear();
        }
        this.addPrimaryKey(primaryKeys);
        return this;
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public String getPrimaryKey() {
        List<String> keys = this.getPrimaryKeys();
        if (null != keys && keys.size() > 0) {
            return keys.get(0);
        }
        return null;
    }

    @Override
    public boolean hasPrimaryKeys() {
        return null != this.primaryKeys && this.primaryKeys.size() > 0;
    }

    @Override
    public RunPrepare addFetchKey(String ... fetchKeys) {
        if (null != fetchKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : fetchKeys) {
                list.add(pk);
            }
            return this.addFetchKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare addFetchKey(Collection<String> fetchKeys) {
        if (BasicUtil.isEmpty(fetchKeys)) {
            return this;
        }
        if (null == this.fetchKeys) {
            this.fetchKeys = new ArrayList<String>();
        }
        for (String item : fetchKeys) {
            if (BasicUtil.isEmpty((Object)item) || this.fetchKeys.contains(item = item.toUpperCase())) continue;
            this.fetchKeys.add(item);
        }
        return this;
    }

    @Override
    public RunPrepare setFetchKey(String ... fetchKeys) {
        if (null != fetchKeys) {
            ArrayList<String> list = new ArrayList<String>();
            for (String pk : fetchKeys) {
                list.add(pk);
            }
            return this.setFetchKey(list);
        }
        return this;
    }

    @Override
    public RunPrepare setFetchKey(Collection<String> fetchKeys) {
        if (BasicUtil.isEmpty(fetchKeys)) {
            return this;
        }
        if (null == this.fetchKeys) {
            this.fetchKeys = new ArrayList<String>();
        } else {
            this.fetchKeys.clear();
        }
        this.addFetchKey(fetchKeys);
        return this;
    }

    @Override
    public List<String> getFetchKeys() {
        return this.fetchKeys;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public RunPrepare join(Join join) {
        return this;
    }

    @Override
    public RunPrepare join(Join.TYPE type, String table, String condition) {
        return this;
    }

    @Override
    public RunPrepare inner(String table, String condition) {
        return this;
    }

    @Override
    public RunPrepare left(String table, String condition) {
        return this;
    }

    @Override
    public RunPrepare right(String table, String condition) {
        return this;
    }

    @Override
    public RunPrepare full(String table, String condition) {
        return this;
    }

    @Override
    public List<Join> getJoins() {
        return null;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }
}

