/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfig;
import org.anyline.data.param.init.DefaultConfigChain;
import org.anyline.data.prepare.Group;
import org.anyline.data.prepare.GroupStore;
import org.anyline.data.prepare.init.DefaultGroup;
import org.anyline.data.prepare.init.DefaultGroupStore;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrder;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.encrypt.DESUtil;

public class DefaultConfigStore
implements ConfigStore {
    private static final long serialVersionUID = -2098827041540802313L;
    protected ConfigChain chain;
    protected PageNavi navi;
    protected OrderStore orders;
    protected GroupStore groups;

    @Override
    public String toString() {
        String str = "";
        if (null != this.chain) {
            str = str + this.chain.toString();
        }
        if (null != this.navi) {
            str = str + "." + this.navi.getFirstRow() + "." + this.navi.getLastRow() + "." + this.navi.getCurPage();
        }
        if (null != this.orders) {
            str = str + "." + this.orders.getRunText("");
        }
        if (null != this.groups) {
            str = str + "." + this.groups.getRunText("");
        }
        return str;
    }

    @Override
    public Config parseConfig(String config) {
        if (null == config) {
            return null;
        }
        DefaultConfig conf = null;
        conf = config.indexOf("|") != -1 ? new DefaultConfigChain(config) : new DefaultConfig(config);
        return conf;
    }

    @Override
    public ConfigStore setPageNavi(PageNavi navi) {
        this.navi = navi;
        return this;
    }

    @Override
    public ConfigStore copyPageNavi(PageNavi navi) {
        if (null == this.navi) {
            this.navi = navi;
        } else {
            this.navi.setBaseLink(navi.getBaseLink());
            this.navi.setCalType(navi.getCalType());
            this.navi.setCurPage(navi.getCurPage());
            this.navi.setDisplayPageFirst(navi.getDisplayPageFirst());
            this.navi.setDisplayPageLast(navi.getDisplayPageLast());
            this.navi.setFirstRow(navi.getFirstRow());
            this.navi.setLastRow(navi.getLastRow());
            this.navi.setPageRows(navi.getPageRows());
            this.navi.setTotalPage(navi.getTotalPage());
            this.navi.setTotalRow(navi.getTotalRow());
        }
        return this;
    }

    public DefaultConfigStore(String ... configs) {
        configs = BasicUtil.compressionSpace((String[])configs);
        this.chain = new DefaultConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    public DefaultConfigStore(int fr, int to) {
        this.chain = new DefaultConfigChain();
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(fr);
        navi.setLastRow(to);
        navi.setCalType(1);
        navi.setTotalRow(to - fr + 1);
        this.setPageNavi((PageNavi)navi);
    }

    public DefaultConfigStore(List<String> configs) {
        configs = BasicUtil.compressionSpace(configs);
        this.chain = new DefaultConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    @Override
    public ConfigStore addConditions(String var, Object ... values) {
        return this.addCondition(Compare.IN, var, (Object)values);
    }

    @Override
    public ConfigStore addCondition(String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition((String)null, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore addCondition(String text) {
        DefaultConfig conf = new DefaultConfig();
        conf.setText(text);
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore addCondition(String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(Compare.EQUAL, prefix, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore addCondition(Compare compare, String var, Object value) {
        return this.addCondition(compare, var, value, false, false);
    }

    @Override
    public ConfigStore addCondition(Compare compare, String id, String var, Object value) {
        return this.addCondition(compare, id, var, value, false, false);
    }

    @Override
    public ConfigStore addCondition(String id, String var, Object value) {
        return this.addCondition(id, var, value, false, false);
    }

    @Override
    public ConfigStore addCondition(Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        Config conf = null;
        boolean require = false;
        boolean strictRequired = false;
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1, var.length());
        }
        if (overCondition) {
            conf = this.chain.getConfig(prefix, var, compare);
        }
        if (null != var) {
            if (var.startsWith("++")) {
                strictRequired = true;
                var = var.substring(2);
            } else if (var.startsWith("+")) {
                require = true;
                var = var.substring(1);
            }
        }
        if (null == conf) {
            conf = new DefaultConfig();
            conf.setJoin(" AND ");
            conf.setCompare(compare);
            this.chain.addConfig(conf);
        }
        conf.setPrefix(prefix);
        conf.setVariable(var);
        conf.setRequire(require);
        conf.setStrictRequired(strictRequired);
        if (overValue) {
            conf.setValue(value);
        } else {
            conf.addValue(value);
        }
        return this;
    }

    @Override
    public ConfigStore addCondition(Compare compare, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(compare, null, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore addCondition(Config conf) {
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore addCondition(String var, Object value) {
        return this.addCondition(var, value, false, false);
    }

    @Override
    public ConfigStore and(String var, Object value) {
        return this.addCondition(var, value, false, false);
    }

    @Override
    public ConfigStore and(Compare compare, String var, Object value) {
        return this.addCondition(compare, var, value, false, false);
    }

    @Override
    public ConfigStore or(String var, Object value) {
        return this.or(Compare.EQUAL, var, value);
    }

    @Override
    public ConfigStore or(Compare compare, String var, Object value) {
        List<Config> configs = this.chain.getConfigs();
        if (configs.size() == 0) {
            this.and(compare, var, value);
        } else {
            DefaultConfigChain orChain = new DefaultConfigChain();
            Config last = configs.get(configs.size() - 1);
            configs.remove(last);
            if (last instanceof ConfigChain) {
                ConfigChain lastChain = (ConfigChain)last;
                List<Config> lastItems = lastChain.getConfigs();
                for (Config lastItem : lastItems) {
                    orChain.addConfig(lastItem);
                }
            } else {
                orChain.addConfig(last);
            }
            DefaultConfig conf = new DefaultConfig();
            conf.setJoin(" OR ");
            conf.setCompare(compare);
            conf.setVariable(var);
            conf.setValue(value);
            orChain.addConfig(conf);
            this.chain.addConfig(orChain);
        }
        return this;
    }

    @Override
    public ConfigStore conditions(String var, Object value) {
        return this.addConditions(var, value);
    }

    @Override
    public ConfigStore condition(String var, Object value) {
        return this.addCondition(var, value);
    }

    @Override
    public ConfigStore condition(String id, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(id, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore condition(String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore condition(Compare compare, String var, Object value) {
        return this.addCondition(compare, var, value);
    }

    @Override
    public ConfigStore condition(Compare compare, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(compare, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore condition(String id, String var, Object value) {
        return this.addCondition(id, var, value);
    }

    @Override
    public ConfigStore condition(Config config) {
        return this.addCondition(config);
    }

    @Override
    public ConfigStore ors(String var, Object value) {
        return this.ors(Compare.EQUAL, var, value);
    }

    @Override
    public ConfigStore ors(Compare compare, String var, Object value) {
        DefaultConfigChain newChain = new DefaultConfigChain();
        newChain.addConfig(this.chain);
        DefaultConfig conf = new DefaultConfig();
        conf.setJoin(" OR ");
        conf.setCompare(compare);
        conf.setVariable(var);
        conf.setValue(value);
        newChain.addConfig(conf);
        this.chain = newChain;
        return this;
    }

    protected void setNaviParam() {
        if (null == this.chain || null == this.navi) {
            return;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            String key = config.getKey();
            List<Object> values = new ArrayList();
            List<Object> srcValues = config.getValues();
            if (config.isKeyEncrypt()) {
                key = DESUtil.encryptParamKey((String)key);
            }
            if (config.isValueEncrypt() && null != srcValues) {
                for (Object value : srcValues) {
                    if (null == value) continue;
                    value = DESUtil.encryptParamValue((String)value.toString());
                    values.add(value);
                }
            } else {
                values = srcValues;
            }
            this.navi.addParam(key, values);
        }
    }

    @Override
    public ConfigStore addParam(String key, String value) {
        if (null != this.navi) {
            this.navi.addParam(key, (Object)value);
        }
        return this;
    }

    @Override
    public ConfigChain getConfigChain() {
        return this.chain;
    }

    @Override
    public ConfigStore order(Order order) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(order);
        if (null != this.navi) {
            this.navi.order(order.getColumn(), order.getType().getCode());
        }
        return this;
    }

    @Override
    public ConfigStore order(String column, String type) {
        return this.order((Order)new DefaultOrder(column, type));
    }

    @Override
    public ConfigStore order(String order) {
        return this.order((Order)new DefaultOrder(order));
    }

    @Override
    public OrderStore getOrders() {
        return this.orders;
    }

    @Override
    public ConfigStore setOrders(OrderStore orders) {
        this.orders = orders;
        return this;
    }

    @Override
    public ConfigStore group(Group group) {
        if (null == this.groups) {
            this.groups = new DefaultGroupStore();
        }
        this.groups.group(group);
        return this;
    }

    @Override
    public ConfigStore group(String group) {
        return this.group(new DefaultGroup(group));
    }

    @Override
    public GroupStore getGroups() {
        return this.groups;
    }

    @Override
    public ConfigStore setGroups(GroupStore groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.navi;
    }

    @Override
    public Config getConfig(String var) {
        return this.chain.getConfig(null, var);
    }

    @Override
    public ConfigStore removeConfig(String var) {
        Config config = this.getConfig(var);
        return this.removeConfig(config);
    }

    @Override
    public ConfigStore removeConfig(Config config) {
        this.chain.removeConfig(config);
        return this;
    }

    @Override
    public List<Object> getConfigValues(String var) {
        Config config = this.chain.getConfig(null, var);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var);
        if (null != config && null != (values = config.getValues()) && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Config getConfig(String var, Compare compare) {
        return this.chain.getConfig(null, var, compare);
    }

    @Override
    public ConfigStore removeConfig(String var, Compare compare) {
        Config config = this.getConfig(var, compare);
        return this.removeConfig(config);
    }

    @Override
    public List<Object> getConfigValues(String var, Compare compare) {
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var, Compare compare) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config && null != (values = config.getValues()) && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public ConfigStore fetch(String ... keys) {
        DefaultConfigStore result = new DefaultConfigStore(new String[0]);
        result.setOrders(this.getOrders());
        result.setGroups(this.getGroups());
        result.setPageNavi(this.getPageNavi());
        DefaultConfigChain chain = new DefaultConfigChain();
        List<Config> configs = this.getConfigChain().getConfigs();
        for (Config config : configs) {
            if (null == config || !BasicUtil.contains((Object[])keys, (Object)config.getPrefix())) continue;
            chain.addConfig((Config)config.clone());
        }
        result.chain = chain;
        return result;
    }

    @Override
    public ConfigStore setTotalLazy(long ms) {
        if (null != this.navi) {
            this.navi.setLazy(ms);
        }
        return this;
    }

    public ConfigStore clone() {
        DefaultConfigStore store = new DefaultConfigStore(new String[0]);
        return store;
    }

    @Override
    public ConfigStore setValue(Map<String, Object> values) {
        if (null == this.chain || null == values) {
            return this;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            config.setValue(values);
        }
        this.setNaviParam();
        return this;
    }
}

