/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.ds;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.jdbc.ds.DataSourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private Logger log = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    protected Object determineCurrentLookupKey() {
        return DataSourceHolder.getDataSource();
    }

    public static void addDataSource(String key, DataSource ds) {
        dataSources.put(key, ds);
    }

    protected DataSource determineTargetDataSource() {
        DataSource dataSource = null;
        Object lookupKey = this.determineCurrentLookupKey();
        dataSource = dataSources.get(lookupKey);
        if (null == dataSource) {
            try {
                dataSource = super.determineTargetDataSource();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == dataSource) {
            this.log.error("[\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25][thread:{}][key:{}]", (Object)Thread.currentThread().getId(), lookupKey);
        }
        return dataSource;
    }
}

