/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.entity;

import org.anyline.data.entity.Table;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.init.DefaultDDListener;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;

public class Column
implements org.anyline.entity.data.Column {
    protected String keyword = "COLUMN";
    protected String catalog;
    protected String className;
    protected String schema;
    protected String tableName;
    protected Table table;
    protected Integer displaySize;
    protected String comment;
    protected String name;
    protected Integer type;
    protected String typeName;
    protected Integer precision;
    protected Integer scale;
    protected int nullable = -1;
    protected int caseSensitive = -1;
    protected int isCurrency = -1;
    protected int isSigned = -1;
    protected int isAutoIncrement = -1;
    protected Integer incrementSeed = 1;
    protected Integer incrementStep = 1;
    protected int isPrimaryKey = -1;
    protected int isGenerated = -1;
    protected Object defaultValue;
    protected String charset;
    protected String collate;
    protected Integer position;
    protected String order;
    protected String after;
    protected String before;
    protected int isOnUpdate = -1;
    protected Object value;
    protected Column update;
    protected DDListener listener;

    public Column() {
        this.listener = new DefaultDDListener();
    }

    public Column(String name) {
        this(null, name);
    }

    public Column(String table, String name) {
        this(null, table, name);
    }

    public Column(String schema, String table, String name) {
        this(null, schema, table, name);
    }

    public Column(String catalog, String schema, String table, String name) {
        this.setCatalog(catalog);
        this.setSchema(schema);
        this.setName(name);
        this.setTable(table);
        this.listener = new DefaultDDListener();
    }

    public Column update() {
        this.update = (Column)this.clone();
        return this.update;
    }

    public Column getUpdate() {
        return this.update;
    }

    public Column setUpdate(Column update) {
        BeanUtil.copyFieldValueNvl((Object)update, (Object)this);
        this.update = update;
        return this;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Column setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public Column setClassName(String className) {
        this.className = className;
        return this;
    }

    public Integer getDisplaySize() {
        return this.displaySize;
    }

    public Column setDisplaySize(Integer displaySize) {
        this.displaySize = displaySize;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Column setComment(String comment) {
        if (null != comment) {
            comment = comment.trim().replace("'", "");
        }
        this.comment = comment;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        if (null != name) {
            name = name.trim().replace("'", "");
        }
        this.name = name;
        return this;
    }

    public Integer getType() {
        return this.type;
    }

    public Column setType(Integer type) {
        if (this.type != type) {
            this.className = null;
        }
        this.type = type;
        return this;
    }

    public Column setType(String type) {
        return this.setTypeName(type);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setTable(String table) {
        this.setTableName(table);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Column setTypeName(String typeName) {
        this.precision = 0;
        this.scale = 0;
        if (null != typeName) {
            if ((typeName = typeName.trim().replace("'", "")).toUpperCase().contains("IDENTITY")) {
                this.setAutoIncrement(true);
            }
            if (typeName.contains(" ")) {
                typeName = typeName.split(" ")[0];
            }
            if (typeName.contains("(")) {
                String len = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                if (len.contains(",")) {
                    String[] lens = len.split("\\,");
                    this.setPrecision(BasicUtil.parseInt((Object)lens[0], null));
                    this.setScale(BasicUtil.parseInt((Object)lens[1], null));
                } else {
                    this.setPrecision(BasicUtil.parseInt((Object)len, null));
                }
                typeName = typeName.substring(0, typeName.indexOf("("));
            }
        }
        if (!BasicUtil.equalsIgnoreCase((Object)typeName, (Object)this.typeName)) {
            this.className = null;
        }
        this.typeName = typeName;
        return this;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Column setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    public Column setPrecision(Integer precision, Integer scale) {
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public Column setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getTableName() {
        if (null != this.table) {
            return this.table.getName();
        }
        return this.tableName;
    }

    public Column setTableName(String tableName) {
        this.tableName = tableName;
        this.table = new Table(tableName);
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int isCaseSensitive() {
        return this.caseSensitive;
    }

    public Column setCaseSensitive(int caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Column setCaseSensitive(Boolean caseSensitive) {
        if (null != caseSensitive) {
            this.caseSensitive = caseSensitive != false ? 1 : 0;
        }
        return this;
    }

    public int isCurrency() {
        return this.isCurrency;
    }

    public Column setCurrency(int currency) {
        this.isCurrency = currency;
        return this;
    }

    public Column setCurrency(Boolean currency) {
        if (null != currency) {
            this.isCurrency = currency != false ? 1 : 0;
        }
        return this;
    }

    public int isSigned() {
        return this.isSigned;
    }

    public Column setSigned(int signed) {
        this.isSigned = signed;
        return this;
    }

    public Column setSigned(Boolean signed) {
        if (null != signed) {
            this.isSigned = signed != false ? 1 : 0;
        }
        return this;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Column setScale(Integer scale) {
        this.scale = scale;
        return this;
    }

    public int isNullable() {
        return this.nullable;
    }

    public Column setNullable(int nullable) {
        this.nullable = nullable;
        return this;
    }

    public Column setNullable(Boolean nullable) {
        if (null != nullable) {
            this.nullable = nullable != false ? 1 : 0;
        }
        return this;
    }

    public int isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public Column setAutoIncrement(int autoIncrement) {
        this.isAutoIncrement = autoIncrement;
        return this;
    }

    public Column setAutoIncrement(Boolean autoIncrement) {
        if (null != autoIncrement) {
            this.isAutoIncrement = autoIncrement != false ? 1 : 0;
        }
        return this;
    }

    public Column setAutoIncrement(int seed, int step) {
        this.setAutoIncrement(1);
        this.incrementSeed = seed;
        this.incrementStep = step;
        return this;
    }

    public int isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public Column setPrimaryKey(int primaryKey) {
        this.isPrimaryKey = primaryKey;
        return this;
    }

    public Column setPrimaryKey(Boolean primaryKey) {
        if (null != primaryKey) {
            this.isPrimaryKey = primaryKey != false ? 1 : 0;
        }
        return this;
    }

    public int isGenerated() {
        return this.isGenerated;
    }

    public Column setGenerated(int generated) {
        this.isGenerated = generated;
        return this;
    }

    public Column setGenerated(Boolean generated) {
        if (null != generated) {
            this.isGenerated = generated != false ? 1 : 0;
        }
        return this;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Column setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getOrder() {
        return this.order;
    }

    public Column setOrder(String order) {
        this.order = order;
        return this;
    }

    public Column setPosition(Integer position) {
        this.position = position;
        return this;
    }

    public String getAfter() {
        return this.after;
    }

    public Integer getIncrementSeed() {
        return this.incrementSeed;
    }

    public Column setIncrementSeed(Integer incrementSeed) {
        this.incrementSeed = incrementSeed;
        return this;
    }

    public Integer getIncrementStep() {
        return this.incrementStep;
    }

    public Column setIncrementStep(Integer incrementStep) {
        this.incrementStep = incrementStep;
        return this;
    }

    public int isOnUpdate() {
        return this.isOnUpdate;
    }

    public Column setOnUpdate(int onUpdate) {
        this.isOnUpdate = onUpdate;
        return this;
    }

    public Column setOnUpdate(Boolean onUpdate) {
        if (null != onUpdate) {
            this.isOnUpdate = onUpdate != false ? 1 : 0;
        }
        return this;
    }

    public DDListener getListener() {
        return this.listener;
    }

    public Column setListener(DDListener listener) {
        this.listener = listener;
        return this;
    }

    public Column setAfter(String after) {
        this.after = after;
        return this;
    }

    public String getBefore() {
        return this.before;
    }

    public String getCharset() {
        return this.charset;
    }

    public Column setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getCollate() {
        return this.collate;
    }

    public Column setCollate(String collate) {
        this.collate = collate;
        return this;
    }

    public String getNewName() {
        if (null != this.update) {
            return this.update.getName();
        }
        return null;
    }

    public Column setNewName(String newName) {
        if (null == this.update) {
            this.update();
        }
        this.update.setName(newName);
        return this.update;
    }

    public Column setBefore(String before) {
        this.before = before;
        return this;
    }

    public Column setService(AnylineService service) {
        if (null != this.listener) {
            this.listener.setService(service);
        }
        return this;
    }

    public Column setCreater(JDBCAdapter adapter) {
        if (null != this.listener) {
            this.listener.setAdapter(adapter);
        }
        return this;
    }

    public String getFullType() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.typeName);
        if (null != this.precision && this.precision > 0) {
            builder.append("(").append(this.precision);
            if (null != this.scale && this.scale > 0) {
                builder.append(",").append(this.scale);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(" ");
        builder.append(this.getFullType());
        if (BasicUtil.isNotEmpty((Object)this.defaultValue)) {
            builder.append(" default ").append(this.defaultValue);
        }
        return builder.toString();
    }

    public Object clone() {
        Column copy = new Column();
        copy.setName(this.name);
        copy.setTypeName(this.typeName);
        copy.setCatalog(this.catalog);
        copy.setClassName(this.className);
        copy.setSchema(this.schema);
        copy.setTableName(this.tableName);
        copy.setDisplaySize(this.displaySize);
        copy.setComment(this.comment);
        copy.setType(this.type);
        copy.setPrecision(this.precision);
        copy.setScale(this.scale);
        copy.setNullable(this.nullable);
        copy.setCaseSensitive(this.caseSensitive);
        copy.setCurrency(this.isCurrency);
        copy.setSigned(this.isSigned);
        copy.setPrimaryKey(this.isPrimaryKey);
        copy.setGenerated(this.isGenerated);
        copy.setDefaultValue(this.defaultValue);
        copy.setPosition(this.position);
        copy.setOrder(this.order);
        copy.setBefore(this.before);
        copy.setAfter(this.after);
        copy.setCharset(this.charset);
        copy.setCollate(this.collate);
        return copy;
    }

    public String getKeyword() {
        return this.keyword;
    }
}

