/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.dao.init;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.util.ConfigTable;

public class BatchInsertStore {
    public boolean isRun = false;
    private ConcurrentHashMap<String, ConcurrentLinkedDeque<DataRow>> map = new ConcurrentHashMap();

    public synchronized void addData(String table, String cols, DataRow data) {
        String key = table + "(" + cols + ")";
        ConcurrentLinkedDeque<Object> rows = this.map.get(key);
        if (null == rows) {
            rows = new ConcurrentLinkedDeque();
            this.map.put(key, rows);
        }
        rows.add(data);
    }

    public synchronized DataSet getDatas() {
        int size;
        int max = ConfigTable.getInt((String)"BATCH_INSERT_MAX_SIZE", (int)100);
        DataSet list = new DataSet();
        for (ConcurrentLinkedDeque<DataRow> rows : this.map.values()) {
            size = rows.size();
            if (size < max) continue;
            int cnt = 0;
            while (cnt < max && !rows.isEmpty()) {
                DataRow row = rows.poll();
                if (null == row) continue;
                list.add(row);
                ++cnt;
            }
            return list;
        }
        for (ConcurrentLinkedDeque<DataRow> rows : this.map.values()) {
            size = rows.size();
            if (size <= 0) continue;
            int cnt = 0;
            while (cnt < max && !rows.isEmpty()) {
                DataRow row = rows.poll();
                if (null == row) continue;
                list.add(row);
            }
            return list;
        }
        return list;
    }
}

