/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.voltdb;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.anyline.adapter.DataWriter;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.DateUtil;

public enum VoltDBWriter {
    TimestampWriter(new Object[]{Date.class, Timestamp.class, LocalDateTime.class, LocalDate.class, "Timestamp"}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            Date date = DateUtil.parse((Object)value);
            if (null != date) {
                value = date.getTime() * 1000L;
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private VoltDBWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

