/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.tdengine;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.AbstractJDBCAdapter;
import org.anyline.data.jdbc.tdengine.TDengineColumnTypeAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.tdengine")
public class TDengineAdapter
extends AbstractJDBCAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.tdengine:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.TDengine;
    }

    public TDengineAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
        for (TDengineColumnTypeAlias alias : TDengineColumnTypeAlias.values()) {
            this.alias.put(alias.name(), alias.standard());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, configs, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, configs, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, list, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    public String batchInsertSeparator() {
        return " ";
    }

    public boolean supportInsertPlaceholder() {
        return false;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.createInsertRun(runtime, dest, obj, configs, columns);
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, List<String> columns) {
        return super.createInsertRunFromCollection(runtime, batch, dest, list, configs, columns);
    }

    public String generatedKey() {
        return super.generatedKey();
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt = 0L;
        JdbcTemplate jdbc = this.jdbc(runtime);
        final String sql = run.getFinalInsert();
        final List values = run.getValues();
        if (null != configs) {
            configs.add(run);
        }
        if (null != values && !values.isEmpty()) {
            cnt = jdbc.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = null;
                    ps = con.prepareStatement(sql);
                    int idx = 0;
                    if (null != values) {
                        for (Object obj : values) {
                            ps.setObject(++idx, obj);
                        }
                    }
                    return ps;
                }
            });
            return cnt;
        }
        cnt = jdbc.update(sql);
        return cnt;
    }

    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, columns);
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, columns);
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, columns);
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        return super.update(runtime, random, dest, data, configs, run);
    }

    public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    protected Boolean checkOverride(Object obj) {
        return super.checkOverride(obj);
    }

    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        return super.querys(runtime, random, procedure, navi);
    }

    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, conditions);
    }

    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        return super.buildQuerySequence(runtime, next, names);
    }

    public void fillQueryContent(DataRuntime runtime, Run run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        super.fillQueryContent(runtime, run);
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.pageLimit(runtime, run);
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (null != value) {
            if (value instanceof Collection) {
                value = ((Collection)value).iterator().next();
            }
            if (compare == Compare.LIKE) {
                builder.append(" LIKE '%").append(value).append("%'");
            } else if (compare == Compare.LIKE_PREFIX || compare == Compare.START_WITH) {
                builder.append(" LIKE'").append(value).append("%'");
            } else if (compare == Compare.LIKE_SUFFIX || compare == Compare.END_WITH) {
                builder.append(" LIKE '%").append(value).append("'");
            }
        }
        RunValue run = new RunValue();
        run.setPlaceholder(false);
        return run;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        return super.createConditionFindInSet(runtime, builder, column, compare, value);
    }

    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        return super.createConditionIn(runtime, builder, compare, value);
    }

    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, system, table, configs, run);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.maps(runtime, random, configs, run);
    }

    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.map(runtime, random, configs, run);
    }

    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        return super.sequence(runtime, random, next, names);
    }

    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        return super.mergeFinalTotal(runtime, run);
    }

    public long count(DataRuntime runtime, String random, Run run) {
        return super.count(runtime, random, run);
    }

    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.exists(runtime, random, prepare, configs, conditions);
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        return super.mergeFinalExists(runtime, run);
    }

    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        return super.execute(runtime, random, batch, configs, prepare, values);
    }

    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        return super.execute(runtime, random, procedure);
    }

    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, conditions);
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        super.fillExecuteContent(runtime, run);
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        super.fillExecuteContent(runtime, run);
    }

    public void fillExecuteContent(DataRuntime runtime, Run run) {
        super.fillExecuteContent(runtime, run);
    }

    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.execute(runtime, random, configs, run);
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    public Run buildDeleteRun(DataRuntime runtime, Table dest, Object obj, String ... columns) {
        return super.buildDeleteRun(runtime, dest, obj, columns);
    }

    public Run buildDeleteRun(DataRuntime runtime, int batch, String table, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, key, values);
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        return super.buildTruncateRun(runtime, table);
    }

    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, String column, Object values) {
        return super.buildDeleteRunFromTable(runtime, batch, table, column, values);
    }

    public Run buildDeleteRunFromEntity(DataRuntime runtime, Table table, Object obj, String ... columns) {
        return super.buildDeleteRunFromEntity(runtime, table, obj, columns);
    }

    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        super.fillDeleteRunContent(runtime, run);
    }

    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.delete(runtime, random, configs, run);
    }

    public Database database(DataRuntime runtime, String random) {
        return super.database(runtime, random);
    }

    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    public List<Database> databases(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.databases(runtime, random, greedy, name);
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random, String name) {
        return super.databases(runtime, random, name);
    }

    public List<Run> buildQueryProductRun(DataRuntime runtime) throws Exception {
        return super.buildQueryProductRun(runtime);
    }

    public List<Run> buildQueryVersionRun(DataRuntime runtime) throws Exception {
        return super.buildQueryVersionRun(runtime);
    }

    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return super.buildQueryDatabasesRun(runtime, greedy, name);
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        return super.databases(runtime, index, create, databases, set);
    }

    public List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, DataSet set) throws Exception {
        return super.databases(runtime, index, create, databases, set);
    }

    public Database database(DataRuntime runtime, int index, boolean create, Database database, DataSet set) throws Exception {
        return super.database(runtime, index, create, database, set);
    }

    public Database database(DataRuntime runtime, boolean create, Database database) throws Exception {
        return super.database(runtime, create, database);
    }

    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    public String product(DataRuntime runtime, boolean create, String product) {
        return super.product(runtime, create, product);
    }

    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    public String version(DataRuntime runtime, boolean create, String version) {
        return super.version(runtime, create, version);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, String random, String name) {
        return super.catalogs(runtime, random, name);
    }

    public List<Catalog> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.catalogs(runtime, random, greedy, name);
    }

    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return super.buildQueryCatalogsRun(runtime, greedy, name);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, set);
    }

    public List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, set);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    public List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog catalog, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, catalog, set);
    }

    public Catalog catalog(DataRuntime runtime, boolean create, Catalog catalog) throws Exception {
        return super.catalog(runtime, create, catalog);
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        return super.schemas(runtime, random, catalog, name);
    }

    public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        return super.schemas(runtime, random, greedy, catalog, name);
    }

    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name) throws Exception {
        return super.buildQuerySchemasRun(runtime, greedy, catalog, name);
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, set);
    }

    public List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, set);
    }

    public Schema schema(DataRuntime runtime, int index, boolean create, Schema schema, DataSet set) throws Exception {
        return super.schema(runtime, index, create, schema, set);
    }

    public Schema schema(DataRuntime runtime, boolean create, Schema schema) throws Exception {
        return super.schema(runtime, create, schema);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        return super.tables(runtime, random, greedy, catalog, schema, pattern, types, strut);
    }

    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema) {
        super.tableMap(runtime, random, greedy, catalog, schema);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        return super.tables(runtime, random, catalog, schema, pattern, types, strut);
    }

    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW TABLES");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" LIKE '" + pattern + "'");
        }
        SimpleRun r = new SimpleRun(runtime);
        runs.add((Run)r);
        builder = r.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE TYPE = 'NORMAL_TABLE' ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            builder.append(" AND DB_NAME = '" + String.valueOf(catalog) + "'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '" + pattern + "'");
        }
        return runs;
    }

    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryTablesCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    Table table;
                    String name = row.getString("STABLE_NAME");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (Table)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("STABLE_NAME");
                if (BasicUtil.isEmpty((Object)name)) continue;
                Table table = (Table)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("DB_NAME"));
                table.setType(row.getString("TYPE"));
                table.setComment(row.getString("TABLE_COMMENT"));
            }
        }
        return tables;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new ArrayList<T>();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    Object table;
                    String name = row.getString("STABLE_NAME");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = this.table(tables, catalog, schema, name)) || !create) continue;
                    table = new MasterTable(name);
                    tables.add(table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("STABLE_NAME");
                if (BasicUtil.isEmpty((Object)name)) continue;
                boolean contains = true;
                Object table = this.table(tables, catalog, schema, name);
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    contains = false;
                }
                table.setCatalog(row.getString("DB_NAME"));
                table.setType(row.getString("TYPE"));
                table.setComment(row.getString("TABLE_COMMENT"));
                if (contains) continue;
                tables.add(table);
            }
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.comments(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        return super.comments(runtime, index, create, catalog, schema, tables, set);
    }

    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        return super.views(runtime, random, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryViewsRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        return super.views(runtime, index, create, catalog, schema, views, set);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.views(runtime, create, views, catalog, schema, pattern, types);
    }

    public List<String> ddl(DataRuntime runtime, String random, View view) {
        return super.ddl(runtime, random, view);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDdlsRun(runtime, view);
    }

    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        return super.mtables(runtime, random, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Object sql = "SHOW STABLES";
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = (String)sql + " LIKE '" + pattern + "'";
        }
        runs.add((Run)new SimpleRun(runtime, (String)sql));
        sql = "SELECT * FROM INFORMATION_SCHEMA.INS_STABLES WHERE 1=1 ";
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            sql = (String)sql + " AND DB_NAME = '" + String.valueOf(catalog) + "'";
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = (String)sql + " AND STABLE_NAME LIKE '" + pattern + "'";
        }
        runs.add((Run)new SimpleRun(runtime, (String)sql));
        return runs;
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    MasterTable table;
                    String name = row.getString("STABLE_NAME");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (MasterTable)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("STABLE_NAME");
                if (BasicUtil.isEmpty((Object)name)) continue;
                MasterTable table = (MasterTable)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("DB_NAME"));
                table.setComment(row.getString("TABLE_COMMENT"));
            }
        }
        return tables;
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<String> ddl(DataRuntime runtime, String random, MasterTable table) {
        return super.ddl(runtime, random, table);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String pattern) {
        return super.ptables(runtime, random, greedy, master, tags, pattern);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String stable = null;
        if (null != master) {
            stable = master.getName();
        }
        if (null != tags && tags.size() > 0) {
            for (String key : tags.keySet()) {
                SimpleRun run = new SimpleRun(runtime);
                runs.add((Run)run);
                StringBuilder builder = run.getBuilder();
                Object value = tags.get(key);
                builder.append("SELECT table_name FROM INFORMATION_SCHEMA.INS_TAGS WHERE STABLE_NAME = '").append(stable).append("'").append(" AND TAG_NAME ='").append(key.toLowerCase()).append("'").append(" AND TAG_VALUE ");
                if (null == value) {
                    builder.append("IS NULL");
                    continue;
                }
                if (BasicUtil.isNumber((Object)value)) {
                    builder.append("= ").append(value);
                    continue;
                }
                builder.append("= '").append(value).append("'");
            }
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE STABLE_NAME = '").append(stable).append("'");
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" AND TABLE_NAME = '").append(name).append("'");
        }
        return runs;
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (index == 0) {
            tables = new LinkedHashMap();
            for (DataRow row : set) {
                String name = row.getString("TABLE_NAME");
                PartitionTable table = new PartitionTable(name);
                tables.put(name, table);
            }
        } else if (index < total - 1) {
            tables.keySet().retainAll(set.getStrings("TABLE_NAME"));
        }
        if (index == total - 1) {
            LinkedHashMap<String, PartitionTable> result = new LinkedHashMap<String, PartitionTable>();
            for (DataRow row : set) {
                String name = row.getString("TABLE_NAME");
                if (!tables.containsKey(name)) continue;
                PartitionTable table = new PartitionTable(name);
                result.put(name.toUpperCase(), table);
                table.setCatalog(row.getString("DB_NAME"));
                table.setComment(row.getString("TABLE_COMMENT"));
                table.setMaster((Table)master);
                result.put(name, table);
            }
            tables.clear();
            for (String key : result.keySet()) {
                tables.put(key.toUpperCase(), (PartitionTable)result.get(key));
            }
        }
        return tables;
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        return super.columns(runtime, random, greedy, table, primary);
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Table table) {
        return super.columns(runtime, random, greedy, catalog, schema, table);
    }

    public List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Catalog catalog = null;
        Schema schema = null;
        String name = null;
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalog();
            schema = table.getSchema();
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!metadata && null != name) {
            builder.append("DESCRIBE ").append(name);
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("FIELD");
            String note = row.getString("NOTE");
            if (BasicUtil.isEmpty((Object)name) || "TAG".equalsIgnoreCase(note)) continue;
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                if (!create) continue;
                column = new Column();
                columns.put(name.toUpperCase(), column);
            }
            column.setName(name);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
            column.setTypeName(row.getString("TYPE"));
            column.setPrecision(row.getInt("LENGTH", Integer.valueOf(0)));
            this.typeMetadata(runtime, column);
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        return super.columns(runtime, index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.tags(runtime, random, greedy, table);
    }

    public List<Run> buildQueryTagsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        StringBuilder builder = new StringBuilder();
        if (!metadata) {
            if (table instanceof MasterTable) {
                builder.append("SELECT DISTINCT STABLE_NAME,DB_NAME,TAG_NAME,TAG_TYPE FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalogName()).append("' AND STABLE_NAME='").append(table.getName()).append("'");
            } else {
                builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalogName()).append("' AND TABLE_NAME='").append(table.getName()).append("'");
            }
            runs.add((Run)new SimpleRun(runtime, builder));
            builder = new StringBuilder();
            builder.append("DESCRIBE ").append(table.getName());
            runs.add((Run)new SimpleRun(runtime, builder));
        }
        return runs;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        block6: {
            block5: {
                if (null == tags) {
                    tags = new LinkedHashMap();
                }
                if (index != 0) break block5;
                for (DataRow row : set) {
                    String name = row.getString("TAG_NAME");
                    if (BasicUtil.isEmpty((Object)name)) continue;
                    Tag item = (Tag)tags.get(name.toUpperCase());
                    if (null == item) {
                        if (!create) continue;
                        item = new Tag();
                    }
                    item.setName(name);
                    item.setTypeName(row.getString("TAG_TYPE"));
                    item.setValue(row.get("TAG_VALUE"));
                    tags.put(name.toUpperCase(), item);
                }
                break block6;
            }
            if (index != 1) break block6;
            for (DataRow row : set) {
                String name;
                String note = row.getString("NOTE");
                if (!"TAG".equalsIgnoreCase(note) || BasicUtil.isEmpty((Object)(name = row.getString("FIELD")))) continue;
                Tag item = (Tag)tags.get(name.toUpperCase());
                if (null == item) {
                    if (!create) continue;
                    item = new Tag();
                }
                item.setName(name);
                item.setTypeName(row.getString("TYPE"));
                item.setPrecision(row.getInt("LENGTH", Integer.valueOf(0)));
                item.setValue(row.get("TAG_VALUE"));
                tags.put(name.toUpperCase(), item);
            }
        }
        return tags;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.primary(runtime, random, greedy, table);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryPrimaryRun(runtime, table);
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        return super.primary(runtime, index, table, set);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.foreigns(runtime, random, greedy, table);
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryForeignsRun(runtime, table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        return super.foreigns(runtime, index, table, foreigns, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        return super.indexs(runtime, random, greedy, table, pattern);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, Table table, String pattern) {
        return super.indexs(runtime, random, table, pattern);
    }

    public List<Run> buildQueryIndexsRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexsRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, int index, boolean create, Table table, List<T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, boolean create, List<T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        return super.constraints(runtime, random, greedy, table, pattern);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        return super.constraints(runtime, random, table, column, pattern);
    }

    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, Table table, Column column, String pattern) {
        return super.buildQueryConstraintsRun(runtime, table, column, pattern);
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, Column column, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, column, constraints, set);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        return super.triggers(runtime, random, greedy, table, events);
    }

    public List<Run> buildQueryTriggersRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggersRun(runtime, table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, table, triggers, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return super.procedures(runtime, random, greedy, catalog, schema, pattern);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return super.procedures(runtime, random, catalog, schema, pattern);
    }

    public List<Run> buildQueryProceduresRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        return super.buildQueryProceduresRun(runtime, catalog, schema, pattern);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, procedures, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDdlsRun(runtime, procedure);
    }

    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return super.functions(runtime, random, greedy, catalog, schema, pattern);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return super.functions(runtime, random, catalog, schema, pattern);
    }

    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, Catalog catalog, Schema schema, String name) {
        return super.buildQueryFunctionsRun(runtime, catalog, schema, name);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, set);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> functions) throws Exception {
        return super.functions(runtime, create, functions);
    }

    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return super.sequences(runtime, random, greedy, catalog, schema, pattern);
    }

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return super.sequences(runtime, random, catalog, schema, pattern);
    }

    public List<Run> buildQuerySequencesRun(DataRuntime runtime, Catalog catalog, Schema schema, String name) {
        return super.buildQuerySequencesRun(runtime, catalog, schema, name);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> sequences, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, sequences, set);
    }

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> sequences, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, sequences, set);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> sequences) throws Exception {
        return super.sequences(runtime, create, sequences);
    }

    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        return super.ddl(runtime, random, meta);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, sequence, ddls, set);
    }

    public <T extends Table> T table(List<T> tables, Catalog catalog, Schema schema, String name) {
        return (T)super.table(tables, catalog, schema, name);
    }

    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return (T)super.schema(schemas, catalog, name);
    }

    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return (T)super.catalog(catalogs, name);
    }

    public <T extends Database> T database(List<T> databases, String name) {
        return (T)super.database(databases, name);
    }

    public boolean execute(DataRuntime runtime, String random, BaseMetadata meta, ACTION.DDL action, Run run) {
        return super.execute(runtime, random, meta, action, run);
    }

    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public String keyword(Table meta) {
        return super.keyword(meta);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        return builder;
    }

    public StringBuilder indexs(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.indexs(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        return builder;
    }

    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionBy(runtime, builder, meta);
    }

    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        String stable = meta.getMasterName();
        if (BasicUtil.isEmpty((Object)stable)) {
            throw new SQLException("\u672a\u6307\u5b9a\u4e3b\u8868");
        }
        builder.append(" USING ");
        this.delimiter(builder, stable);
        builder.append("(");
        Collection tags = meta.getTags().values();
        int idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            this.delimiter(builder, tag.getName());
            ++idx;
        }
        builder.append(") TAGS (");
        idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            builder.append(this.write(runtime, null, tag.getValue(), false));
            ++idx;
        }
        builder.append(")");
        return builder;
    }

    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        MasterTable tab = meta;
        List<Run> list = this.buildCreateRun(runtime, (Table)tab);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Run sql = list.get(i);
            if (i == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(sql.getFinalUpdate());
                builder.append(" TAGS (");
                LinkedHashMap tags = meta.getTags();
                int idx = 0;
                for (Tag tag : tags.values()) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    this.delimiter(builder, tag.getName()).append(" ");
                    this.type(runtime, builder, (Column)tag);
                    ++idx;
                }
                builder.append(")");
                runs.add((Run)new SimpleRun(runtime, builder));
                continue;
            }
            runs.add(sql);
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        PartitionTable tab = meta;
        return super.buildCreateRun(runtime, (Table)tab);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, meta, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeTypeRun(runtime, meta);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER";
    }

    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.addColumnGuide(runtime, builder, meta);
    }

    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.dropColumnGuide(runtime, builder, meta);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeNullableRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropAutoIncrement(runtime, meta);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.define(runtime, builder, meta);
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.type(runtime, builder, meta);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        Integer precision;
        String typeName;
        if (null == builder) {
            builder = new StringBuilder();
        }
        if (BasicUtil.isEmpty((Object)(typeName = meta.getTypeName()))) {
            return builder;
        }
        builder.append(typeName);
        if (typeName.equalsIgnoreCase("NCHAR") && null != (precision = meta.getPrecision()) && precision > 0) {
            builder.append("(").append(precision).append(")");
        }
        return builder;
    }

    public int ignoreLength(DataRuntime runtime, Column meta) {
        return super.ignoreLength(runtime, meta);
    }

    public int ignorePrecision(DataRuntime runtime, Column meta) {
        return super.ignorePrecision(runtime, meta);
    }

    public int ignoreScale(DataRuntime runtime, Column meta) {
        return super.ignoreScale(runtime, meta);
    }

    public int checkIgnoreLength(DataRuntime runtime, String type) {
        return super.checkIgnoreLength(runtime, type);
    }

    public int checkIgnorePrecision(DataRuntime runtime, String type) {
        return super.checkIgnorePrecision(runtime, type);
    }

    public int checkIgnoreScale(DataRuntime runtime, String type) {
        return super.checkIgnoreScale(runtime, type);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.defaultValue(runtime, builder, meta);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.primary(runtime, builder, meta);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (meta instanceof Tag) {
            String comment = meta.getComment();
            if (BasicUtil.isNotEmpty((Object)comment)) {
                builder.append(" COMMENT '").append(comment).append("'");
            }
            return builder;
        }
        return null;
    }

    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, false);
    }

    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeNullableRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeTypeRun(runtime, meta);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, origin, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return super.buildAlterRun(runtime, origin, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendIndexRun(runtime, meta);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.type(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        return super.each(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        return super.parameter(runtime, builder, parameter);
    }

    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, DataSource dataSource, T meta) {
        super.checkSchema(runtime, dataSource, meta);
    }

    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, Connection con, T meta) {
        super.checkSchema(runtime, con, meta);
    }

    public <T extends BaseMetadata> void checkSchema(DataRuntime runtime, T meta) {
        super.checkSchema(runtime, meta);
    }

    public <T extends BaseMetadata> void correctSchemaFromJDBC(T meta, String catalog, String schema, boolean override) {
        super.correctSchemaFromJDBC(meta, catalog, schema, override);
    }

    public <T extends BaseMetadata> void correctSchemaFromJDBC(T meta, String catalog, String schema) {
        super.correctSchemaFromJDBC(meta, catalog, schema);
    }

    public String[] correctSchemaFromJDBC(String catalog, String schema) {
        return super.correctSchemaFromJDBC(catalog, schema);
    }

    public boolean identity(DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder) {
        return super.identity(runtime, random, data, configs, keyholder);
    }

    public String lengthColumn(DataRuntime runtime, TypeMetadata meta) {
        return super.lengthColumn(runtime, meta);
    }

    public String precisionColumn(DataRuntime runtime, TypeMetadata meta) {
        return super.precisionColumn(runtime, meta);
    }

    public String scaleColumn(DataRuntime runtime, TypeMetadata meta) {
        return super.scaleColumn(runtime, meta);
    }

    public String insertHead(ConfigStore configs) {
        return super.insertHead(configs);
    }

    public String insertFoot(ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.insertFoot(configs, columns);
    }

    public Column column(DataRuntime runtime, Column column, ResultSetMetaData rsm, int index) {
        return super.column(runtime, column, rsm, index);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, dbmd, table, pattern);
    }

    public Column column(DataRuntime runtime, Column column, ResultSet rs) {
        return super.column(runtime, column, rs);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public Column column(DataRuntime runtime, Column column, SqlRowSetMetaData rsm, int index) {
        return super.column(runtime, column, rsm, index);
    }

    public DataRow row(boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas, ConfigStore configs, ResultSet rs) {
        return super.row(system, runtime, metadatas, configs, rs);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME) {
            return "NOW";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATE) {
            return "NOW";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "NOW";
        }
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIMESTAMP) {
            return "NOW";
        }
        return null;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return super.concatFun(runtime, args);
    }

    protected String dummy() {
        return super.dummy();
    }
}

