/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.tdengine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.SQLAdapter;
import org.anyline.data.jdbc.tdengine.TDengineColumnTypeAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.tdengine")
public class TDengineAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.tdengine:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.TDengine;
    }

    public TDengineAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
        for (TDengineColumnTypeAlias alias : TDengineColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (null != value) {
            if (value instanceof Collection) {
                value = ((Collection)value).iterator().next();
            }
            if (compare == Compare.LIKE) {
                builder.append(" LIKE '%").append(value).append("%'");
            } else if (compare == Compare.LIKE_PREFIX || compare == Compare.START_WITH) {
                builder.append(" LIKE'").append(value).append("%'");
            } else if (compare == Compare.LIKE_SUFFIX || compare == Compare.END_WITH) {
                builder.append(" LIKE '%").append(value).append("'");
            }
        }
        RunValue run = new RunValue();
        run.setPlaceholder(false);
        return run;
    }

    public String batchInsertSeparator() {
        return " ";
    }

    public boolean supportInsertPlaceholder() {
        return false;
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt = 0L;
        JdbcTemplate jdbc = this.jdbc(runtime);
        final String sql = run.getFinalInsert();
        final List values = run.getValues();
        if (null != configs) {
            configs.add(run);
        }
        if (null != values && !values.isEmpty()) {
            cnt = jdbc.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = null;
                    ps = con.prepareStatement(sql);
                    int idx = 0;
                    if (null != values) {
                        for (Object obj : values) {
                            ps.setObject(++idx, obj);
                        }
                    }
                    return ps;
                }
            });
            return cnt;
        }
        cnt = jdbc.update(sql);
        return cnt;
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatFun(args);
    }

    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW TABLES");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" LIKE '" + pattern + "'");
        }
        SimpleRun r = new SimpleRun(runtime);
        runs.add((Run)r);
        builder = r.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE TYPE = 'NORMAL_TABLE' ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            builder.append(" AND DB_NAME = '" + catalog + "'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '" + pattern + "'");
        }
        return runs;
    }

    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    Table table;
                    String name = row.getString("stable_name");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (Table)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("stable_name");
                if (BasicUtil.isEmpty((Object)name)) continue;
                Table table = (Table)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("db_name"));
                table.setType(row.getString("type"));
                table.setComment(row.getString("table_comment"));
            }
        }
        return tables;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new ArrayList<T>();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    Table table;
                    String name = row.getString("stable_name");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = this.table(tables, catalog, schema, name)) || !create) continue;
                    table = new MasterTable(name);
                    tables.add(table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("stable_name");
                if (BasicUtil.isEmpty((Object)name)) continue;
                boolean contains = true;
                Table table = this.table(tables, catalog, schema, name);
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    contains = false;
                }
                table.setCatalog(row.getString("db_name"));
                table.setType(row.getString("type"));
                table.setComment(row.getString("table_comment"));
                if (contains) continue;
                tables.add(table);
            }
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String sql = "SHOW STABLES";
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " LIKE '" + pattern + "'";
        }
        runs.add((Run)new SimpleRun(sql));
        sql = "SELECT * FROM INFORMATION_SCHEMA.INS_STABLES WHERE 1=1 ";
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            sql = sql + " AND DB_NAME = '" + catalog + "'";
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " AND STABLE_NAME LIKE '" + pattern + "'";
        }
        runs.add((Run)new SimpleRun(sql));
        return runs;
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    MasterTable table;
                    String name = row.getString("stable_name");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (MasterTable)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("stable_name");
                if (BasicUtil.isEmpty((Object)name)) continue;
                MasterTable table = (MasterTable)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("db_name"));
                table.setComment(row.getString("table_comment"));
            }
        }
        return tables;
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String stable = null;
        if (null != master) {
            stable = master.getName();
        }
        if (null != tags && tags.size() > 0) {
            for (String key : tags.keySet()) {
                SimpleRun run = new SimpleRun(runtime);
                runs.add((Run)run);
                StringBuilder builder = run.getBuilder();
                Object value = tags.get(key);
                builder.append("SELECT table_name FROM INFORMATION_SCHEMA.INS_TAGS WHERE STABLE_NAME = '").append(stable).append("'").append(" AND TAG_NAME ='").append(key.toLowerCase()).append("'").append(" AND TAG_VALUE ");
                if (null == value) {
                    builder.append("IS NULL");
                    continue;
                }
                if (BasicUtil.isNumber((Object)value)) {
                    builder.append("= ").append(value);
                    continue;
                }
                builder.append("= '").append(value).append("'");
            }
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE STABLE_NAME = '").append(stable).append("'");
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" AND TABLE_NAME = '").append(name).append("'");
        }
        return runs;
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return this.buildQueryPartitionTableRun(runtime, master, tags, null);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (index == 0) {
            tables = new LinkedHashMap();
            for (DataRow row : set) {
                String name = row.getString("table_name");
                PartitionTable table = new PartitionTable(name);
                tables.put(name, table);
            }
        } else if (index < total - 1) {
            tables.keySet().retainAll(set.getStrings("table_name"));
        }
        if (index == total - 1) {
            LinkedHashMap<String, PartitionTable> result = new LinkedHashMap<String, PartitionTable>();
            for (DataRow row : set) {
                String name = row.getString("table_name");
                if (!tables.containsKey(name)) continue;
                PartitionTable table = new PartitionTable(name);
                result.put(name.toUpperCase(), table);
                table.setCatalog(row.getString("db_name"));
                table.setComment(row.getString("table_comment"));
                table.setMaster(master);
                result.put(name, table);
            }
            tables.clear();
            for (String key : result.keySet()) {
                tables.put(key.toUpperCase(), result.get(key));
            }
        }
        return tables;
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String catalog = null;
        String schema = null;
        String name = null;
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalog();
            schema = table.getSchema();
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, table);
            builder.append(" WHERE 1=0");
        } else if (null != name) {
            builder.append("DESCRIBE ").append(name);
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("field");
            String note = row.getString("note");
            if (BasicUtil.isEmpty((Object)name) || "TAG".equalsIgnoreCase(note)) continue;
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                if (!create) continue;
                column = new Column();
                columns.put(name.toUpperCase(), column);
            }
            column.setName(name);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
            column.setTypeName(row.getString("type"));
            column.setPrecision(row.getInt("length", Integer.valueOf(0)));
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        return columns;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, false, columns, table, pattern);
    }

    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, table);
            builder.append(" WHERE 1=0");
            runs.add((Run)new SimpleRun(builder));
        } else {
            if (table instanceof MasterTable) {
                builder.append("SELECT DISTINCT STABLE_NAME,DB_NAME,TAG_NAME,TAG_TYPE FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalog()).append("' AND STABLE_NAME='").append(table.getName()).append("'");
            } else {
                builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalog()).append("' AND TABLE_NAME='").append(table.getName()).append("'");
            }
            runs.add((Run)new SimpleRun(builder));
            builder = new StringBuilder();
            builder.append("DESCRIBE ").append(table.getName());
            runs.add((Run)new SimpleRun(builder));
        }
        return runs;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        block6: {
            block5: {
                if (null == tags) {
                    tags = new LinkedHashMap();
                }
                if (index != 0) break block5;
                for (DataRow row : set) {
                    String name = row.getString("TAG_NAME");
                    if (BasicUtil.isEmpty((Object)name)) continue;
                    Tag item = (Tag)tags.get(name.toUpperCase());
                    if (null == item) {
                        if (!create) continue;
                        item = new Tag();
                    }
                    item.setName(name);
                    item.setTypeName(row.getString("TAG_TYPE"));
                    item.setValue(row.get("TAG_VALUE"));
                    tags.put(name.toUpperCase(), item);
                }
                break block6;
            }
            if (index != 1) break block6;
            for (DataRow row : set) {
                String name;
                String note = row.getString("note");
                if (!"TAG".equalsIgnoreCase(note) || BasicUtil.isEmpty((Object)(name = row.getString("field")))) continue;
                Tag item = (Tag)tags.get(name.toUpperCase());
                if (null == item) {
                    if (!create) continue;
                    item = new Tag();
                }
                item.setName(name);
                item.setTypeName(row.getString("type"));
                item.setPrecision(row.getInt("length", Integer.valueOf(0)));
                item.setValue(row.get("TAG_VALUE"));
                tags.put(name.toUpperCase(), item);
            }
        }
        return tags;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return tags;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(runtime, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRun(runtime, table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggerRun(runtime, table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, table, triggers, set);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAppendCommentRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.name(runtime, builder, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View view) throws Exception {
        return super.buildCreateRun(runtime, view);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAppendCommentRun(runtime, view);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAlterRun(runtime, view);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View view) throws Exception {
        return super.buildRenameRun(runtime, view);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildChangeCommentRun(runtime, view);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View view) throws Exception {
        return super.buildDropRun(runtime, view);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View view) {
        return super.comment(runtime, builder, view);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        MasterTable tab = table;
        List<Run> list = this.buildCreateRun(runtime, (Table)tab);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Run sql = list.get(i);
            if (i == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(sql.getFinalUpdate());
                builder.append(" TAGS (");
                LinkedHashMap tags = table.getTags();
                int idx = 0;
                for (Tag tag : tags.values()) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                    this.type(runtime, builder, (Column)tag);
                    ++idx;
                }
                builder.append(")");
                runs.add((Run)new SimpleRun(builder));
                continue;
            }
            runs.add(sql);
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        MasterTable tab = table;
        return super.buildDropRun(runtime, (Table)tab);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String stable = table.getMasterName();
        if (BasicUtil.isEmpty((Object)stable)) {
            throw new SQLException("\u672a\u6307\u5b9a\u4e3b\u8868");
        }
        PartitionTable tab = table;
        builder.append(((Run)super.buildCreateRun(runtime, (Table)tab).get(0)).getFinalUpdate());
        builder.append(" USING ");
        SQLUtil.delimiter((StringBuilder)builder, (String)stable, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append("(");
        Collection tags = table.getTags().values();
        int idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            ++idx;
        }
        builder.append(") TAGS (");
        idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            builder.append(this.write(runtime, null, tag.getValue(), false));
            ++idx;
        }
        builder.append(")");
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        PartitionTable tab = table;
        return super.buildDropRun(runtime, (Table)tab);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER";
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAddRun(runtime, column, slice);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAddRun(runtime, column, false);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, column, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAlterRun(runtime, column, false);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildDropRun(runtime, column, slice);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildRenameRun(runtime, column);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeTypeRun(runtime, column);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeDefaultRun(runtime, column);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeNullableRun(runtime, column);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        return super.buildDropAutoIncrement(runtime, column);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.define(runtime, builder, column);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        Integer precision;
        String typeName;
        if (null == builder) {
            builder = new StringBuilder();
        }
        if (BasicUtil.isEmpty((Object)(typeName = column.getTypeName()))) {
            return builder;
        }
        builder.append(typeName);
        if (typeName.equalsIgnoreCase("NCHAR") && null != (precision = column.getPrecision()) && precision > 0) {
            builder.append("(").append(precision).append(")");
        }
        return builder;
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.charset(runtime, builder, column);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.defaultValue(runtime, builder, column);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        if (column instanceof Tag) {
            String comment = column.getComment();
            if (BasicUtil.isNotEmpty((Object)comment)) {
                builder.append(" COMMENT '").append(comment).append("'");
            }
            return builder;
        }
        return null;
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAddRun(runtime, tag);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAlterRun(runtime, tag);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildDropRun(runtime, tag);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildRenameRun(runtime, tag);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeDefaultRun(runtime, tag);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeNullableRun(runtime, tag);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeCommentRun(runtime, tag);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeTypeRun(runtime, tag);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAddRun(runtime, primary);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAlterRun(runtime, primary);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildDropRun(runtime, primary);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildRenameRun(runtime, primary);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAddRun(runtime, foreign);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAlterRun(runtime, foreign);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildDropRun(runtime, foreign);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildRenameRun(runtime, foreign);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAddRun(runtime, index);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAlterRun(runtime, index);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildDropRun(runtime, index);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildRenameRun(runtime, index);
    }

    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
        super.comment(runtime, builder, index);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAddRun(runtime, constraint);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return this.buildAlterRun(runtime, constraint);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildDropRun(runtime, constraint);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildRenameRun(runtime, constraint);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildCreateRun(runtime, trigger);
    }

    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        super.each(runtime, builder, trigger);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildAlterRun(runtime, trigger);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildDropRun(runtime, trigger);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildRenameRun(runtime, trigger);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildCreateRun(runtime, procedure);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildAlterRun(runtime, procedure);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildDropRun(runtime, procedure);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildRenameRun(runtime, procedure);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildCreateRun(runtime, function);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildAlterRun(runtime, function);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildDropRun(runtime, function);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildRenameRun(runtime, function);
    }

    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        return super.isBooleanColumn(runtime, column);
    }

    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        return super.isNumberColumn(runtime, column);
    }

    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return super.isCharColumn(runtime, column);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "NOW";
        }
        return null;
    }
}

