/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.tdengine;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.SQLAdapter;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.run.Run;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.DatabaseType;
import org.anyline.entity.metadata.ColumnType;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.tdengine")
public class TDengineAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.jdbc.delimiter.tdengine:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.TDengine;
    }

    public TDengineAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public Object buildConditionLike(StringBuilder builder, Compare compare, Object value) {
        if (null != value) {
            if (value instanceof Collection) {
                value = ((Collection)value).iterator().next();
            }
            if (compare == Compare.LIKE) {
                builder.append(" LIKE '%" + value + "%'");
            } else if (compare == Compare.LIKE_PREFIX || compare == Compare.START_WITH) {
                builder.append(" LIKE'" + value + "%'");
            } else if (compare == Compare.LIKE_SUFFIX || compare == Compare.END_WITH) {
                builder.append(" LIKE '%" + value + "'");
            }
        }
        return null;
    }

    public String batchInsertSeparator() {
        return " ";
    }

    public boolean supportInsertPlaceholder() {
        return false;
    }

    public int insert(JdbcTemplate template, String random, Object data, final String sql, final List<Object> values, String[] pks) throws Exception {
        int cnt = 0;
        if (null != values && values.size() != 0) {
            cnt = template.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = null;
                    ps = con.prepareStatement(sql);
                    int idx = 0;
                    if (null != values) {
                        for (Object obj : values) {
                            ps.setObject(++idx, obj);
                        }
                    }
                    return ps;
                }
            });
            return cnt;
        }
        cnt = template.update(sql);
        return cnt;
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatFun(args);
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        String sql = "SHOW TABLES";
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " LIKE '" + pattern + "'";
        }
        sqls.add(sql);
        sql = "SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE TYPE = 'NORMAL_TABLE' ";
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            sql = sql + " AND DB_NAME = '" + catalog + "'";
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " AND TABLE_NAME LIKE '" + pattern + "'";
        }
        sqls.add(sql);
        return sqls;
    }

    public List<String> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    Table table;
                    String name = row.getString("stable_name");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (Table)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("stable_name");
                if (BasicUtil.isEmpty((Object)name)) continue;
                Table table = (Table)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("db_name"));
                table.setType(row.getString("type"));
                table.setComment(row.getString("table_comment"));
            }
        }
        return tables;
    }

    public LinkedHashMap<String, Table> tables(boolean create, LinkedHashMap<String, Table> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        String sql = "SHOW STABLES";
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " LIKE '" + pattern + "'";
        }
        sqls.add(sql);
        sql = "SELECT * FROM INFORMATION_SCHEMA.INS_STABLES WHERE 1=1 ";
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            sql = sql + " AND DB_NAME = '" + catalog + "'";
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            sql = sql + " AND STABLE_NAME LIKE '" + pattern + "'";
        }
        sqls.add(sql);
        return sqls;
    }

    public LinkedHashMap<String, MasterTable> mtables(boolean create, LinkedHashMap<String, MasterTable> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        block5: {
            block4: {
                if (null == tables) {
                    tables = new LinkedHashMap();
                }
                if (index != 0) break block4;
                for (DataRow row : set) {
                    MasterTable table;
                    String name = row.getString("stable_name");
                    if (BasicUtil.isEmpty((Object)name) || null != (table = (MasterTable)tables.get(name.toUpperCase())) || !create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                break block5;
            }
            if (index != 1) break block5;
            for (DataRow row : set) {
                String name = row.getString("stable_name");
                if (BasicUtil.isEmpty((Object)name)) continue;
                MasterTable table = (MasterTable)tables.get(name.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new MasterTable(name);
                    tables.put(name.toUpperCase(), table);
                }
                table.setCatalog(row.getString("db_name"));
                table.setComment(row.getString("table_comment"));
            }
        }
        return tables;
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = null;
        String stable = null;
        if (null != master) {
            stable = master.getName();
        }
        if (null != tags && tags.size() > 0) {
            for (String key : tags.keySet()) {
                builder = new StringBuilder();
                Object value = tags.get(key);
                builder.append("SELECT table_name FROM INFORMATION_SCHEMA.INS_TAGS WHERE STABLE_NAME = '").append(stable).append("'").append(" AND TAG_NAME ='").append(key.toLowerCase()).append("'").append(" AND TAG_VALUE ");
                if (null == value) {
                    builder.append("IS NULL");
                } else if (BasicUtil.isNumber((Object)value)) {
                    builder.append("= ").append(value);
                } else {
                    builder.append("= '").append(value).append("'");
                }
                sqls.add(builder.toString());
            }
        }
        builder = new StringBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TABLES WHERE STABLE_NAME = '").append(stable).append("'");
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append(" AND TABLE_NAME = '").append(name).append("'");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return this.buildQueryPartitionTableRunSQL(master, tags, null);
    }

    public LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        if (index == 0) {
            tables = new LinkedHashMap();
            for (DataRow row : set) {
                String name = row.getString("table_name");
                PartitionTable table = new PartitionTable(name);
                tables.put(name, table);
            }
        } else if (index < total - 1) {
            tables.keySet().retainAll(set.getStrings("table_name"));
        }
        if (index == total - 1) {
            LinkedHashMap<String, PartitionTable> result = new LinkedHashMap<String, PartitionTable>();
            for (DataRow row : set) {
                String name = row.getString("table_name");
                if (!tables.containsKey(name)) continue;
                PartitionTable table = new PartitionTable(name);
                result.put(name.toUpperCase(), table);
                table.setCatalog(row.getString("db_name"));
                table.setComment(row.getString("table_comment"));
                table.setMaster(master);
                result.put(name, table);
            }
            tables.clear();
            for (String key : result.keySet()) {
                tables.put(key.toUpperCase(), result.get(key));
            }
        }
        return tables;
    }

    public LinkedHashMap<String, PartitionTable> ptables(boolean create, LinkedHashMap<String, PartitionTable> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
            sqls.add(builder.toString());
        } else {
            builder = new StringBuilder();
            builder.append("DESCRIBE ").append(table.getName());
            sqls.add(builder.toString());
        }
        return sqls;
    }

    public LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("field");
            String note = row.getString("note");
            if (BasicUtil.isEmpty((Object)name) || "TAG".equalsIgnoreCase(note)) continue;
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                if (!create) continue;
                column = new Column();
                columns.put(name.toUpperCase(), column);
            }
            column.setName(name);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
            column.setTypeName(row.getString("type"));
            column.setPrecision(row.getInt("length", Integer.valueOf(0)));
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        return columns;
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(false, columns, dbmd, table, pattern);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
            sqls.add(builder.toString());
        } else {
            if (table instanceof MasterTable) {
                builder.append("SELECT DISTINCT STABLE_NAME,DB_NAME,TAG_NAME,TAG_TYPE FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalog()).append("' AND STABLE_NAME='").append(table.getName()).append("'");
            } else {
                builder.append("SELECT * FROM INFORMATION_SCHEMA.INS_TAGS WHERE db_name = '");
                builder.append(table.getCatalog()).append("' AND TABLE_NAME='").append(table.getName()).append("'");
            }
            sqls.add(builder.toString());
            builder = new StringBuilder();
            builder.append("DESCRIBE ").append(table.getName());
            sqls.add(builder.toString());
        }
        return sqls;
    }

    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        block6: {
            block5: {
                if (null == tags) {
                    tags = new LinkedHashMap();
                }
                if (index != 0) break block5;
                for (DataRow row : set) {
                    String name = row.getString("TAG_NAME");
                    if (BasicUtil.isEmpty((Object)name)) continue;
                    Tag item = (Tag)tags.get(name.toUpperCase());
                    if (null == item) {
                        if (!create) continue;
                        item = new Tag();
                    }
                    item.setName(name);
                    item.setTypeName(row.getString("TAG_TYPE"));
                    item.setValue(row.get("TAG_VALUE"));
                    tags.put(name.toUpperCase(), item);
                }
                break block6;
            }
            if (index != 1) break block6;
            for (DataRow row : set) {
                String name;
                String note = row.getString("note");
                if (!"TAG".equalsIgnoreCase(note) || BasicUtil.isEmpty((Object)(name = row.getString("field")))) continue;
                Tag item = (Tag)tags.get(name.toUpperCase());
                if (null == item) {
                    if (!create) continue;
                    item = new Tag();
                }
                item.setName(name);
                item.setTypeName(row.getString("type"));
                item.setPrecision(row.getInt("length", Integer.valueOf(0)));
                item.setValue(row.get("TAG_VALUE"));
                tags.put(name.toUpperCase(), item);
            }
        }
        return tags;
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, LinkedHashMap<String, Tag> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    public List<String> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, LinkedHashMap<String, Index> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Constraint> constraints(int index, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        return super.buildCreateCommentRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(Table table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return super.checkTableExists(builder, exists);
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<String> buildCreateRunSQL(MasterTable table) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        MasterTable tab = table;
        List<String> list = this.buildCreateRunSQL((Table)tab);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String sql = list.get(i);
            if (i == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(sql);
                builder.append(" TAGS (");
                LinkedHashMap tags = table.getTags();
                int idx = 0;
                for (Tag tag : tags.values()) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                    this.type(builder, (Column)tag);
                    this.comment(builder, (Column)tag);
                    ++idx;
                }
                builder.append(")");
                sqls.add(builder.toString());
                continue;
            }
            sqls.add(sql);
        }
        return sqls;
    }

    public List<String> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(MasterTable table) throws Exception {
        MasterTable tab = table;
        return super.buildDropRunSQL((Table)tab);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        String stable = table.getMasterName();
        if (BasicUtil.isEmpty((Object)stable)) {
            throw new SQLException("\u672a\u6307\u5b9a\u4e3b\u8868");
        }
        PartitionTable tab = table;
        builder.append((String)super.buildCreateRunSQL((Table)tab).get(0));
        builder.append(" USING ");
        SQLUtil.delimiter((StringBuilder)builder, (String)stable, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append("(");
        Collection tags = table.getTags().values();
        int idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            ++idx;
        }
        builder.append(") TAGS (");
        idx = 0;
        for (Tag tag : tags) {
            if (idx > 0) {
                builder.append(",");
            }
            builder.append(this.write(null, tag.getValue(), false));
            ++idx;
        }
        builder.append(")");
        sqls.add(builder.toString());
        return sqls;
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        PartitionTable tab = table;
        return super.buildDropRunSQL((Table)tab);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return "ALTER";
    }

    public List<String> buildAddRunSQL(Column column) throws Exception {
        return super.buildAddRunSQL(column);
    }

    public List<String> buildAlterRunSQL(Column column) throws Exception {
        return super.buildAlterRunSQL(column);
    }

    public String buildDropRunSQL(Column column) throws Exception {
        return super.buildDropRunSQL(column);
    }

    public String buildRenameRunSQL(Column column) throws Exception {
        return super.buildRenameRunSQL(column);
    }

    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        return super.buildChangeTypeRunSQL(column);
    }

    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        return super.buildChangeDefaultRunSQL(column);
    }

    public String buildChangeNullableRunSQL(Column column) throws Exception {
        return super.buildChangeNullableRunSQL(column);
    }

    public String buildCreateCommentRunSQL(Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public String buildChangeCommentRunSQL(Column column) throws Exception {
        return super.buildChangeCommentRunSQL(column);
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        Integer precision;
        String typeName = column.getTypeName();
        if (BasicUtil.isEmpty((Object)typeName)) {
            return builder;
        }
        builder.append(typeName);
        if (typeName.equalsIgnoreCase("NCHAR") && null != (precision = column.getPrecision()) && precision > 0) {
            builder.append("(").append(precision).append(")");
        }
        return builder;
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        if (column instanceof Tag) {
            String comment = column.getComment();
            if (BasicUtil.isNotEmpty((Object)comment)) {
                builder.append(" COMMENT '").append(comment).append("'");
            }
            return builder;
        }
        return null;
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAddRunSQL(primary);
    }

    public List<String> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public String buildDropRunSQL(PrimaryKey primary) throws Exception {
        return super.buildDropRunSQL(primary);
    }

    public String buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        return super.buildDropRunSQL(index);
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return this.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "NOW";
        }
        return null;
    }
}

