/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.postgis;

import org.postgis.Geometry;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.PGgeometry;
import org.postgis.PGgeometryLW;
import org.postgis.Point;
import org.postgis.Polygon;

public class PostgisGeometryAdapter {
    public static Object parsePGgeometry(PGgeometry input) {
        Object result = input;
        if (null != input) {
            Geometry geometry = input.getGeometry();
            int type = input.getGeoType();
            if (type == 1) {
                result = PostgisGeometryAdapter.parsePoint((Point)geometry);
            } else if (type == 2) {
                result = PostgisGeometryAdapter.parseLineString((LineString)geometry);
            } else if (type == 3) {
                result = PostgisGeometryAdapter.parsePolygon((Polygon)geometry);
            } else if (type == 4) {
                result = PostgisGeometryAdapter.parseMultiPoint((MultiPoint)geometry);
            } else if (type == 5) {
                result = PostgisGeometryAdapter.parseMultiLineString((MultiLineString)geometry);
            } else if (type == 6) {
                result = PostgisGeometryAdapter.parseMultiPolygon((MultiPolygon)geometry);
            } else if (type == 7) {
                result = PostgisGeometryAdapter.parseGeometryCollection((GeometryCollection)geometry);
            }
        }
        return result;
    }

    public static Object parsePolygon(Polygon input) {
        return input;
    }

    public static Object parseMultiLineString(MultiLineString input) {
        return input;
    }

    public static Object parsePoint(Point input) {
        org.anyline.entity.geometry.Point result = new org.anyline.entity.geometry.Point();
        result.tag("Point");
        try {
            result.srid(input.srid);
            result.x(Double.valueOf(input.x));
            result.y(Double.valueOf(input.y));
        }
        catch (Exception e) {
            return input;
        }
        return result;
    }

    public static Object parsePGgeometryLW(PGgeometryLW input) {
        return input;
    }

    public static Object parsePGbox3d(PGbox3d input) {
        return input;
    }

    public static Object parsePGbox2d(PGbox2d input) {
        return input;
    }

    public static Object parseMultiPolygon(MultiPolygon input) {
        return input;
    }

    public static Object parseMultiPoint(MultiPoint input) {
        org.anyline.entity.geometry.MultiPoint result = new org.anyline.entity.geometry.MultiPoint();
        result.tag("MultiPoint");
        try {
            Point[] points;
            result.srid(input.srid);
            for (Point point : points = input.getPoints()) {
                result.add(point.getX(), point.getY());
            }
        }
        catch (Exception e) {
            return input;
        }
        return result;
    }

    public static Object parseLineString(LineString input) {
        return input;
    }

    public static Object parseGeometryCollection(GeometryCollection input) {
        return input;
    }
}

