/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.postgis;

import org.anyline.adapter.DataWriter;
import org.anyline.data.jdbc.postgresql.PostgresqlGeometryAdapter;
import org.anyline.entity.geometry.Line;
import org.anyline.entity.geometry.LineSegment;
import org.anyline.entity.geometry.LineString;
import org.anyline.entity.geometry.Point;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.metadata.type.init.StandardTypeMetadata;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;

public enum PostgisWriter {
    PointWriter(new Object[]{Point.class, StandardTypeMetadata.POINT}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (value instanceof Point) {
                Point point = (Point)value;
                PGpoint pg = PostgresqlGeometryAdapter.convert((Point)point);
                if (placeholder) {
                    return pg;
                }
                return point.toString(true);
            }
            return value;
        }
    }),
    LineSegmentWriter(new Object[]{LineSegment.class, StandardTypeMetadata.LSEG}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (value instanceof LineSegment) {
                LineSegment segment = (LineSegment)value;
                PGlseg pg = PostgresqlGeometryAdapter.convert((LineSegment)segment);
                if (placeholder) {
                    return pg;
                }
                return segment.toString(true);
            }
            return value;
        }
    }),
    PathWriter(new Object[]{LineString.class, StandardTypeMetadata.PATH}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (value instanceof LineString) {
                LineString string = (LineString)value;
                PGpath pg = PostgresqlGeometryAdapter.convert((LineString)string);
                if (placeholder) {
                    return pg;
                }
                return string.toString(true);
            }
            return value;
        }
    }),
    LineWriter(new Object[]{Line.class, StandardTypeMetadata.LINE}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (value instanceof Line) {
                Line line = (Line)value;
                PGline pg = PostgresqlGeometryAdapter.convert((Line)line);
                if (placeholder) {
                    return pg;
                }
                return line.toString(true);
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private PostgisWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

