/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.postgis;

import org.anyline.adapter.DataReader;
import org.anyline.data.jdbc.postgis.PostgisGeometryAdapter;
import org.postgis.GeometryCollection;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPoint;
import org.postgis.MultiPolygon;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.PGgeometry;
import org.postgis.PGgeometryLW;
import org.postgis.Point;
import org.postgis.Polygon;

public enum PostgisReader {
    PointReader(new Object[]{Point.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof Point) {
                value = PostgisGeometryAdapter.parsePoint((Point)value);
            }
            return value;
        }
    }),
    PolygonReader(new Object[]{Polygon.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof Polygon) {
                value = PostgisGeometryAdapter.parsePolygon((Polygon)value);
            }
            return value;
        }
    }),
    PGgeometryLWReader(new Object[]{PGgeometryLW.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGgeometryLW) {
                value = PostgisGeometryAdapter.parsePGgeometryLW((PGgeometryLW)value);
            }
            return value;
        }
    }),
    PGgeometryReader(new Object[]{PGgeometry.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGgeometry) {
                value = PostgisGeometryAdapter.parsePGgeometry((PGgeometry)value);
            }
            return value;
        }
    }),
    PGbox3dReader(new Object[]{PGbox3d.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGbox3d) {
                value = PostgisGeometryAdapter.parsePGbox3d((PGbox3d)value);
            }
            return value;
        }
    }),
    PGbox2dReader(new Object[]{PGbox2d.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGbox2d) {
                value = PostgisGeometryAdapter.parsePGbox2d((PGbox2d)value);
            }
            return value;
        }
    }),
    MultiPolygonReader(new Object[]{MultiPolygon.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof MultiPolygon) {
                value = PostgisGeometryAdapter.parseMultiPolygon((MultiPolygon)value);
            }
            return value;
        }
    }),
    MultiPointReader(new Object[]{MultiPoint.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof MultiPoint) {
                value = PostgisGeometryAdapter.parseMultiPoint((MultiPoint)value);
            }
            return value;
        }
    }),
    MultiLineStringReader(new Object[]{MultiLineString.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof MultiLineString) {
                value = PostgisGeometryAdapter.parseMultiLineString((MultiLineString)value);
            }
            return value;
        }
    }),
    LineStringReader(new Object[]{LineString.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof LineString) {
                value = PostgisGeometryAdapter.parseLineString((LineString)value);
            }
            return value;
        }
    }),
    GeometryCollectionReader(new Object[]{GeometryCollection.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof GeometryCollection) {
                value = PostgisGeometryAdapter.parseGeometryCollection((GeometryCollection)value);
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataReader reader;

    public Object[] supports() {
        return this.supports;
    }

    public DataReader reader() {
        return this.reader;
    }

    private PostgisReader(Object[] supports, DataReader reader) {
        this.supports = supports;
        this.reader = reader;
    }
}

