/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.oscar;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.anyline.adapter.DataWriter;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.DateUtil;

public enum OscarWriter {
    DateWriter(new Object[]{java.sql.Date.class, LocalDate.class}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (!placeholder && null != value) {
                Date date = (Date)ConvertProxy.convert((Object)value, Date.class, (boolean)false);
                value = " to_date( '" + DateUtil.format((Date)date) + "', 'YYYY-MM-DD')";
            }
            return value;
        }
    }),
    DateTimeWriter(new Object[]{Timestamp.class, Date.class, LocalDateTime.class}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (!placeholder && null != value) {
                Date date = (Date)ConvertProxy.convert((Object)value, Date.class, (boolean)false);
                value = " to_timestamp( '" + DateUtil.format((Date)date) + "', 'YYYY-MM-DD HH24:MI:SS')";
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private OscarWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

