/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.oscar;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.SQLAdapter;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.entity.View;
import org.anyline.data.jdbc.oscar.OscarColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.run.TextRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.Column;
import org.anyline.entity.data.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.oscar")
public class OscarAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    public static boolean IS_GET_SEQUENCE_VALUE_BEFORE_INSERT = false;
    @Value(value="${anyline.jdbc.delimiter.oscar:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.oscar;
    }

    public OscarAdapter() {
        this.delimiterFr = "";
        this.delimiterTo = "";
        for (OscarColumnTypeAlias alias : OscarColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatFun(args);
    }

    public String buildQuerySequence(boolean next, String ... names) {
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        StringBuilder builder = new StringBuilder();
        TextRun run = null;
        if (null != names && names.length > 0) {
            run = new TextRun();
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(name).append(".").append(key).append(" AS ").append(name);
            }
            builder.append(" FROM DUAL");
        }
        return builder.toString();
    }

    public String parseExists(Run run) {
        String sql = "SELECT 1 AS IS_EXISTS FROM DUAL WHERE  EXISTS(" + run.getBuilder().toString() + ")";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    protected void createPrimaryValue(JdbcTemplate template, Collection list, String seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ").append(seq).append(" AS ID FROM(\n");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            builder.append("SELECT NULL FROM DUAL\n");
            if (i >= size - 1) continue;
            builder.append("UNION ALL\n");
        }
        builder.append(") M");
        List ids = template.queryForList(builder.toString());
        int i = 0;
        for (Object obj : list) {
            Object value = ((Map)ids.get(i++)).get("ID");
            this.setPrimaryValue(obj, value);
        }
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, DataSet set, List<String> keys) {
        String key;
        int i;
        if (null == set || set.size() == 0) {
            return;
        }
        StringBuilder builder = run.getBuilder();
        DataRow first = set.getRow(0);
        HashMap<String, String> seqs = new HashMap<String, String>();
        for (String key2 : keys) {
            String str;
            String value = first.getStringNvl(key2, new String[0]);
            if (null == value || !(value instanceof String) || !(str = value).toUpperCase().contains(".NEXTVAL")) continue;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            }
            if (IS_GET_SEQUENCE_VALUE_BEFORE_INSERT) {
                this.createPrimaryValue(template, (Collection)set, str);
                continue;
            }
            seqs.put(key2, str);
        }
        builder.append("INSERT INTO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)dest, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" (");
        int keySize = keys.size();
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            builder.append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append(") \n");
        builder.append("SELECT ");
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            String seq = (String)seqs.get(key);
            if (null != seq) {
                builder.append(seq);
            } else {
                builder.append("M.").append(key);
            }
            builder.append(" AS ").append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append("\nFROM( ");
        keys.removeAll(seqs.keySet());
        int col = 0;
        for (DataRow row : set) {
            if (row.hasPrimaryKeys() && null != this.primaryGenerator) {
                this.createPrimaryValue(row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
            if (col > 0) {
                builder.append("\n\tUNION ALL");
            }
            builder.append("\n\tSELECT ");
            this.insertValue(template, run, row, true, true, false, keys);
            builder.append(" FROM DUAL ");
            ++col;
        }
        builder.append(") M ");
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, Collection list, List<String> keys) {
        String key;
        int i;
        if (null == list || list.isEmpty()) {
            return;
        }
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.createInserts(template, run, dest, set, keys);
            return;
        }
        Object first = list.iterator().next();
        HashMap<String, String> seqs = new HashMap<String, String>();
        for (String key2 : keys) {
            String str;
            Object value = BeanUtil.getFieldValue(first, (String)key2);
            if (null == value || !(value instanceof String) || !(str = (String)value).toUpperCase().contains(".NEXTVAL")) continue;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            }
            if (IS_GET_SEQUENCE_VALUE_BEFORE_INSERT) {
                this.createPrimaryValue(template, list, str);
                continue;
            }
            seqs.put(key2, str);
        }
        builder.append("INSERT INTO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)dest, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" (");
        int keySize = keys.size();
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            builder.append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append(") \n");
        builder.append("SELECT ");
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            String seq = (String)seqs.get(key);
            if (null != seq) {
                builder.append(seq);
            } else {
                builder.append("M.").append(key);
            }
            builder.append(" AS ").append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append("\nFROM( ");
        keys.removeAll(seqs.keySet());
        int col = 0;
        for (Object obj : list) {
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                if (row.hasPrimaryKeys() && null != this.primaryGenerator && BasicUtil.isEmpty((Object)row.getPrimaryValue())) {
                    String pk = row.getPrimaryKey();
                    if (null == pk) {
                        pk = ConfigTable.DEFAULT_PRIMARY_KEY;
                    }
                    this.createPrimaryValue(row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
                }
            } else if (EntityAdapterProxy.hasAdapter()) {
                EntityAdapterProxy.createPrimaryValue(obj);
            } else if (null != this.primaryGenerator) {
                this.createPrimaryValue(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), null, null);
            }
            if (col > 0) {
                builder.append("\n\tUNION ALL");
            }
            builder.append("\n\tSELECT ");
            this.insertValue(template, run, obj, true, true, false, keys);
            builder.append(" FROM DUAL ");
            ++col;
        }
        builder.append(") M ");
    }

    public int insert(JdbcTemplate template, String random, Object data, String sql, List<Object> values, String[] pks) throws Exception {
        int cnt = 0;
        if (data instanceof Collection) {
            if (null == values || values.isEmpty()) {
                cnt = template.update(sql);
            } else {
                int size = values.size();
                Object[] params = new Object[size];
                for (int i = 0; i < size; ++i) {
                    params[i] = values.get(i);
                }
                cnt = template.update(sql, params);
            }
        } else {
            pks = new String[]{this.getPrimayKey(data)};
            cnt = super.insert(template, random, data, sql, values, pks);
        }
        return cnt;
    }

    public boolean identity(String random, Object data, KeyHolder keyholder) {
        if (data instanceof Collection) {
            return false;
        }
        return super.identity(random, data, keyholder);
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append(" SELECT * FROM (");
        builder.append(" SELECT A.TABLE_NAME, B.COMMENTS, 'TABLE' TABLE_TYPE FROM USER_TABLES A, USER_TAB_COMMENTS B WHERE A.TABLE_NAME = B.TABLE_NAME");
        builder.append(" UNION ALL ");
        builder.append(" SELECT A.VIEW_NAME,  B.COMMENTS, 'VIEW'  TABLE_TYPE FROM USER_VIEWS  A, USER_TAB_COMMENTS B WHERE A.VIEW_NAME = B.TABLE_NAME");
        builder.append(" ) T WHERE 1=1");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(pattern).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)types)) {
            String[] tmps = types.split(",");
            builder.append(" AND TABLE_TYPE IN(");
            int idx = 0;
            for (String tmp : tmps) {
                if (idx > 0) {
                    builder.append(",");
                }
                builder.append("'").append(tmp).append("'");
                ++idx;
            }
            builder.append(")");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public List<String> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM USER_TAB_COMMENTS\n");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append("WHERE TABLE_NAME = '").append(pattern).append("'");
        }
        return sqls;
    }

    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            Table table = (Table)tables.get(name.toUpperCase());
            if (null == table) {
                table = new Table();
            }
            table.setCatalog(catalog);
            table.setSchema(schema);
            table.setName(name);
            table.setComment(row.getString("COMMENTS"));
            tables.put(name.toUpperCase(), table);
        }
        return tables;
    }

    public LinkedHashMap<String, Table> tables(boolean create, LinkedHashMap<String, Table> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<String> buildQueryViewRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT A.VIEW_NAME,A.TEXT DEFINITION_SQL,  B.COMMENTS, 'VIEW'  TABLE_TYPE FROM USER_VIEWS  A, USER_TAB_COMMENTS B WHERE A.VIEW_NAME = B.TABLE_NAME");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(pattern).append("'");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public LinkedHashMap<String, View> views(int index, boolean create, String catalog, String schema, LinkedHashMap<String, View> views, DataSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("VIEW_NAME");
            View view = (View)views.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            view.setCatalog(catalog);
            view.setSchema(schema);
            view.setName(name);
            view.setComment(row.getString("COMMENTS"));
            view.setDefinition(row.getString("DEFINITION_SQL"));
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(boolean create, LinkedHashMap<String, MasterTable> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags, name);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags);
    }

    public LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, PartitionTable> ptables(boolean create, LinkedHashMap<String, PartitionTable> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT M.*, F.COMMENTS AS COLUMN_COMMENT FROM USER_TAB_COLUMNS    M \n");
            builder.append("LEFT JOIN USER_COL_COMMENTS F ON M.TABLE_NAME = F.TABLE_NAME AND M.COLUMN_NAME = F.COLUMN_NAME\n");
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append("WHERE M.TABLE_NAME = '").append(table.getName()).append("'");
            }
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(int index, boolean create, Table table, LinkedHashMap<String, org.anyline.data.entity.Column> columns, DataSet set) throws Exception {
        set.removeColumn(new String[]{"CHARACTER_SET_NAME"});
        return super.columns(index, create, table, columns, set);
    }

    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(boolean create, LinkedHashMap<String, org.anyline.data.entity.Column> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public LinkedHashMap<String, org.anyline.data.entity.Column> columns(boolean create, LinkedHashMap<String, org.anyline.data.entity.Column> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, LinkedHashMap<String, Tag> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.tags(create, tags, dbmd, table, pattern);
    }

    public List<String> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, LinkedHashMap<String, Index> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Constraint> constraints(int index, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        if (BasicUtil.isEmpty((Object)table.getComment())) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" COMMENT ON TABLE ");
        this.name(builder, table);
        builder.append("  IS '").append(table.getComment()).append("'");
        return builder.toString();
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table, Collection<org.anyline.data.entity.Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" RENAME TO ");
        Table update = new Table(table.getUpdate().getName());
        this.name(builder, update);
        return builder.toString();
    }

    public String buildChangeCommentRunSQL(Table table) throws Exception {
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            StringBuilder builder = new StringBuilder();
            builder.append("COMMENT ON TABLE ");
            this.name(builder, table);
            builder.append(" IS '").append(comment).append("'");
            return builder.toString();
        }
        return null;
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return builder;
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            int idx = 0;
            for (org.anyline.data.entity.Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public StringBuilder checkViewExists(StringBuilder builder, boolean exists) {
        return builder;
    }

    public String buildCreateCommentRunSQL(View view) throws Exception {
        return this.buildCreateCommentRunSQL((Table)view);
    }

    public List<String> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return "ALTER";
    }

    public List<String> buildAddRunSQL(org.anyline.data.entity.Column column, boolean slice) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        column.setCreater((JDBCAdapter)this);
        StringBuilder builder = new StringBuilder();
        if (!slice) {
            Table table = column.getTable();
            builder.append("ALTER TABLE ");
            this.name(builder, table);
        }
        builder.append(" ADD ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, column);
        sqls.add(builder.toString());
        sqls.add(this.buildCreateCommentRunSQL(column));
        return sqls;
    }

    public List<String> buildAlterRunSQL(org.anyline.data.entity.Column column, boolean slice) throws Exception {
        return super.buildAlterRunSQL(column, slice);
    }

    public List<String> buildAlterRunSQL(org.anyline.data.entity.Column column) throws Exception {
        return this.buildAlterRunSQL(column, false);
    }

    public String buildDropRunSQL(org.anyline.data.entity.Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public String buildRenameRunSQL(org.anyline.data.entity.Column column) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable());
        builder.append(" RENAME COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getNewName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    public List<String> buildChangeTypeRunSQL(org.anyline.data.entity.Column column) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        org.anyline.data.entity.Column update = column.getUpdate();
        String name = column.getName();
        String type = column.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        String uname = update.getName();
        String utype = update.getTypeName();
        if (uname.endsWith("_TMP_UPDATE_TYPE")) {
            sqls.add(this.buildDropRunSQL(update));
        } else {
            if (utype != null && utype.contains("(")) {
                utype = utype.substring(0, utype.indexOf("("));
            }
            if (!type.equals(utype)) {
                String tmp_name = column.getName() + "_TMP_UPDATE_TYPE";
                update.setName(tmp_name);
                String rename = this.buildRenameRunSQL(column);
                sqls.add(rename);
                update.setName(uname);
                sqls.addAll(this.buildAddRunSQL(update));
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                this.name(builder, column.getTable());
                builder.append(" SET ");
                SQLUtil.delimiter((StringBuilder)builder, (String)uname, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                builder.append(" = ");
                SQLUtil.delimiter((StringBuilder)builder, (String)tmp_name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                sqls.add(builder.toString());
                column.setName(tmp_name);
                String drop = this.buildDropRunSQL(column);
                sqls.add(drop);
                column.setName(name);
                update.setName(tmp_name);
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                this.name(builder, column.getTable());
                builder.append(" MODIFY(");
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.type(builder, column.getUpdate());
                builder.append(")");
                sqls.add(builder.toString());
            }
        }
        return sqls;
    }

    public String buildChangeDefaultRunSQL(org.anyline.data.entity.Column column) throws Exception {
        Object def = null;
        def = null != column.getUpdate() ? column.getUpdate().getDefaultValue() : column.getDefaultValue();
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable()).append(" MODIFY ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" DEFAULT ");
        if (null != def) {
            def = this.write((Column)column, def, false);
            builder.append(def);
        } else {
            builder.append("NULL");
        }
        return builder.toString();
    }

    public String buildChangeNullableRunSQL(org.anyline.data.entity.Column column) throws Exception {
        int nullable = column.isNullable();
        int uNullable = column.getUpdate().isNullable();
        if (nullable != -1 && uNullable != -1) {
            if (nullable == uNullable) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            this.name(builder, column.getTable()).append(" MODIFY ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" NOT ");
            }
            builder.append("NULL");
            return builder.toString();
        }
        return null;
    }

    public String buildCreateCommentRunSQL(org.anyline.data.entity.Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public String buildChangeCommentRunSQL(org.anyline.data.entity.Column column) throws Exception {
        String comment = null;
        comment = null != column.getUpdate() ? column.getUpdate().getComment() : column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            StringBuilder builder = new StringBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(builder, column.getTable()).append(".");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append(" IS '").append(comment).append("'");
            return builder.toString();
        }
        return null;
    }

    public StringBuilder define(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.increment(builder, column);
    }

    public StringBuilder onupdate(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, org.anyline.data.entity.Column column) {
        return super.comment(builder, column);
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable());
            builder.append(" ADD CONSTRAINT ").append(primary.getTableName()).append("_PK").append(" PRIMARY KEY(");
            boolean first = true;
            for (org.anyline.data.entity.Column column : columns.values()) {
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                if (!first) {
                    builder.append(",");
                }
                first = false;
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public List<String> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public String buildDropRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable());
        builder.append(" DROP PRIMARY KEY");
        return builder.toString();
    }

    public String buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public List<String> buildQueryPrimaryRunSQL(Table table) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT COL.* FROM DBA_CONSTRAINTS CON ,DBA_CONS_COLUMNS COL\n");
        builder.append("WHERE CON.CONSTRAINT_NAME = COL.CONSTRAINT_NAME\n");
        builder.append("AND CON.CONSTRAINT_TYPE = 'P'\n");
        builder.append("AND COL.TABLE_NAME = '").append(table.getName()).append("'\n");
        if (BasicUtil.isNotEmpty((Object)table.getSchema())) {
            builder.append(" AND COL.OWNER = '").append(table.getSchema()).append("'");
        }
        list.add(builder.toString());
        return list;
    }

    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = table.getPrimaryKey();
        for (DataRow row : set) {
            String col;
            org.anyline.data.entity.Column column;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString("TABLE_NAME"));
                primary.setTable(table);
            }
            if (null == (column = primary.getColumn(col = row.getString("COLUMN_NAME")))) {
                column = new org.anyline.data.entity.Column(col);
            }
            column.setTable(table);
            column.setPosition(row.getInt("POSITION", Integer.valueOf(0)));
            primary.addColumn(column);
        }
        return primary;
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        return super.buildDropRunSQL(index);
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(org.anyline.data.entity.Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(org.anyline.data.entity.Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(org.anyline.data.entity.Column column) {
        return super.isCharColumn(column);
    }

    public String value(JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "sysdate";
        }
        return null;
    }
}

