/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.opengauss;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.SQLAdapter;
import org.anyline.data.jdbc.opengauss.OpenGaussColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TextRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.RegularUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.opengauss")
public class OpenGaussAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.opengauss:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.OpenGauss;
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public OpenGaussAdapter() {
        this.delimiterFr = "\"";
        this.delimiterTo = "\"";
        for (OpenGaussColumnTypeAlias alias : OpenGaussColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + limit + " OFFSET " + navi.getFirstRow();
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatOr(args);
    }

    public List<Run> buildQuerySequence(boolean next, String ... names) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        if (null != names && names.length > 0) {
            run = new TextRun();
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(key).append("('").append(name).append("') AS ").append(name);
            }
        }
        return runs;
    }

    public List<Run> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableRunSQL(catalog, schema, pattern, types);
    }

    public List<Run> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRunSQL(catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.tables(index, create, catalog, schema, tables, set);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRunSQL(MasterTable table, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(table, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            builder.append("SELECT M.* ,FD.DESCRIPTION AS COLUMN_COMMENT FROM INFORMATION_SCHEMA.COLUMNS M\n");
            builder.append("LEFT JOIN PG_CLASS FC ON FC.RELNAME = M.TABLE_NAME\n");
            builder.append("LEFT JOIN PG_DESCRIPTION FD ON FD.OBJOID = FC.OID AND FD.OBJSUBID = M.ORDINAL_POSITION\n");
            builder.append("WHERE 1 = 1\n");
            if (BasicUtil.isNotEmpty((Object)catalog)) {
                builder.append(" AND M.TABLE_CATALOG = '").append(catalog).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND M.TABLE_SCHEMA = '").append(schema).append("'");
            }
            builder.append(" AND M.TABLE_NAME = '").append(table.getName()).append("'");
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        set.changeKey("UDT_NAME", "DATA_TYPE");
        return super.columns(index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<Run> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, LinkedHashMap<String, T> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.tags(create, tags, dbmd, table, pattern);
    }

    public List<Run> buildQueryPrimaryRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT  m.conname,  pg_get_constraintdef(m.oid, true) AS define\n");
        builder.append("FROM pg_constraint m \n");
        builder.append("LEFT JOIN pg_namespace ns ON m.connamespace = ns.oid \n");
        builder.append("LEFT JOIN pg_class ft ON m.conrelid = ft.oid \n");
        builder.append("WHERE ft.relname = '").append(table.getName()).append("'");
        String schema = table.getSchema();
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND ns.nspname = '").append(schema).append("'");
        }
        return runs;
    }

    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = null;
        if (set.size() > 0) {
            String[] cols;
            DataRow row = set.getRow(0);
            primary = new PrimaryKey();
            primary.setName(row.getString("conname"));
            String define = row.getString("define");
            for (String col : cols = RegularUtil.cut((String)define, (String[])new String[]{"(", ")"}).split(",")) {
                Column column = new Column(col.trim());
                column.setTable(table);
                primary.addColumn(column);
            }
        }
        return primary;
    }

    public List<Run> buildQueryForeignsRunSQL(Table table) throws Exception {
        String name;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT TC.CONSTRAINT_NAME,TC.TABLE_NAME AS TABLE_NAME, KCU.COLUMN_NAME AS COLUMN_NAME, KCU.ORDINAL_POSITION,CCU.TABLE_NAME AS REFERENCED_TABLE_NAME, CCU.COLUMN_NAME AS REFERENCED_COLUMN_NAME\n");
        builder.append("FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC\n");
        builder.append("JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU ON TC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME\n");
        builder.append("JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS CCU ON CCU.CONSTRAINT_NAME = TC.CONSTRAINT_NAME\n");
        builder.append("WHERE TC.CONSTRAINT_TYPE = 'FOREIGN KEY'\n");
        if (null != table && BasicUtil.isNotEmpty((Object)(name = table.getName()))) {
            builder.append(" AND TC.TABLE_NAME = '").append(name).append("'\n");
        }
        builder.append("ORDER BY KCU.ORDINAL_POSITION");
        return runs;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (null == foreigns) {
            foreigns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            ForeignKey foreign = (ForeignKey)foreigns.get(name.toUpperCase());
            if (null == foreign) {
                foreign = new ForeignKey();
                foreign.setName(name);
                foreign.setTable(row.getString("TABLE_NAME"));
                foreign.setReference(row.getString("REFERENCED_TABLE_NAME"));
                foreigns.put(name.toUpperCase(), foreign);
            }
            foreign.addColumn(new Column(row.getString("COLUMN_NAME")).setReference(row.getString("REFERENCED_COLUMN_NAME")).setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0))));
        }
        return foreigns;
    }

    public List<Run> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, LinkedHashMap<String, T> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRunSQL(Table table, List<Trigger.EVENT> events) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS WHERE 1=1");
        if (null != table) {
            String schemae = table.getSchema();
            String name = table.getName();
            if (BasicUtil.isNotEmpty((Object)schemae)) {
                builder.append(" AND TRIGGER_SCHEMA = '").append(schemae).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append(" AND EVENT_OBJECT_TABLE = '").append(name).append("'");
            }
        }
        if (null != events && events.size() > 0) {
            builder.append(" AND(");
            boolean first = true;
            for (Trigger.EVENT event : events) {
                if (!first) {
                    builder.append(" OR ");
                }
                builder.append("EVENT_MANIPULATION ='").append(event);
            }
            builder.append(")");
        }
        return runs;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TRIGGER_NAME");
            Trigger trigger = (Trigger)triggers.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            Table tab = new Table(row.getString("EVENT_OBJECT_TABLE"));
            tab.setSchema(row.getString("TRIGGER_SCHEMA"));
            tab.setCatalog(row.getString("TRIGGER_CATALOG("));
            trigger.setTable(tab);
            boolean each = false;
            if ("ROW".equalsIgnoreCase(row.getString("ACTION_ORIENTATION"))) {
                each = true;
            }
            trigger.setEach(each);
            try {
                String[] events = row.getStringNvl("EVENT_MANIPULATION", new String[0]).split(",");
                String time = row.getString("ACTION_TIMING");
                trigger.setTime(Trigger.TIME.valueOf((String)time));
                for (String event : events) {
                    trigger.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)event)});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            trigger.setDefinition(row.getString("ACTION_STATEMENT"));
            triggers.put(name.toUpperCase(), trigger);
        }
        return triggers;
    }

    public List<Run> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public List<Run> buildRenameRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" RENAME TO ");
        Table update = new Table(table.getUpdate().getName());
        this.name(builder, update);
        return runs;
    }

    public List<Run> buildChangeCommentRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON TABLE ");
            this.name(builder, table);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    public List<Run> buildAddCommentRunSQL(Table table) throws Exception {
        return this.buildChangeCommentRunSQL(table);
    }

    public List<Run> buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return super.checkTableExists(builder, exists);
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            int idx = 0;
            for (Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<Run> buildCreateRunSQL(View view) throws Exception {
        return super.buildCreateRunSQL(view);
    }

    public List<Run> buildAddCommentRunSQL(View view) throws Exception {
        return super.buildAddCommentRunSQL(view);
    }

    public List<Run> buildAlterRunSQL(View view) throws Exception {
        return super.buildAlterRunSQL(view);
    }

    public List<Run> buildRenameRunSQL(View view) throws Exception {
        return super.buildRenameRunSQL(view);
    }

    public List<Run> buildChangeCommentRunSQL(View view) throws Exception {
        return super.buildChangeCommentRunSQL(view);
    }

    public List<Run> buildDropRunSQL(View view) throws Exception {
        return super.buildDropRunSQL(view);
    }

    public StringBuilder checkViewExists(StringBuilder builder, boolean exists) {
        return super.checkViewExists(builder, exists);
    }

    public StringBuilder comment(StringBuilder builder, View view) {
        return super.comment(builder, view);
    }

    public List<Run> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public List<Run> buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public List<Run> buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<Run> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public List<Run> buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public List<Run> buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return super.alterColumnKeyword();
    }

    public List<Run> buildAddRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAddRunSQL(column);
    }

    public List<Run> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAlterRunSQL(column, slice);
    }

    public List<Run> buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public List<Run> buildDropRunSQL(Column column) throws Exception {
        return this.buildDropRunSQL(column, false);
    }

    public List<Run> buildRenameRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable(true));
        builder.append(" RENAME ").append(column.getName()).append(" TO ").append(column.getUpdate().getName());
        column.setName(column.getUpdate().getName());
        return runs;
    }

    public List<Run> buildChangeTypeRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Column update = column.getUpdate();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable(true));
        builder.append(" ALTER COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TYPE ");
        this.type(builder, update);
        String type = update.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        builder.append(" USING ").append(column.getName()).append("::").append(type);
        return runs;
    }

    public List<Run> buildChangeDefaultRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Object def = null;
        def = null != column.getUpdate() ? column.getUpdate().getDefaultValue() : column.getDefaultValue();
        if (null != def) {
            String str = def.toString();
            if (str.contains("::")) {
                str = str.split("::")[0];
            }
            str = str.replace("'", "");
            def = str;
        }
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable(true)).append(" ALTER COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        if (null != def) {
            builder.append(" SET DEFAULT '").append(def).append("'");
        } else {
            builder.append(" DROP DEFAULT");
        }
        return runs;
    }

    public List<Run> buildChangeNullableRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        int nullable = column.isNullable();
        int uNullable = column.getUpdate().isNullable();
        if (nullable != -1 && uNullable != -1 && nullable != uNullable) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("ALTER TABLE ");
            this.name(builder, column.getTable(true)).append(" ALTER ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" SET ");
            } else {
                builder.append(" DROP ");
            }
            builder.append(" NOT NULL");
            column.setNullable(uNullable);
        }
        return runs;
    }

    public List<Run> buildAddCommentRunSQL(Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public List<Run> buildChangeCommentRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = null;
        Column update = column.getUpdate();
        if (null != update) {
            comment = update.getComment();
        }
        if (BasicUtil.isEmpty(comment)) {
            comment = column.getComment();
        }
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(builder, column.getTable(true)).append(".");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    public List<Run> buildDropAutoIncrement(Column column) throws Exception {
        return super.buildDropAutoIncrement(column);
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            String type = column.getTypeName().toLowerCase();
            if ("int4".equals(type) || "int".equals(type) || "integer".equals(type)) {
                column.setType("SERIAL4");
            } else if ("int8".equals(type) || "long".equals(type) || "bigint".equals(type)) {
                column.setType("SERIAL8");
            } else if ("int2".equals(type) || "smallint".equals(type) || "short".equals(type)) {
                column.setType("SERIAL2");
            } else {
                column.setType("SERIAL8");
            }
        }
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<Run> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public List<Run> buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public List<Run> buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public List<Run> buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public List<Run> buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public List<Run> buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<Run> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable(true));
            builder.append(" ADD PRIMARY KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public List<Run> buildDropRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable(true));
        builder.append(" DROP CONSTRAINT ");
        SQLUtil.delimiter((StringBuilder)builder, (String)primary.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    public List<Run> buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public List<Run> buildAddRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAddRunSQL(foreign);
    }

    public List<Run> buildAlterRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAlterRunSQL(foreign);
    }

    public List<Run> buildDropRunSQL(ForeignKey foreign) throws Exception {
        return super.buildDropRunSQL(foreign);
    }

    public List<Run> buildRenameRunSQL(ForeignKey foreign) throws Exception {
        return super.buildRenameRunSQL(foreign);
    }

    public List<Run> buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<Run> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public List<Run> buildDropRunSQL(Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (index.isPrimary()) {
            log.warn("[\u4e3b\u952e\u7d22\u5f15,\u5ffd\u7565\u5220\u9664][index:{}]", (Object)index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
        }
        return runs;
    }

    public List<Run> buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public void comment(StringBuilder builder, Index index) {
        super.comment(builder, index);
    }

    public List<Run> buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<Run> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public List<Run> buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public List<Run> buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public List<Run> buildCreateRunSQL(Trigger trigger) throws Exception {
        return super.buildCreateRunSQL(trigger);
    }

    public void each(StringBuilder builder, Trigger trigger) {
        super.each(builder, trigger);
    }

    public List<Run> buildAlterRunSQL(Trigger trigger) throws Exception {
        return super.buildAlterRunSQL(trigger);
    }

    public List<Run> buildDropRunSQL(Trigger trigger) throws Exception {
        return super.buildDropRunSQL(trigger);
    }

    public List<Run> buildRenameRunSQL(Trigger trigger) throws Exception {
        return super.buildRenameRunSQL(trigger);
    }

    public List<Run> buildCreateRunSQL(Procedure procedure) throws Exception {
        return super.buildCreateRunSQL(procedure);
    }

    public List<Run> buildAlterRunSQL(Procedure procedure) throws Exception {
        return super.buildAlterRunSQL(procedure);
    }

    public List<Run> buildDropRunSQL(Procedure procedure) throws Exception {
        return super.buildDropRunSQL(procedure);
    }

    public List<Run> buildRenameRunSQL(Procedure procedure) throws Exception {
        return super.buildRenameRunSQL(procedure);
    }

    public List<Run> buildCreateRunSQL(Function function) throws Exception {
        return super.buildCreateRunSQL(function);
    }

    public List<Run> buildAlterRunSQL(Function function) throws Exception {
        return super.buildAlterRunSQL(function);
    }

    public List<Run> buildDropRunSQL(Function function) throws Exception {
        return super.buildDropRunSQL(function);
    }

    public List<Run> buildRenameRunSQL(Function function) throws Exception {
        return super.buildRenameRunSQL(function);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "now()";
        }
        return null;
    }
}

