/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.neo4j;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.anyline.adapter.EntityAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.DefaultJDBCAdapter;
import org.anyline.data.jdbc.neo4j.entity.Neo4jDataRow;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.Join;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.SQLException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.Column;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.neo4j")
public class Neo4jAdapter
extends DefaultJDBCAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.neo4j:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.Neo4j;
    }

    public Neo4jAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, checkPrimary, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        int i;
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        builder.append("CREATE ");
        int dataSize = set.size();
        for (i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            this.insertValue("e" + i, run, dest, row, columns);
            if (i >= dataSize - 1) continue;
            builder.append(",");
        }
        builder.append(" RETURN ");
        for (i = 0; i < dataSize; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(" ID(e").append(i).append(") AS __ID").append(i);
        }
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, columns);
            return;
        }
        builder.append("CREATE ");
        int dataSize = list.size();
        int idx = 0;
        for (Object obj : list) {
            this.insertValue("e" + idx, run, dest, obj, columns);
            if (idx < dataSize - 1) {
                builder.append(",");
            }
            ++idx;
        }
        builder.append(" RETURN ");
        for (int i = 0; i < dataSize; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(" ID(e").append(i).append(") AS __ID").append(i);
        }
    }

    protected Run createInsertRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setPrepare((RunPrepare)new DefaultTablePrepare());
        StringBuilder builder = run.getBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        DataRow row = null;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
        } else {
            boolean create = EntityAdapterProxy.createPrimaryValue((Object)obj, columns);
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), columns, null);
            }
        }
        LinkedHashMap cols = this.confirmInsertColumns(runtime, dest, obj, configs, columns, false);
        builder.append("CREATE ");
        this.insertValue("e0", (Run)run, dest, obj, cols);
        builder.append(" RETURN ID(e0) AS __ID0");
        return run;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        if (null == list || list.isEmpty()) {
            throw new SQLException("\u7a7a\u6570\u636e");
        }
        DataRow first = null;
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            first = set.getRow(0);
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = DataSourceUtil.parseDataSource((String)dest, (Object)set);
            }
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = DataSourceUtil.parseDataSource((String)dest, (Object)first);
            }
        } else {
            first = (DataRow)list.iterator().next();
            if (BasicUtil.isEmpty((Object)dest)) {
                dest = EntityAdapterProxy.table(first.getClass(), (boolean)true);
            }
        }
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        LinkedHashMap cols = this.confirmInsertColumns(runtime, dest, first, configs, columns, true);
        this.fillInsertContent(runtime, (Run)run, dest, list, cols);
        return run;
    }

    protected void insertValue(String alias, Run run, String dest, Object obj, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        builder.append("(");
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(alias);
        }
        builder.append(":").append(this.parseTable(dest));
        builder.append("{");
        ArrayList<String> insertColumns = new ArrayList<String>();
        boolean first = true;
        for (Column column : columns.values()) {
            String key = column.getName();
            if (!first) {
                builder.append(",");
            }
            first = false;
            Object value = null;
            value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(":");
            if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                String str = value.toString();
                if ((value = str.substring(2, str.length() - 1)).toString().startsWith("${") && value.toString().endsWith("}")) {
                    builder.append("?");
                    insertColumns.add(key);
                    run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
                    continue;
                }
                builder.append(value);
                continue;
            }
            builder.append("?");
            insertColumns.add(key);
            if ("NULL".equals(value)) {
                run.addValues(Compare.EQUAL, column, null, ConfigTable.IS_AUTO_SPLIT_ARRAY);
                continue;
            }
            run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
        }
        builder.append("})");
        run.setInsertColumns(insertColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt = 0L;
        DataSource ds = null;
        Connection con = null;
        if (!run.isValid()) {
            if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + run.getTable() + "]");
            }
            return -1L;
        }
        String sql = run.getFinalInsert();
        if (BasicUtil.isEmpty((Object)sql)) {
            log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:{}]", (Object)run.getTable());
            return -1L;
        }
        if (null != configs) {
            configs.add(run);
        }
        List values = run.getValues();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
        }
        long millis = -1L;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            PreparedStatement ps = con.prepareStatement(sql);
            int idx = 0;
            if (null != values) {
                for (Object obj : values) {
                    ps.setObject(++idx, obj);
                }
            }
            ResultSet rs = ps.executeQuery();
            if (data instanceof Collection) {
                ArrayList<Object> ids = new ArrayList<Object>();
                Collection list = (Collection)data;
                if (rs.next()) {
                    for (Object item : list) {
                        Object id = rs.getObject("__ID" + cnt);
                        ids.add(id);
                        this.setPrimaryValue(item, id);
                        ++cnt;
                    }
                }
                log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
            } else if (rs.next()) {
                ++cnt;
                Object id = rs.getObject("__ID0");
                this.setPrimaryValue(data, id);
                log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setSql(sql);
                ex.setValues(values);
                throw ex;
            }
            if (ConfigTable.IS_LOG_SQL_WHEN_ERROR) {
                log.error("{}[{}][sql:\n{}\n]\n[param:{}]", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)run.getInsertColumns(), (List)values)});
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return cnt;
    }

    public boolean identity(DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder) {
        return false;
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        if (!(run instanceof TableRun)) {
            return run.getBaseQuery();
        }
        StringBuilder builder = new StringBuilder();
        RunPrepare prepare = run.getPrepare();
        builder.append(run.getBaseQuery());
        String cols = run.getQueryColumn();
        String alias = run.getPrepare().getAlias();
        OrderStore orders = run.getOrderStore();
        if (null != orders) {
            builder.append(orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo()));
        }
        builder.append(" RETURN ");
        List columns = prepare.getQueryColumns();
        if (null != columns && columns.size() > 0) {
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                String column = (String)columns.get(i);
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("${") && column.endsWith("}")) {
                    column = column.substring(2, column.length() - 1);
                    builder.append(column);
                } else if (column.toUpperCase().contains(" AS ") || column.contains("(") || column.contains(",")) {
                    builder.append(column);
                } else if ("*".equals(column)) {
                    builder.append(alias);
                } else {
                    SQLUtil.delimiter((StringBuilder)builder, (String)(alias + "." + column), (String)this.delimiterFr, (String)this.delimiterTo);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
        } else {
            builder.append(alias);
            builder.append("\n");
        }
        builder.append(", ID(").append(alias).append(") AS __ID");
        PageNavi navi = run.getPageNavi();
        if (null != navi) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            builder.append(" SKIP ").append(navi.getFirstRow()).append(" LIMIT ").append(limit);
        }
        String content = builder.toString();
        return content;
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (compare == Compare.LIKE) {
            builder.append(" CONTAINS ?");
        } else if (compare == Compare.LIKE_PREFIX || compare == Compare.START_WITH) {
            builder.append(" STARTS WITH ?");
        } else if (compare == Compare.LIKE_SUFFIX || compare == Compare.END_WITH) {
            builder.append(" ENDS WITH ?");
        }
        RunValue run = new RunValue();
        run.setValue(value);
        return run;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        return null;
    }

    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (compare == Compare.NOT_IN) {
            builder.append(" NOT");
        }
        builder.append(" IN [");
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                builder.append("?");
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else {
            builder.append("= ?");
        }
        return builder;
    }

    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        List<Map<String, Object>> result = list;
        if (null != list && !list.isEmpty()) {
            Map<String, Object> map = list.get(0);
            Set<String> keys = map.keySet();
            String id_key = "__ID";
            boolean mapHashIdKey = BasicUtil.containsString((boolean)true, (boolean)true, keys, (String)"__ID");
            if (2 == keys.size() && keys.contains(id_key) || keys.size() == 1) {
                Object chk;
                String key = null;
                for (String k : keys) {
                    if (id_key.equalsIgnoreCase(k)) continue;
                    key = k;
                    break;
                }
                if (null != (chk = list.get(0).get(key)) && chk instanceof Map) {
                    result = new ArrayList<Map<String, Object>>();
                    for (Map<String, Object> item : list) {
                        Map value = (Map)item.get(key);
                        if (mapHashIdKey) {
                            value.put("id", item.get(id_key));
                        }
                        result.add(value);
                    }
                }
            }
        }
        return result;
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        List variables = run.getVariables();
        String result = prepare.getText();
        if (null != variables) {
            List varValues;
            String value;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                List varValue = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((Object)varValue)) {
                    value = varValue.toString();
                }
                if (null != value) {
                    result = result.replace("::" + var.getKey(), value);
                    continue;
                }
                result = result.replace("::" + var.getKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                if (null != value) {
                    result = result.replace(":" + var.getKey(), value);
                    continue;
                }
                result = result.replace(":" + var.getKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1 || !BasicUtil.isNotEmpty((boolean)true, (Object)(varValues = var.getValues()))) continue;
                if (var.getCompare() == Compare.IN) {
                    String replaceSrc = ":" + var.getKey();
                    String replaceDst = "";
                    for (Object tmp : varValues) {
                        run.addValues(var.getKey(), tmp);
                        replaceDst = replaceDst + " ?";
                    }
                    replaceDst = replaceDst.trim().replace(" ", ",");
                    result = result.replace(replaceSrc, replaceDst);
                    continue;
                }
                result = result.replace(":" + var.getKey(), "?");
                run.addValues(var.getKey(), varValues.get(0));
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                run.addValues(var.getKey(), (Object)value);
            }
        }
        builder.append(result);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        String alias = prepare.getAlias();
        if (BasicUtil.isEmpty((Object)alias)) {
            alias = "e";
            prepare.setAlias(alias);
        }
        builder.append("MATCH (").append(alias);
        String table = run.getTable();
        if (BasicUtil.isNotEmpty((Object)table)) {
            builder.append(":");
            if (null != run.getSchema()) {
                SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        builder.append(") ");
        builder.append(" WHERE 1=1 ");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        String sql = run.getBaseQuery() + " RETURN COUNT(" + run.getPrepare().getAlias() + ") AS CNT";
        return sql;
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        String sql = run.getBaseQuery() + " RETURN COUNT(" + run.getPrepare().getAlias() + ") > 0  AS IS_EXISTS";
        return sql;
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = new StringBuilder();
        LinkedHashMap<Object, Object> keys = new LinkedHashMap();
        LinkedHashMap<String, Column> primaryKeys = new LinkedHashMap<String, Column>();
        if (null != columns && columns.size() > 0) {
            keys = columns;
        } else {
            keys.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE));
        }
        if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            primaryKeys.putAll(EntityAdapterProxy.primaryKeys(obj.getClass()));
        } else {
            primaryKeys = new LinkedHashMap();
            primaryKeys.put(Neo4jDataRow.DEFAULT_PRIMARY_KEY, new Column(Neo4jDataRow.DEFAULT_PRIMARY_KEY));
        }
        for (String pk : primaryKeys.keySet()) {
            if (columns.containsKey(pk)) continue;
            keys.remove(pk);
        }
        if (!columns.containsKey(Neo4jDataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            keys.remove(Neo4jDataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!keys.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            boolean start = true;
            for (Column column : keys.values()) {
                if (!start) {
                    builder.append(",");
                }
                start = false;
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key);
                }
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                    continue;
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                }
                updateColumns.add(key);
                run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                for (Column column : primaryKeys.values()) {
                    String pk = column.getName();
                    builder.append(" AND ");
                    SQLUtil.delimiter((StringBuilder)builder, (String)pk, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?");
                    updateColumns.add(pk);
                    if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                        Field field = EntityAdapterProxy.field(obj.getClass(), (String)pk);
                        run.addValues(Compare.EQUAL, new Column(pk), BeanUtil.getFieldValue((Object)obj, (Field)field), ConfigTable.IS_AUTO_SPLIT_ARRAY);
                        continue;
                    }
                    run.addValues(Compare.EQUAL, new Column(pk), BeanUtil.getFieldValue((Object)obj, (String)pk), ConfigTable.IS_AUTO_SPLIT_ARRAY);
                }
            } else {
                run.setConfigStore(configs);
                run.init();
                run.appendCondition();
            }
        }
        run.setUpdateColumns(updateColumns);
        run.setBuilder(builder);
        return run;
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null != columns) {
            for (String column : columns) {
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        return this.buildUpdateRunFromDataRow(runtime, dest, row, configs, checkPrimary, cols);
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        StringBuilder builder = new StringBuilder();
        LinkedHashMap cols = this.confirmUpdateColumns(runtime, dest, row, configs, BeanUtil.getMapKeys(columns));
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk.toUpperCase())) continue;
            cols.remove(pk.toUpperCase());
        }
        if (!columns.containsKey(Neo4jDataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(Neo4jDataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = row.get(key);
                if (!first) {
                    builder.append(",");
                }
                first = false;
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                    continue;
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                }
                updateColumns.add(key);
                run.addValues(Compare.EQUAL, column, value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                for (String pk : primaryKeys) {
                    builder.append(" AND ");
                    SQLUtil.delimiter((StringBuilder)builder, (String)pk, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?");
                    updateColumns.add(pk);
                    run.addValues(Compare.EQUAL, new Column(pk), row.get(pk), ConfigTable.IS_AUTO_SPLIT_ARRAY);
                }
            } else {
                run.setConfigStore(configs);
                run.init();
                run.appendCondition();
            }
        }
        run.setUpdateColumns(updateColumns);
        run.setBuilder(builder);
        return run;
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, boolean checkPrimary, LinkedHashMap<String, Column> columns) {
        return null;
    }

    protected Run fillDeleteRunContent(TableRun run) {
        List joins;
        RunPrepare prepare = run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        if (null != run.getSchema()) {
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                SQLUtil.delimiter((StringBuilder)builder, (String)join.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                if (BasicUtil.isNotEmpty((Object)join.getAlias())) {
                    builder.append("  ").append(join.getAlias());
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
        return run;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, String key, Object values) {
        if (null == table || null == key || null == values) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TableRun run = new TableRun(runtime, table);
        builder.append("DELETE FROM ").append(table).append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (cons.size() > 1) {
                builder.append(" IN(");
                int idx = 0;
                for (Object obj : cons) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    builder.append("?");
                    ++idx;
                }
                builder.append(")");
            } else {
                if (cons.size() != 1) throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
                for (Object obj : cons) {
                    builder.append("=?");
                }
            }
        } else {
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append("=?");
        }
        run.addValues(Compare.IN, new Column(key), values, ConfigTable.IS_AUTO_SPLIT_ARRAY);
        run.setBuilder(builder);
        return run;
    }

    public Run buildDeleteRunFromEntity(DataRuntime runtime, String dest, Object obj, String ... columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = new StringBuilder();
        builder.append("MATCH (d");
        String table = this.parseTable(dest);
        if (BasicUtil.isNotEmpty((Object)table)) {
            builder.append(":").append(table);
        }
        builder.append(")");
        builder.append(" WHERE ");
        List<String> keys = new ArrayList();
        if (null != columns && columns.length > 0) {
            for (String col : columns) {
                keys.add(col);
            }
        } else if (obj instanceof DataRow) {
            keys = ((DataRow)obj).getPrimaryKeys();
        } else {
            keys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        }
        int size = keys.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                SQLUtil.delimiter((StringBuilder)builder, (String)("d." + key), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ? ");
                Object value = null;
                value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
                run.addValues(Compare.EQUAL, new Column(key), value, ConfigTable.IS_AUTO_SPLIT_ARRAY);
            }
        } else {
            throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
        }
        builder.append(" DELETE d");
        run.setBuilder(builder);
        return run;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return null;
    }

    protected String concatFun(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + ",";
                }
                result = result + arg;
            }
            result = result + ")";
        }
        return result;
    }

    protected String concatOr(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " || ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAdd(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " + ";
                }
                result = result + arg;
            }
        }
        return result;
    }
}

