/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.neo4j;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.anyline.data.entity.Join;
import org.anyline.data.jdbc.adapter.DefaultJDBCAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.exception.SQLException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.util.AdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.neo4j")
public class Neo4jAdapter
extends DefaultJDBCAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.jdbc.delimiter.neo4j:}")
    private String delimiter;

    public JDBCAdapter.DB_TYPE type() {
        return JDBCAdapter.DB_TYPE.Neo4j;
    }

    public Neo4jAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
    }

    public void afterPropertiesSet() throws Exception {
        this.setDelimiter(this.delimiter);
    }

    public Run buildInsertRun(String dest, Object obj, boolean checkPrimary, List<String> columns) {
        return super.buildInsertRun(dest, obj, checkPrimary, columns);
    }

    public void createInserts(Run run, String dest, DataSet set, List<String> keys) {
        int i;
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        builder.append("CREATE ");
        int dataSize = set.size();
        for (i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            this.insertValue("e" + i, run, dest, row, keys);
            if (i >= dataSize - 1) continue;
            builder.append(",");
        }
        builder.append(" RETURN ");
        for (i = 0; i < dataSize; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(" ID(e").append(i).append(") AS __ID").append(i);
        }
    }

    public void createInserts(Run run, String dest, Collection list, List<String> keys) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.createInserts(run, dest, set, keys);
            return;
        }
        builder.append("CREATE ");
        int dataSize = list.size();
        int idx = 0;
        for (Object obj : list) {
            this.insertValue("e" + idx, run, dest, obj, keys);
            if (idx < dataSize - 1) {
                builder.append(",");
            }
            ++idx;
        }
        builder.append(" RETURN ");
        for (int i = 0; i < dataSize; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(" ID(e").append(i).append(") AS __ID").append(i);
        }
    }

    protected Run createInsertRunFromEntity(String dest, Object obj, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun((JDBCAdapter)this, dest);
        run.setPrepare((RunPrepare)new DefaultTablePrepare());
        StringBuilder builder = run.getBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        builder.append("CREATE ");
        this.insertValue("e0", (Run)run, dest, obj, columns);
        builder.append(" RETURN ID(e0) AS __ID0");
        return run;
    }

    protected Run createInsertRunFromCollection(String dest, Collection list, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun((JDBCAdapter)this, dest);
        if (null == list || list.size() == 0) {
            throw new SQLException("\u7a7a\u6570\u636e");
        }
        this.createInserts((Run)run, dest, list, columns);
        return run;
    }

    protected void insertValue(String alias, Run run, String dest, Object obj, List<String> columns) {
        String pk;
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        DataRow row = null;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (row.hasPrimaryKeys() && null != this.primaryCreater && BasicUtil.isEmpty((Object)row.getPrimaryValue())) {
                pk = row.getPrimaryKey();
                if (null == pk) {
                    pk = ConfigTable.getString((String)"DEFAULT_PRIMARY_KEY", (String)"ID");
                }
                row.put(pk, this.primaryCreater.createPrimary(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pk, null));
            }
        } else {
            pk = null;
            Object pv = null;
            if (AdapterProxy.hasAdapter()) {
                pk = AdapterProxy.primaryKey(obj.getClass());
                pv = AdapterProxy.primaryValue((Object)obj);
                AdapterProxy.createPrimaryValue((Object)obj);
            } else {
                pk = DataRow.DEFAULT_PRIMARY_KEY;
                pv = BeanUtil.getFieldValue((Object)obj, (String)pk);
                if (null != this.primaryCreater && null == pv) {
                    pv = this.primaryCreater.createPrimary(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pk, null);
                    BeanUtil.setFieldValue((Object)obj, (String)pk, (Object)pv);
                }
            }
        }
        List keys = this.confirmInsertColumns(dest, obj, columns);
        builder.append("(");
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(alias);
        }
        builder.append(":").append(this.parseTable(dest));
        builder.append("{");
        ArrayList<String> insertColumns = new ArrayList<String>();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)keys.get(i);
            Object value = null;
            value = null != row ? row.get(key) : (AdapterProxy.hasAdapter() ? BeanUtil.getFieldValue((Object)obj, (Field)AdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(":");
            if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                String str = value.toString();
                if ((value = str.substring(2, str.length() - 1)).toString().startsWith("${") && value.toString().endsWith("}")) {
                    builder.append("?");
                    insertColumns.add(key);
                    run.addValues(key, value);
                } else {
                    builder.append(value);
                }
            } else {
                builder.append("?");
                insertColumns.add(key);
                if ("NULL".equals(value)) {
                    run.addValues(key, null);
                } else {
                    run.addValues(key, value);
                }
            }
            if (i >= size - 1) continue;
            builder.append(",");
        }
        builder.append("})");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(String random, Object data, String sql, List<Object> values, String[] pks) throws Exception {
        int cnt = 0;
        DataSource ds = null;
        Connection con = null;
        try {
            ds = this.jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            PreparedStatement ps = con.prepareStatement(sql);
            int idx = 0;
            if (null != values) {
                for (Object obj : values) {
                    ps.setObject(++idx, obj);
                }
            }
            ResultSet rs = ps.executeQuery();
            if (data instanceof Collection) {
                ArrayList<Object> ids = new ArrayList<Object>();
                Collection list = (Collection)data;
                if (rs.next()) {
                    for (Object item : list) {
                        Object id = rs.getObject("__ID" + cnt);
                        ids.add(id);
                        this.setPrimaryValue(item, id);
                        ++cnt;
                    }
                }
                log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
            } else if (rs.next()) {
                ++cnt;
                Object id = rs.getObject("__ID0");
                this.setPrimaryValue(data, id);
                log.warn("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
            }
        }
        finally {
            if (!DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return cnt;
    }

    public boolean identity(String random, Object data, KeyHolder keyholder) {
        return false;
    }

    public String parseFinalQuery(Run run) {
        if (!(run instanceof TableRun)) {
            return run.getBaseQuery();
        }
        StringBuilder builder = new StringBuilder();
        RunPrepare prepare = run.getPrepare();
        builder.append(run.getBaseQuery());
        String cols = run.getQueryColumns();
        String alias = run.getPrepare().getAlias();
        OrderStore orders = run.getOrderStore();
        if (null != orders) {
            builder.append(orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo()));
        }
        builder.append(" RETURN ");
        List columns = prepare.getColumns();
        if (null != columns && columns.size() > 0) {
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                String column = (String)columns.get(i);
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("${") && column.endsWith("}")) {
                    column = column.substring(2, column.length() - 1);
                    builder.append(column);
                } else if (column.toUpperCase().contains(" AS ") || column.contains("(") || column.contains(",")) {
                    builder.append(column);
                } else if ("*".equals(column)) {
                    builder.append(alias);
                } else {
                    SQLUtil.delimiter((StringBuilder)builder, (String)(alias + "." + column), (String)this.delimiterFr, (String)this.delimiterTo);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
        } else {
            builder.append(alias);
            builder.append("\n");
        }
        builder.append(", ID(").append(alias).append(") AS __ID");
        PageNavi navi = run.getPageNavi();
        if (null != navi) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            builder.append(" SKIP ").append(navi.getFirstRow()).append(" LIMIT ").append(limit);
        }
        String content = builder.toString();
        return content;
    }

    public StringBuilder buildConditionLike(StringBuilder builder, Compare compare) {
        if (compare == Compare.LIKE) {
            builder.append(" CONTAINS ?");
        } else if (compare == Compare.LIKE_PREFIX) {
            builder.append(" START WITH ?");
        } else if (compare == Compare.LIKE_SUFFIX) {
            builder.append(" END WITH ?");
        }
        return builder;
    }

    public StringBuilder buildConditionIn(StringBuilder builder, Compare compare, Object value) {
        if (compare == Compare.NOT_IN) {
            builder.append(" NOT");
        }
        builder.append(" IN [");
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                builder.append("?");
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        } else {
            builder.append("= ?");
        }
        return builder;
    }

    public List<Map<String, Object>> process(List<Map<String, Object>> list) {
        List<Map<String, Object>> result = list;
        if (null != list && !list.isEmpty()) {
            Map<String, Object> map = list.get(0);
            Set<String> keys = map.keySet();
            String id_key = "__ID";
            boolean mapHashIdKey = BasicUtil.containsString((boolean)true, (boolean)true, keys, (String)"__ID");
            if (2 == keys.size() && keys.contains(id_key) || keys.size() == 1) {
                Object chk;
                String key = null;
                for (String k : keys) {
                    if (id_key.equalsIgnoreCase(k)) continue;
                    key = k;
                    break;
                }
                if (null != (chk = list.get(0).get(key)) && chk instanceof Map) {
                    result = new ArrayList<Map<String, Object>>();
                    for (Map<String, Object> item : list) {
                        Map value = (Map)item.get(key);
                        if (mapHashIdKey) {
                            value.put("id", item.get(id_key));
                        }
                        result.add(value);
                    }
                }
            }
        }
        return result;
    }

    protected void buildQueryRunContent(XMLRun run) {
    }

    protected void buildQueryRunContent(TextRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        List variables = run.getVariables();
        String result = prepare.getText();
        if (null != variables) {
            List varValues;
            String value;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                List varValue = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((Object)varValue)) {
                    value = varValue.toString();
                }
                if (null != value) {
                    result = result.replace("::" + var.getKey(), value);
                    continue;
                }
                result = result.replace("::" + var.getKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                if (null != value) {
                    result = result.replace(":" + var.getKey(), value);
                    continue;
                }
                result = result.replace(":" + var.getKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1 || !BasicUtil.isNotEmpty((boolean)true, (Object)(varValues = var.getValues()))) continue;
                if (var.getCompare() == Compare.IN) {
                    String replaceSrc = ":" + var.getKey();
                    String replaceDst = "";
                    for (Object tmp : varValues) {
                        run.addValues(var.getKey(), tmp);
                        replaceDst = replaceDst + " ?";
                    }
                    replaceDst = replaceDst.trim().replace(" ", ",");
                    result = result.replace(replaceSrc, replaceDst);
                    continue;
                }
                result = result.replace(":" + var.getKey(), "?");
                run.addValues(var.getKey(), varValues.get(0));
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, (Object)varValues)) {
                    value = (String)varValues.get(0);
                }
                run.addValues(var.getKey(), (Object)value);
            }
        }
        builder.append(result);
        run.appendCondition();
        run.appendGroup();
        run.checkValid();
    }

    protected void buildQueryRunContent(TableRun run) {
        StringBuilder builder = run.getBuilder();
        RunPrepare prepare = run.getPrepare();
        String alias = prepare.getAlias();
        if (BasicUtil.isEmpty((Object)alias)) {
            alias = "e";
            prepare.setAlias(alias);
        }
        builder.append("MATCH (").append(alias);
        String table = run.getTable();
        if (BasicUtil.isNotEmpty((Object)table)) {
            builder.append(":");
            if (null != run.getSchema()) {
                SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        builder.append(") ");
        builder.append(" WHERE 1=1 ");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public String parseTotalQuery(Run run) {
        String sql = run.getBaseQuery() + " RETURN COUNT(" + run.getPrepare().getAlias() + ") AS CNT";
        return sql;
    }

    public String parseExists(Run run) {
        String sql = run.getBaseQuery() + " RETURN COUNT(" + run.getPrepare().getAlias() + ") > 0  AS IS_EXISTS";
        return sql;
    }

    protected Run buildUpdateRunFromObject(String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun((JDBCAdapter)this, dest);
        StringBuilder builder = new StringBuilder();
        List keys = null;
        ArrayList<String> primaryKeys = null;
        if (null != columns && columns.size() > 0) {
            keys = columns;
        } else if (AdapterProxy.hasAdapter()) {
            keys = AdapterProxy.columns(obj.getClass());
        }
        if (AdapterProxy.hasAdapter()) {
            primaryKeys = AdapterProxy.primaryKeys(obj.getClass());
        } else {
            primaryKeys = new ArrayList<String>();
            primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
        }
        for (String pk : primaryKeys) {
            if (columns.contains(pk)) continue;
            keys.remove(pk);
        }
        if (!columns.contains(DataRow.DEFAULT_PRIMARY_KEY)) {
            keys.remove(DataRow.DEFAULT_PRIMARY_KEY);
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        int size = keys.size();
        if (size > 0) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            for (int i = 0; i < size; ++i) {
                String key = (String)keys.get(i);
                Object value = null;
                if (AdapterProxy.hasAdapter()) {
                    Field field = AdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key);
                }
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                } else {
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                    if ("NULL".equals(value)) {
                        value = null;
                    }
                    updateColumns.add(key);
                    run.addValues(key, value);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                for (String pk : primaryKeys) {
                    builder.append(" AND ");
                    SQLUtil.delimiter((StringBuilder)builder, (String)pk, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?");
                    updateColumns.add(pk);
                    if (AdapterProxy.hasAdapter()) {
                        Field field = AdapterProxy.field(obj.getClass(), (String)pk);
                        run.addValues(pk, BeanUtil.getFieldValue((Object)obj, (Field)field));
                        continue;
                    }
                    run.addValues(pk, BeanUtil.getFieldValue((Object)obj, (String)pk));
                }
            } else {
                run.setConfigStore(configs);
                run.init();
                run.appendCondition();
            }
        }
        run.setUpdateColumns(updateColumns);
        run.setBuilder(builder);
        return run;
    }

    protected Run buildUpdateRunFromDataRow(String dest, DataRow row, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        TableRun run = new TableRun((JDBCAdapter)this, dest);
        StringBuilder builder = new StringBuilder();
        List keys = this.confirmUpdateColumns(dest, row, configs, columns);
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String pk : primaryKeys) {
            if (columns.contains(pk)) continue;
            keys.remove(pk);
        }
        if (!columns.contains(DataRow.DEFAULT_PRIMARY_KEY)) {
            keys.remove(DataRow.DEFAULT_PRIMARY_KEY);
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        int size = keys.size();
        if (size > 0) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            for (int i = 0; i < size; ++i) {
                String key = (String)keys.get(i);
                Object value = row.get(key);
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ").append(value).append("\n\t");
                } else {
                    SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?").append("\n\t");
                    if ("NULL".equals(value)) {
                        value = null;
                    }
                    updateColumns.add(key);
                    run.addValues(key, value);
                }
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                for (String pk : primaryKeys) {
                    builder.append(" AND ");
                    SQLUtil.delimiter((StringBuilder)builder, (String)pk, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ?");
                    updateColumns.add(pk);
                    run.addValues(pk, row.get(pk));
                }
            } else {
                run.setConfigStore(configs);
                run.init();
                run.appendCondition();
            }
        }
        run.setUpdateColumns(updateColumns);
        run.setBuilder(builder);
        return run;
    }

    protected Run buildDeleteRunContent(TableRun run) {
        List joins;
        RunPrepare prepare = run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        if (null != run.getSchema()) {
            SQLUtil.delimiter((StringBuilder)builder, (String)run.getSchema(), (String)this.delimiterFr, (String)this.delimiterTo).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)run.getTable(), (String)this.delimiterFr, (String)this.delimiterTo);
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                SQLUtil.delimiter((StringBuilder)builder, (String)join.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                if (BasicUtil.isNotEmpty((Object)join.getAlias())) {
                    builder.append("  ").append(join.getAlias());
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        builder.append("\nWHERE 1=1\n\t");
        run.appendCondition();
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
        return run;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Run createDeleteRunSQLFromTable(String table, String key, Object values) {
        if (null == table || null == key || null == values) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TableRun run = new TableRun((JDBCAdapter)this, table);
        builder.append("DELETE FROM ").append(table).append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (cons.size() > 1) {
                builder.append(" IN(");
                int idx = 0;
                for (Object obj : cons) {
                    if (idx > 0) {
                        builder.append(",");
                    }
                    builder.append("?");
                    ++idx;
                }
                builder.append(")");
            } else {
                if (cons.size() != 1) throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
                for (Object obj : cons) {
                    builder.append("=?");
                }
            }
        } else {
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append("=?");
        }
        run.addValues(key, values);
        run.setBuilder(builder);
        return run;
    }

    protected Run createDeleteRunSQLFromEntity(String dest, Object obj, String ... columns) {
        TableRun run = new TableRun((JDBCAdapter)this, dest);
        StringBuilder builder = new StringBuilder();
        builder.append("MATCH (d");
        String table = this.parseTable(dest);
        if (BasicUtil.isNotEmpty((Object)table)) {
            builder.append(":").append(table);
        }
        builder.append(")");
        builder.append(" WHERE ");
        List<String> keys = new ArrayList();
        if (null != columns && columns.length > 0) {
            for (String col : columns) {
                keys.add(col);
            }
        } else if (obj instanceof DataRow) {
            keys = ((DataRow)obj).getPrimaryKeys();
        } else if (AdapterProxy.hasAdapter()) {
            keys = AdapterProxy.primaryKeys(obj.getClass());
        }
        int size = keys.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                SQLUtil.delimiter((StringBuilder)builder, (String)("d." + key), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" = ? ");
                Object value = null;
                value = obj instanceof DataRow ? ((DataRow)obj).get(key) : (AdapterProxy.hasAdapter() ? BeanUtil.getFieldValue((Object)obj, (Field)AdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
                run.addValues(key, value);
            }
        } else {
            throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
        }
        builder.append(" DELETE d");
        run.setBuilder(builder);
        return run;
    }

    public String concat(String ... args) {
        return null;
    }

    protected String concatFun(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + ",";
                }
                result = result + arg;
            }
            result = result + ")";
        }
        return result;
    }

    protected String concatOr(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " || ";
                }
                result = result + arg;
            }
        }
        return result;
    }

    protected String concatAdd(String ... args) {
        String result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = result + " + ";
                }
                result = result + arg;
            }
        }
        return result;
    }
}

