/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mssql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.annotation.Component;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.mssql.MSSQLAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.data.jdbc.adapter.mssql2000")
public class MSSQL2000Adapter
extends MSSQLAdapter
implements JDBCAdapter {
    @Override
    public String version() {
        return "2000";
    }

    @Override
    public boolean match(DataRuntime runtime, boolean compensate) {
        String version;
        List keywords = this.type().keywords();
        String feature = runtime.getFeature();
        boolean chk = this.match(feature, keywords, compensate);
        if (chk && null != (version = runtime.getVersion()) && version.contains(".")) {
            version = version.split("\\.")[0];
            double v = BasicUtil.parseDouble((Object)version, (Double)0.0);
            if (ConfigTable.IS_LOG_ADAPTER_MATCH) {
                log.debug("[adapter match][SQL Server\u7248\u672c\u68c0\u6d4b][result:{}][runtime version:{}][adapter:{}]", new Object[]{false, version, ((Object)((Object)this)).getClass()});
            }
            if (v < 9.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0L && null != navi) {
            builder.append("SELECT TOP ").append(last + 1L).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            long rows = navi.getPageRows();
            if (rows * navi.getCurPage() > navi.getTotalRow()) {
                rows = navi.getTotalRow() % (long)navi.getPageRows();
            }
            String asc = order;
            String desc = order.replace("ASC", "<A_ORDER>");
            desc = desc.replace("DESC", "ASC");
            desc = desc.replace("<A_ORDER>", "DESC");
            builder.append("SELECT " + cols + " FROM (\n ");
            builder.append("SELECT TOP ").append(rows).append(" * FROM (\n");
            builder.append("SELECT TOP ").append((long)navi.getPageRows() * navi.getCurPage()).append(" * ");
            builder.append(" FROM (" + sql + ") AS T0 ").append(asc).append("\n");
            builder.append(") AS T1 ").append(desc).append("\n");
            builder.append(") AS T2").append(asc);
        }
        return builder.toString();
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        LinkedHashMap pks = null;
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        if (null != generator) {
            pks = set.getRow(0).getPrimaryColumns();
            columns.putAll(pks);
        }
        builder.append("INSERT INTO ");
        this.name(runtime, builder, (BaseMetadata)dest);
        builder.append("(");
        boolean start = true;
        for (Column column : columns.values()) {
            if (!start) {
                builder.append(",");
            }
            start = false;
            String key = column.getName();
            this.delimiter(builder, key);
        }
        builder.append(")");
        int dataSize = set.size();
        for (int i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            if (row.hasPrimaryKeys() && BasicUtil.isEmpty((Object)row.getPrimaryValue()) && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            builder.append("\n SELECT ");
            builder.append(this.insertValue(runtime, run, row, i == 0, true, true, false, false, columns));
            if (i >= dataSize - 1) continue;
            builder.append("\n UNION ALL ");
        }
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, columns);
            return;
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        LinkedHashMap pks = null;
        if (null != generator) {
            Object entity = list.iterator().next();
            pks = EntityAdapterProxy.primaryKeys(entity.getClass());
            columns.putAll(pks);
        }
        builder.append("INSERT INTO ");
        this.name(runtime, builder, (BaseMetadata)dest);
        builder.append("(");
        boolean start = true;
        for (Column column : columns.values()) {
            if (!start) {
                builder.append(",");
            }
            start = false;
            String key = column.getName();
            this.delimiter(builder, key);
        }
        builder.append(")\n ");
        int dataSize = list.size();
        int idx = 0;
        for (Object obj : list) {
            builder.append("\n SELECT ");
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, (LinkedHashMap)pks);
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            builder.append(this.insertValue(runtime, run, obj, idx == 0, true, true, false, false, columns));
            if (idx < dataSize - 1) {
                builder.append("\n UNION ALL ");
            }
            ++idx;
        }
    }

    @Override
    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.*, SCHEMA_NAME(M.SCHEMA_ID) AS TABLE_SCHEMA, F.VALUE AS TABLE_COMMENT FROM SYS.TABLES AS M \n").append("LEFT JOIN SYS.EXTENDED_PROPERTIES AS F ON M.OBJECT_ID = F.MAJOR_ID AND F.MINOR_ID=0 \n");
        if (BasicUtil.isNotEmpty((Object)pattern) || !this.empty((BaseMetadata)schema)) {
            builder.append(this.conditionHead());
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND M.NAME LIKE '").append(pattern).append("'");
        }
        if (!this.empty((BaseMetadata)schema)) {
            builder.append(" AND SCHEMA_NAME(M.SCHEMA_ID) = '").append(schema.getName()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("EXEC sp_addextendedproperty ");
            builder.append("'MS_Description', ");
            builder.append("N'").append(comment).append("', ");
            builder.append("'USER', ");
            builder.append("'").append(table.getSchemaName()).append("', ");
            builder.append("'TABLE', ");
            builder.append("'").append(table.getName()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("EXEC sp_updateextendedproperty ");
            builder.append("'MS_Description', ");
            builder.append("N'").append(comment).append("', ");
            builder.append("'USER', ");
            builder.append("'").append(table.getSchema()).append("', ");
            builder.append("'TABLE', ");
            builder.append("'").append(table.getName()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            Schema schema = column.getSchema();
            if (BasicUtil.isEmpty((Object)schema)) {
                schema = column.getTable(true).getSchema();
            }
            builder.append("EXEC sp_addextendedproperty ");
            builder.append("'MS_Description', ");
            builder.append("N'").append(comment).append("', ");
            builder.append("'USER', ");
            builder.append("'").append(schema.getName()).append("', ");
            builder.append("'TABLE', ");
            builder.append("'").append(column.getTableName(true)).append("', ");
            builder.append("'COLUMN', ");
            builder.append("'").append(column.getName()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = null;
        comment = null != column.getUpdate() ? ((Column)column.getUpdate()).getComment() : column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            Schema schema = column.getSchema();
            if (BasicUtil.isEmpty((Object)schema)) {
                schema = column.getTable(true).getSchema();
            }
            builder.append("EXEC sp_updateextendedproperty ");
            builder.append("'MS_Description', ");
            builder.append("N'").append(comment).append("', ");
            builder.append("'USER', ");
            builder.append("'").append(schema.getName()).append("', ");
            builder.append("'TABLE', ");
            builder.append("'").append(column.getTableName(true)).append("', ");
            builder.append("'COLUMN', ");
            builder.append("'").append(column.getName()).append("'");
        }
        return runs;
    }
}

