/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mssql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.jdbc.mssql.MSSQLAdapter;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.mssql.2000")
public class MSSQL2000Adapter
extends MSSQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Override
    public String version() {
        return "2000";
    }

    @Override
    public String parseFinalQuery(Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumns();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        int first = 0;
        int last = 0;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0 && null != navi) {
            builder.append("SELECT TOP ").append(last + 1).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            int rows = navi.getPageRows();
            if (rows * navi.getCurPage() > navi.getTotalRow()) {
                rows = navi.getTotalRow() % navi.getPageRows();
            }
            String asc = order;
            String desc = order.replace("ASC", "<A_ORDER>");
            desc = desc.replace("DESC", "ASC");
            desc = desc.replace("<A_ORDER>", "DESC");
            builder.append("SELECT " + cols + " FROM (\n ");
            builder.append("SELECT TOP ").append(rows).append(" * FROM (\n");
            builder.append("SELECT TOP ").append(navi.getPageRows() * navi.getCurPage()).append(" * ");
            builder.append(" FROM (" + sql + ") AS T0 ").append(asc).append("\n");
            builder.append(") AS T1 ").append(desc).append("\n");
            builder.append(") AS T2").append(asc);
        }
        return builder.toString();
    }

    @Override
    public void createInserts(JdbcTemplate template, Run run, String dest, DataSet set, List<String> keys) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        List pks = null;
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        if (null != generator) {
            pks = set.getRow(0).getPrimaryKeys();
            BeanUtil.join((boolean)true, keys, (Collection)pks);
        }
        builder.append("INSERT INTO ").append(this.parseTable(dest));
        builder.append("(");
        int keySize = keys.size();
        for (int i = 0; i < keySize; ++i) {
            String key = keys.get(i);
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (i >= keySize - 1) continue;
            builder.append(",");
        }
        builder.append(")");
        int dataSize = set.size();
        for (int i = 0; i < dataSize; ++i) {
            DataRow row = set.getRow(i);
            if (null == row) continue;
            if (row.hasPrimaryKeys() && BasicUtil.isEmpty((Object)row.getPrimaryValue()) && null != generator) {
                generator.create((Object)row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            builder.append("\n SELECT ");
            this.insertValue(template, run, row, true, false, false, keys);
            if (i >= dataSize - 1) continue;
            builder.append("\n UNION ALL ");
        }
    }

    @Override
    public void createInserts(JdbcTemplate template, Run run, String dest, Collection list, List<String> keys) {
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.createInserts(template, run, dest, set, keys);
            return;
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        List pks = null;
        if (null != generator) {
            Object entity = list.iterator().next();
            pks = EntityAdapterProxy.primaryKeys(entity.getClass(), (boolean)true);
            BeanUtil.join((boolean)true, keys, (Collection)pks);
        }
        builder.append("INSERT INTO ").append(this.parseTable(dest));
        builder.append("(");
        int keySize = keys.size();
        for (int i = 0; i < keySize; ++i) {
            String key = keys.get(i);
            SQLUtil.delimiter((StringBuilder)builder, (String)key, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (i >= keySize - 1) continue;
            builder.append(",");
        }
        builder.append(")\n ");
        int dataSize = list.size();
        int idx = 0;
        for (Object obj : list) {
            builder.append("\n SELECT ");
            boolean create = false;
            if (EntityAdapterProxy.hasAdapter()) {
                create = EntityAdapterProxy.createPrimaryValue(obj, keys);
            }
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            this.insertValue(template, run, obj, true, false, false, keys);
            if (idx < dataSize - 1) {
                builder.append("\n UNION ALL ");
            }
            ++idx;
        }
    }

    @Override
    public List<Run> buildAddCommentRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("EXEC sp_addextendedproperty ");
            builder.append("'MS_Description',");
            builder.append("N'").append(comment).append("',");
            builder.append("'USER',");
            builder.append("'").append(table.getSchema()).append("',");
            builder.append("'TABLE',");
            builder.append("'").append(table.getName()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("EXEC sp_updateextendedproperty ");
            builder.append("'MS_Description',");
            builder.append("N'").append(comment).append("',");
            builder.append("'USER',");
            builder.append("'").append(table.getSchema()).append("',");
            builder.append("'TABLE',");
            builder.append("'").append(table.getName()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildAddCommentRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            String schema = column.getSchema();
            if (BasicUtil.isEmpty((Object)schema)) {
                schema = column.getTable(true).getSchema();
            }
            builder.append("EXEC sp_addextendedproperty ");
            builder.append("'MS_Description',");
            builder.append("N'").append(comment).append("',");
            builder.append("'USER',");
            builder.append("'").append(schema).append("',");
            builder.append("'TABLE',");
            builder.append("'").append(column.getTableName(true)).append("',");
            builder.append("'COLUMN',");
            builder.append("'").append(column.getName()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = null;
        comment = null != column.getUpdate() ? column.getUpdate().getComment() : column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            String schema = column.getSchema();
            if (BasicUtil.isEmpty((Object)schema)) {
                schema = column.getTable(true).getSchema();
            }
            builder.append("EXEC sp_updateextendedproperty ");
            builder.append("'MS_Description',");
            builder.append("N'").append(comment).append("',");
            builder.append("'USER',");
            builder.append("'").append(schema).append("',");
            builder.append("'TABLE',");
            builder.append("'").append(column.getTableName(true)).append("',");
            builder.append("'COLUMN',");
            builder.append("'").append(column.getName()).append("'");
        }
        return runs;
    }
}

