/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mssql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.SQLAdapter;
import org.anyline.data.jdbc.mssql.MSSQLColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.Column;
import org.anyline.entity.data.Constraint;
import org.anyline.entity.data.DatabaseType;
import org.anyline.entity.data.ForeignKey;
import org.anyline.entity.data.Function;
import org.anyline.entity.data.Index;
import org.anyline.entity.data.MasterTable;
import org.anyline.entity.data.PartitionTable;
import org.anyline.entity.data.PrimaryKey;
import org.anyline.entity.data.Procedure;
import org.anyline.entity.data.Table;
import org.anyline.entity.data.Tag;
import org.anyline.entity.data.Trigger;
import org.anyline.entity.data.View;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.mssql")
public class MSSQLAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.mssql:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.MSSQL;
    }

    public String version() {
        return "2005";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public MSSQLAdapter() {
        this.delimiterFr = "[";
        this.delimiterTo = "]";
        for (MSSQLColumnTypeAlias alias : MSSQLColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public String parseFinalQuery(Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumns();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        int first = 0;
        int last = 0;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0 && null != navi) {
            builder.append("SELECT TOP ").append(last + 1).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            if (BasicUtil.isEmpty((Object)order)) {
                order = "ORDER BY " + ConfigTable.DEFAULT_PRIMARY_KEY;
            }
            builder.append("SELECT " + cols + " FROM( \n");
            builder.append("SELECT _TAB_I.* ,ROW_NUMBER() OVER(").append(order).append(") AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append(") AS _TAB_I \n");
            builder.append(") AS _TAB_O WHERE PAGE_ROW_NUMBER_ BETWEEN " + (first + 1) + " AND " + (last + 1));
        }
        return builder.toString();
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, DataSet set, List<String> keys) {
        super.createInserts(template, run, dest, set, keys);
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, Collection list, List<String> keys) {
        super.createInserts(template, run, dest, list, keys);
    }

    public String parseExists(Run run) {
        String sql = "IF EXISTS(\n" + run.getBuilder().toString() + "\n) SELECT 1 AS IS_EXISTS ELSE SELECT 0 AS IS_EXISTS";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatAdd(args);
    }

    public void checkSchema(Connection con, Table table) {
        try {
            if (null == table.getCatalog()) {
                table.setCatalog(con.getCatalog());
            }
            if (null == table.getSchema()) {
                table.setSchema("dbo");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        table.setCheckSchemaTime(new Date());
    }

    public List<Run> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableRunSQL(catalog, schema, pattern, types);
    }

    public List<Run> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT TBS.NAME AS TABLE_NAME ,DS.VALUE AS TABLE_COMMENT\n");
        builder.append("FROM SYS.EXTENDED_PROPERTIES DS\n");
        builder.append("LEFT JOIN SYS.SYSOBJECTS TBS ON DS.MAJOR_ID=TBS.ID \n");
        builder.append("WHERE  DS.MINOR_ID=0 \n");
        if (BasicUtil.isNotEmpty((Object)this.objectName(pattern))) {
            builder.append("TBS.NAME = '").append(pattern).append("'");
        }
        return runs;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.tables(index, create, catalog, schema, tables, set);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags, name);
    }

    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT C.NAME AS COLUMN_NAME, B.VALUE COLUMN_COMMENT, OBJECT_NAME(c.OBJECT_ID) AS TABLE_NAME, C.*  \n");
            builder.append("FROM SYS.COLUMNS C \n");
            builder.append("LEFT JOIN SYS.EXTENDED_PROPERTIES B ON B.MAJOR_ID = c.OBJECT_ID AND B.MINOR_ID = C.COLUMN_ID\n");
            if (null != table) {
                builder.append("WHERE OBJECT_NAME(c.OBJECT_ID) ='").append(this.objectName(table.getName())).append("'");
            }
            SimpleRun r = new SimpleRun();
            runs.add((Run)r);
            builder = r.getBuilder();
            builder.append("SELECT * FROM INFORMATION_SCHEMA.COLUMNS \n");
            if (null != table) {
                builder.append("WHERE TABLE_NAME ='").append(this.objectName(table.getName())).append("'");
            }
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        return super.columns(index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<Run> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, LinkedHashMap<String, T> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.tags(create, tags, dbmd, table, pattern);
    }

    public List<Run> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, LinkedHashMap<String, T> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRunSQL(Table table, List<Trigger.EVENT> events) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT object_name(parent_id) AS TABLE_NAME ,* FROM SYS.TRIGGERS WHERE 1=1");
        if (null != table) {
            String schemae = table.getSchema();
            String name = table.getName();
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append(" AND object_name(parent_id) = '").append(name).append("'");
            }
        }
        return runs;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("NAME");
            Trigger trigger = (Trigger)triggers.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            trigger.setTable(table);
            triggers.put(name.toUpperCase(), trigger);
        }
        return triggers;
    }

    public List<Run> buildCreateRunSQL(Table table) throws Exception {
        List runs = super.buildCreateRunSQL(table);
        return runs;
    }

    public List<Run> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public List<Run> buildRenameRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC SP_RENAME '").append(table.getName()).append("', '").append(table.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildAddCommentRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("EXEC sys.sp_addextendedproperty @name=N'MS_Description'");
            builder.append(",@value=N'").append(comment).append("'");
            builder.append(",@level0type=N'SCHEMA'");
            builder.append(",@level0name=N'").append(table.getSchema()).append("'");
            builder.append(",@level1type=N'TABLE'");
            builder.append(",@level1name=N'").append(table.getName()).append("'");
        }
        return runs;
    }

    public List<Run> buildChangeCommentRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("EXEC sys.sp_updateextendedproperty @name=N'MS_Description'");
            builder.append(",@value=N'").append(comment).append("'");
            builder.append(",@level0type=N'SCHEMA'");
            builder.append(",@level0name=N'").append(table.getSchema()).append("'");
            builder.append(",@level1type=N'TABLE'");
            builder.append(",@level1name=N'").append(table.getName()).append("'");
        }
        return runs;
    }

    public List<Run> buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        if (exists) {
            return super.checkTableExists(builder, exists);
        }
        return builder;
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (BasicUtil.isNotEmpty((Object)order)) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<Run> buildCreateRunSQL(View view) throws Exception {
        return super.buildCreateRunSQL(view);
    }

    public List<Run> buildAddCommentRunSQL(View view) throws Exception {
        return super.buildAddCommentRunSQL(view);
    }

    public List<Run> buildAlterRunSQL(View view) throws Exception {
        return super.buildAlterRunSQL(view);
    }

    public List<Run> buildRenameRunSQL(View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(view.getName()).append("', '").append(view.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildChangeCommentRunSQL(View view) throws Exception {
        return super.buildChangeCommentRunSQL(view);
    }

    public List<Run> buildDropRunSQL(View view) throws Exception {
        return super.buildDropRunSQL(view);
    }

    public StringBuilder checkViewExists(StringBuilder builder, boolean exists) {
        return super.checkViewExists(builder, exists);
    }

    public StringBuilder comment(StringBuilder builder, View view) {
        return super.comment(builder, view);
    }

    public List<Run> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public List<Run> buildRenameRunSQL(MasterTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(table.getName()).append("', '").append(table.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<Run> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public List<Run> buildRenameRunSQL(PartitionTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(table.getName()).append("', '").append(table.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return super.alterColumnKeyword();
    }

    public List<Run> buildAddRunSQL(Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(builder, table);
        }
        builder.append(" ADD ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, column);
        runs.addAll(this.buildAddCommentRunSQL(column));
        return runs;
    }

    public List<Run> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAlterRunSQL(column, slice);
    }

    public List<Run> buildAlterRunSQL(Column column) throws Exception {
        return this.buildAlterRunSQL(column, false);
    }

    public List<Run> buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public List<Run> buildRenameRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC SP_RENAME '").append(column.getTableName(true)).append(".").append(column.getName()).append("' , '").append(column.getUpdate().getName()).append("','COLUMN' ");
        column.setName(column.getUpdate().getName());
        return runs;
    }

    public List<Run> buildChangeTypeRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Column update = column.getUpdate();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable(true));
        builder.append(" ALTER COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" ");
        this.type(builder, update);
        this.nullable(builder, update);
        return runs;
    }

    public List<Run> buildChangeDefaultRunSQL(Column column) throws Exception {
        return super.buildChangeDefaultRunSQL(column);
    }

    public List<Run> buildChangeNullableRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Column update = column.getUpdate();
        int nullable = update.isNullable();
        if (nullable != -1) {
            builder.append("ALTER TABLE ");
            this.name(builder, column.getTable(true)).append(" ALTER COLUMN ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            this.type(builder, update);
            if (nullable == 0) {
                builder.append(" NOT");
            }
            builder.append(" NULL");
            column.setNullable(nullable);
        }
        return runs;
    }

    public List<Run> buildAddCommentRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            String schema = column.getSchema();
            if (BasicUtil.isEmpty((Object)schema)) {
                schema = column.getTable(true).getSchema();
            }
            builder.append("EXEC sys.sp_addextendedproperty @name=N'MS_Description'");
            builder.append(",@value=N'").append(comment).append("'");
            builder.append(",@level0type=N'SCHEMA'");
            builder.append(",@level0name=N'").append(schema).append("'");
            builder.append(",@level1type=N'TABLE'");
            builder.append(",@level1name=N'").append(column.getTableName(true)).append("'");
            builder.append(",@level2type=N'COLUMN'");
            builder.append(",@level2name=N'").append(column.getName()).append("'");
        }
        return runs;
    }

    public List<Run> buildChangeCommentRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = null;
        comment = null != column.getUpdate() ? column.getUpdate().getComment() : column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            String schema = column.getSchema();
            if (BasicUtil.isEmpty((Object)schema)) {
                schema = column.getTable(true).getSchema();
            }
            builder.append("EXEC sys.sp_updateextendedproperty @name=N'MS_Description'");
            builder.append(",@value=N'").append(comment).append("'");
            builder.append(",@level0type=N'SCHEMA'");
            builder.append(",@level0name=N'").append(schema).append("'");
            builder.append(",@level1type=N'TABLE'");
            builder.append(",@level1name=N'").append(column.getTableName(true)).append("'");
            builder.append(",@level2type=N'COLUMN'");
            builder.append(",@level2name=N'").append(column.getName()).append("'");
        }
        return runs;
    }

    public List<Run> buildDropAutoIncrement(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        return runs;
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            builder.append(" IDENTITY(").append(column.getIncrementSeed()).append(",").append(column.getIncrementStep()).append(")");
        }
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        return super.comment(builder, column);
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<Run> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public List<Run> buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public List<Run> buildRenameRunSQL(Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(tag.getName()).append("', '").append(tag.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public List<Run> buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public List<Run> buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<Run> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable(true));
            builder.append(" ADD PRIMARY KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public List<Run> buildDropRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable(true));
        builder.append(" DROP CONSTRAINT ");
        SQLUtil.delimiter((StringBuilder)builder, (String)primary.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    public List<Run> buildRenameRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(primary.getName()).append("', '").append(primary.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildAddRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAddRunSQL(foreign);
    }

    public List<Run> buildAlterRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAlterRunSQL(foreign);
    }

    public List<Run> buildDropRunSQL(ForeignKey foreign) throws Exception {
        return super.buildDropRunSQL(foreign);
    }

    public List<Run> buildRenameRunSQL(ForeignKey foreign) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(foreign.getName()).append("', '").append(foreign.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildQueryPrimaryRunSQL(Table table) throws Exception {
        String schema;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT  *  FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE \n");
        builder.append("WHERE TABLE_NAME='").append(this.objectName(table.getName())).append("'");
        String catalog = table.getCatalog();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            builder.append("\nAND TABLE_CATALOG = '").append(catalog).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)(schema = table.getSchema()))) {
            builder.append("\nAND TABLE_SCHEMA = '").append(schema).append("'");
        }
        builder.append("\nORDER BY ORDINAL_POSITION");
        return runs;
    }

    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = table.getPrimaryKey();
        for (DataRow row : set) {
            String col;
            Column column;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString("CONSTRAINT_NAME"));
                primary.setTable(table);
            }
            if (null == (column = primary.getColumn(col = row.getString("COLUMN_NAME")))) {
                column = new Column(col);
            }
            column.setTable(table);
            column.setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0)));
            primary.addColumn(column);
        }
        return primary;
    }

    public List<Run> buildQueryForeignsRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT F.NAME AS CONSTRAINT_NAME, OBJECT_NAME(F.PARENT_OBJECT_ID) AS TABLE_NAME, COL_NAME(FC.PARENT_OBJECT_ID, FC.PARENT_COLUMN_ID) AS COLUMN_NAME,");
        builder.append(" OBJECT_NAME(F.REFERENCED_OBJECT_ID) AS REFERENCED_TABLE_NAME, COL_NAME(FC.REFERENCED_OBJECT_ID, FC.REFERENCED_COLUMN_ID) AS REFERENCED_COLUMN_NAME \n");
        builder.append("FROM SYS.FOREIGN_KEYS AS F INNER JOIN SYS.FOREIGN_KEY_COLUMNS AS FC ON F.OBJECT_ID = FC.CONSTRAINT_OBJECT_ID \n");
        if (null != table) {
            builder.append(" AND OBJECT_NAME(F.PARENT_OBJECT_ID) = '").append(table.getName()).append("'\n");
        }
        return runs;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (null == foreigns) {
            foreigns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            ForeignKey foreign = (ForeignKey)foreigns.get(name.toUpperCase());
            if (null == foreign) {
                foreign = new ForeignKey();
                foreign.setName(name);
                foreign.setTable(row.getString("TABLE_NAME"));
                foreign.setReference(row.getString("REFERENCED_TABLE_NAME"));
                foreigns.put(name.toUpperCase(), foreign);
            }
            foreign.addColumn(new Column(row.getString("COLUMN_NAME")).setReference(row.getString("REFERENCED_COLUMN_NAME")).setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0))));
        }
        return foreigns;
    }

    public List<Run> buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<Run> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public List<Run> buildDropRunSQL(Index index) throws Exception {
        return super.buildDropRunSQL(index);
    }

    public List<Run> buildRenameRunSQL(Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(index.getName()).append("', '").append(index.getUpdate().getName()).append("'");
        return runs;
    }

    public void comment(StringBuilder builder, Index index) {
        super.comment(builder, index);
    }

    public List<Run> buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<Run> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public List<Run> buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public List<Run> buildRenameRunSQL(Constraint constraint) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(constraint.getName()).append("', '").append(constraint.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildCreateRunSQL(Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE TRIGGER ").append(trigger.getName());
        builder.append(" ON ");
        this.name(builder, trigger.getTable(true));
        builder.append(" ").append(trigger.getTime().sql()).append(" ");
        List events = trigger.getEvents();
        boolean first = true;
        for (Trigger.EVENT event : events) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append(event);
            first = false;
        }
        builder.append(" AS \n").append(trigger.getDefinition());
        return runs;
    }

    public List<Run> buildAlterRunSQL(Trigger trigger) throws Exception {
        return null;
    }

    public List<Run> buildDropRunSQL(Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP TRIGGER ").append(trigger.getName());
        return runs;
    }

    public List<Run> buildRenameRunSQL(Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(trigger.getName()).append("', '").append(trigger.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildCreateRunSQL(Procedure procedure) throws Exception {
        return super.buildCreateRunSQL(procedure);
    }

    public List<Run> buildAlterRunSQL(Procedure procedure) throws Exception {
        return super.buildAlterRunSQL(procedure);
    }

    public List<Run> buildDropRunSQL(Procedure procedure) throws Exception {
        return super.buildDropRunSQL(procedure);
    }

    public List<Run> buildRenameRunSQL(Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(procedure.getName()).append("', '").append(procedure.getUpdate().getName()).append("'");
        return runs;
    }

    public List<Run> buildCreateRunSQL(Function function) throws Exception {
        return super.buildCreateRunSQL(function);
    }

    public List<Run> buildAlterRunSQL(Function function) throws Exception {
        return super.buildAlterRunSQL(function);
    }

    public List<Run> buildDropRunSQL(Function function) throws Exception {
        return super.buildDropRunSQL(function);
    }

    public List<Run> buildRenameRunSQL(Function function) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("EXEC sp_rename '").append(function.getName()).append("', '").append(function.getUpdate().getName()).append("'");
        return runs;
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "getdate()";
        }
        return null;
    }
}

