/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mariadb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.MySQLGenusAdapter;
import org.anyline.data.jdbc.mariadb.MariaColumnTypeAlias;
import org.anyline.data.jdbc.mariadb.MariaReader;
import org.anyline.data.jdbc.mariadb.MariaWriter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataSet;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.mariadb")
public class MariaAdapter
extends MySQLGenusAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.mariadb:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.MariaDB;
    }

    public String generatedKey() {
        return "GENERATED_KEY";
    }

    public MariaAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
        for (MariaColumnTypeAlias mariaColumnTypeAlias : MariaColumnTypeAlias.values()) {
            this.types.put(mariaColumnTypeAlias.name(), mariaColumnTypeAlias.standard());
        }
        for (Enum enum_ : MariaWriter.values()) {
            this.reg(((MariaWriter)enum_).supports(), ((MariaWriter)enum_).writer());
        }
        for (Enum enum_ : MariaReader.values()) {
            this.reg(((MariaReader)enum_).supports(), ((MariaReader)enum_).reader());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String insertHead(ConfigStore configs) {
        return super.insertHead(configs);
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.mergeFinalQuery(runtime, run);
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        return super.createConditionFindInSet(runtime, builder, column, compare, value);
    }

    public void checkSchema(DataRuntime runtime, Connection con, Table table) {
        try {
            if (null == table.getSchema()) {
                table.setSchema(con.getCatalog());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        table.setCheckSchemaTime(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchema(DataRuntime runtime, DataSource dataSource, Table table) {
        if (null == table || null != table.getCheckSchemaTime()) {
            return;
        }
        Connection con = null;
        try {
            if (null == table.getSchema()) {
                con = DataSourceUtils.getConnection((DataSource)dataSource);
                table.setSchema(con.getCatalog());
            }
            table.setCheckSchemaTime(new Date());
        }
        catch (Exception e) {
            log.warn("[check schema][fail:{}]", (Object)e.toString());
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)dataSource)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
        }
    }

    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        tables = super.tables(runtime, index, create, catalog, schema, tables, set);
        for (Table table : tables.values()) {
            table.setCatalog(null);
        }
        return tables;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        tables = super.tables(runtime, index, create, catalog, schema, tables, set);
        for (Table table : tables) {
            table.setCatalog(null);
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryDDLRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDDLRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public List<Run> buildQueryViewRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryViewRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        return super.views(runtime, index, create, catalog, schema, views, set);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.views(runtime, create, views, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryDDLRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDDLRun(runtime, view);
    }

    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags, name);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryColumnRun(runtime, table, metadata);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        return super.columns(runtime, index, create, table, columns, set);
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        columns = super.columns(runtime, index, create, table, columns, set);
        for (Column column : columns) {
            column.setCatalog(null);
        }
        return columns;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return new ArrayList<Run>();
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return new LinkedHashMap();
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return new LinkedHashMap();
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return new LinkedHashMap();
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryPrimaryRun(runtime, table);
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        return super.primary(runtime, index, table, set);
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryForeignsRun(runtime, table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        return super.foreigns(runtime, index, table, foreigns, set);
    }

    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(runtime, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRun(runtime, table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggerRun(runtime, table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, table, triggers, set);
    }

    public List<Run> buildQueryProcedureRun(DataRuntime runtime, String catalog, String schema, String name) {
        return super.buildQueryProcedureRun(runtime, catalog, schema, name);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, procedures, set);
    }

    public List<Run> buildQueryDDLRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDDLRun(runtime, procedure);
    }

    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    public List<Run> buildQueryFunctionRun(DataRuntime runtime, String catalog, String schema, String name) {
        return super.buildQueryFunctionRun(runtime, catalog, schema, name);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, set);
    }

    public List<Run> buildQueryDDLRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildQueryDDLRun(runtime, function);
    }

    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAppendCommentRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.primary(runtime, builder, table);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.comment(runtime, builder, table);
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.name(runtime, builder, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View view) throws Exception {
        return super.buildCreateRun(runtime, view);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAppendCommentRun(runtime, view);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAlterRun(runtime, view);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View view) throws Exception {
        return super.buildRenameRun(runtime, view);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildChangeCommentRun(runtime, view);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View view) throws Exception {
        return super.buildDropRun(runtime, view);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View view) {
        return super.comment(runtime, builder, view);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER COLUMN ";
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAddRun(runtime, column, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, column, slice);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildDropRun(runtime, column, slice);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildRenameRun(runtime, column);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeTypeRun(runtime, column);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeDefaultRun(runtime, column);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeNullableRun(runtime, column);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        ((Column)column.update()).autoIncrement(Boolean.valueOf(false));
        return this.buildAlterRun(runtime, column);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.define(runtime, builder, column);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.type(runtime, builder, column);
    }

    public boolean isIgnorePrecision(DataRuntime runtime, Column column) {
        return super.isIgnorePrecision(runtime, column);
    }

    public boolean isIgnoreScale(DataRuntime runtime, Column column) {
        return super.isIgnoreScale(runtime, column);
    }

    public Boolean checkIgnorePrecision(DataRuntime runtime, String datatype) {
        return super.checkIgnorePrecision(runtime, datatype);
    }

    public Boolean checkIgnoreScale(DataRuntime runtime, String datatype) {
        return super.checkIgnoreScale(runtime, datatype);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.nullable(runtime, builder, column);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.charset(runtime, builder, column);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.defaultValue(runtime, builder, column);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.increment(runtime, builder, column);
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.onupdate(runtime, builder, column);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.position(runtime, builder, column);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.comment(runtime, builder, column);
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAddRun(runtime, primary);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAlterRun(runtime, primary);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildDropRun(runtime, primary);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildRenameRun(runtime, primary);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAddRun(runtime, foreign);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAlterRun(runtime, foreign);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildDropRun(runtime, foreign);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildRenameRun(runtime, foreign);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAddRun(runtime, index);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAlterRun(runtime, index);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildDropRun(runtime, index);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildRenameRun(runtime, index);
    }

    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
        super.comment(runtime, builder, index);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAddRun(runtime, constraint);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAlterRun(runtime, constraint);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildDropRun(runtime, constraint);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildRenameRun(runtime, constraint);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildCreateRun(runtime, trigger);
    }

    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        super.each(runtime, builder, trigger);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildAlterRun(runtime, trigger);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildDropRun(runtime, trigger);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildRenameRun(runtime, trigger);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildCreateRun(runtime, procedure);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildAlterRun(runtime, procedure);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildDropRun(runtime, procedure);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        log.warn("MySQL\u4e0d\u652f\u6301 rename procedure(" + procedure.getName() + ")");
        return new ArrayList<Run>();
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Procedure procedure) {
        return super.name(runtime, builder, procedure);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildCreateRun(runtime, function);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildAlterRun(runtime, function);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildDropRun(runtime, function);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        log.warn("MySQL\u4e0d\u652f\u6301 rename function(" + function.getName() + ")");
        return new ArrayList<Run>();
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Function function) {
        return super.name(runtime, builder, function);
    }

    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        return super.isBooleanColumn(runtime, column);
    }

    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        return super.isNumberColumn(runtime, column);
    }

    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return super.isCharColumn(runtime, column);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        return super.value(runtime, column, value);
    }
}

