/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mariadb;

import org.anyline.adapter.DataReader;
import org.anyline.data.jdbc.mariadb.MariaGeometryAdapter;
import org.anyline.data.metadata.StandardColumnType;

public enum MariaReader {
    GeometryReader(new Object[]{StandardColumnType.GEOMETRY}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parse(bytes);
        }
    }),
    PointReader(new Object[]{StandardColumnType.POINT}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parsePoint(bytes);
        }
    }),
    LineReader(new Object[]{StandardColumnType.LINESTRING}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parseLine(bytes);
        }
    }),
    PolygonReader(new Object[]{StandardColumnType.POLYGON}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parsePolygon(bytes);
        }
    }),
    MultiPointReader(new Object[]{StandardColumnType.MULTIPOINT}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parseMultiPoint(bytes);
        }
    }),
    MultiLineReader(new Object[]{StandardColumnType.MULTILINESTRING}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parseMultiLine(bytes);
        }
    }),
    MultiPolygonReader(new Object[]{StandardColumnType.MULTIPOLYGON}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parseMultiPolygon(bytes);
        }
    }),
    GeometryCollectionReader(new Object[]{StandardColumnType.GEOMETRYCOLLECTION}, new DataReader(){

        public Object read(Object value) {
            byte[] bytes = (byte[])value;
            return MariaGeometryAdapter.parseGeometryCollection(bytes);
        }
    });

    private final Object[] supports;
    private final DataReader reader;

    public Object[] supports() {
        return this.supports;
    }

    public DataReader reader() {
        return this.reader;
    }

    private MariaReader(Object[] supports, DataReader reader) {
        this.supports = supports;
        this.reader = reader;
    }
}

