/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mariadb;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.GeometryCollection;
import org.anyline.entity.geometry.LineString;
import org.anyline.entity.geometry.MultiLine;
import org.anyline.entity.geometry.MultiPoint;
import org.anyline.entity.geometry.MultiPolygon;
import org.anyline.entity.geometry.Point;
import org.anyline.entity.geometry.Polygon;
import org.anyline.entity.geometry.Ring;
import org.anyline.util.ByteBuffer;
import org.anyline.util.NumberUtil;

public class MariaGeometryAdapter {
    private static Map<Integer, Geometry.Type> types = new Hashtable<Integer, Geometry.Type>();

    public static void init(Geometry geometry) {
        if (null != geometry) {
            Integer type;
            Byte endian;
            if (null == geometry.srid()) {
                geometry.srid(0);
            }
            if (null == (endian = geometry.endian())) {
                geometry.endian(1);
            }
            if (null == (type = geometry.type())) {
                if (geometry instanceof Point) {
                    type = 1;
                } else if (geometry instanceof LineString) {
                    type = 2;
                } else if (geometry instanceof Polygon) {
                    type = 3;
                } else if (geometry instanceof MultiPoint) {
                    type = 4;
                } else if (geometry instanceof MultiLine) {
                    type = 5;
                } else if (geometry instanceof MultiPolygon) {
                    type = 6;
                } else if (geometry instanceof GeometryCollection) {
                    type = 7;
                }
                geometry.type(type.intValue());
            }
        }
    }

    public static Geometry.Type type(Integer type) {
        return types.get(type);
    }

    public static String sql(Geometry geometry) {
        return null;
    }

    public static String sql(Point point) {
        return "Point(" + point.x() + " " + point.y() + ")";
    }

    public static Geometry parse(byte[] bytes) {
        Point geometry = null;
        byte[] srid_bytes = new byte[4];
        System.arraycopy(bytes, 0, srid_bytes, 0, 4);
        byte endian = bytes[4];
        int srid = NumberUtil.byte2int((byte[])bytes, (int)0, (int)4, (endian == 0 ? 1 : 0) != 0);
        int type = NumberUtil.byte2int((byte[])bytes, (int)5, (int)4, (endian == 0 ? 1 : 0) != 0);
        if (type == 1) {
            geometry = MariaGeometryAdapter.parsePoint(bytes);
        } else if (type == 2) {
            geometry = MariaGeometryAdapter.parseLine(bytes);
        } else if (type == 3) {
            geometry = MariaGeometryAdapter.parsePolygon(bytes);
        } else if (type == 4) {
            geometry = MariaGeometryAdapter.parseMultiPoint(bytes);
        } else if (type == 5) {
            geometry = MariaGeometryAdapter.parseMultiLine(bytes);
        } else if (type == 6) {
            geometry = MariaGeometryAdapter.parseMultiPolygon(bytes);
        } else if (type == 7) {
            geometry = MariaGeometryAdapter.parseGeometryCollection(bytes);
        }
        geometry.endian(endian);
        geometry.srid(srid);
        geometry.type(type);
        geometry.origin((Object)bytes);
        return geometry;
    }

    public static Point parsePoint(byte[] bytes) {
        Point point = MariaGeometryAdapter.point(bytes, 9);
        return point;
    }

    public static Point point(byte[] bytes, int offset) {
        ByteBuffer buffer = new ByteBuffer(bytes, (int)bytes[4], offset);
        return MariaGeometryAdapter.point(buffer);
    }

    public static Point point(ByteBuffer buffer) {
        Point point = new Point(Double.valueOf(buffer.readDouble()), Double.valueOf(buffer.readDouble()));
        point.tag("Point");
        point.type(1);
        point.endian(1);
        return point;
    }

    public static LineString parseLine(byte[] bytes) {
        LineString line = MariaGeometryAdapter.line(bytes, 9);
        return line;
    }

    public static LineString line(byte[] bytes, int offset) {
        ByteBuffer buffer = new ByteBuffer(bytes, (int)bytes[4], offset);
        return MariaGeometryAdapter.line(buffer);
    }

    public static LineString line(ByteBuffer buffer) {
        ArrayList<Point> points = new ArrayList<Point>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            Point point = MariaGeometryAdapter.point(buffer);
            points.add(point);
        }
        LineString line = new LineString(points);
        line.tag("LineString");
        line.type(2);
        line.endian(1);
        return line;
    }

    public static Polygon parsePolygon(byte[] bytes) {
        Polygon polygon = MariaGeometryAdapter.polygon(bytes, 9);
        return polygon;
    }

    public static Polygon polygon(byte[] bytes, int offset) {
        ByteBuffer buffer = new ByteBuffer(bytes, (int)bytes[4], offset);
        return MariaGeometryAdapter.polygon(buffer);
    }

    public static Polygon polygon(ByteBuffer buffer) {
        Polygon polygon = new Polygon();
        polygon.tag("Polygon");
        polygon.type(3);
        polygon.endian(1);
        int ring_count = buffer.readInt();
        Ring out = MariaGeometryAdapter.ring(buffer);
        out.clockwise(Boolean.valueOf(true));
        polygon.add(out);
        if (ring_count > 1) {
            for (int r = 1; r < ring_count; ++r) {
                Ring in = MariaGeometryAdapter.ring(buffer);
                in.clockwise(Boolean.valueOf(false));
                polygon.add(in);
            }
        }
        return polygon;
    }

    public static Ring ring(ByteBuffer buffer) {
        ArrayList<Point> points = new ArrayList<Point>();
        int point_count = buffer.readInt();
        for (int p = 0; p < point_count; ++p) {
            points.add(MariaGeometryAdapter.point(buffer));
        }
        Ring ring = new Ring(points);
        return ring;
    }

    public static MultiPoint parseMultiPoint(byte[] bytes) {
        ByteBuffer buffer = new ByteBuffer(bytes, (int)bytes[4], 9);
        return MariaGeometryAdapter.multiPoint(buffer);
    }

    public static MultiPoint multiPoint(ByteBuffer buffer) {
        int count = buffer.readInt();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < count; ++i) {
            buffer.step(5);
            points.add(MariaGeometryAdapter.point(buffer));
        }
        MultiPoint multiPoint = new MultiPoint(points);
        multiPoint.tag("MultiPoint");
        multiPoint.type(4);
        multiPoint.endian(1);
        return multiPoint;
    }

    public static MultiLine parseMultiLine(byte[] bytes) {
        ByteBuffer buffer = new ByteBuffer(bytes, (int)bytes[4], 9);
        return MariaGeometryAdapter.multiLine(buffer);
    }

    public static MultiLine multiLine(ByteBuffer buffer) {
        int line_count = buffer.readInt();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (int l = 0; l < line_count; ++l) {
            buffer.step(5);
            lines.add(MariaGeometryAdapter.line(buffer));
        }
        MultiLine multiLine = new MultiLine(lines);
        multiLine.tag("MultiLine");
        multiLine.type(5);
        multiLine.endian(1);
        return multiLine;
    }

    public static MultiPolygon parseMultiPolygon(byte[] bytes) {
        ByteBuffer buffer = new ByteBuffer(bytes, (int)bytes[4], 9);
        return MariaGeometryAdapter.multiPolygon(buffer);
    }

    public static MultiPolygon multiPolygon(ByteBuffer buffer) {
        int polygon_count = buffer.readInt();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int py = 0; py < polygon_count; ++py) {
            buffer.step(5);
            Polygon polygon = MariaGeometryAdapter.polygon(buffer);
            polygons.add(polygon);
        }
        MultiPolygon multiPolygon = new MultiPolygon(polygons);
        multiPolygon.tag("MultiPolygon");
        multiPolygon.type(6);
        multiPolygon.endian(1);
        return multiPolygon;
    }

    public static GeometryCollection parseGeometryCollection(byte[] bytes) {
        GeometryCollection collection = new GeometryCollection();
        ByteBuffer buffer = new ByteBuffer(bytes, (int)bytes[4], 9);
        int geometryCount = buffer.readInt();
        for (int g = 0; g < geometryCount; ++g) {
            buffer.step(1);
            int type = buffer.readInt();
            Point geometry = null;
            if (type == 1) {
                geometry = MariaGeometryAdapter.point(buffer);
            } else if (type == 2) {
                geometry = MariaGeometryAdapter.line(buffer);
            } else if (type == 3) {
                geometry = MariaGeometryAdapter.polygon(buffer);
            } else if (type == 4) {
                geometry = MariaGeometryAdapter.multiPoint(buffer);
            } else if (type == 5) {
                geometry = MariaGeometryAdapter.multiLine(buffer);
            } else if (type == 6) {
                geometry = MariaGeometryAdapter.multiPolygon(buffer);
            }
            if (null == geometry) continue;
            collection.add((Geometry)geometry);
        }
        collection.tag("GeometryCollection");
        collection.type(7);
        collection.endian(1);
        return collection;
    }

    public static byte[] wkb(Geometry geometry) {
        if (geometry instanceof Point) {
            return MariaGeometryAdapter.wkb((Point)geometry);
        }
        if (geometry instanceof LineString) {
            return MariaGeometryAdapter.wkb((LineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return MariaGeometryAdapter.wkb((Polygon)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return MariaGeometryAdapter.wkb((MultiPoint)geometry);
        }
        if (geometry instanceof MultiLine) {
            return MariaGeometryAdapter.wkb((MultiLine)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return MariaGeometryAdapter.wkb((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return MariaGeometryAdapter.wkb((GeometryCollection)geometry);
        }
        return null;
    }

    public static void wkb(ByteBuffer buffer, Geometry geometry, boolean head) {
        if (geometry instanceof Point) {
            MariaGeometryAdapter.wkb(buffer, (Point)geometry, head);
        } else if (geometry instanceof LineString) {
            MariaGeometryAdapter.wkb(buffer, (LineString)geometry, head);
        } else if (geometry instanceof Polygon) {
            MariaGeometryAdapter.wkb(buffer, (Polygon)geometry, head);
        } else if (geometry instanceof MultiPoint) {
            MariaGeometryAdapter.wkb(buffer, (MultiPoint)geometry, head);
        } else if (geometry instanceof MultiLine) {
            MariaGeometryAdapter.wkb(buffer, (MultiLine)geometry, head);
        } else if (geometry instanceof MultiPolygon) {
            MariaGeometryAdapter.wkb(buffer, (MultiPolygon)geometry, head);
        }
    }

    public static byte[] wkb(Point point) {
        MariaGeometryAdapter.init((Geometry)point);
        ByteBuffer buffer = new ByteBuffer(25, (int)point.endian().byteValue());
        buffer.put(point.srid().intValue());
        MariaGeometryAdapter.wkb(buffer, point, true);
        byte[] bytes = buffer.bytes();
        return bytes;
    }

    public static void wkb(ByteBuffer buffer, Point point, boolean head) {
        if (head) {
            buffer.put(point.endian().byteValue());
            buffer.put(point.type().intValue());
        }
        buffer.put(point.x().doubleValue());
        buffer.put(point.y().doubleValue());
    }

    public static byte[] wkb(LineString line) {
        List points = line.points();
        ByteBuffer buffer = new ByteBuffer(points.size() * 16 + 13, (int)line.endian().byteValue());
        buffer.put(line.srid().intValue());
        MariaGeometryAdapter.wkb(buffer, line, true);
        byte[] bytes = buffer.bytes();
        return bytes;
    }

    public static void wkb(ByteBuffer buffer, LineString line, boolean head) {
        if (head) {
            buffer.put(line.endian().byteValue());
            buffer.put(line.type().intValue());
        }
        List points = line.points();
        buffer.put(points.size());
        for (Point point : points) {
            MariaGeometryAdapter.wkb(buffer, point, false);
        }
    }

    public static byte[] wkb(Polygon polygon) {
        MariaGeometryAdapter.init((Geometry)polygon);
        List rings = polygon.rings();
        int len = 13;
        for (Ring ring : rings) {
            len += ring.points().size() * 16 + 4;
        }
        ByteBuffer buffer = new ByteBuffer(len, (int)polygon.endian().byteValue());
        buffer.put(polygon.srid().intValue());
        MariaGeometryAdapter.wkb(buffer, polygon, true);
        return buffer.bytes();
    }

    public static void wkb(ByteBuffer buffer, Polygon polygon, boolean head) {
        if (head) {
            buffer.put(polygon.endian().byteValue());
            buffer.put(polygon.type().intValue());
        }
        List rings = polygon.rings();
        buffer.put(rings.size());
        for (Ring ring : rings) {
            MariaGeometryAdapter.wkb(buffer, ring);
        }
    }

    public static void wkb(ByteBuffer buffer, Ring ring) {
        List points = ring.points();
        buffer.put(points.size());
        for (Point point : points) {
            MariaGeometryAdapter.wkb(buffer, point, false);
        }
    }

    public static byte[] wkb(MultiPoint multiPoint) {
        MariaGeometryAdapter.init((Geometry)multiPoint);
        List points = multiPoint.points();
        int len = 13 + points.size() * 21;
        ByteBuffer buffer = new ByteBuffer(len, (int)multiPoint.endian().byteValue());
        buffer.put(multiPoint.srid().intValue());
        MariaGeometryAdapter.wkb(buffer, multiPoint, true);
        return buffer.bytes();
    }

    public static void wkb(ByteBuffer buffer, MultiPoint multiPoint, boolean head) {
        if (head) {
            buffer.put(multiPoint.endian().byteValue());
            buffer.put(multiPoint.type().intValue());
        }
        List points = multiPoint.points();
        buffer.put(points.size());
        for (Point point : points) {
            buffer.put(multiPoint.endian().byteValue());
            buffer.put(point.type().intValue());
            MariaGeometryAdapter.wkb(buffer, point, false);
        }
    }

    public static byte[] wkb(MultiLine multiLine) {
        MariaGeometryAdapter.init((Geometry)multiLine);
        int len = 13;
        List lines = multiLine.lines();
        for (LineString line : lines) {
            len += 9;
            List points = line.points();
            len += points.size() * 16;
        }
        ByteBuffer buffer = new ByteBuffer(len, (int)multiLine.endian().byteValue());
        buffer.put(multiLine.srid().intValue());
        MariaGeometryAdapter.wkb(buffer, multiLine, true);
        return buffer.bytes();
    }

    public static void wkb(ByteBuffer buffer, MultiLine multiLine, boolean head) {
        if (head) {
            buffer.put(multiLine.endian().byteValue());
            buffer.put(multiLine.type().intValue());
        }
        List lines = multiLine.lines();
        buffer.put(lines.size());
        for (LineString line : lines) {
            MariaGeometryAdapter.wkb(buffer, line, true);
        }
    }

    public static byte[] wkb(MultiPolygon multiPolygon) {
        MariaGeometryAdapter.init((Geometry)multiPolygon);
        int len = 13;
        List polygons = multiPolygon.polygons();
        for (Polygon polygon : polygons) {
            len += 9;
            List rings = polygon.rings();
            for (Ring ring : rings) {
                len += 4;
                len += ring.points().size() * 16;
            }
        }
        ByteBuffer buffer = new ByteBuffer(len, (int)multiPolygon.endian().byteValue());
        buffer.put(multiPolygon.srid().intValue());
        MariaGeometryAdapter.wkb(buffer, multiPolygon, true);
        return buffer.bytes();
    }

    public static void wkb(ByteBuffer buffer, MultiPolygon multiPolygon, boolean head) {
        if (head) {
            buffer.put(multiPolygon.endian().byteValue());
            buffer.put(multiPolygon.type().intValue());
        }
        List polygons = multiPolygon.polygons();
        buffer.put(polygons.size());
        for (Polygon polygon : polygons) {
            MariaGeometryAdapter.wkb(buffer, polygon, true);
        }
    }

    public static byte[] wkb(GeometryCollection collection) {
        MariaGeometryAdapter.init((Geometry)collection);
        ByteBuffer buffer = new ByteBuffer();
        List list = collection.collection();
        buffer.put(collection.srid().intValue());
        buffer.put(collection.endian().byteValue());
        buffer.put(collection.type().intValue());
        buffer.put(list.size());
        for (Geometry geometry : list) {
            MariaGeometryAdapter.wkb(buffer, geometry, true);
        }
        byte[] bytes = buffer.bytes();
        return bytes;
    }

    static {
        types.put(1, Geometry.Type.Point);
        types.put(2, Geometry.Type.LineString);
        types.put(3, Geometry.Type.Polygon);
        types.put(4, Geometry.Type.MultiPoint);
        types.put(5, Geometry.Type.MultiLine);
        types.put(6, Geometry.Type.MultiPolygon);
        types.put(7, Geometry.Type.GeometryCollection);
    }
}

