/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mariadb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.SQLAdapter;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Database;
import org.anyline.data.entity.ForeignKey;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.entity.Trigger;
import org.anyline.data.entity.View;
import org.anyline.data.jdbc.mariadb.MariaColumnTypeAlias;
import org.anyline.data.jdbc.mariadb.MariaReader;
import org.anyline.data.jdbc.mariadb.MariaWriter;
import org.anyline.data.run.Run;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.DatabaseType;
import org.anyline.entity.data.Trigger;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.mariadb")
public class MariaAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.mariadb:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.MariaDB;
    }

    public String generatedKey() {
        return "GENERATED_KEY";
    }

    public MariaAdapter() {
        Object[] supports;
        this.delimiterFr = "`";
        this.delimiterTo = "`";
        for (MariaColumnTypeAlias mariaColumnTypeAlias : MariaColumnTypeAlias.values()) {
            this.types.put(mariaColumnTypeAlias.name(), mariaColumnTypeAlias.standard());
        }
        for (Enum enum_ : MariaWriter.values()) {
            supports = ((MariaWriter)enum_).supports();
            if (null == supports) continue;
            for (Object support : supports) {
                this.writers.put(support, ((MariaWriter)enum_).writer());
            }
        }
        for (Enum enum_ : MariaReader.values()) {
            supports = ((MariaReader)enum_).supports();
            if (null == supports) continue;
            for (Object support : supports) {
                this.readers.put(support, ((MariaReader)enum_).reader());
            }
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatFun(args);
    }

    public Object buildConditionFindInSet(StringBuilder builder, String column, Compare compare, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (null != value) {
            if (value instanceof Collection) {
                Collection cols = (Collection)value;
                for (Object e : cols) {
                    values.add(e);
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object obj : array = (Object[])value) {
                    values.add(obj);
                }
            } else {
                values.add(value);
            }
        }
        if (values.size() > 1) {
            builder.append("(");
        }
        boolean first = true;
        for (Object e : values) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append("FIND_IN_SET(?,").append(column).append(")");
            first = false;
        }
        if (values.size() > 1) {
            builder.append(")");
        }
        return value;
    }

    public void checkSchema(Connection con, Table table) {
        try {
            if (null == table.getSchema()) {
                table.setSchema(con.getCatalog());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        table.setCheckSchemaTime(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchema(DataSource dataSource, Table table) {
        if (null == table || null != table.getCheckSchemaTime()) {
            return;
        }
        Connection con = null;
        try {
            if (null == table.getSchema()) {
                con = DataSourceUtils.getConnection((DataSource)dataSource);
                table.setSchema(con.getCatalog());
            }
            table.setCheckSchemaTime(new Date());
        }
        catch (Exception e) {
            log.warn("[check schema][fail:{}]", (Object)e.toString());
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)dataSource)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
        }
    }

    public List<String> buildQueryDatabaseRunSQL() throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("SHOW DATABASES");
        return sqls;
    }

    public LinkedHashMap<String, Database> databases(int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        if (null == databases) {
            databases = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Database database = new Database();
            database.setName(row.getString("DATABASE"));
            databases.put(database.getName().toUpperCase(), database);
        }
        return databases;
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM information_schema.TABLES WHERE 1=1 ");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(pattern)).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)types)) {
            String[] tmps = types.split(",");
            builder.append(" AND TABLE_TYPE IN(");
            int idx = 0;
            for (String tmp : tmps) {
                if (idx > 0) {
                    builder.append(",");
                }
                builder.append("'").append(tmp).append("'");
                ++idx;
            }
            builder.append(")");
        } else {
            builder.append(" AND TABLE_TYPE IN ('BASE TABLE','TABLE')");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public List<String> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRunSQL(catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            Table table = (Table)tables.get(name.toUpperCase());
            if (null == table) {
                table = new Table();
            }
            table.setSchema(row.getString("TABLE_SCHEMA"));
            table.setName(name);
            table.setEngine(row.getString("ENGINE"));
            table.setComment(row.getString("TABLE_COMMENT"));
            tables.put(name.toUpperCase(), table);
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        Map keys = this.keys(set);
        while (set.next()) {
            String tableName = this.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)tableName)) {
                tableName = this.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)tableName)) continue;
            Table table = (Table)tables.get(tableName.toUpperCase());
            if (null == table) {
                if (!create) continue;
                table = new Table();
                tables.put(tableName.toUpperCase(), table);
            }
            table.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
            table.setCatalog(null);
            table.setName(tableName);
            table.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), table.getType()}));
            table.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), table.getComment()}));
            table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
            table.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), table.getTypeName()}));
            table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
            table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
            tables.put(tableName.toUpperCase(), table);
        }
        return tables;
    }

    public List<String> buildQueryViewRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM information_schema.VIEWS WHERE 1=1 ");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(pattern)).append("'");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public <T extends View> LinkedHashMap<String, T> views(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            View view = (View)views.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            view.setSchema(row.getString("TABLE_SCHEMA"));
            view.setName(name);
            view.setDefinition(row.getString("VIEW_DEFINITION"));
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    public <T extends View> LinkedHashMap<String, T> views(boolean create, LinkedHashMap<String, T> views, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
        if (null == views) {
            views = new LinkedHashMap();
        }
        Map keys = this.keys(set);
        while (set.next()) {
            String viewName = this.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)viewName)) {
                viewName = this.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)viewName)) continue;
            View view = (View)views.get(viewName.toUpperCase());
            if (null == view) {
                if (!create) continue;
                view = new View();
                views.put(viewName.toUpperCase(), view);
            }
            view.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
            view.setCatalog(null);
            view.setName(viewName);
            view.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), view.getType()}));
            view.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), view.getComment()}));
            view.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), view.getTypeCat()}));
            view.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), view.getTypeName()}));
            view.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), view.getSelfReferencingColumn()}));
            view.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), view.getRefGeneration()}));
            views.put(viewName.toUpperCase(), view);
        }
        return views;
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags, name);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            builder.append("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE 1=1 ");
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
            }
            builder.append(" AND TABLE_NAME = '").append(this.objectName(table.getName())).append("'");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        return super.columns(index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return null;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return null;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return null;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, LinkedHashMap<String, T> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return null;
    }

    public List<String> buildQueryPrimaryRunSQL(Table table) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SHOW INDEX FROM ");
        this.name(builder, table);
        list.add(builder.toString());
        return list;
    }

    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = null;
        if ((set = set.getRows(new String[]{"Key_name", "PRIMARY"})).size() > 0) {
            primary = new PrimaryKey();
            for (DataRow row : set) {
                primary.setName(row.getString("Key_name"));
                Column column = new Column(row.getString("Column_name"));
                primary.addColumn(column);
            }
        }
        return primary;
    }

    public List<String> buildQueryForeignsRunSQL(Table table) throws Exception {
        String name;
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE where REFERENCED_TABLE_NAME IS NOT NULL\n");
        if (null != table && BasicUtil.isNotEmpty((Object)(name = table.getName()))) {
            builder.append(" AND TABLE_NAME = '").append(name).append("'\n");
        }
        builder.append("ORDER BY ORDINAL_POSITION");
        sqls.add(builder.toString());
        return sqls;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (null == foreigns) {
            foreigns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            ForeignKey foreign = (ForeignKey)foreigns.get(name.toUpperCase());
            if (null == foreign) {
                foreign = new ForeignKey();
                foreign.setName(name);
                foreign.setTable(row.getString("TABLE_NAME"));
                foreign.setReference(row.getString("REFERENCED_TABLE_NAME"));
                foreigns.put(name.toUpperCase(), foreign);
            }
            foreign.addColumn(new Column(row.getString("COLUMN_NAME")).setReference(row.getString("REFERENCED_COLUMN_NAME")).setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0))));
        }
        return foreigns;
    }

    public List<String> buildQueryIndexRunSQL(Table table, String name) {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.STATISTICS\n");
        builder.append("WHERE 1=1\n");
        if (null != table) {
            if (null != table.getSchema()) {
                builder.append("AND TABLE_SCHEMA='").append(table.getSchema()).append("'\n");
            }
            if (null != table.getName()) {
                builder.append("AND TABLE_NAME='").append(this.objectName(table.getName())).append("'\n");
            }
        }
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append("AND INDEX_NAME='").append(name).append("'\n");
        }
        builder.append("ORDER BY SEQ_IN_INDEX");
        sqls.add(builder.toString());
        return sqls;
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("INDEX_NAME");
            if (null == name) continue;
            String schema = row.getString("TABLE_SCHEMA");
            String tableName = row.getString("TABLE_NAME");
            Index idx = (Index)indexs.get(name.toUpperCase());
            if (null == idx && create) {
                idx = new Index();
                indexs.put(name.toUpperCase(), idx);
            }
            idx.setTableName(tableName);
            idx.setName(name);
            if (null == table) {
                table = new Table(tableName);
                table.setSchema(schema);
            }
            idx.setTable(table);
            if (name.equals("PRIMARY")) {
                idx.setPrimary(true);
            }
            if ("0".equals(row.getString("NON_UNIQUE"))) {
                idx.setUnique(true);
            }
            idx.setComment(row.getString("INDEX_COMMENT"));
            idx.setType(row.getString("INDEX_TYPE"));
            String col = row.getString("COLUMN_NAME");
            Column column = idx.getColumn(col);
            if (null == column) {
                idx.addColumn(col, null, row.getInt("SEQ_IN_INDEX", Integer.valueOf(0)).intValue());
            }
            indexs.put(name.toUpperCase(), idx);
        }
        return indexs;
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, LinkedHashMap<String, T> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildQueryTriggerRunSQL(Table table, List<Trigger.EVENT> events) {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS WHERE 1=1");
        if (null != table) {
            String schemae = table.getSchema();
            String name = table.getName();
            if (BasicUtil.isNotEmpty((Object)schemae)) {
                builder.append(" AND TRIGGER_SCHEMA = '").append(schemae).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append(" AND EVENT_OBJECT_TABLE = '").append(name).append("'");
            }
        }
        if (null != events && events.size() > 0) {
            builder.append(" AND(");
            boolean first = true;
            for (Trigger.EVENT event : events) {
                if (!first) {
                    builder.append(" OR ");
                }
                builder.append("EVENT_MANIPULATION ='").append(event);
            }
            builder.append(")");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TRIGGER_NAME");
            Trigger trigger = (Trigger)triggers.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            Table tab = new Table(row.getString("EVENT_OBJECT_TABLE"));
            tab.setSchema(row.getString("TRIGGER_SCHEMA"));
            trigger.setTable((org.anyline.entity.data.Table)tab);
            boolean each = false;
            if ("ROW".equalsIgnoreCase(row.getString("ACTION_ORIENTATION"))) {
                each = true;
            }
            trigger.setEach(each);
            try {
                String[] events = row.getStringNvl("EVENT_MANIPULATION", new String[0]).split(",");
                String time = row.getString("ACTION_TIMING");
                trigger.setTime(Trigger.TIME.valueOf((String)time));
                for (String event : events) {
                    trigger.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)event)});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            trigger.setDefinition(row.getString("ACTION_STATEMENT"));
            triggers.put(name.toUpperCase(), trigger);
        }
        return triggers;
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        return super.buildCreateCommentRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        if (columns.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER ").append(table.getKeyword()).append(" ");
            this.name(builder, table);
            ArrayList<String> slices = new ArrayList<String>();
            for (Column column : columns) {
                String action = column.getAction();
                if ("add".equals(action)) {
                    slices.addAll(this.buildAddRunSQL(column, true));
                    continue;
                }
                if ("alter".equals(action)) {
                    slices.addAll(this.buildAlterRunSQL(column, true));
                    continue;
                }
                if (!"drop".equals(action)) continue;
                slices.add(this.buildDropRunSQL(column, true));
            }
            boolean first = true;
            for (String slice : slices) {
                if (!BasicUtil.isNotEmpty((Object)slice)) continue;
                builder.append("\n");
                if (!first) {
                    builder.append(",");
                }
                builder.append(slice.trim());
                first = false;
            }
            sqls.add(builder.toString());
        }
        return sqls;
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("RENAME TABLE ");
        this.name(builder, table);
        builder.append(" TO ");
        this.name(builder, table.getUpdate());
        return builder.toString();
    }

    public String buildChangeCommentRunSQL(Table table) {
        String comment = table.getComment();
        if (BasicUtil.isEmpty((Object)comment)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" COMMENT '").append(comment).append("'");
        return builder.toString();
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return super.checkTableExists(builder, exists);
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (BasicUtil.isNotEmpty((Object)order)) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return super.comment(builder, table);
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<String> buildCreateRunSQL(View view) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        view.setCreater((JDBCAdapter)this);
        builder.append("CREATE OR REPLACE VIEW ");
        this.name(builder, (Table)view);
        builder.append(" AS \n").append(view.getDefinition());
        list.add(builder.toString());
        list.add(this.buildCreateCommentRunSQL(view));
        return list;
    }

    public String buildCreateCommentRunSQL(View view) throws Exception {
        return super.buildCreateCommentRunSQL(view);
    }

    public List<String> buildAlterRunSQL(View view) throws Exception {
        return super.buildAlterRunSQL(view);
    }

    public String buildRenameRunSQL(View view) throws Exception {
        return super.buildRenameRunSQL(view);
    }

    public String buildChangeCommentRunSQL(View view) throws Exception {
        return super.buildChangeCommentRunSQL(view);
    }

    public String buildDropRunSQL(View view) throws Exception {
        return super.buildDropRunSQL(view);
    }

    public StringBuilder checkViewExists(StringBuilder builder, boolean exists) {
        return super.checkViewExists(builder, exists);
    }

    public StringBuilder comment(StringBuilder builder, View view) {
        return super.comment(builder, view);
    }

    public List<String> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return "ALTER COLUMN ";
    }

    public List<String> buildAddRunSQL(Column column, boolean slice) throws Exception {
        Column update;
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (!slice) {
            Table table = column.getTable();
            builder.append("ALTER TABLE ");
            this.name(builder, table);
        }
        if (null == (update = column.getUpdate())) {
            this.addColumnGuide(builder, column);
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            this.type(builder, column);
            this.charset(builder, column);
            this.defaultValue(builder, column);
            this.nullable(builder, column);
            this.onupdate(builder, column);
            this.comment(builder, column);
            this.position(builder, column);
        }
        sqls.add(builder.toString());
        sqls.add(this.buildCreateCommentRunSQL(column));
        return sqls;
    }

    public List<String> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        Column update;
        ArrayList<String> sqls = new ArrayList<String>();
        column.setCreater((JDBCAdapter)this);
        StringBuilder builder = new StringBuilder();
        if (!slice) {
            Table table = column.getTable();
            builder.append("ALTER TABLE ");
            this.name(builder, table);
        }
        if (null != (update = column.getUpdate())) {
            builder.append(" CHANGE ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            if (!BasicUtil.equalsIgnoreCase((Object)column.getName(), (Object)update.getTableName())) {
                SQLUtil.delimiter((StringBuilder)builder, (String)update.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            }
            this.define(builder, update);
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public String buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public String buildRenameRunSQL(Column column) throws Exception {
        return super.buildRenameRunSQL(column);
    }

    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        return super.buildChangeTypeRunSQL(column);
    }

    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        return super.buildChangeDefaultRunSQL(column);
    }

    public String buildChangeNullableRunSQL(Column column) throws Exception {
        return super.buildChangeNullableRunSQL(column);
    }

    public String buildChangeCommentRunSQL(Column column) throws Exception {
        return super.buildChangeCommentRunSQL(column);
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public boolean isIgnorePrecision(Column column) {
        return super.isIgnorePrecision(column);
    }

    public boolean isIgnoreScale(Column column) {
        return super.isIgnoreScale(column);
    }

    public Boolean checkIgnorePrecision(String datatype) {
        return super.checkIgnorePrecision(datatype);
    }

    public Boolean checkIgnoreScale(String datatype) {
        return super.checkIgnoreScale(datatype);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            builder.append(" AUTO_INCREMENT");
        }
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        if (column.isOnUpdate() == 1) {
            builder.append(" ON UPDATE CURRENT_TIMESTAMP");
        }
        return builder;
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        Integer position = column.getPosition();
        if (null != position && 0 == position) {
            builder.append(" FIRST");
        } else {
            String after = column.getAfter();
            if (BasicUtil.isNotEmpty((Object)after)) {
                builder.append(" AFTER ").append(after);
            }
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        String comment = column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT '").append(comment).append("'");
        }
        return builder;
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return null;
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return null;
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return null;
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable());
            builder.append(" ADD PRIMARY KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public List<String> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public String buildDropRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable());
        builder.append(" DROP PRIMARY KEY");
        return builder.toString();
    }

    public String buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public String buildAddRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAddRunSQL(foreign);
    }

    public List<String> buildAlterRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAlterRunSQL(foreign);
    }

    public String buildDropRunSQL(ForeignKey foreign) throws Exception {
        return super.buildDropRunSQL(foreign);
    }

    public String buildRenameRunSQL(ForeignKey foreign) throws Exception {
        return super.buildRenameRunSQL(foreign);
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ").append(index.getTableName());
        if (index.isPrimary()) {
            builder.append(" DROP PRIMARY KEY");
        } else {
            builder.append(" DROP INDEX ").append(index.getName());
        }
        return builder.toString();
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public void comment(StringBuilder builder, Index index) {
        String comment = index.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT '").append(comment).append("'");
        }
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "now()";
        }
        return null;
    }
}

