/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.mariadb;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.SQLAdapter;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.run.Run;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.DatabaseType;
import org.anyline.entity.metadata.ColumnType;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.mariadb")
public class MariaAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.mariadb:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.MariaDB;
    }

    public MariaAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatFun(args);
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM information_schema.TABLES WHERE 1=1 ");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(pattern)).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)types)) {
            String[] tmps = types.split(",");
            builder.append(" AND TABLE_TYPE IN(");
            int idx = 0;
            for (String tmp : tmps) {
                if (idx > 0) {
                    builder.append(",");
                }
                builder.append("'").append(tmp).append("'");
                ++idx;
            }
            builder.append(")");
        } else {
            builder.append(" AND TABLE_TYPE IN ('BASE TABLE','TABLE')");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public List<String> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Table table = new Table();
            table.setCatalog(row.getString("TABLE_CATALOG"));
            table.setSchema(row.getString("TABLE_SCHEMA"));
            table.setName(row.getString("TABLE_NAME"));
            table.setEngine(row.getString("ENGINE"));
            table.setComment(row.getString("TABLE_COMMENT"));
            tables.put(table.getName().toUpperCase(), table);
        }
        return tables;
    }

    public LinkedHashMap<String, Table> tables(boolean create, LinkedHashMap<String, Table> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(boolean create, LinkedHashMap<String, MasterTable> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags, name);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags);
    }

    public LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, PartitionTable> ptables(boolean create, LinkedHashMap<String, PartitionTable> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            builder.append("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE 1=1 ");
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
            }
            builder.append(" AND TABLE_NAME = '").append(this.objectName(this.objectName(table.getName()))).append("'");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Column column = new Column();
            column.setCatalog(row.getString("TABLE_CATALOG"));
            column.setSchema(row.getString("TABLE_SCHEMA"));
            column.setTable(row.getString("TABLE_NAME"));
            column.setName(row.getString("COLUMN_NAME"));
            column.setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0)));
            column.setComment(row.getString("COLUMN_COMMENT"));
            column.setTypeName(row.getString("DATA_TYPE"));
            column.setDefaultValue(row.get("COLUMN_DEFAULT"));
            column.setNullable(row.getBoolean("IS_NULLABLE", null));
            int len = row.getInt("CHARACTER_MAXIMUM_LENGTH", Integer.valueOf(-1));
            if (len == -1) {
                len = row.getInt("NUMERIC_PRECISION", Integer.valueOf(0));
            }
            column.setPrecision(Integer.valueOf(len));
            column.setScale(row.getInt("NUMERIC_SCALE", Integer.valueOf(0)));
            column.setCharset(row.getString("CHARACTER_SET_NAME"));
            column.setCollate(row.getString("COLLATION_NAME"));
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
            columns.put(column.getName().toUpperCase(), column);
        }
        return columns;
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return null;
    }

    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        return null;
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        return null;
    }

    public LinkedHashMap<String, Tag> tags(boolean create, LinkedHashMap<String, Tag> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return null;
    }

    public List<String> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, LinkedHashMap<String, Index> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Constraint> constraints(int index, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        return super.buildCreateCommentRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("RENAME TABLE ");
        this.name(builder, table);
        builder.append(" TO ");
        this.name(builder, table.getUpdate());
        return builder.toString();
    }

    public String buildChangeCommentRunSQL(Table table) {
        String comment = table.getComment();
        if (BasicUtil.isEmpty((Object)comment)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" COMMENT '").append(comment).append("'");
        return builder.toString();
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return super.checkTableExists(builder, exists);
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            int idx = 0;
            for (Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (BasicUtil.isNotEmpty((Object)order)) {
                    builder.append(" ").append(order);
                }
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return super.comment(builder, table);
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<String> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return "ALTER COLUMN";
    }

    public List<String> buildAddRunSQL(Column column, boolean slice) throws Exception {
        Column update;
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (!slice) {
            Table table = column.getTable();
            builder.append("ALTER TABLE ");
            this.name(builder, table);
        }
        if (null == (update = column.getUpdate())) {
            this.addColumnGuide(builder, column);
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            this.type(builder, column);
            this.charset(builder, column);
            this.defaultValue(builder, column);
            this.nullable(builder, column);
            this.onupdate(builder, column);
            this.comment(builder, column);
            this.position(builder, column);
        }
        sqls.add(builder.toString());
        sqls.add(this.buildCreateCommentRunSQL(column));
        return sqls;
    }

    public List<String> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        Column update;
        ArrayList<String> sqls = new ArrayList<String>();
        column.setCreater((JDBCAdapter)this);
        StringBuilder builder = new StringBuilder();
        if (!slice) {
            Table table = column.getTable();
            builder.append("ALTER TABLE ");
            this.name(builder, table);
        }
        if (null != (update = column.getUpdate())) {
            builder.append(" CHANGE ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            if (!BasicUtil.equalsIgnoreCase((Object)column.getName(), (Object)update.getTableName())) {
                SQLUtil.delimiter((StringBuilder)builder, (String)update.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            }
            this.define(builder, update);
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public String buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public String buildRenameRunSQL(Column column) throws Exception {
        return super.buildRenameRunSQL(column);
    }

    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        return super.buildChangeTypeRunSQL(column);
    }

    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        return super.buildChangeDefaultRunSQL(column);
    }

    public String buildChangeNullableRunSQL(Column column) throws Exception {
        return super.buildChangeNullableRunSQL(column);
    }

    public String buildCreateCommentRunSQL(Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public String buildChangeCommentRunSQL(Column column) throws Exception {
        return super.buildChangeCommentRunSQL(column);
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            builder.append(" AUTO_INCREMENT");
        }
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        if (column.isOnUpdate() == 1) {
            builder.append(" ON UPDATE CURRENT_TIMESTAMP");
        }
        return builder;
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        Integer position = column.getPosition();
        if (null != position && 0 == position) {
            builder.append(" FIRST");
        } else {
            String after = column.getAfter();
            if (BasicUtil.isNotEmpty((Object)after)) {
                builder.append(" AFTER ").append(after);
            }
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        String comment = column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT '").append(comment).append("'");
        }
        return builder;
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return null;
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return null;
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return null;
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return null;
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable());
            builder.append(" ADD PRIMARY KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public List<String> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public String buildDropRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable());
        builder.append(" DROP PRIMARY KEY");
        return builder.toString();
    }

    public String buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        return super.buildDropRunSQL(index);
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "now()";
        }
        return null;
    }
}

