/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.kingbase;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.SQLAdapter;
import org.anyline.data.jdbc.kingbase.KingbaseColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.kingbase")
public class KingbaseOracleAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    public static boolean IS_GET_SEQUENCE_VALUE_BEFORE_INSERT = false;
    @Value(value="${anyline.data.jdbc.delimiter.kingbase:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.KingBase;
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public KingbaseOracleAdapter() {
        this.delimiterFr = "";
        this.delimiterTo = "";
        for (KingbaseColumnTypeAlias alias : KingbaseColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public String parseFinalQuery(Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumns();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        int first = 0;
        int last = 0;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append("SELECT " + cols + " FROM( \n");
            builder.append("SELECT TAB_I.* ,ROWNUM AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append("\n").append(order);
            builder.append(")  TAB_I \n");
            builder.append(")  TAB_O WHERE PAGE_ROW_NUMBER_ >= " + (first + 1) + " AND PAGE_ROW_NUMBER_ <= " + (last + 1));
        }
        return builder.toString();
    }

    public String concat(String ... args) {
        return this.concatOr(args);
    }

    public String parseExists(Run run) {
        String sql = "SELECT 1 AS IS_EXISTS FROM DUAL WHERE  EXISTS(" + run.getBuilder().toString() + ")";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    protected void createPrimaryValue(JdbcTemplate template, Collection list, String seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ").append(seq).append(" AS ID FROM(\n");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            builder.append("SELECT NULL FROM DUAL\n");
            if (i >= size - 1) continue;
            builder.append("UNION ALL\n");
        }
        builder.append(") M");
        List ids = template.queryForList(builder.toString());
        int i = 0;
        for (Object obj : list) {
            Object value = ((Map)ids.get(i++)).get("ID");
            this.setPrimaryValue(obj, value);
        }
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, DataSet set, List<String> keys) {
        String key;
        int i;
        if (null == set || set.size() == 0) {
            return;
        }
        StringBuilder builder = run.getBuilder();
        DataRow first = set.getRow(0);
        HashMap<String, String> seqs = new HashMap<String, String>();
        for (String key2 : keys) {
            String str;
            String value = first.getStringNvl(key2, new String[0]);
            if (null == value || !(value instanceof String) || !(str = value).toUpperCase().contains(".NEXTVAL")) continue;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            }
            if (IS_GET_SEQUENCE_VALUE_BEFORE_INSERT) {
                this.createPrimaryValue(template, (Collection)set, str);
                continue;
            }
            seqs.put(key2, str);
        }
        List pks = null;
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        if (null != generator) {
            pks = first.getPrimaryKeys();
            BeanUtil.join((boolean)true, keys, (Collection)pks);
        }
        builder.append("INSERT INTO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)dest, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" (");
        int keySize = keys.size();
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            builder.append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append(") \n");
        builder.append("SELECT ");
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            String seq = (String)seqs.get(key);
            if (null != seq) {
                builder.append(seq);
            } else {
                builder.append("M.").append(key);
            }
            builder.append(" AS ").append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append("\nFROM( ");
        keys.removeAll(seqs.keySet());
        int col = 0;
        for (DataRow row : set) {
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            if (col > 0) {
                builder.append("\n\tUNION ALL");
            }
            builder.append("\n\tSELECT ");
            this.insertValue(template, run, row, true, true, false, keys);
            builder.append(" FROM DUAL ");
            ++col;
        }
        builder.append(") M ");
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, Collection list, List<String> keys) {
        String key;
        int i;
        if (null == list || list.isEmpty()) {
            return;
        }
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.createInserts(template, run, dest, set, keys);
            return;
        }
        Object first = list.iterator().next();
        HashMap<String, String> seqs = new HashMap<String, String>();
        for (String key2 : keys) {
            String str;
            Object value = BeanUtil.getFieldValue(first, (String)key2);
            if (null == value || !(value instanceof String) || !(str = (String)value).toUpperCase().contains(".NEXTVAL")) continue;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            }
            if (IS_GET_SEQUENCE_VALUE_BEFORE_INSERT) {
                this.createPrimaryValue(template, list, str);
                continue;
            }
            seqs.put(key2, str);
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        List pks = null;
        if (null != generator) {
            pks = EntityAdapterProxy.primaryKeys(first.getClass(), (boolean)true);
            BeanUtil.join((boolean)true, keys, (Collection)pks);
        }
        builder.append("INSERT INTO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)dest, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" (");
        int keySize = keys.size();
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            builder.append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append(") \n");
        builder.append("SELECT ");
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            String seq = (String)seqs.get(key);
            if (null != seq) {
                builder.append(seq);
            } else {
                builder.append("M.").append(key);
            }
            builder.append(" AS ").append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append("\nFROM( ");
        keys.removeAll(seqs.keySet());
        int col = 0;
        for (Object obj : list) {
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, keys);
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            if (col > 0) {
                builder.append("\n\tUNION ALL");
            }
            builder.append("\n\tSELECT ");
            this.insertValue(template, run, obj, true, true, false, keys);
            builder.append(" FROM DUAL ");
            ++col;
        }
        builder.append(") M ");
    }

    public int insert(JdbcTemplate template, String random, Object data, String sql, List<Object> values, String[] pks) throws Exception {
        int cnt = 0;
        if (data instanceof Collection) {
            if (null == values || values.isEmpty()) {
                cnt = template.update(sql);
            } else {
                int size = values.size();
                Object[] params = new Object[size];
                for (int i = 0; i < size; ++i) {
                    params[i] = values.get(i);
                }
                cnt = template.update(sql, params);
            }
        } else {
            String pk = this.getPrimayKey(data);
            pks = null != pk ? new String[]{pk} : null;
            cnt = super.insert(template, random, data, sql, values, pks);
        }
        return cnt;
    }

    public boolean identity(String random, Object data, KeyHolder keyholder) {
        if (data instanceof Collection) {
            return false;
        }
        return super.identity(random, data, keyholder);
    }

    public List<Run> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append(" SELECT * FROM (");
        builder.append(" SELECT A.TABLE_NAME, B.COMMENTS, 'TABLE' TABLE_TYPE FROM USER_TABLES A, USER_TAB_COMMENTS B WHERE A.TABLE_NAME = B.TABLE_NAME");
        builder.append(" UNION ALL ");
        builder.append(" SELECT A.VIEW_NAME,  B.COMMENTS, 'VIEW'  TABLE_TYPE FROM USER_VIEWS  A, USER_TAB_COMMENTS B WHERE A.VIEW_NAME = B.TABLE_NAME");
        builder.append(" ) T WHERE 1=1");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(pattern)).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)types)) {
            String[] tmps = types.split(",");
            builder.append(" AND TABLE_TYPE IN(");
            int idx = 0;
            for (String tmp : tmps) {
                if (idx > 0) {
                    builder.append(",");
                }
                builder.append("'").append(tmp).append("'");
                ++idx;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM USER_TAB_COMMENTS\n");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append("WHERE TABLE_NAME = '").append(this.objectName(pattern)).append("'");
        }
        return runs;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            Table table = (Table)tables.get(name.toUpperCase());
            if (null == table) {
                table = new Table();
            }
            table.setCatalog(catalog);
            table.setSchema(schema);
            table.setName(name);
            table.setComment(row.getString("COMMENTS"));
            tables.put(name.toUpperCase(), table);
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryViewRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT A.VIEW_NAME,A.TEXT DEFINITION_SQL,  B.COMMENTS, 'VIEW'  TABLE_TYPE FROM USER_VIEWS  A, USER_TAB_COMMENTS B WHERE A.VIEW_NAME = B.TABLE_NAME");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(pattern)).append("'");
        }
        return runs;
    }

    public <T extends View> LinkedHashMap<String, T> views(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("VIEW_NAME");
            View view = (View)views.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            view.setCatalog(catalog);
            view.setSchema(schema);
            view.setName(name);
            view.setComment(row.getString("COMMENTS"));
            view.setDefinition(row.getString("DEFINITION_SQL"));
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    public List<Run> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags, name);
    }

    public List<Run> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean create, LinkedHashMap<String, T> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT M.*, F.COMMENTS AS COLUMN_COMMENT FROM USER_TAB_COLUMNS    M \n");
            builder.append("LEFT JOIN USER_COL_COMMENTS F ON M.TABLE_NAME = F.TABLE_NAME AND M.COLUMN_NAME = F.COLUMN_NAME\n");
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append("WHERE M.TABLE_NAME = '").append(this.objectName(table.getName())).append("'");
            }
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        return super.columns(index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<Run> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(boolean create, LinkedHashMap<String, T> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.tags(create, tags, dbmd, table, pattern);
    }

    public List<Run> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(boolean create, LinkedHashMap<String, T> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRunSQL(Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggerRunSQL(table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(index, create, table, triggers, set);
    }

    public List<Run> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAddCommentRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (BasicUtil.isEmpty((Object)table.getComment())) {
            return runs;
        }
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append(" COMMENT ON TABLE ");
        this.name(builder, table);
        builder.append("  IS '").append(table.getComment()).append("'");
        return runs;
    }

    public List<Run> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public List<Run> buildRenameRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" RENAME TO ");
        Table update = new Table(table.getUpdate().getName());
        this.name(builder, update);
        return runs;
    }

    public List<Run> buildChangeCommentRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("COMMENT ON TABLE ");
            this.name(builder, table);
            builder.append(" IS '").append(comment).append("'");
            runs.add((Run)run);
        }
        return runs;
    }

    public List<Run> buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return builder;
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<Run> buildCreateRunSQL(View view) throws Exception {
        return super.buildCreateRunSQL(view);
    }

    public List<Run> buildAddCommentRunSQL(View view) throws Exception {
        return super.buildAddCommentRunSQL(view);
    }

    public List<Run> buildAlterRunSQL(View view) throws Exception {
        return super.buildAlterRunSQL(view);
    }

    public List<Run> buildRenameRunSQL(View view) throws Exception {
        return super.buildRenameRunSQL(view);
    }

    public List<Run> buildChangeCommentRunSQL(View view) throws Exception {
        return super.buildChangeCommentRunSQL(view);
    }

    public List<Run> buildDropRunSQL(View view) throws Exception {
        return super.buildDropRunSQL(view);
    }

    public StringBuilder checkViewExists(StringBuilder builder, boolean exists) {
        return super.checkViewExists(builder, exists);
    }

    public StringBuilder comment(StringBuilder builder, View view) {
        return super.comment(builder, view);
    }

    public List<Run> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public List<Run> buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public List<Run> buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<Run> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<Run> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<Run> buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public List<Run> buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public List<Run> buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return "ALTER";
    }

    public List<Run> buildAddRunSQL(Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(builder, table);
        }
        builder.append(" ADD ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, column);
        runs.addAll(this.buildAddCommentRunSQL(column));
        return runs;
    }

    public List<Run> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAlterRunSQL(column, slice);
    }

    public List<Run> buildAlterRunSQL(Column column) throws Exception {
        return this.buildAlterRunSQL(column, false);
    }

    public List<Run> buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public List<Run> buildRenameRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable(true));
        builder.append(" RENAME COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        column.setName(column.getUpdate().getName());
        return runs;
    }

    public List<Run> buildChangeTypeRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = column.getUpdate();
        String name = column.getName();
        String type = column.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        String uname = update.getName();
        String utype = update.getTypeName();
        if (uname.endsWith("_TMP_UPDATE_TYPE")) {
            runs.addAll(this.buildDropRunSQL(update));
        } else {
            if (utype != null && utype.contains("(")) {
                utype = utype.substring(0, utype.indexOf("("));
            }
            if (!type.equals(utype)) {
                String tmp_name = column.getName() + "_TMP_UPDATE_TYPE";
                update.setName(tmp_name);
                runs.addAll(this.buildRenameRunSQL(column));
                update.setName(uname);
                runs.addAll(this.buildAddRunSQL(update));
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                this.name(builder, column.getTable(true));
                builder.append(" SET ");
                SQLUtil.delimiter((StringBuilder)builder, (String)uname, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                builder.append(" = ");
                SQLUtil.delimiter((StringBuilder)builder, (String)tmp_name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                runs.add((Run)new SimpleRun(builder));
                column.setName(tmp_name);
                List drop = this.buildDropRunSQL(column);
                runs.addAll(drop);
                column.setName(name);
                update.setName(name);
                column.setNullable(update.isNullable());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                this.name(builder, column.getTable(true));
                builder.append(" MODIFY(");
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.type(builder, column.getUpdate());
                builder.append(")");
                runs.add((Run)new SimpleRun(builder));
            }
        }
        return runs;
    }

    public List<Run> buildChangeDefaultRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Object def = null;
        def = null != column.getUpdate() ? column.getUpdate().getDefaultValue() : column.getDefaultValue();
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable(true)).append(" MODIFY ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" DEFAULT ");
        if (null != def) {
            def = this.write(column, def, false);
            builder.append(def);
        } else {
            builder.append(" NULL");
        }
        return runs;
    }

    public List<Run> buildChangeNullableRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        int nullable = column.isNullable();
        int uNullable = column.getUpdate().isNullable();
        if (nullable != -1 && uNullable != -1) {
            if (nullable == uNullable) {
                return runs;
            }
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("ALTER TABLE ");
            this.name(builder, column.getTable(true)).append(" MODIFY ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" NOT ");
            }
            builder.append(" NULL");
            column.setNullable(uNullable);
        }
        return runs;
    }

    public List<Run> buildAddCommentRunSQL(Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public List<Run> buildChangeCommentRunSQL(Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = null;
        comment = null != column.getUpdate() ? column.getUpdate().getComment() : column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(builder, column.getTable(true)).append(".");
            Column update = column.getUpdate();
            String name = null;
            name = null != update ? update.getName() : column.getName();
            SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    public List<Run> buildDropAutoIncrement(Column column) throws Exception {
        return super.buildDropAutoIncrement(column);
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        return super.increment(builder, column);
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        return super.comment(builder, column);
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<Run> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public List<Run> buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public List<Run> buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public List<Run> buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public List<Run> buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public List<Run> buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<Run> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public List<Run> buildAddRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable(true));
            builder.append(" ADD CONSTRAINT ").append(primary.getTableName(true)).append("_PK").append(" PRIMARY KEY(");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public List<Run> buildDropRunSQL(PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable(true));
        builder.append(" DROP PRIMARY KEY");
        return runs;
    }

    public List<Run> buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public List<Run> buildAddRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAddRunSQL(foreign);
    }

    public List<Run> buildAlterRunSQL(ForeignKey foreign) throws Exception {
        return super.buildAlterRunSQL(foreign);
    }

    public List<Run> buildDropRunSQL(ForeignKey foreign) throws Exception {
        return super.buildDropRunSQL(foreign);
    }

    public List<Run> buildRenameRunSQL(ForeignKey foreign) throws Exception {
        return super.buildRenameRunSQL(foreign);
    }

    public List<Run> buildQueryPrimaryRunSQL(Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT COL.* FROM USER_CONSTRAINTS CON ,USER_CONS_COLUMNS COL\n");
        builder.append("WHERE CON.CONSTRAINT_NAME = COL.CONSTRAINT_NAME\n");
        builder.append("AND CON.CONSTRAINT_TYPE = 'P'\n");
        builder.append("AND COL.TABLE_NAME = '").append(this.objectName(table.getName())).append("'\n");
        if (BasicUtil.isNotEmpty((Object)table.getSchema())) {
            builder.append(" AND COL.OWNER = '").append(table.getSchema()).append("'");
        }
        return runs;
    }

    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = table.getPrimaryKey();
        for (DataRow row : set) {
            String col;
            Column column;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString("CONSTRAINT_NAME"));
                primary.setTable(table);
            }
            if (null == (column = primary.getColumn(col = row.getString("COLUMN_NAME")))) {
                column = new Column(col);
            }
            column.setTable(table);
            column.setPosition(row.getInt("POSITION", Integer.valueOf(0)));
            primary.addColumn(column);
        }
        return primary;
    }

    public List<Run> buildQueryForeignsRunSQL(Table table) throws Exception {
        return super.buildQueryForeignsRunSQL(table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        return super.foreigns(index, table, foreigns, set);
    }

    public List<Run> buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<Run> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public List<Run> buildDropRunSQL(Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = index.getTable(true);
        if (index.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(builder, table);
            builder.append(" DROP CONSTRAINT ").append(index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
        }
        return runs;
    }

    public List<Run> buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public void comment(StringBuilder builder, Index index) {
        super.comment(builder, index);
    }

    public List<Run> buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<Run> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public List<Run> buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public List<Run> buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "sysdate";
        }
        return null;
    }
}

