/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.iotdb;

import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.MySQLGenusAdapter;
import org.anyline.data.jdbc.iotdb.IoTDBColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Table;
import org.anyline.metadata.type.DatabaseType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.iotdb")
public class IoTDBAdapter
extends MySQLGenusAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.iotdb:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.IoTDB;
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public IoTDBAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
        for (IoTDBColumnTypeAlias alias : IoTDBColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String keyword(Table table) {
        return "timeseries";
    }
}

