/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.informix;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.SQLAdapter;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.jdbc.informix.InformixColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.run.TextRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.DatabaseType;
import org.anyline.entity.metadata.ColumnType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.informix")
public class InformixAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    public static Map<Integer, String> column_types = new HashMap<Integer, String>();
    public static boolean IS_GET_SEQUENCE_VALUE_BEFORE_INSERT = false;
    @Value(value="${anyline.data.jdbc.delimiter.informix:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.Informix;
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public InformixAdapter() {
        this.delimiterFr = "\"";
        this.delimiterTo = "\"";
        for (InformixColumnTypeAlias alias : InformixColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            String sub = sql.substring(sql.toUpperCase().indexOf("SELECT") + 6);
            sql = "SELECT SKIP " + navi.getFirstRow() + " FIRST " + limit + sub;
        }
        return sql;
    }

    public String concat(String ... args) {
        return this.concatFun(args);
    }

    public String buildQuerySequence(boolean next, String ... names) {
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        StringBuilder builder = new StringBuilder();
        TextRun run = null;
        if (null != names && names.length > 0) {
            run = new TextRun();
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(name).append(".").append(key).append(" AS ").append(name);
            }
            builder.append(" FROM DUAL");
        }
        return builder.toString();
    }

    public String parseExists(Run run) {
        String sql = "SELECT 1 AS IS_EXISTS FROM DUAL WHERE  EXISTS(" + run.getBuilder().toString() + ")";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    protected void createPrimaryValue(JdbcTemplate template, Collection list, String seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ").append(seq).append(" AS ID FROM(\n");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            builder.append("SELECT NULL FROM DUAL\n");
            if (i >= size - 1) continue;
            builder.append("UNION ALL\n");
        }
        builder.append(") M");
        List ids = template.queryForList(builder.toString());
        int i = 0;
        for (Object obj : list) {
            Object value = ((Map)ids.get(i++)).get("ID");
            this.setPrimaryValue(obj, value);
        }
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, DataSet set, List<String> keys) {
        if (null == set || set.size() == 0) {
            return;
        }
        StringBuilder builder = run.getBuilder();
        DataRow first = set.getRow(0);
        HashMap<String, String> seqs = new HashMap<String, String>();
        for (String key : keys) {
            String str;
            String value = first.getStringNvl(key, new String[0]);
            if (null == value || !(value instanceof String) || !(str = value).toUpperCase().contains(".NEXTVAL")) continue;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            }
            if (IS_GET_SEQUENCE_VALUE_BEFORE_INSERT) {
                this.createPrimaryValue(template, (Collection)set, str);
                continue;
            }
            seqs.put(key, str);
        }
        for (DataRow row : set) {
            builder.append("INSERT INTO ");
            SQLUtil.delimiter((StringBuilder)builder, (String)dest, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" (");
            boolean start = true;
            for (String key : keys) {
                if (!start) {
                    builder.append(",");
                }
                builder.append(key);
                start = false;
            }
            builder.append(")");
            this.insertValue(template, run, row, false, false, true, keys);
            builder.append(";");
        }
    }

    public void createInserts(JdbcTemplate template, Run run, String dest, Collection list, List<String> keys) {
        String key;
        int i;
        if (null == list || list.isEmpty()) {
            return;
        }
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.createInserts(template, run, dest, set, keys);
            return;
        }
        Object first = list.iterator().next();
        HashMap<String, String> seqs = new HashMap<String, String>();
        for (String key2 : keys) {
            String str;
            Object value = BeanUtil.getFieldValue(first, (String)key2);
            if (null == value || !(value instanceof String) || !(str = (String)value).toUpperCase().contains(".NEXTVAL")) continue;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            }
            if (IS_GET_SEQUENCE_VALUE_BEFORE_INSERT) {
                this.createPrimaryValue(template, list, str);
                continue;
            }
            seqs.put(key2, str);
        }
        builder.append("INSERT INTO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)dest, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" (");
        int keySize = keys.size();
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            builder.append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append(") \n");
        builder.append("SELECT ");
        for (i = 0; i < keySize; ++i) {
            key = keys.get(i);
            String seq = (String)seqs.get(key);
            if (null != seq) {
                builder.append(seq);
            } else {
                builder.append("M.").append(key);
            }
            builder.append(" AS ").append(key);
            if (i >= keySize - 1) continue;
            builder.append(", ");
        }
        builder.append("\nFROM( ");
        keys.removeAll(seqs.keySet());
        int col = 0;
        for (Object obj : list) {
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                if (row.hasPrimaryKeys() && null != this.primaryGenerator && BasicUtil.isEmpty((Object)row.getPrimaryValue())) {
                    String pk = row.getPrimaryKey();
                    if (null == pk) {
                        pk = ConfigTable.DEFAULT_PRIMARY_KEY;
                    }
                    this.createPrimaryValue(row, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
                }
            } else if (EntityAdapterProxy.hasAdapter()) {
                EntityAdapterProxy.createPrimaryValue(obj);
            } else if (null != this.primaryGenerator) {
                this.createPrimaryValue(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), null, null);
            }
            if (col > 0) {
                builder.append("\n\tUNION ALL");
            }
            builder.append("\n\tSELECT ");
            this.insertValue(template, run, obj, true, true, false, keys);
            builder.append(" FROM DUAL ");
            ++col;
        }
        builder.append(") M ");
    }

    public int insert(JdbcTemplate template, String random, Object data, String sql, List<Object> values, String[] pks) throws Exception {
        int cnt = 0;
        if (data instanceof Collection) {
            if (null == values || values.isEmpty()) {
                cnt = template.update(sql);
            } else {
                int size = values.size();
                Object[] params = new Object[size];
                for (int i = 0; i < size; ++i) {
                    params[i] = values.get(i);
                }
                cnt = template.update(sql, params);
            }
        } else {
            pks = new String[]{this.getPrimayKey(data)};
            cnt = super.insert(template, random, data, sql, values, pks);
        }
        return cnt;
    }

    public boolean identity(String random, Object data, KeyHolder keyholder) {
        if (data instanceof Collection) {
            return false;
        }
        return super.identity(random, data, keyholder);
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM SYSTABLES  WHERE TABID > 99 AND TABTYPE = 'T'");
        sqls.add(builder.toString());
        return sqls;
    }

    public List<String> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return null;
    }

    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TABNAME");
            Table table = (Table)tables.get(name.toUpperCase());
            if (null == table) {
                table = new Table();
            }
            table.setCatalog(catalog);
            table.setSchema(schema);
            table.setName(name);
            tables.put(name.toUpperCase(), table);
        }
        return tables;
    }

    public LinkedHashMap<String, Table> tables(boolean create, LinkedHashMap<String, Table> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(boolean create, LinkedHashMap<String, MasterTable> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable table, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(table, tags);
    }

    public LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, PartitionTable> ptables(boolean create, LinkedHashMap<String, PartitionTable> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            builder.append("SELECT M.*,F.TABNAME FROM SYSCOLUMNS AS M LEFT JOIN SYSTABLES AS F ON M.TABID = F.TABID\n");
            builder.append("WHERE 1 = 1\n");
            if (BasicUtil.isNotEmpty((Object)catalog)) {
                // empty if block
            }
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND F.OWNER = '").append(schema).append("'");
            }
            builder.append(" AND F.TABNAME = '").append(table.getName()).append("'");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("COLNAME");
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) {
                column = new Column();
            }
            column.setTable(table);
            column.setTableName((String)BasicUtil.evl((Object[])new String[]{row.getString("TABNAME"), table.getName(), column.getTableName()}));
            column.setName(name);
            Integer coltype = row.getInt("COLTYPE", null);
            if (null != coltype) {
                if (coltype >= 256) {
                    coltype = coltype - 256;
                    column.setNullable(Boolean.valueOf(false));
                }
                String typeName = column_types.get(coltype);
                column.setTypeName(typeName);
            }
            int len = row.getInt("COLLENGTH", Integer.valueOf(0));
            column.setPrecision(Integer.valueOf(len));
            if (coltype == 8 || coltype == 5) {
                int scale = len % 256;
                column.setPrecision(Integer.valueOf(len /= 256), Integer.valueOf(scale));
            }
            if (null == column.getColumnType()) {
                ColumnType columnType = this.type(column.getTypeName());
                column.setColumnType(columnType);
            }
            columns.put(name.toUpperCase(), column);
        }
        return columns;
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, LinkedHashMap<String, Tag> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.tags(create, tags, dbmd, table, pattern);
    }

    public List<String> buildQueryPrimaryRunSQL(Table table) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT T.TABNAME AS TABLE_NAME, C.CONSTRNAME AS CONSTRAINT_NAME, C.CONSTRTYPE AS CONSTRAINT_TYPE, K.COLNAME AS COLUMN_NAME\n");
        builder.append("FROM SYSTABLES T\n");
        builder.append("JOIN SYSCONSTRAINTS C ON T.TABID = C.TABID\n");
        builder.append("JOIN SYSINDEXES I ON C.IDXNAME = I.IDXNAME AND C.TABID = I.TABID\n");
        builder.append("JOIN SYSCOLUMNS K ON T.TABID = K.TABID AND I.PART1 = K.COLNO\n");
        builder.append("WHERE  C.CONSTRTYPE = 'P'\n");
        builder.append("AND T.TABNAME = '").append(table.getName()).append("'\n");
        String schema = table.getSchema();
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND T.OWNER = '").append(schema).append("'");
        }
        list.add(builder.toString());
        return list;
    }

    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = table.getPrimaryKey();
        for (DataRow row : set) {
            String col;
            Column column;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString("CONSTRAINT_NAME"));
                primary.setTable(table);
            }
            if (null == (column = primary.getColumn(col = row.getString("COLUMN_NAME")))) {
                column = new Column(col);
            }
            column.setTable(table);
            primary.addColumn(column);
        }
        return primary;
    }

    public List<String> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, LinkedHashMap<String, Index> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Constraint> constraints(int index, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" RENAME TO ");
        Table update = new Table(table.getUpdate().getName());
        this.name(builder, update);
        return builder.toString();
    }

    public String buildChangeCommentRunSQL(Table table) throws Exception {
        return null;
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        return this.buildChangeCommentRunSQL(table);
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return builder;
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            int idx = 0;
            for (Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        String name = table.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(":");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder;
    }

    public List<String> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return null;
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return null;
    }

    public String alterColumnKeyword() {
        return super.alterColumnKeyword();
    }

    public List<String> buildAddRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAddRunSQL(column, slice);
    }

    public List<String> buildAddRunSQL(Column column) throws Exception {
        return this.buildAddRunSQL(column, false);
    }

    public List<String> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAlterRunSQL(column, slice);
    }

    public List<String> buildAlterRunSQL(Column column) throws Exception {
        return this.buildAlterRunSQL(column, false);
    }

    public String buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public String buildRenameRunSQL(Column column) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable());
        builder.append(" RENAME ").append(column.getName()).append(" TO ").append(column.getNewName());
        return builder.toString();
    }

    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        Column update = column.getUpdate();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable());
        builder.append(" ALTER COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TYPE ");
        this.type(builder, update);
        String type = update.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        builder.append(" USING ").append(column.getName()).append("::").append(type);
        sqls.add(builder.toString());
        return sqls;
    }

    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        Object def = null;
        def = null != column.getUpdate() ? column.getUpdate().getDefaultValue() : column.getDefaultValue();
        if (null != def) {
            String str = def.toString();
            if (str.contains("::")) {
                str = str.split("::")[0];
            }
            str = str.replace("'", "");
            def = str;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable()).append(" ALTER COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        if (null != def) {
            builder.append(" SET DEFAULT '").append(def).append("'");
        } else {
            builder.append(" DROP DEFAULT");
        }
        return builder.toString();
    }

    public String buildChangeNullableRunSQL(Column column) throws Exception {
        int nullable = column.isNullable();
        int uNullable = column.getUpdate().isNullable();
        if (nullable != -1 && uNullable != -1) {
            if (nullable == uNullable) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            this.name(builder, column.getTable()).append(" ALTER ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" SET ");
            } else {
                builder.append(" DROP ");
            }
            builder.append(" NOT NULL");
            return builder.toString();
        }
        return null;
    }

    public String buildCreateCommentRunSQL(Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public String buildChangeCommentRunSQL(Column column) throws Exception {
        return null;
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            String type = column.getTypeName().toLowerCase();
            if ("int4".equals(type) || "int".equals(type) || "integer".equals(type)) {
                column.setType("SERIAL");
            } else if ("int8".equals(type) || "long".equals(type) || "bigint".equals(type)) {
                column.setType("SERIAL8");
            } else if ("int2".equals(type) || "smallint".equals(type) || "short".equals(type)) {
                column.setType("SERIAL");
            } else {
                column.setType("SERIAL8");
            }
        }
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column, String type, boolean isIgnorePrecision, boolean isIgnoreScale) {
        String dateScale;
        if (null == builder) {
            builder = new StringBuilder();
        }
        if ("datetime".equalsIgnoreCase(type)) {
            dateScale = column.getDateScale();
            if (null == dateScale) {
                dateScale = "FRACTION";
            }
        } else {
            return super.type(builder, column, type, isIgnorePrecision, isIgnoreScale);
        }
        builder.append(type).append(" YEAR TO ").append(dateScale);
        return builder;
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return null;
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable());
            builder.append(" ADD PRIMARY KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public List<String> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public String buildDropRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable());
        builder.append(" DROP CONSTRAINT ");
        SQLUtil.delimiter((StringBuilder)builder, (String)primary.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    public String buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (index.isPrimary()) {
            log.warn("[\u4e3b\u952e\u7d22\u5f15,\u5ffd\u7565\u5220\u9664][index:{}]", (Object)index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
        }
        return builder.toString();
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            String type = column.getTypeName();
            if ("datetime".equalsIgnoreCase(type)) {
                String scale = column.getDateScale();
                if (null == scale) {
                    scale = "date".equalsIgnoreCase(type) ? "DAY" : "FRACTION";
                }
                return "CURRENT YEAR TO " + scale;
            }
            if ("date".equalsIgnoreCase(type)) {
                return "TODAY";
            }
        }
        return null;
    }

    static {
        column_types.put(0, "CHAR");
        column_types.put(1, "SMALLINT");
        column_types.put(2, "INTEGER");
        column_types.put(3, "FLOAT");
        column_types.put(4, "SMALLFLOAT");
        column_types.put(5, "DECIMAL");
        column_types.put(6, "SERIAL");
        column_types.put(7, "DATE");
        column_types.put(8, "MONEY");
        column_types.put(9, "NULL");
        column_types.put(10, "DATETIME");
        column_types.put(11, "BYTE");
        column_types.put(12, "TEXT");
        column_types.put(13, "VARCHAR");
        column_types.put(14, "INTERVAL");
        column_types.put(15, "NCHAR");
        column_types.put(16, "NVARCHAR");
        column_types.put(17, "INT8");
        column_types.put(18, "SERIAL8");
        column_types.put(19, "SET");
        column_types.put(20, "MULTISET");
        column_types.put(21, "LIST");
        column_types.put(22, "ROW");
        column_types.put(23, "COLLECTION");
        column_types.put(24, "UDT");
        column_types.put(40, "LVARCHAR");
        column_types.put(41, "BLOB");
        column_types.put(42, "CLOB");
        column_types.put(43, "BOOLEAN");
    }
}

