/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.influxdb;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.AbstractJDBCAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.run.TableRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.influxdb")
public class InfluxAdapter
extends AbstractJDBCAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.influxdb:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.InfluxDB;
    }

    public InfluxAdapter() {
        this.delimiterFr = "\"";
        this.delimiterTo = "\"";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.pageLimitOffset(runtime, run);
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatOr(runtime, args);
    }

    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        TableRun run = null;
        if (null != obj) {
            StringBuilder builder = new StringBuilder();
            run = new TableRun(runtime, dest);
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                LinkedHashMap cols = this.confirmInsertColumns(runtime, dest, obj, configs, columns, false);
                builder.append("insert ");
                this.name(runtime, builder, (BaseMetadata)dest);
                builder.append(" ");
                Map tags = row.getTags();
                for (String tag : tags.keySet()) {
                    builder.append(",").append(tag).append("=").append(tags.get(tag));
                }
                int qty = 0;
                for (Column column : cols.values()) {
                    String col = column.getName();
                    Object value = row.get(col);
                    if (null == value) continue;
                    if (qty > 0) {
                        builder.append(",");
                    }
                    builder.append(col).append("=");
                    if (BasicUtil.isNumber((Object)value) || BasicUtil.isBoolean((Object)value)) {
                        builder.append(value);
                    } else {
                        builder.append("\"").append(value).append("\"");
                    }
                    ++qty;
                }
                builder.append(" ").append(row.getNanoTime());
                run.setBuilder(builder);
            }
        }
        return run;
    }
}

