/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.influxdb;

import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.init.SQLAdapter;
import org.anyline.data.run.Run;
import org.anyline.data.run.TableRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.DatabaseType;
import org.anyline.util.BasicUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.influxdb")
public class InfluxAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.influxdb:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.InfluxDB;
    }

    public InfluxAdapter() {
        this.delimiterFr = "\"";
        this.delimiterTo = "\"";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + limit + " OFFSET " + navi.getFirstRow();
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatOr(args);
    }

    public Run buildInsertRun(JdbcTemplate template, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        TableRun run = null;
        if (null != obj) {
            StringBuilder builder = new StringBuilder();
            run = new TableRun((JDBCAdapter)this, dest);
            if (obj instanceof DataRow) {
                DataRow row = (DataRow)obj;
                List cols = this.confirmInsertColumns(dest, obj, columns, false);
                builder.append("insert ").append(this.parseTable(dest)).append(" ");
                Map tags = row.getTags();
                for (String tag : tags.keySet()) {
                    builder.append(",").append(tag).append("=").append(tags.get(tag));
                }
                int qty = 0;
                for (String col : cols) {
                    Object value = row.get(col);
                    if (null == value) continue;
                    if (qty > 0) {
                        builder.append(",");
                    }
                    builder.append(col).append("=");
                    if (BasicUtil.isNumber((Object)value) || BasicUtil.isBoolean((Object)value)) {
                        builder.append(value);
                    } else {
                        builder.append("\"").append(value).append("\"");
                    }
                    ++qty;
                }
                builder.append(" ").append(row.getNanoTime());
                run.setBuilder(builder);
            }
        }
        return run;
    }
}

