/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.hive;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.SQLAdapter;
import org.anyline.data.jdbc.hive.HiveColumnTypeAlias;
import org.anyline.data.jdbc.hive.HiveReader;
import org.anyline.data.jdbc.hive.HiveWriter;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.hive")
public class HiveAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.hive:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.Hive;
    }

    public String generatedKey() {
        return "GENERATED_KEY";
    }

    public HiveAdapter() {
        this.delimiterFr = "`";
        this.delimiterTo = "`";
        for (HiveColumnTypeAlias hiveColumnTypeAlias : HiveColumnTypeAlias.values()) {
            this.types.put(hiveColumnTypeAlias.name(), hiveColumnTypeAlias.standard());
        }
        for (Enum enum_ : HiveWriter.values()) {
            this.reg(((HiveWriter)enum_).supports(), ((HiveWriter)enum_).writer());
        }
        for (Enum enum_ : HiveReader.values()) {
            this.reg(((HiveReader)enum_).supports(), ((HiveReader)enum_).reader());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatFun(args);
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (null != value) {
            if (value instanceof Collection) {
                Collection cols = (Collection)value;
                for (Object e : cols) {
                    values.add(e);
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object obj : array = (Object[])value) {
                    values.add(obj);
                }
            } else {
                values.add(value);
            }
        }
        if (values.size() > 1) {
            builder.append("(");
        }
        boolean first = true;
        for (Object e : values) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append("FIND_IN_SET(?,").append(column).append(")");
            first = false;
        }
        if (values.size() > 1) {
            builder.append(")");
        }
        return value;
    }

    public void checkSchema(DataRuntime runtime, Connection con, Table table) {
        try {
            if (null == table.getSchema()) {
                table.setSchema(con.getCatalog());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        table.setCheckSchemaTime(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchema(DataRuntime runtime, DataSource dataSource, Table table) {
        if (null == table || null != table.getCheckSchemaTime()) {
            return;
        }
        Connection con = null;
        try {
            if (null == table.getSchema()) {
                con = DataSourceUtils.getConnection((DataSource)dataSource);
                table.setSchema(con.getCatalog());
            }
            table.setCheckSchemaTime(new Date());
        }
        catch (Exception e) {
            log.warn("[check schema][fail:{}]", (Object)e.toString());
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)dataSource)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)dataSource);
            }
        }
    }

    public List<Run> buildQueryDatabaseRun(DataRuntime runtime) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW DATABASES");
        return runs;
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        if (null == databases) {
            databases = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Database database = new Database();
            database.setName(row.getString("DATABASE"));
            databases.put(database.getName().toUpperCase(), database);
        }
        return databases;
    }

    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM information_schema.TABLES WHERE 1=1 ");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(runtime, pattern)).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)types)) {
            String[] tmps = types.split(",");
            builder.append(" AND TABLE_TYPE IN(");
            int idx = 0;
            for (String tmp : tmps) {
                if (idx > 0) {
                    builder.append(",");
                }
                if (tmp.equalsIgnoreCase("table")) {
                    tmp = "BASE TABLE";
                }
                builder.append("'").append(tmp).append("'");
                ++idx;
            }
            builder.append(")");
        } else {
            builder.append(" AND TABLE_TYPE IN ('BASE TABLE','TABLE')");
        }
        return runs;
    }

    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        DataSource ds = null;
        Connection con = null;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
            if (null == tables) {
                tables = new LinkedHashMap();
            }
            Map keys = this.keys(set);
            while (set.next()) {
                String tableName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)tableName)) {
                    tableName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)tableName)) continue;
                Table table = (Table)tables.get(tableName.toUpperCase());
                if (null == table) {
                    if (!create) continue;
                    table = new Table();
                    tables.put(tableName.toUpperCase(), table);
                }
                table.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CATALOG", set), this.string(keys, "TABLE_CAT", set), catalog}));
                table.setCatalog(null);
                table.setName(tableName);
                table.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), table.getType()}));
                table.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), table.getComment()}));
                table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
                table.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), table.getTypeName()}));
                table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
                table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
                tables.put(tableName.toUpperCase(), table);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        DataSource ds = null;
        Connection con = null;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
            if (null == tables) {
                tables = new ArrayList<T>();
            }
            Map keys = this.keys(set);
            while (set.next()) {
                String tableName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)tableName)) {
                    tableName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)tableName)) continue;
                boolean contains = true;
                catalog = (String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CATALOG", set), this.string(keys, "TABLE_CAT", set), catalog});
                Table table = this.table(tables, catalog, schema, tableName);
                if (null == table) {
                    if (!create) continue;
                    table = new Table();
                    contains = false;
                }
                table.setSchema(catalog);
                table.setCatalog(null);
                table.setName(tableName);
                table.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), table.getType()}));
                table.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), table.getComment()}));
                table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
                table.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), table.getTypeName()}));
                table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
                table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
                if (contains) continue;
                tables.add(table);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return tables;
    }

    public List<Run> buildQueryDDLRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("show create table ");
        this.name(runtime, builder, table);
        return runs;
    }

    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        for (DataRow row : set) {
            ddls.add(row.getString("Create Table"));
        }
        return ddls;
    }

    public List<Run> buildQueryViewRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM information_schema.VIEWS WHERE 1=1 ");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(runtime, pattern)).append("'");
        }
        return runs;
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            View view = (View)views.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            view.setSchema(row.getString("TABLE_SCHEMA"));
            view.setName(name);
            view.setDefinition(row.getString("VIEW_DEFINITION"));
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, String catalog, String schema, String pattern, String ... types) throws Exception {
        DataSource ds = null;
        Connection con = null;
        try {
            JdbcTemplate jdbc = this.jdbc(runtime);
            ds = jdbc.getDataSource();
            con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseMetaData dbmd = con.getMetaData();
            ResultSet set = dbmd.getTables(catalog, schema, pattern, types);
            if (null == views) {
                views = new LinkedHashMap();
            }
            Map keys = this.keys(set);
            while (set.next()) {
                String viewName = this.string(keys, "TABLE_NAME", set);
                if (BasicUtil.isEmpty((Object)viewName)) {
                    viewName = this.string(keys, "NAME", set);
                }
                if (BasicUtil.isEmpty((Object)viewName)) continue;
                View view = (View)views.get(viewName.toUpperCase());
                if (null == view) {
                    if (!create) continue;
                    view = new View();
                    views.put(viewName.toUpperCase(), view);
                }
                view.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
                view.setCatalog(null);
                view.setName(viewName);
                view.setType((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_TYPE", set), view.getType()}));
                view.setComment((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REMARKS", set), view.getComment()}));
                view.setTypeCat((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_CAT", set), view.getTypeCat()}));
                view.setTypeName((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TYPE_NAME", set), view.getTypeName()}));
                view.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "SELF_REFERENCING_COL_NAME", set), view.getSelfReferencingColumn()}));
                view.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "REF_GENERATION", set), view.getRefGeneration()}));
                views.put(viewName.toUpperCase(), view);
            }
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)ds)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
        }
        return views;
    }

    public List<Run> buildQueryDDLRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("show create view ");
        this.name(runtime, builder, (Table)view);
        return runs;
    }

    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        for (DataRow row : set) {
            ddls.add(row.getString("Create View"));
        }
        return ddls;
    }

    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags, name);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String catalog = null;
        String schema = null;
        String name = null;
        if (null != table) {
            name = table.getName();
            catalog = table.getCatalog();
            schema = table.getSchema();
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE 1=1 ");
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND TABLE_SCHEMA = '").append(schema).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append(" AND TABLE_NAME = '").append(this.objectName(runtime, name)).append("'");
            }
            builder.append(" ORDER BY TABLE_NAME, ORDINAL_POSITION");
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        return super.columns(runtime, index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return new ArrayList<Run>();
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return new LinkedHashMap();
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return new LinkedHashMap();
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return new LinkedHashMap();
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SHOW INDEX FROM ");
        this.name(runtime, builder, table);
        return runs;
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = null;
        if ((set = set.getRows(new String[]{"Key_name", "PRIMARY"})).size() > 0) {
            primary = new PrimaryKey();
            for (DataRow row : set) {
                primary.setName(row.getString("Key_name"));
                Column column = new Column(row.getString("Column_name"));
                primary.addColumn(column);
            }
        }
        return primary;
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        String name;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE where REFERENCED_TABLE_NAME IS NOT NULL\n");
        if (null != table && BasicUtil.isNotEmpty((Object)(name = table.getName()))) {
            builder.append(" AND TABLE_NAME = '").append(name).append("'\n");
        }
        builder.append("ORDER BY ORDINAL_POSITION");
        return runs;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (null == foreigns) {
            foreigns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            ForeignKey foreign = (ForeignKey)foreigns.get(name.toUpperCase());
            if (null == foreign) {
                foreign = new ForeignKey();
                foreign.setName(name);
                foreign.setTable(row.getString("TABLE_NAME"));
                foreign.setReference(row.getString("REFERENCED_TABLE_NAME"));
                foreigns.put(name.toUpperCase(), foreign);
            }
            foreign.addColumn(new Column(row.getString("COLUMN_NAME")).setReference(row.getString("REFERENCED_COLUMN_NAME")).setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0))));
        }
        return foreigns;
    }

    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.STATISTICS\n");
        builder.append("WHERE 1=1\n");
        if (null != table) {
            if (null != table.getSchema()) {
                builder.append("AND TABLE_SCHEMA='").append(table.getSchema()).append("'\n");
            }
            if (null != table.getName()) {
                builder.append("AND TABLE_NAME='").append(this.objectName(runtime, table.getName())).append("'\n");
            }
        }
        if (BasicUtil.isNotEmpty((Object)name)) {
            builder.append("AND INDEX_NAME='").append(name).append("'\n");
        }
        builder.append("ORDER BY SEQ_IN_INDEX");
        return runs;
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("INDEX_NAME");
            if (null == name) continue;
            String schema = row.getString("TABLE_SCHEMA");
            String tableName = row.getString("TABLE_NAME");
            Index idx = (Index)indexs.get(name.toUpperCase());
            if (null == idx && create) {
                idx = new Index();
                indexs.put(name.toUpperCase(), idx);
            }
            idx.setTable(tableName);
            idx.setName(name);
            if (null == table) {
                table = new Table(tableName);
                table.setSchema(schema);
            }
            idx.setTable(table);
            if (name.equals("PRIMARY")) {
                idx.setPrimary(true);
            }
            if ("0".equals(row.getString("NON_UNIQUE"))) {
                idx.setUnique(true);
            }
            idx.setComment(row.getString("INDEX_COMMENT"));
            idx.setType(row.getString("INDEX_TYPE"));
            String col = row.getString("COLUMN_NAME");
            Column column = idx.getColumn(col);
            if (null == column) {
                idx.addColumn(col, null, row.getInt("SEQ_IN_INDEX", Integer.valueOf(0)).intValue());
            }
            indexs.put(name.toUpperCase(), idx);
        }
        return indexs;
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(runtime, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRun(runtime, table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS WHERE 1=1");
        if (null != table) {
            String schemae = table.getSchema();
            String name = table.getName();
            if (BasicUtil.isNotEmpty((Object)schemae)) {
                builder.append(" AND TRIGGER_SCHEMA = '").append(schemae).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append(" AND EVENT_OBJECT_TABLE = '").append(name).append("'");
            }
        }
        if (null != events && events.size() > 0) {
            builder.append(" AND(");
            boolean first = true;
            for (Trigger.EVENT event : events) {
                if (!first) {
                    builder.append(" OR ");
                }
                builder.append("EVENT_MANIPULATION ='").append(event);
            }
            builder.append(")");
        }
        return runs;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TRIGGER_NAME");
            Trigger trigger = (Trigger)triggers.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            Table tab = new Table(row.getString("EVENT_OBJECT_TABLE"));
            tab.setSchema(row.getString("TRIGGER_SCHEMA"));
            trigger.setTable(tab);
            boolean each = false;
            if ("ROW".equalsIgnoreCase(row.getString("ACTION_ORIENTATION"))) {
                each = true;
            }
            trigger.setEach(each);
            try {
                String[] events = row.getStringNvl("EVENT_MANIPULATION", new String[0]).split(",");
                String time = row.getString("ACTION_TIMING");
                trigger.setTime(Trigger.TIME.valueOf((String)time));
                for (String event : events) {
                    trigger.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)event)});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            trigger.setDefinition(row.getString("ACTION_STATEMENT"));
            triggers.put(name.toUpperCase(), trigger);
        }
        return triggers;
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = table.getComment();
        if (BasicUtil.isEmpty((Object)comment)) {
            return runs;
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, table);
        builder.append(" COMMENT '").append(comment).append("'");
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        if (columns.size() > 0) {
            StringBuilder builder = run.getBuilder();
            builder.append("ALTER ").append(this.keyword(table)).append(" ");
            this.name(runtime, builder, table);
            ArrayList<Run> slices = new ArrayList<Run>();
            for (Column column : columns) {
                ACTION.DDL action = column.getAction();
                if (action == ACTION.DDL.COLUMN_ADD) {
                    slices.addAll(this.buildAddRun(runtime, column, true));
                    continue;
                }
                if (action == ACTION.DDL.COLUMN_ALTER) {
                    slices.addAll(this.buildAlterRun(runtime, column, true));
                    continue;
                }
                if (action != ACTION.DDL.COLUMN_DROP) continue;
                slices.addAll(this.buildDropRun(runtime, column, true));
            }
            boolean first = true;
            for (Run slice : slices) {
                if (!BasicUtil.isNotEmpty((Object)slice)) continue;
                builder.append("\n");
                if (!first) {
                    builder.append(",");
                }
                builder.append(slice.getFinalUpdate().trim());
                first = false;
            }
        }
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("RENAME TABLE ");
        this.name(runtime, builder, table);
        builder.append(" TO ");
        this.name(runtime, builder, (Table)table.getUpdate());
        return runs;
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = table.getComment();
        if (BasicUtil.isEmpty((Object)comment)) {
            return runs;
        }
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, table);
        builder.append(" COMMENT '").append(comment).append("'");
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (BasicUtil.isNotEmpty((Object)order)) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.comment(runtime, builder, table);
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.name(runtime, builder, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE OR REPLACE VIEW ");
        this.name(runtime, builder, (Table)view);
        builder.append(" AS \n").append(view.getDefinition());
        runs.addAll(this.buildAppendCommentRun(runtime, view));
        return runs;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAppendCommentRun(runtime, view);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAlterRun(runtime, view);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View view) throws Exception {
        return super.buildRenameRun(runtime, view);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildChangeCommentRun(runtime, view);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View view) throws Exception {
        return super.buildDropRun(runtime, view);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View view) {
        return super.comment(runtime, builder, view);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER COLUMN ";
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        Column update;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, table);
        }
        if (null == (update = (Column)column.getUpdate())) {
            this.addColumnGuide(runtime, builder, column);
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            this.type(runtime, builder, column);
            this.charset(runtime, builder, column);
            this.defaultValue(runtime, builder, column);
            this.nullable(runtime, builder, column);
            this.onupdate(runtime, builder, column);
            this.comment(runtime, builder, column);
            this.position(runtime, builder, column);
        }
        runs.addAll(this.buildAppendCommentRun(runtime, column));
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        Column update;
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, table);
        }
        if (null != (update = (Column)column.getUpdate())) {
            builder.append(" CHANGE ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            SQLUtil.delimiter((StringBuilder)builder, (String)update.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
            this.define(runtime, builder, update);
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildDropRun(runtime, column, slice);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildRenameRun(runtime, column);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeTypeRun(runtime, column);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeDefaultRun(runtime, column);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeNullableRun(runtime, column);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        ((Column)column.update()).setAutoIncrement(Boolean.valueOf(false));
        return this.buildAlterRun(runtime, column);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.define(runtime, builder, column);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.type(runtime, builder, column);
    }

    public boolean isIgnorePrecision(DataRuntime runtime, Column column) {
        return super.isIgnorePrecision(runtime, column);
    }

    public boolean isIgnoreScale(DataRuntime runtime, Column column) {
        return super.isIgnoreScale(runtime, column);
    }

    public Boolean checkIgnorePrecision(DataRuntime runtime, String datatype) {
        return super.checkIgnorePrecision(runtime, datatype);
    }

    public Boolean checkIgnoreScale(DataRuntime runtime, String datatype) {
        return super.checkIgnoreScale(runtime, datatype);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.nullable(runtime, builder, column);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.charset(runtime, builder, column);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.defaultValue(runtime, builder, column);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            builder.append(" AUTO_INCREMENT");
        }
        return builder;
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        if (column.isOnUpdate() == 1) {
            builder.append(" ON UPDATE CURRENT_TIMESTAMP");
        }
        return builder;
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        Integer position = column.getPosition();
        if (null != position && 0 == position) {
            builder.append(" FIRST");
        } else {
            String after = column.getAfter();
            if (BasicUtil.isNotEmpty((Object)after)) {
                builder.append(" AFTER ").append(after);
            }
        }
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        String comment = column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT '").append(comment).append("'");
        }
        return builder;
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        return new ArrayList<Run>();
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, primary.getTable(true));
            builder.append(" ADD PRIMARY KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAlterRun(runtime, primary);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, primary.getTable(true));
        builder.append(" DROP PRIMARY KEY");
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildRenameRun(runtime, primary);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAddRun(runtime, foreign);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAlterRun(runtime, foreign);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildDropRun(runtime, foreign);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildRenameRun(runtime, foreign);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAddRun(runtime, index);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAlterRun(runtime, index);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, index.getTable(true));
        if (index.isPrimary()) {
            builder.append(" DROP PRIMARY KEY");
        } else {
            builder.append(" DROP INDEX ").append(index.getName());
        }
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildRenameRun(runtime, index);
    }

    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
        String comment = index.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT '").append(comment).append("'");
        }
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAddRun(runtime, constraint);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAlterRun(runtime, constraint);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildDropRun(runtime, constraint);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildRenameRun(runtime, constraint);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildCreateRun(runtime, trigger);
    }

    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        super.each(runtime, builder, trigger);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildAlterRun(runtime, trigger);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildDropRun(runtime, trigger);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildRenameRun(runtime, trigger);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildCreateRun(runtime, procedure);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildAlterRun(runtime, procedure);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildDropRun(runtime, procedure);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        log.warn("Hive\u4e0d\u652f\u6301 rename procedure(" + procedure.getName() + ")");
        return new ArrayList<Run>();
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildCreateRun(runtime, function);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildAlterRun(runtime, function);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildDropRun(runtime, function);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        log.warn("Hive\u4e0d\u652f\u6301 rename function(" + function.getName() + ")");
        return new ArrayList<Run>();
    }

    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        return super.isBooleanColumn(runtime, column);
    }

    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        return super.isNumberColumn(runtime, column);
    }

    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return super.isCharColumn(runtime, column);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "now()";
        }
        return null;
    }
}

