/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.highgo;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.PostgresGenusAdapter;
import org.anyline.data.jdbc.highgo.HighgoColumnTypeAlias;
import org.anyline.data.jdbc.highgo.HighgoReader;
import org.anyline.data.jdbc.highgo.HighgoWriter;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataSet;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.highgo")
public class HighgoAdapter
extends PostgresGenusAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.highgo:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.HighGo;
    }

    public HighgoAdapter() {
        this.delimiterFr = "";
        this.delimiterTo = "";
        for (HighgoColumnTypeAlias highgoColumnTypeAlias : HighgoColumnTypeAlias.values()) {
            this.types.put(highgoColumnTypeAlias.name(), highgoColumnTypeAlias.standard());
        }
        for (Enum enum_ : HighgoWriter.values()) {
            this.reg(((HighgoWriter)enum_).supports(), ((HighgoWriter)enum_).writer());
        }
        for (Enum enum_ : HighgoReader.values()) {
            this.reg(((HighgoReader)enum_).supports(), ((HighgoReader)enum_).reader());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.mergeFinalQuery(runtime, run);
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatOr(args);
    }

    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        return super.buildQuerySequence(runtime, next, names);
    }

    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable table, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, table, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryColumnRun(runtime, table, metadata);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        return super.columns(runtime, index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRun(runtime, table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(runtime, index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return super.tags(runtime, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryPrimaryRun(runtime, table);
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        return super.primary(runtime, index, table, set);
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryForeignsRun(runtime, table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        return super.foreigns(runtime, index, table, foreigns, set);
    }

    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(runtime, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRun(runtime, table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggerRun(runtime, table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, table, triggers, set);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        return this.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTableExists(runtime, builder, exists);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        return this.primary(runtime, builder, table);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.name(runtime, builder, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View view) throws Exception {
        return super.buildCreateRun(runtime, view);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAppendCommentRun(runtime, view);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAlterRun(runtime, view);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View view) throws Exception {
        return super.buildRenameRun(runtime, view);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildChangeCommentRun(runtime, view);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View view) throws Exception {
        return super.buildDropRun(runtime, view);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View view) {
        return super.comment(runtime, builder, view);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return super.alterColumnKeyword(runtime);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAddRun(runtime, column, slice);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAddRun(runtime, column, false);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, column, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAlterRun(runtime, column, false);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildDropRun(runtime, column, slice);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, column.getTable(true));
        builder.append(" RENAME ").append(column.getName()).append(" TO ").append(((Column)column.getUpdate()).getName());
        column.setName(((Column)column.getUpdate()).getName());
        return runs;
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeTypeRun(runtime, column);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeDefaultRun(runtime, column);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeNullableRun(runtime, column);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        return super.buildDropAutoIncrement(runtime, column);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.define(runtime, builder, column);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.type(runtime, builder, column);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.nullable(runtime, builder, column);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.charset(runtime, builder, column);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.defaultValue(runtime, builder, column);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.onupdate(runtime, builder, column);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.position(runtime, builder, column);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAddRun(runtime, tag);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAlterRun(runtime, tag);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildDropRun(runtime, tag);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildRenameRun(runtime, tag);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeDefaultRun(runtime, tag);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeNullableRun(runtime, tag);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeCommentRun(runtime, tag);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeTypeRun(runtime, tag);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAddRun(runtime, primary);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAlterRun(runtime, primary);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildDropRun(runtime, primary);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildRenameRun(runtime, primary);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAddRun(runtime, foreign);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAlterRun(runtime, foreign);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildDropRun(runtime, foreign);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildRenameRun(runtime, foreign);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAddRun(runtime, index);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAlterRun(runtime, index);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (index.isPrimary()) {
            log.info("[\u4e3b\u952e\u7d22\u5f15,\u5ffd\u7565\u5220\u9664][index:{}]", (Object)index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
        }
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildRenameRun(runtime, index);
    }

    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
        super.comment(runtime, builder, index);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAddRun(runtime, constraint);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAlterRun(runtime, constraint);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildDropRun(runtime, constraint);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildRenameRun(runtime, constraint);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildCreateRun(runtime, trigger);
    }

    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        super.each(runtime, builder, trigger);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildAlterRun(runtime, trigger);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildDropRun(runtime, trigger);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildRenameRun(runtime, trigger);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildCreateRun(runtime, procedure);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildAlterRun(runtime, procedure);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildDropRun(runtime, procedure);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildRenameRun(runtime, procedure);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildCreateRun(runtime, function);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildAlterRun(runtime, function);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildDropRun(runtime, function);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildRenameRun(runtime, function);
    }

    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        return super.isBooleanColumn(runtime, column);
    }

    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        return super.isNumberColumn(runtime, column);
    }

    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return super.isCharColumn(runtime, column);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "now()";
        }
        return null;
    }
}

