/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.highgo;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.JDBCAdapter;
import org.anyline.data.adapter.SQLAdapter;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.PrimaryKey;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.jdbc.highgo.HighgoColumnTypeAlias;
import org.anyline.data.run.Run;
import org.anyline.data.run.TextRun;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.data.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.RegularUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.highgo")
public class HighgoAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.highgo:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.HighGo;
    }

    public HighgoAdapter() {
        this.delimiterFr = "";
        this.delimiterTo = "";
        for (HighgoColumnTypeAlias alias : HighgoColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + limit + " OFFSET " + navi.getFirstRow();
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatOr(args);
    }

    public String buildQuerySequence(boolean next, String ... names) {
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        StringBuilder builder = new StringBuilder();
        TextRun run = null;
        if (null != names && names.length > 0) {
            run = new TextRun();
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(key).append("('").append(name).append("') AS ").append(name);
            }
        }
        return builder.toString();
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryTableCommentRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableCommentRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        return super.tables(index, create, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, Table> tables(boolean create, LinkedHashMap<String, Table> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(boolean create, LinkedHashMap<String, MasterTable> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable table, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(table, tags);
    }

    public LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, PartitionTable> ptables(boolean create, LinkedHashMap<String, PartitionTable> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(builder, table);
            builder.append(" WHERE 1=0");
        } else {
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            builder.append("SELECT M.* ,FD.DESCRIPTION AS COLUMN_COMMENT FROM INFORMATION_SCHEMA.COLUMNS M\n");
            builder.append("LEFT JOIN PG_CLASS FC ON FC.RELNAME = M.TABLE_NAME\n");
            builder.append("LEFT JOIN PG_DESCRIPTION FD ON FD.OBJOID = FC.OID AND FD.OBJSUBID = M.ORDINAL_POSITION\n");
            builder.append("WHERE 1 = 1\n");
            if (BasicUtil.isNotEmpty((Object)catalog)) {
                builder.append(" AND M.TABLE_CATALOG = '").append(catalog).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND M.TABLE_SCHEMA = '").append(schema).append("'");
            }
            builder.append(" AND M.TABLE_NAME = '").append(this.objectName(table.getName())).append("'");
        }
        sqls.add(builder.toString());
        return sqls;
    }

    public LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set) throws Exception {
        set.changeKey("UDT_NAME", "DATA_TYPE");
        return super.columns(index, create, table, columns, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, LinkedHashMap<String, Tag> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.tags(create, tags, dbmd, table, pattern);
    }

    public List<String> buildQueryPrimaryRunSQL(Table table) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT  m.conname,  pg_get_constraintdef(m.oid, true) AS define\n");
        builder.append("FROM pg_constraint m \n");
        builder.append("LEFT JOIN pg_namespace ns ON m.connamespace = ns.oid \n");
        builder.append("LEFT JOIN pg_class ft ON m.conrelid = ft.oid \n");
        builder.append("WHERE ft.relname = '").append(this.objectName(table.getName())).append("'");
        String schema = table.getSchema();
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND ns.nspname = '").append(schema).append("'");
        }
        list.add(builder.toString());
        return list;
    }

    public PrimaryKey primary(int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = null;
        if (set.size() > 0) {
            String[] cols;
            DataRow row = set.getRow(0);
            primary = new PrimaryKey();
            primary.setName(row.getString("conname"));
            String define = row.getString("define");
            for (String col : cols = RegularUtil.cut((String)define, (String[])new String[]{"(", ")"}).split(",")) {
                Column column = new Column(col.trim());
                column.setTable(table);
                primary.addColumn(column);
            }
        }
        return primary;
    }

    public List<String> buildQueryIndexRunSQL(Table table, String name) {
        return super.buildQueryIndexRunSQL(table, name);
    }

    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, LinkedHashMap<String, Index> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Constraint> constraints(int index, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRunSQL(table, columns);
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" RENAME TO ");
        Table update = new Table(table.getUpdate().getName());
        this.name(builder, update);
        return builder.toString();
    }

    public String buildChangeCommentRunSQL(Table table) throws Exception {
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            StringBuilder builder = new StringBuilder();
            builder.append("COMMENT ON TABLE ");
            this.name(builder, table);
            builder.append(" IS '").append(comment).append("'");
            return builder.toString();
        }
        return null;
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        return this.buildChangeCommentRunSQL(table);
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return super.checkTableExists(builder, exists);
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            int idx = 0;
            for (Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<String> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return super.alterColumnKeyword();
    }

    public List<String> buildAddRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAddRunSQL(column, slice);
    }

    public List<String> buildAddRunSQL(Column column) throws Exception {
        return this.buildAddRunSQL(column, false);
    }

    public List<String> buildAlterRunSQL(Column column, boolean slice) throws Exception {
        return super.buildAlterRunSQL(column, slice);
    }

    public List<String> buildAlterRunSQL(Column column) throws Exception {
        return this.buildAlterRunSQL(column, false);
    }

    public String buildDropRunSQL(Column column, boolean slice) throws Exception {
        return super.buildDropRunSQL(column, slice);
    }

    public String buildRenameRunSQL(Column column) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable());
        builder.append(" RENAME ").append(column.getName()).append(" TO ").append(column.getNewName());
        return builder.toString();
    }

    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        Column update = column.getUpdate();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable());
        builder.append(" ALTER COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TYPE ");
        this.type(builder, update);
        String type = update.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        builder.append(" USING ").append(column.getName()).append("::").append(type);
        sqls.add(builder.toString());
        return sqls;
    }

    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        Object def = null;
        def = null != column.getUpdate() ? column.getUpdate().getDefaultValue() : column.getDefaultValue();
        if (null != def) {
            String str = def.toString();
            if (str.contains("::")) {
                str = str.split("::")[0];
            }
            str = str.replace("'", "");
            def = str;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable()).append(" ALTER COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        if (null != def) {
            builder.append(" SET DEFAULT '").append(def).append("'");
        } else {
            builder.append(" DROP DEFAULT");
        }
        return builder.toString();
    }

    public String buildChangeNullableRunSQL(Column column) throws Exception {
        int nullable = column.isNullable();
        int uNullable = column.getUpdate().isNullable();
        if (nullable != -1 && uNullable != -1) {
            if (nullable == uNullable) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            this.name(builder, column.getTable()).append(" ALTER ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" SET ");
            } else {
                builder.append(" DROP ");
            }
            builder.append(" NOT NULL");
            return builder.toString();
        }
        return null;
    }

    public String buildCreateCommentRunSQL(Column column) throws Exception {
        return this.buildChangeCommentRunSQL(column);
    }

    public String buildChangeCommentRunSQL(Column column) throws Exception {
        String comment = null;
        Column update = column.getUpdate();
        if (null != update) {
            comment = update.getComment();
        }
        if (BasicUtil.isEmpty(comment)) {
            comment = column.getComment();
        }
        if (BasicUtil.isNotEmpty((Object)comment)) {
            StringBuilder builder = new StringBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(builder, column.getTable()).append(".");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append(" IS '").append(comment).append("'");
            return builder.toString();
        }
        return null;
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            String type = column.getTypeName().toLowerCase();
            if ("int4".equals(type) || "int".equals(type) || "integer".equals(type)) {
                column.setType("SERIAL4");
            } else if ("int8".equals(type) || "long".equals(type) || "bigint".equals(type)) {
                column.setType("SERIAL8");
            } else if ("int2".equals(type) || "smallint".equals(type) || "short".equals(type)) {
                column.setType("SERIAL2");
            } else {
                column.setType("SERIAL8");
            }
        }
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(builder, primary.getTable());
            builder.append(" ADD PRIMARY KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public List<String> buildAlterRunSQL(PrimaryKey primary) throws Exception {
        return super.buildAlterRunSQL(primary);
    }

    public String buildDropRunSQL(PrimaryKey primary) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, primary.getTable());
        builder.append(" DROP CONSTRAINT ");
        SQLUtil.delimiter((StringBuilder)builder, (String)primary.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    public String buildRenameRunSQL(PrimaryKey primary) throws Exception {
        return super.buildRenameRunSQL(primary);
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (index.isPrimary()) {
            log.info("[\u4e3b\u952e\u7d22\u5f15,\u5ffd\u7565\u5220\u9664][index:{}]", (Object)index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
        }
        return builder.toString();
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String value(Column column, JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "now()";
        }
        return null;
    }
}

