/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.hana;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.OracleGenusAdapter;
import org.anyline.data.jdbc.hana.HanaColumnTypeAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.hana")
public class HanaAdapter
extends OracleGenusAdapter
implements JDBCAdapter,
InitializingBean {
    public static boolean IS_GET_SEQUENCE_VALUE_BEFORE_INSERT = false;
    @Value(value="${anyline.data.jdbc.delimiter.hana:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.HANA;
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public HanaAdapter() {
        this.delimiterFr = "";
        this.delimiterTo = "";
        for (HanaColumnTypeAlias alias : HanaColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        if (null != names && names.length > 0) {
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(name).append(".").append(key).append(" AS ").append(name);
            }
            builder.append(" FROM DUMMY");
        }
        return runs;
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append(sql).append("\n").append(order);
            builder.append(" LIMIT ").append(navi.getPageRows()).append(" OFFSET ").append(first);
        }
        return builder.toString();
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        Object sql = "SELECT 1 AS IS_EXISTS FROM DUMMY WHERE  EXISTS(" + run.getBuilder().toString() + ")";
        sql = ((String)sql).replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatFun(args);
    }

    protected void createPrimaryValue(DataRuntime runtime, Collection list, String seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ").append(seq).append(" AS ID FROM(\n");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            builder.append("SELECT NULL FROM DUMMY\n");
            if (i >= size - 1) continue;
            builder.append("UNION ALL\n");
        }
        builder.append(") M");
        JdbcTemplate jdbc = this.jdbc(runtime);
        List ids = jdbc.queryForList(builder.toString());
        int i = 0;
        for (Object obj : list) {
            Object value = ((Map)ids.get(i++)).get("ID");
            this.setPrimaryValue(obj, value);
        }
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, configs, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, list, configs, columns);
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt = 0L;
        if (!run.isValid()) {
            if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + run.getTable() + "]");
            }
            return -1L;
        }
        String sql = run.getFinalUpdate();
        if (BasicUtil.isEmpty((Object)sql)) {
            log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)run.getTable());
            return -1L;
        }
        if (null != configs) {
            configs.add(run);
        }
        List values = run.getValues();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
        }
        JdbcTemplate jdbc = this.jdbc(runtime);
        cnt = null != values && values.size() > 0 ? (long)jdbc.update(sql, values.toArray()) : (long)jdbc.update(sql);
        return cnt;
    }

    public boolean identity(DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder) {
        if (data instanceof Collection) {
            return false;
        }
        return super.identity(runtime, random, data, configs, keyholder);
    }

    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT SCHEMA_NAME, TABLE_NAME, COMMENTS, 'TABLE' AS TABLE_TYPE FROM public.tables WHERE 1=1");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND SCHEMA_NAME = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(pattern).append("'");
        }
        if (null != types && types.toUpperCase().contains("VIEW")) {
            builder.append("UNION ALL \n");
            builder.append("SELECT SCHEMA_NAME, VIEW_NAME, COMMENTS, 'VIEW' AS TABLE_TYPE FROM public.views WHERE 1=1");
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND SCHEMA_NAME = '").append(schema).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                builder.append(" AND VIEW_NAME LIKE '").append(pattern).append("'");
            }
        }
        return runs;
    }

    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        return runs;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object table;
            String name = row.getString("TABLE_NAME");
            String _catalog = row.getString("CATALOG_NAME");
            String _schema = row.getString("SCHEMA_NAME");
            if (null == _catalog) {
                _catalog = catalog;
            }
            if (null == _schema) {
                _schema = schema;
            }
            if (null == (table = (Table)tables.get(name.toUpperCase()))) {
                table = "VIEW".equals(row.getString("TABLE_TYPE")) ? new View() : new Table();
            }
            table.setCatalog(_catalog);
            table.setSchema(_schema);
            table.setName(name);
            table.setComment(row.getString("COMMENTS"));
            tables.put(name.toUpperCase(), table);
        }
        return tables;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            String _catalog = row.getString("CATALOG_NAME");
            String _schema = row.getString("SCHEMA_NAME");
            if (null == _catalog) {
                _catalog = catalog;
            }
            if (null == _schema) {
                _schema = schema;
            }
            Object table = this.table(tables, _catalog, _schema, name);
            boolean conains = true;
            if (null == table) {
                conains = false;
                table = "VIEW".equals(row.getString("TABLE_TYPE")) ? new View() : new Table();
            }
            table.setCatalog(_catalog);
            table.setSchema(_schema);
            table.setName(name);
            table.setComment(row.getString("COMMENTS"));
            if (conains) continue;
            tables.add(table);
        }
        return tables;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryViewRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM  public.views WHERE 1=1");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND SCHEMA_NAME = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND VIEW_NAME LIKE '").append(pattern).append("'");
        }
        return runs;
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("VIEW_NAME");
            View view = (View)views.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            if (null == schema) {
                schema = row.getString("SCHEMA_NAME");
            }
            view.setCatalog(catalog);
            view.setSchema(schema);
            view.setName(name);
            view.setComment(row.getString("COMMENTS"));
            view.setDefinition(row.getString("DEFINITION"));
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags, name);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        String name = null;
        if (null != table) {
            name = table.getName();
        }
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT * FROM " + this.keyword(table) + "_COLUMNS \n");
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append("WHERE " + this.keyword(table) + "_NAME = '").append(name).append("'");
            }
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        set.removeColumn(new String[]{"CHARACTER_SET_NAME"});
        return super.columns(runtime, index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRun(runtime, table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(runtime, index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return super.tags(runtime, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(runtime, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRun(runtime, table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM USER_TRIGGERS WHERE 1=1");
        if (null != table) {
            String schemae = table.getSchema();
            String tableName = table.getName();
            if (BasicUtil.isNotEmpty((Object)schemae)) {
                builder.append(" AND TABLE_OWNER = '").append(schemae).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)tableName)) {
                builder.append(" AND TABLE_NAME = '").append(tableName).append("'");
            }
        }
        if (null != events && events.size() > 0) {
            builder.append(" AND(");
            boolean first = true;
            for (Trigger.EVENT event : events) {
                if (!first) {
                    builder.append(" OR ");
                }
                builder.append("TRIGGERING_EVENT ='").append(event);
            }
            builder.append(")");
        }
        return runs;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TRIGGER_NAME");
            Trigger trigger = (Trigger)triggers.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            Table tab = new Table(row.getString("TABLE_NAME"));
            tab.setSchema(row.getString("TABLE_OWNER"));
            trigger.setTable(tab);
            try {
                boolean each = false;
                String des = row.getStringNvl("DESCRIPTION", new String[0]).toUpperCase();
                if (des.contains("ROW")) {
                    each = true;
                }
                trigger.setEach(each);
                String[] tmps = des.split(" ");
                trigger.setTime(Trigger.TIME.valueOf((String)tmps[1]));
                trigger.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)tmps[2])});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            trigger.setDefinition(row.getString("TRIGGER_BODY"));
            triggers.put(name.toUpperCase(), trigger);
        }
        return triggers;
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (BasicUtil.isNotEmpty((Object)table.getComment())) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append(" COMMENT ON TABLE ");
            this.name(runtime, builder, table);
            builder.append("  IS '").append(table.getComment()).append("'");
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, table);
        builder.append(" RENAME TO ");
        Table update = new Table(table.getUpdate().getName());
        this.name(runtime, builder, update);
        return runs;
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("COMMENT ON TABLE ");
            this.name(runtime, builder, table);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.name(runtime, builder, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View view) throws Exception {
        return super.buildCreateRun(runtime, view);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAppendCommentRun(runtime, view);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAlterRun(runtime, view);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View view) throws Exception {
        return super.buildRenameRun(runtime, view);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildChangeCommentRun(runtime, view);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View view) throws Exception {
        return super.buildDropRun(runtime, view);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View view) {
        return super.comment(runtime, builder, view);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER";
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, table);
        }
        builder.append(" ADD ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(runtime, builder, column);
        runs.addAll(this.buildAppendCommentRun(runtime, column));
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, column, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAlterRun(runtime, column, false);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildDropRun(runtime, column, slice);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, column.getTable(true));
        builder.append(" RENAME COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)((Column)column.getUpdate()).getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        column.setName(((Column)column.getUpdate()).getName());
        return runs;
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = (Column)column.getUpdate();
        String name = column.getName();
        String type = column.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        String uname = update.getName();
        String utype = update.getTypeName();
        if (uname.endsWith("_TMP_UPDATE_TYPE")) {
            runs.addAll(this.buildDropRun(runtime, update));
        } else {
            if (utype != null && utype.contains("(")) {
                utype = utype.substring(0, utype.indexOf("("));
            }
            if (!type.equals(utype)) {
                String tmp_name = column.getName() + "_TMP_UPDATE_TYPE";
                update.setName(tmp_name);
                runs.addAll(this.buildRenameRun(runtime, column));
                update.setName(uname);
                runs.addAll(this.buildAddRun(runtime, update));
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                this.name(runtime, builder, column.getTable(true));
                builder.append(" SET ");
                SQLUtil.delimiter((StringBuilder)builder, (String)uname, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                builder.append(" = ");
                SQLUtil.delimiter((StringBuilder)builder, (String)tmp_name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                runs.add((Run)new SimpleRun(builder));
                column.setName(tmp_name);
                List drop = this.buildDropRun(runtime, column);
                runs.addAll(drop);
                column.setName(name);
                update.setName(name);
                column.setNullable(update.isNullable());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                this.name(runtime, builder, column.getTable(true));
                builder.append(" MODIFY(");
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.type(runtime, builder, (Column)column.getUpdate());
                builder.append(")");
                runs.add((Run)new SimpleRun(builder));
            }
        }
        return runs;
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Object def = null;
        def = null != column.getUpdate() ? ((Column)column.getUpdate()).getDefaultValue() : column.getDefaultValue();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, column.getTable(true)).append(" MODIFY ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        if (null != def) {
            this.defaultValue(runtime, builder, column);
            builder.append(def);
        } else {
            builder.append(" DEFAULT NULL");
        }
        return runs;
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        int nullable = column.isNullable();
        int uNullable = ((Column)column.getUpdate()).isNullable();
        if (nullable != -1 && uNullable != -1) {
            if (nullable == uNullable) {
                return runs;
            }
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, column.getTable(true)).append(" MODIFY ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" NOT ");
            }
            builder.append(" NULL");
            column.setNullable(uNullable);
        }
        return runs;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = null;
        comment = null != column.getUpdate() ? ((Column)column.getUpdate()).getComment() : column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("COMMENT ON COLUMN ");
            this.name(runtime, builder, column.getTable(true)).append(".");
            Column update = (Column)column.getUpdate();
            String name = null;
            name = null != update ? update.getName() : column.getName();
            SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        return super.buildDropAutoIncrement(runtime, column);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.define(runtime, builder, column);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.type(runtime, builder, column);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.nullable(runtime, builder, column);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.charset(runtime, builder, column);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.defaultValue(runtime, builder, column);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        builder.append(" GENERATED ALWAYS AS IDENTITY");
        return builder;
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.onupdate(runtime, builder, column);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.position(runtime, builder, column);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.comment(runtime, builder, column);
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAddRun(runtime, tag);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAlterRun(runtime, tag);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildDropRun(runtime, tag);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildRenameRun(runtime, tag);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeDefaultRun(runtime, tag);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeNullableRun(runtime, tag);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeCommentRun(runtime, tag);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeTypeRun(runtime, tag);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, primary.getTable(true));
            builder.append(" ADD CONSTRAINT ").append(primary.getTableName(true)).append("_PK").append(" PRIMARY KEY(");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAlterRun(runtime, primary);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, primary.getTable(true));
        builder.append(" DROP PRIMARY KEY");
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildRenameRun(runtime, primary);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAddRun(runtime, foreign);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAlterRun(runtime, foreign);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildDropRun(runtime, foreign);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildRenameRun(runtime, foreign);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM PUBLIC.INDEX_COLUMNS \n");
        builder.append("WHERE CONSTRAINT = 'PRIMARY KEY'");
        builder.append(" AND TABLE_NAME = '").append(table.getName()).append("'");
        if (BasicUtil.isNotEmpty((Object)table.getSchema())) {
            builder.append(" AND SCHEMA_NAME = '").append(table.getSchema()).append("'");
        }
        return runs;
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = table.getPrimaryKey();
        for (DataRow row : set) {
            String col;
            Column column;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString("INDEX_NAME"));
                primary.setTable(table);
            }
            if (null == (column = primary.getColumn(col = row.getString("COLUMN_NAME")))) {
                column = new Column(col);
            }
            column.setTable(table);
            column.setPosition(row.getInt("POSITION", Integer.valueOf(0)));
            primary.addColumn(column);
        }
        return primary;
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT UC.CONSTRAINT_NAME, UC.TABLE_NAME, KCU.COLUMN_NAME, UC.R_CONSTRAINT_NAME, RC.TABLE_NAME AS REFERENCED_TABLE_NAME, RCC.COLUMN_NAME AS REFERENCED_COLUMN_NAME, RCC.POSITION AS ORDINAL_POSITION\n");
        builder.append("FROM USER_CONSTRAINTS UC \n");
        builder.append("JOIN USER_CONS_COLUMNS KCU ON UC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME \n");
        builder.append("JOIN USER_CONSTRAINTS RC ON UC.R_CONSTRAINT_NAME = RC.CONSTRAINT_NAME \n");
        builder.append("JOIN USER_CONS_COLUMNS RCC ON RC.CONSTRAINT_NAME = RCC.CONSTRAINT_NAME AND KCU.POSITION = RCC.POSITION");
        if (null != table) {
            if (BasicUtil.isNotEmpty((Object)table.getCatalog())) {
                builder.append(" AND OWNER = '").append(table.getCatalog()).append("'\n");
            }
            builder.append(" AND UC.TABLE_NAME = '").append(table.getName()).append("'\n");
        }
        return runs;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (null == foreigns) {
            foreigns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            ForeignKey foreign = (ForeignKey)foreigns.get(name.toUpperCase());
            if (null == foreign) {
                foreign = new ForeignKey();
                foreign.setName(name);
                foreign.setTable(row.getString("TABLE_NAME"));
                foreign.setReference(row.getString("REFERENCED_TABLE_NAME"));
                foreigns.put(name.toUpperCase(), foreign);
            }
            foreign.addColumn(new Column(row.getString("COLUMN_NAME")).setReference(row.getString("REFERENCED_COLUMN_NAME")).setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0))));
        }
        return foreigns;
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAddRun(runtime, index);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAlterRun(runtime, index);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = index.getTable(true);
        if (index.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, table);
            builder.append(" DROP CONSTRAINT ").append(index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
        }
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildRenameRun(runtime, index);
    }

    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
        super.comment(runtime, builder, index);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAddRun(runtime, constraint);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAlterRun(runtime, constraint);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildDropRun(runtime, constraint);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildRenameRun(runtime, constraint);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildCreateRun(runtime, trigger);
    }

    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        super.each(runtime, builder, trigger);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildAlterRun(runtime, trigger);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildDropRun(runtime, trigger);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildRenameRun(runtime, trigger);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildCreateRun(runtime, procedure);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildAlterRun(runtime, procedure);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildDropRun(runtime, procedure);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildRenameRun(runtime, procedure);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildCreateRun(runtime, function);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildAlterRun(runtime, function);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildDropRun(runtime, function);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildRenameRun(runtime, function);
    }

    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        return super.isBooleanColumn(runtime, column);
    }

    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        return super.isNumberColumn(runtime, column);
    }

    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return super.isCharColumn(runtime, column);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "sysdate";
        }
        return null;
    }
}

