/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.hana;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.OracleGenusAdapter;
import org.anyline.data.jdbc.hana.HanaColumnTypeAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.hana")
public class HanaAdapter
extends OracleGenusAdapter
implements JDBCAdapter,
InitializingBean {
    public static boolean IS_GET_SEQUENCE_VALUE_BEFORE_INSERT = false;
    @Value(value="${anyline.data.jdbc.delimiter.hana:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.HANA;
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public HanaAdapter() {
        this.delimiterFr = "";
        this.delimiterTo = "";
        for (HanaColumnTypeAlias alias : HanaColumnTypeAlias.values()) {
            this.types.put(alias.name(), alias.standard());
        }
    }

    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        if (null != names && names.length > 0) {
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(name).append(".").append(key).append(" AS ").append(name);
            }
            builder.append(" FROM DUMMY");
        }
        return runs;
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append(sql).append("\n").append(order);
            builder.append(" LIMIT ").append(navi.getPageRows()).append(" OFFSET ").append(first);
        }
        return builder.toString();
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        return super.mergeFinalExists(runtime, run);
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatFun(args);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, configs, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, list, configs, columns);
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt = 0L;
        if (!run.isValid()) {
            if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + run.getTable() + "]");
            }
            return -1L;
        }
        String sql = run.getFinalUpdate();
        if (BasicUtil.isEmpty((Object)sql)) {
            log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)run.getTable());
            return -1L;
        }
        if (null != configs) {
            configs.add(run);
        }
        List values = run.getValues();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[sql:\n{}\n]\n[param:{}]", new Object[]{random, sql, LogUtil.param((List)values)});
        }
        JdbcTemplate jdbc = this.jdbc(runtime);
        cnt = null != values && values.size() > 0 ? (long)jdbc.update(sql, values.toArray()) : (long)jdbc.update(sql);
        return cnt;
    }

    public boolean identity(DataRuntime runtime, String random, Object data, ConfigStore configs, KeyHolder keyholder) {
        if (data instanceof Collection) {
            return false;
        }
        return super.identity(runtime, random, data, configs, keyholder);
    }

    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT SCHEMA_NAME, TABLE_NAME, COMMENTS, 'TABLE' AS TABLE_TYPE FROM public.tables WHERE 1=1");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND SCHEMA_NAME = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(pattern).append("'");
        }
        if (null != types && types.toUpperCase().contains("VIEW")) {
            builder.append("UNION ALL \n");
            builder.append("SELECT SCHEMA_NAME, VIEW_NAME, COMMENTS, 'VIEW' AS TABLE_TYPE FROM public.views WHERE 1=1");
            if (BasicUtil.isNotEmpty((Object)schema)) {
                builder.append(" AND SCHEMA_NAME = '").append(schema).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                builder.append(" AND VIEW_NAME LIKE '").append(pattern).append("'");
            }
        }
        return runs;
    }

    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        return runs;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryViewRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM  public.views WHERE 1=1");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND SCHEMA_NAME = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND VIEW_NAME LIKE '").append(pattern).append("'");
        }
        return runs;
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("VIEW_NAME");
            View view = (View)views.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            if (null == schema) {
                schema = row.getString("SCHEMA_NAME");
            }
            view.setCatalog(catalog);
            view.setSchema(schema);
            view.setName(name);
            view.setComment(row.getString("COMMENTS"));
            view.setDefinition(row.getString("DEFINITION"));
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags, name);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        String name = null;
        if (null != table) {
            name = table.getName();
        }
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT * FROM " + this.keyword(table) + "_COLUMNS \n");
            if (BasicUtil.isNotEmpty((Object)name)) {
                builder.append("WHERE " + this.keyword(table) + "_NAME = '").append(name).append("'");
            }
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        set.removeColumn(new String[]{"CHARACTER_SET_NAME"});
        return super.columns(runtime, index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRun(runtime, table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(runtime, index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return super.tags(runtime, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(runtime, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRun(runtime, table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggerRun(runtime, table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, table, triggers, set);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAppendCommentRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.primary(runtime, builder, table);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.name(runtime, builder, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View view) throws Exception {
        return super.buildCreateRun(runtime, view);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAppendCommentRun(runtime, view);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View view) throws Exception {
        return super.buildAlterRun(runtime, view);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View view) throws Exception {
        return super.buildRenameRun(runtime, view);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View view) throws Exception {
        return super.buildChangeCommentRun(runtime, view);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View view) throws Exception {
        return super.buildDropRun(runtime, view);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View view) {
        return super.comment(runtime, builder, view);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER";
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAddRun(runtime, column, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, column, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAlterRun(runtime, column, false);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildDropRun(runtime, column, slice);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildRenameRun(runtime, column);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeTypeRun(runtime, column);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeDefaultRun(runtime, column);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeNullableRun(runtime, column);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildAppendCommentRun(runtime, column);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        return super.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        return super.buildDropAutoIncrement(runtime, column);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.define(runtime, builder, column);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.type(runtime, builder, column);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.nullable(runtime, builder, column);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.charset(runtime, builder, column);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.defaultValue(runtime, builder, column);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        builder.append(" GENERATED ALWAYS AS IDENTITY");
        return builder;
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.onupdate(runtime, builder, column);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.position(runtime, builder, column);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.comment(runtime, builder, column);
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAddRun(runtime, tag);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAlterRun(runtime, tag);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildDropRun(runtime, tag);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildRenameRun(runtime, tag);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeDefaultRun(runtime, tag);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeNullableRun(runtime, tag);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeCommentRun(runtime, tag);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeTypeRun(runtime, tag);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAddRun(runtime, primary);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAlterRun(runtime, primary);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildDropRun(runtime, primary);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildRenameRun(runtime, primary);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAddRun(runtime, foreign);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAlterRun(runtime, foreign);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildDropRun(runtime, foreign);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildRenameRun(runtime, foreign);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM PUBLIC.INDEX_COLUMNS \n");
        builder.append("WHERE CONSTRAINT = 'PRIMARY KEY'");
        builder.append(" AND TABLE_NAME = '").append(table.getName()).append("'");
        if (BasicUtil.isNotEmpty((Object)table.getSchema())) {
            builder.append(" AND SCHEMA_NAME = '").append(table.getSchema()).append("'");
        }
        return runs;
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = table.getPrimaryKey();
        for (DataRow row : set) {
            String col;
            Column column;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString("INDEX_NAME"));
                primary.setTable(table);
            }
            if (null == (column = primary.getColumn(col = row.getString("COLUMN_NAME")))) {
                column = new Column(col);
            }
            column.setTable(table);
            column.setPosition(row.getInt("POSITION", Integer.valueOf(0)));
            primary.addColumn(column);
        }
        return primary;
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryForeignsRun(runtime, table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        return super.foreigns(runtime, index, table, foreigns, set);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAddRun(runtime, index);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAlterRun(runtime, index);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildDropRun(runtime, index);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildRenameRun(runtime, index);
    }

    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
        super.comment(runtime, builder, index);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAddRun(runtime, constraint);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAlterRun(runtime, constraint);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildDropRun(runtime, constraint);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildRenameRun(runtime, constraint);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildCreateRun(runtime, trigger);
    }

    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        super.each(runtime, builder, trigger);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildAlterRun(runtime, trigger);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildDropRun(runtime, trigger);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildRenameRun(runtime, trigger);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildCreateRun(runtime, procedure);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildAlterRun(runtime, procedure);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildDropRun(runtime, procedure);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildRenameRun(runtime, procedure);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildCreateRun(runtime, function);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildAlterRun(runtime, function);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildDropRun(runtime, function);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildRenameRun(runtime, function);
    }

    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        return super.isBooleanColumn(runtime, column);
    }

    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        return super.isNumberColumn(runtime, column);
    }

    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return super.isCharColumn(runtime, column);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        return super.value(runtime, column, value);
    }
}

