/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.dm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.SQLAdapter;
import org.anyline.data.jdbc.dm.DMColumnTypeAlias;
import org.anyline.data.jdbc.dm.DMReader;
import org.anyline.data.jdbc.dm.DMWriter;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.dm")
public class DMAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    public static boolean IS_GET_SEQUENCE_VALUE_BEFORE_INSERT = false;
    @Value(value="${anyline.data.jdbc.delimiter.dm:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.DM;
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public DMAdapter() {
        Object[] supports;
        this.delimiterFr = "\"";
        this.delimiterTo = "\"";
        for (DMColumnTypeAlias dMColumnTypeAlias : DMColumnTypeAlias.values()) {
            this.types.put(dMColumnTypeAlias.name(), dMColumnTypeAlias.standard());
        }
        for (Enum enum_ : DMWriter.values()) {
            supports = ((DMWriter)enum_).supports();
            if (null == supports) continue;
            for (Object support : supports) {
                this.writers.put(support, ((DMWriter)enum_).writer());
            }
        }
        for (Enum enum_ : DMReader.values()) {
            supports = ((DMReader)enum_).supports();
            if (null == supports) continue;
            for (Object support : supports) {
                this.readers.put(support, ((DMReader)enum_).reader());
            }
        }
    }

    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        ArrayList<Run> runs = new ArrayList<Run>();
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        if (null != names && names.length > 0) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(name).append(".").append(key).append(" AS ").append(name);
            }
            builder.append(" FROM DUAL");
        }
        return runs;
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatOr(args);
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        String sql = "SELECT 1 AS IS_EXISTS FROM DUAL WHERE  EXISTS(" + run.getBuilder().toString() + ")";
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    protected boolean createPrimaryValue(DataRuntime runtime, Collection list, String seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ").append(seq).append(" AS ID FROM(\n");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            builder.append("SELECT NULL FROM DUAL\n");
            if (i >= size - 1) continue;
            builder.append("UNION ALL\n");
        }
        builder.append(") M");
        JdbcTemplate jdbc = this.jdbc(runtime);
        List ids = jdbc.queryForList(builder.toString());
        int i = 0;
        for (Object obj : list) {
            Object value = ((Map)ids.get(i++)).get("ID");
            this.setPrimaryValue(obj, value);
        }
        return true;
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, LinkedHashMap<String, Column> columns) {
        String key;
        if (null == list || list.isEmpty()) {
            return;
        }
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, columns);
            return;
        }
        Object first = list.iterator().next();
        HashMap<String, String> seqs = new HashMap<String, String>();
        for (Column column : columns.values()) {
            String str;
            String key2 = column.getName();
            Iterator<Object> value = BeanUtil.getFieldValue(first, (String)key2);
            if (null == value || !(value instanceof String) || !(str = (String)((Object)value)).toUpperCase().contains(".NEXTVAL")) continue;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            }
            if (IS_GET_SEQUENCE_VALUE_BEFORE_INSERT) {
                this.createPrimaryValue(runtime, list, str);
                continue;
            }
            seqs.put(key2, str);
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""));
        LinkedHashMap pks = null;
        if (null != generator) {
            pks = EntityAdapterProxy.primaryKeys(first.getClass());
            columns.putAll(pks);
        }
        builder.append("INSERT INTO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)dest, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" (");
        boolean start = true;
        for (Column column : columns.values()) {
            if (!start) {
                builder.append(", ");
            }
            start = false;
            key = column.getName();
            builder.append(key);
        }
        builder.append(") \n");
        builder.append("SELECT ");
        start = true;
        for (Column column : columns.values()) {
            key = column.getName();
            String seq = (String)seqs.get(key);
            if (!start) {
                builder.append(", ");
            }
            start = false;
            if (null != seq) {
                builder.append(seq);
            } else {
                builder.append("M.").append(key);
            }
            builder.append(" AS ").append(key);
        }
        builder.append("\nFROM( ");
        for (String seq : seqs.keySet()) {
            columns.remove(seq.toUpperCase());
        }
        int col = 0;
        for (Object obj : list) {
            List inserts = BeanUtil.getMapKeys(columns);
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, (List)BeanUtil.getMapKeys(columns));
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), BeanUtil.getMapKeys((Map)pks), null);
            }
            if (col > 0) {
                builder.append("\n\tUNION ALL");
            }
            builder.append("\n\tSELECT ");
            this.insertValue(runtime, run, obj, true, true, false, columns);
            builder.append(" FROM DUAL ");
            ++col;
        }
        builder.append(") M ");
    }

    public long insert(DataRuntime runtime, String random, Object data, Run run, String[] pks) {
        long cnt = 0L;
        if (data instanceof Collection) {
            this.insert(runtime, random, data, run, (String[])pks, true);
        } else {
            String pk = this.getPrimayKey(data);
            pks = null != pk ? new String[]{pk} : null;
            cnt = super.insert(runtime, random, data, run, pks);
        }
        return cnt;
    }

    public boolean identity(DataRuntime runtime, String random, Object data, KeyHolder keyholder) {
        if (data instanceof Collection) {
            return false;
        }
        return super.identity(runtime, random, data, keyholder);
    }

    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.OWNER AS TABLE_SCHEMA, M.OBJECT_NAME AS TABLE_NAME, M.OBJECT_TYPE AS TABLE_TYPE, F.COMMENTS FROM ALL_OBJECTS   M LEFT JOIN ALL_TAB_COMMENTS   F \n");
        builder.append("ON M.OBJECT_NAME = F.TABLE_NAME  AND M.OWNER = F.OWNER AND M.object_type = F.TABLE_TYPE \n");
        builder.append("WHERE M.OWNER NOT IN('SYS','PUBLIC','SYSTEM') AND M.OBJECT_TYPE IN('TABLE','VIEW')");
        if (BasicUtil.isNotEmpty((Object)schema)) {
            builder.append(" AND M.OWNER = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)types)) {
            String[] tmps = types.split(",");
            builder.append(" AND M.OBJECT_TYPE IN(");
            int idx = 0;
            for (String tmp : tmps) {
                if (idx > 0) {
                    builder.append(",");
                }
                builder.append("'").append(tmp).append("'");
                ++idx;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM USER_TAB_COMMENTS\n");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append("WHERE TABLE_NAME = '").append(this.objectName(runtime, pattern)).append("'");
        }
        return runs;
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        return super.tables(runtime, index, create, catalog, schema, tables, set);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryViewRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT A.VIEW_NAME,A.TEXT DEFINITION_SQL,  B.COMMENTS, 'VIEW'  TABLE_TYPE FROM USER_VIEWS  A, USER_TAB_COMMENTS B WHERE A.VIEW_NAME = B.TABLE_NAME");
        if (BasicUtil.isNotEmpty((Object)pattern)) {
            builder.append(" AND TABLE_NAME LIKE '").append(this.objectName(runtime, pattern)).append("'");
        }
        return runs;
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("VIEW_NAME");
            View view = (View)views.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            view.setCatalog(catalog);
            view.setSchema(schema);
            view.setName(name);
            view.setComment(row.getString("COMMENTS"));
            view.setDefinition(row.getString("DEFINITION_SQL"));
            views.put(name.toUpperCase(), view);
        }
        return views;
    }

    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.mtables(runtime, index, create, catalog, schema, tables, set);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags, name);
    }

    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRun(runtime, master, tags);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        return super.ptables(runtime, total, index, create, master, catalog, schema, tables, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(runtime, create, tables, catalog, schema, master);
    }

    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (BasicUtil.isEmpty((Object)table.getName())) {
            return runs;
        }
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (metadata) {
            builder.append("SELECT * FROM ");
            this.name(runtime, builder, table);
            builder.append(" WHERE 1=0");
        } else {
            builder.append("SELECT M.*, F.COMMENTS AS COLUMN_COMMENT FROM USER_TAB_COLUMNS    M \n");
            builder.append("LEFT JOIN USER_COL_COMMENTS F ON M.TABLE_NAME = F.TABLE_NAME AND M.COLUMN_NAME = F.COLUMN_NAME\n");
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append("WHERE M.TABLE_NAME = '").append(this.objectName(runtime, table.getName())).append("'");
            }
        }
        return runs;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        set.removeColumn(new String[]{"CHARACTER_SET_NAME"});
        return super.columns(runtime, index, create, table, columns, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(runtime, create, columns, table, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        return super.columns(runtime, create, columns, table, pattern);
    }

    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRun(runtime, table, metadata);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(runtime, index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> tags, SqlRowSet set) throws Exception {
        return super.tags(runtime, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> indexs, SqlRowSet set) throws Exception {
        return super.indexs(runtime, create, table, indexs, set);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRun(runtime, table, metadata);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, SqlRowSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        return super.constraints(runtime, create, table, constraints, set);
    }

    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM USER_TRIGGERS WHERE 1=1");
        if (null != table) {
            String schemae = table.getSchema();
            String tableName = table.getName();
            if (BasicUtil.isNotEmpty((Object)schemae)) {
                builder.append(" AND TABLE_OWNER = '").append(schemae).append("'");
            }
            if (BasicUtil.isNotEmpty((Object)tableName)) {
                builder.append(" AND TABLE_NAME = '").append(tableName).append("'");
            }
        }
        if (null != events && events.size() > 0) {
            builder.append(" AND(");
            boolean first = true;
            for (Trigger.EVENT event : events) {
                if (!first) {
                    builder.append(" OR ");
                }
                builder.append("TRIGGERING_EVENT ='").append(event);
            }
            builder.append(")");
        }
        return runs;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TRIGGER_NAME");
            Trigger trigger = (Trigger)triggers.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            Table tab = new Table(row.getString("TABLE_NAME"));
            tab.setSchema(row.getString("TABLE_OWNER"));
            trigger.setTable(tab);
            try {
                boolean each = false;
                String des = row.getStringNvl("DESCRIPTION", new String[0]).toUpperCase();
                if (des.contains("ROW")) {
                    each = true;
                }
                trigger.setEach(each);
                String[] tmps = des.split(" ");
                trigger.setTime(Trigger.TIME.valueOf((String)tmps[1]));
                trigger.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)tmps[2])});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            trigger.setDefinition(row.getString("TRIGGER_BODY"));
            triggers.put(name.toUpperCase(), trigger);
        }
        return triggers;
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (BasicUtil.isNotEmpty((Object)table.getComment())) {
            SimpleRun run = new SimpleRun();
            StringBuilder builder = run.getBuilder();
            runs.add((Run)run);
            builder.append(" COMMENT ON TABLE ");
            this.name(runtime, builder, table);
            builder.append("  IS '").append(table.getComment()).append("'");
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, table, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, table);
        builder.append(" RENAME TO ");
        Table update = new Table(table.getUpdate().getName());
        this.name(runtime, builder, update);
        return runs;
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON TABLE ");
            this.name(runtime, builder, table);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        return builder;
    }

    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        return super.name(runtime, builder, table);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return this.buildAppendCommentRun(runtime, (Table)view);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildCreateRun(runtime, table);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildAlterRun(runtime, table);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildDropRun(runtime, table);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildRenameRun(runtime, table);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildChangeCommentRun(runtime, table);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER";
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, table);
        }
        builder.append(" ADD ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(runtime, builder, column);
        runs.addAll(this.buildAppendCommentRun(runtime, column));
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, column, slice);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        return super.buildDropRun(runtime, column, slice);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildDropRun(runtime, column, false);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, column.getTable(true));
        builder.append(" RENAME COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        column.setName(column.getUpdate().getName());
        return runs;
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = column.getUpdate();
        String name = column.getName();
        String type = column.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        String uname = update.getName();
        String utype = update.getTypeName();
        if (uname.endsWith("_TMP_UPDATE_TYPE")) {
            runs.addAll(this.buildDropRun(runtime, update));
        } else {
            if (utype != null && utype.contains("(")) {
                utype = utype.substring(0, utype.indexOf("("));
            }
            if (!type.equals(utype)) {
                String tmp_name = column.getName() + "_TMP_UPDATE_TYPE";
                update.setName(tmp_name);
                runs.addAll(this.buildRenameRun(runtime, column));
                update.setName(uname);
                runs.addAll(this.buildAddRun(runtime, update));
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                this.name(runtime, builder, column.getTable(true));
                builder.append(" SET ");
                SQLUtil.delimiter((StringBuilder)builder, (String)uname, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                builder.append(" = ");
                SQLUtil.delimiter((StringBuilder)builder, (String)tmp_name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                runs.add((Run)new SimpleRun(builder));
                column.setName(tmp_name);
                List<Run> drop = this.buildDropRun(runtime, column);
                runs.addAll(drop);
                column.setName(name);
                update.setName(name);
                column.setNullable(update.isNullable());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                this.name(runtime, builder, column.getTable(true));
                builder.append(" MODIFY(");
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.type(runtime, builder, column.getUpdate());
                builder.append(")");
                runs.add((Run)new SimpleRun(builder));
            }
        }
        return runs;
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Object def = null;
        def = null != column.getUpdate() ? column.getUpdate().getDefaultValue() : column.getDefaultValue();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, column.getTable(true)).append(" MODIFY ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" DEFAULT ");
        if (null != def) {
            def = this.write(runtime, column, def, false);
            builder.append(def);
        } else {
            builder.append(" NULL");
        }
        return runs;
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        int nullable = column.isNullable();
        int uNullable = column.getUpdate().isNullable();
        if (nullable != -1 && uNullable != -1) {
            if (nullable == uNullable) {
                return runs;
            }
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, column.getTable(true)).append(" MODIFY ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" NOT ");
            }
            builder.append(" NULL");
            column.setNullable(uNullable);
        }
        return runs;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildChangeCommentRun(runtime, column);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = null;
        comment = null != column.getUpdate() ? column.getUpdate().getComment() : column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(runtime, builder, column.getTable(true)).append(".");
            Column update = column.getUpdate();
            String name = null;
            name = null != update ? update.getName() : column.getName();
            SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        return super.buildDropAutoIncrement(runtime, column);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.define(runtime, builder, column);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.type(runtime, builder, column);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.nullable(runtime, builder, column);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.charset(runtime, builder, column);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.defaultValue(runtime, builder, column);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            builder.append(" IDENTITY(").append(column.getIncrementSeed()).append(",").append(column.getIncrementStep()).append(")");
        }
        return builder;
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.onupdate(runtime, builder, column);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.position(runtime, builder, column);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        return super.comment(runtime, builder, column);
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAddRun(runtime, tag);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildAlterRun(runtime, tag);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildDropRun(runtime, tag);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildRenameRun(runtime, tag);
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeDefaultRun(runtime, tag);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeNullableRun(runtime, tag);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeCommentRun(runtime, tag);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        return super.buildChangeTypeRun(runtime, tag);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        LinkedHashMap columns = primary.getColumns();
        if (columns.size() > 0) {
            SimpleRun run = new SimpleRun();
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, primary.getTable(true));
            builder.append(" ADD CONSTRAINT ").append(primary.getTableName(true)).append("_PK").append(" PRIMARY KEY(");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildAlterRun(runtime, primary);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, primary.getTable(true));
        builder.append(" DROP PRIMARY KEY");
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return super.buildRenameRun(runtime, primary);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAddRun(runtime, foreign);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildAlterRun(runtime, foreign);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildDropRun(runtime, foreign);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        return super.buildRenameRun(runtime, foreign);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT A.*,  B.COLUMN_NAME , B.POSITION \n");
        builder.append("FROM ALL_CONSTRAINTS A, ALL_CONS_COLUMNS B WHERE B.OWNER =A.OWNER AND A.TABLE_NAME =B.TABLE_NAME \n");
        builder.append("AND A.CONSTRAINT_TYPE = 'P'\n");
        builder.append("AND A.TABLE_NAME = '").append(this.objectName(runtime, table.getName())).append("'\n");
        if (BasicUtil.isNotEmpty((Object)table.getSchema())) {
            builder.append(" AND A.OWNER = '").append(table.getSchema()).append("'");
        }
        return runs;
    }

    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        PrimaryKey primary = table.getPrimaryKey();
        for (DataRow row : set) {
            String col;
            Column column;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString("CONSTRAINT_NAME"));
                primary.setTable(table);
            }
            if (null == (column = primary.getColumn(col = row.getString("COLUMN_NAME")))) {
                column = new Column(col);
            }
            column.setTable(table);
            column.setPosition(row.getInt("POSITION", Integer.valueOf(0)));
            primary.addColumn(column);
        }
        return primary;
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT UC.CONSTRAINT_NAME, UC.TABLE_NAME, KCU.COLUMN_NAME, UC.R_CONSTRAINT_NAME, RC.TABLE_NAME AS REFERENCED_TABLE_NAME, RCC.COLUMN_NAME AS REFERENCED_COLUMN_NAME, RCC.POSITION AS ORDINAL_POSITION\n");
        builder.append("FROM USER_CONSTRAINTS UC \n");
        builder.append("JOIN USER_CONS_COLUMNS KCU ON UC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME \n");
        builder.append("JOIN USER_CONSTRAINTS RC ON UC.R_CONSTRAINT_NAME = RC.CONSTRAINT_NAME \n");
        builder.append("JOIN USER_CONS_COLUMNS RCC ON RC.CONSTRAINT_NAME = RCC.CONSTRAINT_NAME AND KCU.POSITION = RCC.POSITION");
        if (null != table) {
            if (BasicUtil.isNotEmpty((Object)table.getCatalog())) {
                builder.append(" AND OWNER = '").append(table.getCatalog()).append("'\n");
            }
            builder.append(" AND UC.TABLE_NAME = '").append(table.getName()).append("'\n");
        }
        return runs;
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (null == foreigns) {
            foreigns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            ForeignKey foreign = (ForeignKey)foreigns.get(name.toUpperCase());
            if (null == foreign) {
                foreign = new ForeignKey();
                foreign.setName(name);
                foreign.setTable(row.getString("TABLE_NAME"));
                foreign.setReference(row.getString("REFERENCED_TABLE_NAME"));
                foreigns.put(name.toUpperCase(), foreign);
            }
            foreign.addColumn(new Column(row.getString("COLUMN_NAME")).setReference(row.getString("REFERENCED_COLUMN_NAME")).setPosition(row.getInt("ORDINAL_POSITION", Integer.valueOf(0))));
        }
        return foreigns;
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAddRun(runtime, index);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildAlterRun(runtime, index);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = index.getTable(true);
        if (index.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, table);
            builder.append(" DROP CONSTRAINT ").append(index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
        }
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        return super.buildRenameRun(runtime, index);
    }

    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
        super.comment(runtime, builder, index);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAddRun(runtime, constraint);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildAlterRun(runtime, constraint);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildDropRun(runtime, constraint);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        return super.buildRenameRun(runtime, constraint);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildCreateRun(runtime, trigger);
    }

    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        super.each(runtime, builder, trigger);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildAlterRun(runtime, trigger);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildDropRun(runtime, trigger);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return super.buildRenameRun(runtime, trigger);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildCreateRun(runtime, procedure);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildAlterRun(runtime, procedure);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildDropRun(runtime, procedure);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildRenameRun(runtime, procedure);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildCreateRun(runtime, function);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildAlterRun(runtime, function);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildDropRun(runtime, function);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        return super.buildRenameRun(runtime, function);
    }

    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        return super.isBooleanColumn(runtime, column);
    }

    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        return super.isNumberColumn(runtime, column);
    }

    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return super.isCharColumn(runtime, column);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "sysdate";
        }
        return null;
    }
}

