/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.dm;

import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.entity.Column;
import org.anyline.data.entity.Constraint;
import org.anyline.data.entity.Index;
import org.anyline.data.entity.MasterTable;
import org.anyline.data.entity.PartitionTable;
import org.anyline.data.entity.Table;
import org.anyline.data.entity.Tag;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.SQLAdapter;
import org.anyline.data.run.Run;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DateUtil;
import org.anyline.util.EntityAdapterProxy;
import org.anyline.util.SQLUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.dm")
public class DMAdapter
extends SQLAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.jdbc.delimiter.dm:}")
    private String delimiter;

    public JDBCAdapter.DB_TYPE type() {
        return JDBCAdapter.DB_TYPE.DM;
    }

    public DMAdapter() {
        this.delimiterFr = "\"";
        this.delimiterTo = "\"";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String parseFinalQuery(Run run) {
        PageNavi navi;
        OrderStore orders;
        String sql = run.getBaseQuery();
        String cols = run.getQueryColumns();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = sql.replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            int limit = navi.getLastRow() - navi.getFirstRow() + 1;
            if (limit < 0) {
                limit = 0;
            }
            sql = sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public String concat(String ... args) {
        return this.concatOr(args);
    }

    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        return super.tables(index, create, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, Table> tables(boolean create, LinkedHashMap<String, Table> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.tables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryMasterTableRunSQL(catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(boolean create, LinkedHashMap<String, MasterTable> tables, DatabaseMetaData dbmd, String catalog, String schema, String pattern, String ... types) throws Exception {
        return super.mtables(create, tables, dbmd, catalog, schema, pattern, types);
    }

    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        return super.mtables(index, create, catalog, schema, tables, set);
    }

    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        return super.buildQueryPartitionTableRunSQL(catalog, schema, pattern, types);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags, name);
    }

    public List<String> buildQueryPartitionTableRunSQL(MasterTable master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTableRunSQL(master, tags);
    }

    public LinkedHashMap<String, PartitionTable> ptables(int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        return super.ptables(total, index, create, master, catalog, schema, tables, set);
    }

    public LinkedHashMap<String, PartitionTable> ptables(boolean create, LinkedHashMap<String, PartitionTable> tables, DatabaseMetaData dbmd, String catalog, String schema, MasterTable master) throws Exception {
        return super.ptables(create, tables, dbmd, catalog, schema, master);
    }

    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryColumnRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set) throws Exception {
        return super.columns(index, create, table, columns, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, Table table, SqlRowSet set) throws Exception {
        return super.columns(create, columns, table, set);
    }

    public LinkedHashMap<String, Column> columns(boolean create, LinkedHashMap<String, Column> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.columns(create, columns, dbmd, table, pattern);
    }

    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryTagRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        return super.tags(index, create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        return super.tags(create, table, tags, set);
    }

    public LinkedHashMap<String, Tag> tags(boolean create, LinkedHashMap<String, Tag> tags, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        return super.tags(create, tags, dbmd, table, pattern);
    }

    public List<String> buildQueryIndexRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryIndexRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        return super.indexs(index, create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        return super.indexs(create, table, indexs, set);
    }

    public LinkedHashMap<String, Index> indexs(boolean create, LinkedHashMap<String, Index> indexs, DatabaseMetaData dbmd, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(create, indexs, dbmd, table, unique, approximate);
    }

    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        return super.buildQueryConstraintRunSQL(table, metadata);
    }

    public LinkedHashMap<String, Constraint> constraints(int index, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        return super.constraints(index, create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        return super.constraints(create, table, constraints, set);
    }

    public List<String> buildCreateRunSQL(Table table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public String buildCreateCommentRunSQL(Table table) throws Exception {
        return super.buildCreateCommentRunSQL(table);
    }

    public List<String> buildAlterRunSQL(Table table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildRenameRunSQL(Table table) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" RENAME TO ");
        this.name(builder, table.getUpdate());
        return builder.toString();
    }

    public String buildChangeCommentRunSQL(Table table) throws Exception {
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            StringBuilder builder = new StringBuilder();
            builder.append("COMMENT ON TABLE ");
            this.name(builder, table);
            builder.append(" IS '").append(comment).append("'");
            return builder.toString();
        }
        return null;
    }

    public String buildDropRunSQL(Table table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        return builder;
    }

    public StringBuilder primary(StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",CONSTRAINT ").append("PK_").append(table.getName()).append(" PRIMARY KEY (");
            int idx = 0;
            for (Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder comment(StringBuilder builder, Table table) {
        return super.comment(builder, table);
    }

    public StringBuilder name(StringBuilder builder, Table table) {
        return super.name(builder, table);
    }

    public List<String> buildCreateRunSQL(MasterTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(MasterTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(MasterTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(MasterTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public List<String> buildCreateRunSQL(PartitionTable table) throws Exception {
        return super.buildCreateRunSQL(table);
    }

    public List<String> buildAlterRunSQL(PartitionTable table) throws Exception {
        return super.buildAlterRunSQL(table);
    }

    public String buildDropRunSQL(PartitionTable table) throws Exception {
        return super.buildDropRunSQL(table);
    }

    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        return super.buildRenameRunSQL(table);
    }

    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        return super.buildChangeCommentRunSQL(table);
    }

    public String alterColumnKeyword() {
        return "ALTER";
    }

    public String buildAddRunSQL(Column column) throws Exception {
        column.setCreater((JDBCAdapter)this);
        StringBuilder builder = new StringBuilder();
        Table table = column.getTable();
        builder.append("ALTER TABLE ");
        this.name(builder, table);
        builder.append(" ADD ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, column);
        return builder.toString();
    }

    public List<String> buildAlterRunSQL(Column column) throws Exception {
        return super.buildAlterRunSQL(column);
    }

    public String buildDropRunSQL(Column column) throws Exception {
        return super.buildDropRunSQL(column);
    }

    public String buildRenameRunSQL(Column column) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable());
        builder.append(" RENAME COLUMN ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getNewName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        Column update = column.getUpdate();
        String name = column.getName();
        String type = column.getTypeName();
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf("("));
        }
        String uname = update.getName();
        String utype = update.getTypeName();
        if (uname.endsWith("_TMP_UPDATE_TYPE")) {
            sqls.add(this.buildDropRunSQL(update));
        } else {
            if (utype != null && utype.contains("(")) {
                utype = utype.substring(0, utype.indexOf("("));
            }
            if (!type.equals(utype)) {
                String tmp_name = column.getName() + "_TMP_UPDATE_TYPE";
                update.setName(tmp_name);
                String rename = this.buildRenameRunSQL(column);
                sqls.add(rename);
                update.setName(uname);
                String add = this.buildAddRunSQL(update);
                sqls.add(add);
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                this.name(builder, column.getTable());
                builder.append(" SET ");
                SQLUtil.delimiter((StringBuilder)builder, (String)uname, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                builder.append(" = ");
                SQLUtil.delimiter((StringBuilder)builder, (String)tmp_name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                sqls.add(builder.toString());
                column.setName(tmp_name);
                String drop = this.buildDropRunSQL(column);
                sqls.add(drop);
                column.setName(name);
                update.setName(tmp_name);
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                this.name(builder, column.getTable());
                builder.append(" MODIFY(");
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.type(builder, column.getUpdate());
                builder.append(")");
                sqls.add(builder.toString());
            }
        }
        return sqls;
    }

    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        Object def = column.getDefaultValue();
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ");
        this.name(builder, column.getTable()).append(" MODIFY ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" DEFAULT ");
        if (null != def) {
            this.format(builder, def);
        } else {
            builder.append("NULL");
        }
        return builder.toString();
    }

    public String buildChangeNullableRunSQL(Column column) throws Exception {
        int nullable = column.isNullable();
        int uNullable = column.getUpdate().isNullable();
        if (nullable != -1 && uNullable != -1) {
            if (nullable == uNullable) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            this.name(builder, column.getTable()).append(" MODIFY ");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            if (uNullable == 0) {
                builder.append(" NOT ");
            }
            builder.append("NULL");
            return builder.toString();
        }
        return null;
    }

    public String buildChangeCommentRunSQL(Column column) throws Exception {
        String comment = column.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            StringBuilder builder = new StringBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(builder, column.getTable()).append(".");
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            builder.append(" IS '").append(comment).append("'");
            return builder.toString();
        }
        return null;
    }

    public StringBuilder define(StringBuilder builder, Column column) {
        return super.define(builder, column);
    }

    public StringBuilder type(StringBuilder builder, Column column) {
        return super.type(builder, column);
    }

    public StringBuilder nullable(StringBuilder builder, Column column) {
        return super.nullable(builder, column);
    }

    public StringBuilder charset(StringBuilder builder, Column column) {
        return super.charset(builder, column);
    }

    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        return super.defaultValue(builder, column);
    }

    public StringBuilder increment(StringBuilder builder, Column column) {
        if (column.isAutoIncrement() == 1) {
            builder.append(" IDENTITY(").append(column.getIncrementSeed()).append(",").append(column.getIncrementStep()).append(")");
        }
        return builder;
    }

    public StringBuilder onupdate(StringBuilder builder, Column column) {
        return super.onupdate(builder, column);
    }

    public StringBuilder position(StringBuilder builder, Column column) {
        return super.position(builder, column);
    }

    public StringBuilder comment(StringBuilder builder, Column column) {
        return super.comment(builder, column);
    }

    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        return super.checkColumnExists(builder, exists);
    }

    public String buildAddRunSQL(Tag tag) throws Exception {
        return super.buildAddRunSQL(tag);
    }

    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        return super.buildAlterRunSQL(tag);
    }

    public String buildDropRunSQL(Tag tag) throws Exception {
        return super.buildDropRunSQL(tag);
    }

    public String buildRenameRunSQL(Tag tag) throws Exception {
        return super.buildRenameRunSQL(tag);
    }

    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        return super.buildChangeDefaultRunSQL(tag);
    }

    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        return super.buildChangeNullableRunSQL(tag);
    }

    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        return super.buildChangeCommentRunSQL(tag);
    }

    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        return super.buildChangeTypeRunSQL(tag);
    }

    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        return super.checkTagExists(builder, exists);
    }

    public String buildAddRunSQL(Index index) throws Exception {
        return super.buildAddRunSQL(index);
    }

    public List<String> buildAlterRunSQL(Index index) throws Exception {
        return super.buildAlterRunSQL(index);
    }

    public String buildDropRunSQL(Index index) throws Exception {
        return super.buildDropRunSQL(index);
    }

    public String buildRenameRunSQL(Index index) throws Exception {
        return super.buildRenameRunSQL(index);
    }

    public String buildAddRunSQL(Constraint constraint) throws Exception {
        return super.buildAddRunSQL(constraint);
    }

    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        return super.buildAlterRunSQL(constraint);
    }

    public String buildDropRunSQL(Constraint constraint) throws Exception {
        return super.buildDropRunSQL(constraint);
    }

    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        return super.buildRenameRunSQL(constraint);
    }

    public boolean isBooleanColumn(Column column) {
        return super.isBooleanColumn(column);
    }

    public boolean isNumberColumn(Column column) {
        return super.isNumberColumn(column);
    }

    public boolean isCharColumn(Column column) {
        return super.isCharColumn(column);
    }

    public String buildInValue(JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == JDBCAdapter.SQL_BUILD_IN_VALUE.CURRENT_TIME) {
            return "sysdate";
        }
        return null;
    }

    public String type2type(String type) {
        if (null != type) {
            if ("DATETIME".equals(type = type.toUpperCase())) {
                return "TIMESTAMP";
            }
            if ("DOUBLE".equals(type)) {
                return "DECIMAL";
            }
        }
        return super.type2type(type);
    }

    public String type2class(String type) {
        return super.type2class(type);
    }

    public void value(StringBuilder builder, Object obj, String key) {
        Object value = null;
        if (obj instanceof DataRow) {
            value = ((DataRow)obj).get(key);
        } else if (EntityAdapterProxy.hasAdapter()) {
            Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
            value = BeanUtil.getFieldValue((Object)obj, (Field)field);
        } else {
            value = BeanUtil.getFieldValue((Object)obj, (String)key);
        }
        if (null == value || "NULL".equals(value)) {
            builder.append("null");
        } else if (value instanceof String) {
            this.format(builder, value);
        } else if (value instanceof Timestamp || value instanceof java.util.Date || value instanceof Date || value instanceof LocalDate || value instanceof LocalTime || value instanceof LocalDateTime) {
            try {
                java.util.Date date = DateUtil.parse((Object)value);
                builder.append("TO_DATE('").append(DateUtil.format((java.util.Date)date, (String)"yyyy-MM-dd HH:mm:ss")).append("','yyyy-mm-dd hh24:mi:ss')");
            }
            catch (Exception e) {
                builder.append("null");
                e.printStackTrace();
            }
        } else if (value instanceof java.util.Date) {
            builder.append("TO_DATE('").append(DateUtil.format((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd HH:mm:ss")).append("','yyyy-mm-dd hh24:mi:ss')");
        } else if (value instanceof Number || value instanceof Boolean) {
            builder.append(value);
        } else {
            builder.append(value);
        }
    }
}

