/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.clickhouse;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.anyline.adapter.DataWriter;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.DateUtil;

public enum ClickhouseWriter {
    DateWriter(new Object[]{java.sql.Date.class, Timestamp.class, Date.class, LocalDate.class, LocalDateTime.class}, new DataWriter(){

        public Object write(Object value, boolean placeholder, TypeMetadata type) {
            if (!placeholder && null != value) {
                Date date = (Date)ConvertProxy.convert((Object)value, Date.class, (boolean)false);
                TypeMetadata.CATEGORY category = null;
                if (null != type) {
                    category = type.getCategory();
                }
                if (category == TypeMetadata.CATEGORY.DATE) {
                    value = " toDate('" + DateUtil.format((Date)date) + "')";
                } else if (category == TypeMetadata.CATEGORY.DATETIME) {
                    value = " toDateTime('" + DateUtil.format((Date)date) + "')";
                }
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private ClickhouseWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

