/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.cassandra;

import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.adapter.init.DefaultJDBCAdapter;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataSet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Database;
import org.anyline.metadata.type.DatabaseType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.jdbc.adapter.cassandra")
public class CassandraAdapter
extends DefaultJDBCAdapter
implements JDBCAdapter,
InitializingBean {
    @Value(value="${anyline.data.jdbc.delimiter.cassandra:}")
    private String delimiter;

    public DatabaseType type() {
        return DatabaseType.Cassandra;
    }

    public CassandraAdapter() {
        this.delimiterFr = "";
        this.delimiterTo = "";
    }

    public void afterPropertiesSet() {
        this.setDelimiter(this.delimiter);
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        Object sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = ((String)sql).replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = (String)sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = (String)sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = ((String)sql).replaceAll("WHERE\\s*1=1\\s*AND", "WHERE");
        return sql;
    }

    public List<Run> buildQueryDatabaseRun(DataRuntime runtime, boolean greedy) throws Exception {
        return null;
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        return null;
    }

    public String concat(DataRuntime runtime, String ... args) {
        return this.concatFun(runtime, args);
    }
}

