/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.graph.adapter.init;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.init.AbstractDriverAdapter;
import org.anyline.data.handler.DataHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.AutoPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.run.ProcedureRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.Join;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.SQLException;
import org.anyline.exception.SQLQueryException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.adapter.ColumnMetadataAdapter;
import org.anyline.metadata.adapter.IndexMetadataAdapter;
import org.anyline.metadata.adapter.PrimaryMetadataAdapter;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;

public abstract class AbstractGraphAdapter
extends AbstractDriverAdapter {
    private static Map<Type, String> types = new HashMap<Type, String>();

    public DatabaseType type() {
        return DatabaseType.COMMON;
    }

    public boolean supportCatalog() {
        return true;
    }

    public boolean supportSchema() {
        return true;
    }

    public String name(Type type) {
        return types.get(type);
    }

    public boolean match(DataRuntime runtime, boolean compensate) {
        return super.match(runtime, compensate);
    }

    public boolean match(String feature, List<String> keywords, boolean compensate) {
        return super.match(feature, keywords, compensate);
    }

    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        Run run = null;
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDest(null, (Object)obj, (ConfigStore)configs);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (!list.isEmpty()) {
                run = this.createInsertRunFromCollection(runtime, batch, dest, list, configs, columns);
            }
            run.setRows((long)list.size());
        } else {
            run = this.createInsertRun(runtime, dest, obj, configs, columns);
            run.setRows(1L);
        }
        this.convert(runtime, configs, run);
        return run;
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        super.fillInsertContent(runtime, run, dest, set, configs, columns);
    }

    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        StringBuilder builder = run.getBuilder();
        int batch = run.getBatch();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        this.checkName(runtime, null, dest);
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, configs, columns);
            return;
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        Object entity = list.iterator().next();
        List pks = null;
        if (null != generator) {
            columns.putAll(EntityAdapterProxy.primaryKeys(entity.getClass()));
        }
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (Metadata)dest);
        builder.append("(");
        this.delimiter(builder, Column.names(columns));
        builder.append(") VALUES ");
        int dataSize = list.size();
        int idx = 0;
        if (batch > 1) {
            builder.append("(");
            int size = columns.size();
            run.setVol(size);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append("?");
            }
            builder.append(")");
        }
        for (Object obj : list) {
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, (List)Column.names(columns));
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            builder.append(this.insertValue(runtime, run, obj, true, true, false, true, columns));
            if (idx < dataSize - 1 && batch <= 1) {
                builder.append(this.batchInsertSeparator());
            }
            ++idx;
        }
        builder.append(this.insertFoot(configs, columns));
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    public String batchInsertSeparator() {
        return ",";
    }

    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        this.checkName(runtime, null, dest);
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        int from = 1;
        StringBuilder valuesBuilder = new StringBuilder();
        DataRow row = null;
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow((Map)obj);
        }
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), row.getPrimaryKeys(), null);
            }
        } else {
            from = 2;
            boolean create = EntityAdapterProxy.createPrimaryValue((Object)obj, columns);
            LinkedHashMap pks = EntityAdapterProxy.primaryKeys(obj.getClass());
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
        }
        run.setFrom(from);
        LinkedHashMap<String, Column> cols = this.confirmInsertColumns(runtime, dest, obj, configs, columns, false);
        if (null == cols || cols.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + obj.getClass().getName() + ":" + BeanUtil.object2json((Object)obj) + "]");
        }
        boolean replaceEmptyNull = false;
        if (obj instanceof DataRow) {
            row = (DataRow)obj;
            replaceEmptyNull = row.isReplaceEmptyNull();
        } else {
            replaceEmptyNull = ConfigStore.IS_REPLACE_EMPTY_NULL((ConfigStore)configs);
        }
        String head = this.insertHead(configs);
        builder.append(head);
        this.name(runtime, builder, (Metadata)dest);
        builder.append("(");
        valuesBuilder.append(") VALUES (");
        ArrayList<String> insertColumns = new ArrayList<String>();
        boolean first = true;
        for (Column column : cols.values()) {
            if (!first) {
                builder.append(",");
                valuesBuilder.append(",");
            }
            first = false;
            String key = column.getName();
            Object value = null;
            value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
            String str = null;
            if (value instanceof String) {
                str = (String)value;
            }
            this.delimiter(builder, key);
            if (BasicUtil.checkEl((String)str)) {
                value = str.substring(2, str.length() - 1);
                valuesBuilder.append(value);
                continue;
            }
            if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                value = this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)value);
                valuesBuilder.append(value);
                continue;
            }
            insertColumns.add(key);
            if (this.supportInsertPlaceholder()) {
                valuesBuilder.append("?");
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, column, value);
                continue;
            }
            valuesBuilder.append(this.write(runtime, null, value, false));
        }
        valuesBuilder.append(")");
        builder.append((CharSequence)valuesBuilder);
        builder.append(this.insertFoot(configs, cols));
        run.setBuilder(builder);
        run.setInsertColumns(insertColumns);
        return run;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, List<String> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setBatch(batch);
        if (null == list || list.isEmpty()) {
            throw new SQLException("\u7a7a\u6570\u636e");
        }
        Object first = list.iterator().next();
        if (BasicUtil.isEmpty((Object)dest)) {
            throw new SQLException("\u672a\u6307\u5b9a\u8868");
        }
        LinkedHashMap<String, Column> cols = this.confirmInsertColumns(runtime, dest, first, configs, columns, true);
        if (null == cols || cols.size() == 0) {
            throw new SQLException("\u672a\u6307\u5b9a\u5217(DataRow\u6216Entity\u4e2d\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u5c5e\u6027\u503c)[" + first.getClass().getName() + ":" + BeanUtil.object2json(first) + "]");
        }
        run.setInsertColumns(cols);
        run.setVol(cols.size());
        this.fillInsertContent(runtime, (Run)run, dest, list, configs, cols);
        return run;
    }

    public String generatedKey() {
        return super.generatedKey();
    }

    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt;
        block19: {
            cnt = 0L;
            int batch = run.getBatch();
            String action = "insert";
            if (batch > 1) {
                action = "batch insert";
            }
            if (!run.isValid()) {
                if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                    log.warn("[valid:false][action:{}][table:{}][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]", (Object)action, (Object)run.getTableName());
                }
                return -1L;
            }
            String sql = run.getFinalInsert();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][action:{}][table:{}]", (Object)action, (Object)run.getTable());
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List values = run.getValues();
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                if (batch > 1 && !ConfigStore.IS_LOG_BATCH_SQL_PARAM((ConfigStore)configs)) {
                    log.info("{}[action:{}][table:{}][cmd:\n{}\n]\n[param size:{}]", new Object[]{random, action, run.getTable(), sql, values.size()});
                } else {
                    log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                }
            }
            long millis = -1L;
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            try {
                if (batch > 1) {
                    // empty if block
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL((ConfigStore)configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, action, run.getTable(), millis, run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.INSERT, run, sql, values, null, true, (Object)cnt, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
                    String qty = LogUtil.format((long)cnt, (int)34);
                    if (batch > 1) {
                        qty = LogUtil.format((String)("\u7ea6" + cnt), (int)34);
                    }
                    log.info("{}[action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), millis, qty});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                    e.printStackTrace();
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR((ConfigStore)configs)) {
                    log.error("{}[{}][action:{}][table:{}]{}", new Object[]{random, LogUtil.format((String)"\u63d2\u5165\u5f02\u5e38:", (int)33) + e, action, run.getTable(), run.log(ACTION.DML.INSERT, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION((ConfigStore)configs)) break block19;
                SQLUpdateException ex = new SQLUpdateException("insert\u5f02\u5e38:" + e.toString(), e);
                ex.setCmd(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return cnt;
    }

    public String insertHead(ConfigStore configs) {
        return "INSERT INTO ";
    }

    public String insertFoot(ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return "";
    }

    public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, columns);
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, columns);
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, columns);
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, columns);
    }

    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return null;
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) {
        long result;
        block19: {
            result = 0L;
            if (!run.isValid()) {
                if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
                }
                return -1L;
            }
            String sql = null;
            sql = run.getFinalUpdate();
            if (BasicUtil.isEmpty((Object)sql)) {
                log.warn("[\u4e0d\u5177\u5907\u66f4\u65b0\u6761\u4ef6][dest:{}]", (Object)dest);
                return -1L;
            }
            if (null != configs) {
                configs.add(run);
            }
            List values = run.getValues();
            int batch = run.getBatch();
            String action = "update";
            if (batch > 1) {
                action = "batch update";
            }
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                if (batch > 1 && !ConfigStore.IS_LOG_BATCH_SQL_PARAM((ConfigStore)configs)) {
                    log.info("{}[action:{}][table:{}]{}", new Object[]{random, action, run.getTable(), run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                } else {
                    log.info("{}[action:update][table:{}]{}", new Object[]{random, run.getTable(), run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                }
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                if (batch > 1) {
                    // empty if block
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL((ConfigStore)configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, action, run.getTable(), millis, run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.UPDATE, run, sql, values, null, true, (Object)result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
                    String qty = "" + result;
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][table:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, run.getTable(), millis, LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                    e.printStackTrace();
                }
                if (ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION((ConfigStore)configs)) {
                    SQLUpdateException ex = new SQLUpdateException("update\u5f02\u5e38:" + e.toString(), e);
                    ex.setCmd(sql);
                    ex.setValues(values);
                    throw ex;
                }
                if (!ConfigStore.IS_LOG_SQL_WHEN_ERROR((ConfigStore)configs)) break block19;
                log.error("{}[{}][action:update][table:{}]{}", new Object[]{random, run.getTable(), LogUtil.format((String)"\u66f4\u65b0\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.UPDATE, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
            }
        }
        return result;
    }

    public long save(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    protected Boolean checkOverride(Object obj) {
        return super.checkOverride(obj);
    }

    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        DataSet set;
        block11: {
            set = null;
            List inputs = procedure.getInputs();
            List outputs = procedure.getOutputs();
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][cmd:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            String rdm = random;
            long millis = -1L;
            try {
                ACTION.SWITCH swt = InterceptorProxy.prepareQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                swt = InterceptorProxy.beforeQuery((DataRuntime)runtime, (String)random, (Procedure)procedure, (PageNavi)navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, procedure);
                }
                DataRuntime rt = runtime;
                long fr = System.currentTimeMillis();
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigTable.SLOW_SQL_MILLIS;
                if (SLOW_SQL_MILLIS > 0L && ConfigTable.IS_LOG_SLOW_SQL && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}ms][cmd:\n{}\n][input param:{}]\n[output param:{}]", new Object[]{random, millis, procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, procedure.getName(), inputs, outputs, true, set, millis);
                    }
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)millis);
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                    SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block11;
                log.error("{}[{}][action:procedure][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), procedure.getName(), LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return set;
    }

    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, conditions);
    }

    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        return super.buildQuerySequence(runtime, next, names);
    }

    public void fillQueryContent(DataRuntime runtime, Run run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        super.fillQueryContent(runtime, run);
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        StringBuilder builder = run.getBuilder();
        this.fillQueryContent(runtime, builder, run);
        List unions = run.getUnions();
        if (null != unions) {
            for (Run union : unions) {
                builder.append("\n UNION ");
                if (union.isUnionAll()) {
                    builder.append(" ALL ");
                }
                builder.append("\n");
                this.fillQueryContent(runtime, builder, union);
            }
        }
        run.appendOrderStore();
        run.checkValid();
    }

    protected void fillQueryContent(DataRuntime runtime, StringBuilder builder, TableRun run) {
        ConfigStore configs;
        TablePrepare sql = (TablePrepare)run.getPrepare();
        builder.append("SELECT ");
        if (null != sql.getDistinct()) {
            builder.append(sql.getDistinct());
        }
        builder.append("\n\t");
        LinkedHashMap<String, Column> columns = sql.getColumns();
        if ((null == columns || columns.isEmpty()) && null != (configs = run.getConfigs())) {
            List cols = configs.columns();
            columns = new LinkedHashMap<String, Column>();
            Iterator iterator = cols.iterator();
            while (iterator.hasNext()) {
                String col = (String)iterator.next();
                columns.put(col.toUpperCase(), new Column(col));
            }
        }
        if (null != columns && !columns.isEmpty()) {
            boolean first = true;
            for (Column column : columns.values()) {
                if (BasicUtil.isEmpty((Object)column) || BasicUtil.isEmpty((Object)column.getName())) continue;
                if (!first) {
                    builder.append(",");
                }
                first = false;
                String name = column.getName();
                if (BasicUtil.checkEl((String)name)) {
                    name = name.substring(2, name.length() - 1);
                    builder.append(column);
                    continue;
                }
                if (name.contains("(") || name.contains(",")) {
                    builder.append(name);
                    continue;
                }
                if (name.toUpperCase().contains(" AS ")) {
                    int split = name.toUpperCase().indexOf(" AS ");
                    String tmp = name.substring(0, split).trim();
                    this.delimiter(builder, tmp);
                    builder.append(" ");
                    tmp = name.substring(split + 4).trim();
                    this.delimiter(builder, tmp);
                    continue;
                }
                if ("*".equals(name)) {
                    builder.append("*");
                    continue;
                }
                this.delimiter(builder, name);
            }
            builder.append("\n");
        } else {
            builder.append("*");
            builder.append("\n");
        }
        Table table = run.getTable();
        builder.append("FROM").append("\n\t");
        this.name(runtime, builder, (Metadata)table);
        String alias = table.getAlias();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(" ");
            this.delimiter(builder, alias);
        }
        builder.append("\n");
        List joins = sql.getJoins();
        if (null != joins) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                Table joinTable = join.getTable();
                String joinTableAlias = joinTable.getAlias();
                this.name(runtime, builder, (Metadata)joinTable);
                if (BasicUtil.isNotEmpty((Object)joinTableAlias)) {
                    builder.append("  ");
                    this.delimiter(builder, joinTableAlias);
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        run.appendCondition((DriverAdapter)this, true, false);
        run.appendGroup();
    }

    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.mergeFinalQuery(runtime, run);
    }

    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder) {
        int code = compare.getCode();
        if (code > 100) {
            builder.append(" NOT");
            code -= 100;
        }
        if (code == 50) {
            builder.append(" LIKE ").append(this.concat(runtime, "'%'", "?", "'%'"));
        } else if (code == 51) {
            builder.append(" LIKE ").append(this.concat(runtime, "?", "'%'"));
        } else if (code == 52) {
            builder.append(" LIKE ").append(this.concat(runtime, "'%'", "?"));
        }
        RunValue run = new RunValue();
        run.setValue(value);
        return run;
    }

    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, boolean placeholder) {
        return super.createConditionFindInSet(runtime, builder, column, compare, value, placeholder);
    }

    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, boolean placeholder) {
        if (compare == Compare.NOT_IN) {
            builder.append(" NOT");
        }
        builder.append(" IN (");
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                builder.append("?");
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append(")");
        } else {
            builder.append("= ?");
        }
        return builder;
    }

    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        if (run instanceof ProcedureRun) {
            ProcedureRun pr = (ProcedureRun)run;
            return this.querys(runtime, random, pr.getProcedure(), configs.getPageNavi());
        }
        String cmd = run.getFinalQuery();
        if (BasicUtil.isEmpty((Object)cmd)) {
            return new DataSet().setTable(table);
        }
        List values = run.getValues();
        return this.select(runtime, random, system, ACTION.DML.SELECT, table, configs, run, cmd, values);
    }

    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        List<Map<String, Object>> maps;
        block17: {
            maps = null;
            if (null == random) {
                random = this.random(runtime);
            }
            if (null != configs) {
                configs.add(run);
            }
            String sql = run.getFinalQuery();
            List values = run.getValues();
            if (BasicUtil.isEmpty((Object)sql)) {
                if (ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION((ConfigStore)configs)) {
                    throw new SQLQueryException("\u672a\u6307\u5b9a\u547d\u4ee4");
                }
                log.error("\u672a\u6307\u5b9a\u547d\u4ee4");
                return new ArrayList<Map<String, Object>>();
            }
            long fr = System.currentTimeMillis();
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                log.info("{}[action:select]{}", (Object)random, (Object)run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs)));
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return new ArrayList<Map<String, Object>>();
            }
            try {
                DataHandler handler;
                StreamHandler _handler = null;
                if (null != configs && (handler = configs.handler()) instanceof StreamHandler) {
                    _handler = (StreamHandler)handler;
                }
                long[] count = new long[]{0L};
                boolean[] process = new boolean[]{false};
                StreamHandler handler2 = _handler;
                long[] mid = new long[]{System.currentTimeMillis()};
                if (null != handler2) {
                    boolean keep = handler2.keep();
                    maps = new ArrayList<Map<String, Object>>();
                }
                boolean slow = false;
                if (ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs) > 0L && mid[0] - fr > ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs)) {
                    slow = true;
                    log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}ms]{}", new Object[]{random, mid[0] - fr, run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, maps, mid[0] - fr);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
                    log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms]", (Object)random, (Object)(mid[0] - fr));
                }
                maps = this.process(runtime, maps);
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
                    log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, System.currentTimeMillis() - mid[0], count[0]});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                    e.printStackTrace();
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR((ConfigStore)configs)) {
                    log.error("{}[{}][action:select]{}", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5f02\u5e38:", (int)33) + e.toString(), run.log(ACTION.DML.SELECT, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_QUERY_EXCEPTION((ConfigStore)configs)) break block17;
                SQLQueryException ex = new SQLQueryException("query\u5f02\u5e38:" + e.toString(), e);
                ex.setCmd(sql);
                ex.setValues(values);
                throw ex;
            }
        }
        return maps;
    }

    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        Map<String, Object> map = null;
        String sql = run.getFinalExists();
        List values = run.getValues();
        if (null != configs) {
            configs.add(run);
        }
        long fr = System.currentTimeMillis();
        if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
            log.info("{}[action:select]{}", (Object)random, (Object)run.log(ACTION.DML.EXISTS, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs)));
        }
        boolean exe = true;
        if (null != configs) {
            exe = configs.execute();
        }
        if (!exe) {
            return new HashMap<String, Object>();
        }
        Long millis = System.currentTimeMillis() - fr;
        boolean slow = false;
        long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs);
        if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL((ConfigStore)configs) && millis > SLOW_SQL_MILLIS) {
            slow = true;
            log.warn("{}[slow cmd][action:exists][\u6267\u884c\u8017\u65f6:{}ms][cmd:\n{}\n]\n[param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)values)});
            if (null != this.dmListener) {
                this.dmListener.slow(runtime, random, ACTION.DML.EXISTS, run, sql, values, null, true, map, millis.longValue());
            }
        }
        if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
            log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}ms][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, millis, LogUtil.format((int)(map == null ? 0 : 1), (int)34)});
        }
        return map;
    }

    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        List<Run> runs = this.buildQuerySequence(runtime, next, names);
        if (null != runs && !runs.isEmpty()) {
            Run run = runs.get(0);
            if (!run.isValid()) {
                if (ConfigTable.IS_LOG_SQL && log.isWarnEnabled()) {
                    log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][sequence:" + names);
                }
                return new DataRow();
            }
            DataSet set = this.select(runtime, random, true, (Table)null, null, run);
            if (!set.isEmpty()) {
                return set.getRow(0);
            }
        }
        return new DataRow();
    }

    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        String base = run.getBuilder().toString();
        StringBuilder builder = new StringBuilder();
        boolean simple = false;
        String upper = base.toUpperCase();
        if (upper.split("FROM").length == 2 && !upper.contains("DISTINCT") && !upper.contains("GROUP")) {
            simple = true;
        }
        if (simple) {
            int idx = base.toUpperCase().indexOf("FROM");
            builder.append("SELECT COUNT(*) AS CNT FROM ").append(base.substring(idx + 5));
        } else {
            builder.append("SELECT COUNT(*) AS CNT FROM (\n").append(base).append("\n) F");
        }
        String sql = builder.toString();
        sql = sql.replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    public long count(DataRuntime runtime, String random, Run run) {
        long total = 0L;
        DataSet set = this.select(runtime, random, false, ACTION.DML.COUNT, null, null, run, run.getTotalQuery(), run.getValues());
        total = ((DataSet)set.toUpperKey(new String[0])).getInt(0, "CNT", 0);
        return total;
    }

    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        boolean result = false;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        Run run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign((boolean)false, (boolean)false, (String)prepare.getTableName(), (ConfigStore)configs, (String[])conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return false;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeExists(runtime, random, run);
        }
        long fr = System.currentTimeMillis();
        Map<String, Object> map = this.map(runtime, random, configs, run);
        result = null == map ? false : BasicUtil.parseBoolean((Object)map.get("IS_EXISTS"), (Boolean)false);
        Long millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterExists(runtime, random, run, true, result, millis.longValue());
        }
        return result;
    }

    public String mergeFinalExists(DataRuntime runtime, Run run) {
        Object sql = "SELECT EXISTS(\n" + run.getBuilder().toString() + "\n)  IS_EXISTS";
        sql = ((String)sql).replaceAll("WHERE\\s*1=1\\s*AND", "WHERE ");
        return sql;
    }

    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        return super.execute(runtime, random, batch, configs, prepare, values);
    }

    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        boolean result;
        block11: {
            result = false;
            ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
            boolean cmd_success = false;
            ArrayList list = new ArrayList();
            List inputs = procedure.getInputs();
            List outputs = procedure.getOutputs();
            long fr = System.currentTimeMillis();
            Object sql = " {";
            boolean returnIndex = false;
            if (procedure.hasReturn()) {
                sql = (String)sql + "? = ";
                returnIndex = true;
            }
            sql = (String)sql + "call " + procedure.getName() + "(";
            int sizeIn = inputs.size();
            int sizeOut = outputs.size();
            int size = sizeIn + sizeOut;
            for (int i = 0; i < size; ++i) {
                sql = (String)sql + "?";
                if (i >= size - 1) continue;
                sql = (String)sql + ",";
            }
            sql = (String)sql + ")}";
            if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:procedure][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
            long millis = -1L;
            try {
                cmd_success = true;
                procedure.setResult(list);
                result = true;
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigTable.SLOW_SQL_MILLIS;
                if (SLOW_SQL_MILLIS > 0L && ConfigTable.IS_LOG_SLOW_SQL && millis > SLOW_SQL_MILLIS) {
                    log.warn("{}[slow cmd][action:procedure][\u6267\u884c\u8017\u65f6:{}ms][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, millis, sql, LogUtil.param((List)inputs), LogUtil.param(list)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.PROCEDURE, null, (String)sql, inputs, list, true, (Object)result, millis);
                    }
                }
                if (null != this.dmListener) {
                    this.dmListener.afterExecute(runtime, random, procedure, result, millis);
                }
                if (!slow && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[action:procedure][\u6267\u884c\u8017\u65f6:{}ms]\n[output param:{}]", new Object[]{random, millis, list});
                }
            }
            catch (Exception e) {
                result = false;
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    SQLUpdateException ex = new SQLUpdateException("execute\u5f02\u5e38:" + e.toString(), e);
                    ex.setCmd((String)sql);
                    throw ex;
                }
                if (!ConfigTable.IS_LOG_SQL_WHEN_ERROR) break block11;
                log.error("{}[{}][action:procedure][cmd:\n{}\n]\n[input param:{}]\n[output param:{}]", new Object[]{random, LogUtil.format((String)"\u5b58\u50a8\u8fc7\u7a0b\u6267\u884c\u5f02\u5e38:", (int)33) + e.toString(), sql, LogUtil.param((List)inputs), LogUtil.param((List)outputs)});
            }
        }
        return result;
    }

    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, conditions);
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        super.fillExecuteContent(runtime, run);
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        super.fillExecuteContent(runtime, run);
    }

    public void fillExecuteContent(DataRuntime runtime, Run run) {
        super.fillExecuteContent(runtime, run);
    }

    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result;
        block17: {
            result = -1L;
            if (null == random) {
                random = this.random(runtime);
            }
            String sql = run.getFinalExecute();
            List values = run.getValues();
            long fr = System.currentTimeMillis();
            int batch = run.getBatch();
            String action = "execute";
            if (batch > 1) {
                action = "batch execute";
            }
            if (log.isInfoEnabled() && ConfigStore.IS_LOG_SQL((ConfigStore)configs)) {
                if (batch > 1 && !ConfigStore.IS_LOG_BATCH_SQL_PARAM((ConfigStore)configs)) {
                    log.info("{}[action:{}][cmd:\n{}\n]\n[param size:{}]", new Object[]{random, action, sql, values.size()});
                } else {
                    log.info("{}[action:{}]{}", new Object[]{random, action, run.log(ACTION.DML.EXECUTE, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                }
            }
            if (null != configs) {
                configs.add(run);
            }
            boolean exe = true;
            if (null != configs) {
                exe = configs.execute();
            }
            if (!exe) {
                return -1L;
            }
            long millis = -1L;
            try {
                if (batch > 1) {
                    // empty if block
                }
                millis = System.currentTimeMillis() - fr;
                boolean slow = false;
                long SLOW_SQL_MILLIS = ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs);
                if (SLOW_SQL_MILLIS > 0L && ConfigStore.IS_LOG_SLOW_SQL((ConfigStore)configs) && millis > SLOW_SQL_MILLIS) {
                    slow = true;
                    log.warn("{}[slow cmd][action:{}][\u6267\u884c\u8017\u65f6:{}ms][cmd:\n{}\n]\n[param:{}]", new Object[]{random, action, millis, sql, LogUtil.param((List)values)});
                    if (null != this.dmListener) {
                        this.dmListener.slow(runtime, random, ACTION.DML.EXECUTE, run, sql, values, null, true, (Object)result, millis);
                    }
                }
                if (!slow && log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
                    String qty = "" + result;
                    if (batch > 1) {
                        qty = "\u7ea6" + result;
                    }
                    log.info("{}[action:{}][\u6267\u884c\u8017\u65f6:{}ms][\u5f71\u54cd\u884c\u6570:{}]", new Object[]{random, action, millis, LogUtil.format((String)qty, (int)34)});
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                    e.printStackTrace();
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR((ConfigStore)configs)) {
                    log.error("{}[{}][action:{}]{}", new Object[]{random, LogUtil.format((String)"\u547d\u4ee4\u6267\u884c\u5f02\u5e38:", (int)33) + e, action, run.log(ACTION.DML.EXECUTE, ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs))});
                }
                if (!ConfigStore.IS_THROW_SQL_UPDATE_EXCEPTION((ConfigStore)configs)) break block17;
                throw e;
            }
        }
        return result;
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, Table dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, Table table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    public Run buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, String ... columns) {
        return super.buildDeleteRun(runtime, dest, configs, obj, columns);
    }

    public Run buildDeleteRun(DataRuntime runtime, int batch, Table table, ConfigStore configs, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, configs, key, values);
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, Table table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        this.name(runtime, builder, (Metadata)table);
        return runs;
    }

    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, String key, Object values) {
        if (null == table || null == key || null == values) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        TableRun run = new TableRun(runtime, table);
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" WHERE ");
        if (values instanceof Collection) {
            Collection cons = (Collection)values;
            this.delimiter(builder, key);
            if (batch > 1) {
                builder.append(" = ?");
                ArrayList list = null;
                if (values instanceof List) {
                    list = (ArrayList)values;
                } else {
                    list = new ArrayList();
                    for (Object item : cons) {
                        list.add(item);
                    }
                }
                run.setValues(key, list);
                run.setVol(1);
                run.setBatch(batch);
            } else {
                if (cons.size() > 1) {
                    builder.append(" IN(");
                    int idx = 0;
                    for (Object obj : cons) {
                        if (idx > 0) {
                            builder.append(",");
                        }
                        builder.append("?");
                        ++idx;
                    }
                    builder.append(")");
                } else if (cons.size() == 1) {
                    for (Object obj : cons) {
                        builder.append("=?");
                    }
                } else {
                    throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
                }
                this.addRunValue(runtime, (Run)run, Compare.IN, new Column(key), values);
            }
        } else {
            this.delimiter(builder, key);
            builder.append("=?");
            this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(key), values);
        }
        run.setBuilder(builder);
        return run;
    }

    public Run buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, String ... columns) {
        TableRun run = new TableRun(runtime, table);
        run.setFrom(2);
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" WHERE ");
        List<String> keys = new ArrayList();
        if (null != columns && columns.length > 0) {
            for (String col : columns) {
                keys.add(col);
            }
        } else if (obj instanceof DataRow) {
            keys = ((DataRow)obj).getPrimaryKeys();
        } else {
            keys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        }
        int size = keys.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    builder.append("\nAND ");
                }
                String key = (String)keys.get(i);
                this.delimiter(builder, key).append(" = ? ");
                Object value = null;
                value = obj instanceof DataRow ? ((DataRow)obj).get(key) : (EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
                this.addRunValue(runtime, (Run)run, Compare.EQUAL, new Column(key), value);
            }
        } else {
            throw new SQLUpdateException("\u5220\u9664\u5f02\u5e38:\u5220\u9664\u6761\u4ef6\u4e3a\u7a7a,delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u6574\u8868\u64cd\u4f5c.");
        }
        run.setBuilder(builder);
        return run;
    }

    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            this.fillDeleteRunContent(runtime, r);
        }
    }

    protected void fillDeleteRunContent(DataRuntime runtime, TableRun run) {
        List joins;
        AutoPrepare prepare = (AutoPrepare)run.getPrepare();
        StringBuilder builder = run.getBuilder();
        builder.append("DELETE FROM ");
        this.name(runtime, builder, (Metadata)run.getTable());
        builder.append("\n");
        if (BasicUtil.isNotEmpty((Object)prepare.getAlias())) {
            builder.append("  ").append(prepare.getAlias());
        }
        if (null != (joins = prepare.getJoins())) {
            for (Join join : joins) {
                builder.append("\n\t").append(join.getType().getCode()).append(" ");
                Table joinTable = join.getTable();
                String jionTableAlias = joinTable.getAlias();
                this.name(runtime, builder, (Metadata)joinTable);
                if (BasicUtil.isNotEmpty((Object)jionTableAlias)) {
                    builder.append("  ").append(jionTableAlias);
                }
                builder.append(" ON ").append(join.getCondition());
            }
        }
        run.appendCondition((DriverAdapter)this, true, false);
        run.appendGroup();
        run.appendOrderStore();
        run.checkValid();
    }

    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.delete(runtime, random, configs, run);
    }

    public Database database(DataRuntime runtime, String random) {
        Catalog catalog = this.catalog(runtime, random);
        if (null != catalog) {
            return new Database(catalog.getName());
        }
        return super.database(runtime, random);
    }

    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    public List<Database> databases(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.databases(runtime, random, greedy, name);
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random, String name) {
        return super.databases(runtime, random, name);
    }

    public List<Run> buildQueryProductRun(DataRuntime runtime) throws Exception {
        return super.buildQueryProductRun(runtime);
    }

    public List<Run> buildQueryVersionRun(DataRuntime runtime) throws Exception {
        return super.buildQueryVersionRun(runtime);
    }

    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return super.buildQueryDatabasesRun(runtime, greedy, name);
    }

    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.databases(runtime, index, create, databases, catalog, schema, set);
    }

    public List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.databases(runtime, index, create, databases, catalog, schema, set);
    }

    public Database database(DataRuntime runtime, int index, boolean create, Database database, DataSet set) throws Exception {
        return super.database(runtime, index, create, database, set);
    }

    public Database database(DataRuntime runtime, boolean create, Database database) throws Exception {
        return super.database(runtime, create, database);
    }

    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    public String product(DataRuntime runtime, boolean create, String product) {
        return product;
    }

    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    public String version(DataRuntime runtime, boolean create, String version) {
        return version;
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, String random, String name) {
        return super.catalogs(runtime, random, name);
    }

    public List<Catalog> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        return super.catalogs(runtime, random, greedy, name);
    }

    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return super.buildQueryCatalogsRun(runtime, greedy, name);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, catalog, schema, set);
    }

    public List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, catalogs, catalog, schema, set);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    public List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs) throws Exception {
        return super.catalogs(runtime, create, catalogs);
    }

    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog catalog, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, catalog, set);
    }

    public Catalog catalog(DataRuntime runtime, boolean create, Catalog catalog) throws Exception {
        if (null == catalog) {
            Table table = new Table();
            this.checkSchema(runtime, (Metadata)table);
            catalog = table.getCatalog();
        }
        return catalog;
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        return super.schemas(runtime, random, catalog, name);
    }

    public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        return super.schemas(runtime, random, greedy, catalog, name);
    }

    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name) throws Exception {
        return super.buildQuerySchemasRun(runtime, greedy, catalog, name);
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, catalog, schema, set);
    }

    public List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, schemas, catalog, schema, set);
    }

    public Schema schema(DataRuntime runtime, int index, boolean create, Schema schema, DataSet set) throws Exception {
        return super.schema(runtime, index, create, schema, set);
    }

    public Schema schema(DataRuntime runtime, boolean create, Schema schema) throws Exception {
        if (null == schema) {
            Table table = new Table();
            this.checkSchema(runtime, (Metadata)table);
            schema = table.getSchema();
        }
        return schema;
    }

    public <T extends Metadata> T checkName(DataRuntime runtime, String random, T meta) throws RuntimeException {
        if (null == meta) {
            return null;
        }
        String name = meta.getName();
        if (null != name && name.contains(".")) {
            String[] ks = name.split("\\.");
            if (ks.length == 3) {
                meta.setCatalog(ks[0]);
                meta.setSchema(ks[1]);
                meta.setName(ks[2]);
            } else if (ks.length == 2) {
                meta.setSchema(ks[0]);
                meta.setName(ks[1]);
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u5b9e\u522bschema\u6216catalog(\u5b50\u7c7b\u672a" + ((Object)((Object)this)).getClass().getSimpleName() + "\u5b9e\u73b0)");
            }
        }
        return meta;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return super.tables(runtime, random, greedy, catalog, schema, pattern, types, struct);
    }

    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema) {
        super.tableMap(runtime, random, greedy, catalog, schema);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return super.tables(runtime, random, catalog, schema, pattern, types, struct);
    }

    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryTablesRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryTablesCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object table = null;
            table = this.init(runtime, index, (T)table, catalog, schema, row);
            table = this.detail(runtime, index, (T)table, catalog, schema, row);
            tables.put(table.getName().toUpperCase(), table);
        }
        return tables;
    }

    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        for (DataRow row : set) {
            T table = null;
            if (null == this.search(tables, (table = this.init(runtime, index, table, catalog, schema, row)).getCatalog(), table.getSchema(), table.getName())) {
                tables.add(table);
            }
            this.detail(runtime, index, table, catalog, schema, row);
        }
        return tables;
    }

    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends Table> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return meta;
    }

    public <T extends Table> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return meta;
    }

    protected void init(Table table, ResultSet set, Map<String, Integer> keys) {
    }

    protected void init(View view, ResultSet set, Map<String, Integer> keys) {
    }

    public List<String> ddl(DataRuntime runtime, String random, View view) {
        return super.ddl(runtime, random, view);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDdlsRun(runtime, view);
    }

    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return super.vertexTables(runtime, random, greedy, catalog, schema, pattern, types, struct);
    }

    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return super.vertexTables(runtime, random, catalog, schema, pattern, types, struct);
    }

    public List<Run> buildQueryVertexTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryVertexTablesRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryVertexTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryVertexTablesCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.vertexTables(runtime, index, create, tables, catalog, schema, set);
    }

    public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, int index, boolean create, List<T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.vertexTables(runtime, index, create, tables, catalog, schema, set);
    }

    public <T extends VertexTable> LinkedHashMap<String, T> vertexTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.vertexTables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends VertexTable> List<T> vertexTables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.vertexTables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends VertexTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.init(runtime, index, meta, catalog, schema, row);
    }

    public <T extends VertexTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.detail(runtime, index, meta, catalog, schema, row);
    }

    public List<String> ddl(DataRuntime runtime, String random, VertexTable meta, boolean init) {
        return super.ddl(runtime, random, meta, init);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, VertexTable meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, VertexTable meta, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, meta, ddls, set);
    }

    public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return super.edgeTables(runtime, random, greedy, catalog, schema, pattern, types, struct);
    }

    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return super.edgeTables(runtime, random, catalog, schema, pattern, types, struct);
    }

    public List<Run> buildQueryEdgeTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryEdgeTablesRun(runtime, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryEdgeTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryEdgeTablesCommentRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.edgeTables(runtime, index, create, tables, catalog, schema, set);
    }

    public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, int index, boolean create, List<T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.edgeTables(runtime, index, create, tables, catalog, schema, set);
    }

    public <T extends EdgeTable> LinkedHashMap<String, T> edgeTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.edgeTables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends EdgeTable> List<T> edgeTables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.edgeTables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public <T extends EdgeTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return (T)super.init(runtime, index, meta, catalog, schema, row);
    }

    public <T extends EdgeTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return (T)super.detail(runtime, index, meta, catalog, schema, row);
    }

    public List<String> ddl(DataRuntime runtime, String random, EdgeTable meta, boolean init) {
        return super.ddl(runtime, random, meta, init);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, EdgeTable meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, EdgeTable meta, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, meta, ddls, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return super.masterTables(runtime, random, greedy, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryMasterTablesRun(runtime, catalog, schema, pattern, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.masterTables(runtime, index, create, tables, catalog, schema, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masterTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.masterTables(runtime, create, tables, catalog, schema, pattern, types);
    }

    public List<String> ddl(DataRuntime runtime, String random, MasterTable table) {
        return super.ddl(runtime, random, table);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, MasterTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String pattern) {
        return super.partitionTables(runtime, random, greedy, master, tags, pattern);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, catalog, schema, pattern, types);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master, Map<String, Object> tags, String name) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master, tags, name);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master, Map<String, Object> tags) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master, tags);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, Table master) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, master);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.partitionTables(runtime, total, index, create, master, tables, catalog, schema, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> partitionTables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master) throws Exception {
        return super.partitionTables(runtime, create, tables, catalog, schema, master);
    }

    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlsRun(runtime, table);
    }

    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        if (!greedy) {
            this.checkSchema(runtime, (Metadata)table);
        }
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        LinkedHashMap columns = CacheProxy.columns((DriverAdapter)this, (String)runtime.getKey(), (Table)table);
        if (null != columns && !columns.isEmpty()) {
            return columns;
        }
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            block23: {
                int qty_total = 0;
                int qty_dialect = 0;
                boolean qty_metadata = false;
                boolean qty_jdbc = false;
                try {
                    List<Run> runs = this.buildQueryColumnsRun(runtime, table, false);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run);
                            columns = this.columns(runtime, idx, true, table, columns, set);
                            ++idx;
                        }
                    }
                    if (null != columns) {
                        qty_dialect = columns.size();
                        qty_total = columns.size();
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (primary) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block23;
                    log.warn("{}[columns][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
                }
            }
            if (ConfigTable.IS_METADATA_AUTO_CHECK_COLUMN_PRIMARY && (null != columns || !columns.isEmpty())) {
                LinkedHashMap pks;
                PrimaryKey pk;
                boolean exists = false;
                for (Column column : columns.values()) {
                    if (column.isPrimaryKey() == -1) continue;
                    exists = true;
                    break;
                }
                if (!exists && null != (pk = this.primary(runtime, random, false, table)) && null != (pks = pk.getColumns())) {
                    for (String k : pks.keySet()) {
                        Column column = (Column)columns.get(k);
                        if (null == column) continue;
                        column.primary(Boolean.valueOf(true));
                    }
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("{}[columns][result:fail][table:{}][msg:{}]", new Object[]{random, table, e.toString()});
        }
        if (null != columns) {
            CacheProxy.columns((DriverAdapter)this, (String)runtime.getKey(), (Table)table, columns);
        } else {
            columns = new LinkedHashMap();
        }
        int index = 0;
        for (Column column : columns.values()) {
            if (null == column.getPosition() || -1 == column.getPosition()) {
                column.setPosition(Integer.valueOf(index++));
            }
            if (column.isAutoIncrement() != 1) {
                column.autoIncrement(Boolean.valueOf(false));
            }
            if (column.isPrimaryKey() != 1) {
                column.setPrimary(Boolean.valueOf(false));
            }
            if (null != column.getTable() || greedy) continue;
            column.setTable(table);
        }
        table.setColumns(columns);
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, Table table) {
        return super.columns(runtime, random, greedy, catalog, schema, table);
    }

    public List<Run> buildQueryColumnsRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        return runs;
    }

    public List<Run> buildQueryColumnsRun(DataRuntime runtime, Catalog catalog, Schema schema, List<Table> tables, boolean metadata) throws Exception {
        return super.buildQueryColumnsRun(runtime, catalog, schema, tables, metadata);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Object column = null;
            if (null == (column = this.init(runtime, index, (T)column, table, row))) continue;
            column = this.detail(runtime, index, (T)column, null, null, row);
            columns.put(column.getName().toUpperCase(), column);
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new ArrayList<T>();
        }
        for (DataRow row : set) {
            T column = null;
            if (null == this.column(column = this.init(runtime, index, column, table, row), columns)) {
                columns.add(column);
            }
            this.detail(runtime, index, column, null, null, row);
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<Table> tables, List<T> columns, DataSet set) throws Exception {
        if (null == columns) {
            columns = new ArrayList<T>();
        }
        HashMap<String, Table> tbls = new HashMap<String, Table>();
        for (Table table : tables) {
            tbls.put(table.getName().toUpperCase(), table);
        }
        for (DataRow row : set) {
            Table table;
            Column column = null;
            if (null == this.column(column = this.init(runtime, index, column, null, row), columns)) {
                columns.add(column);
            }
            this.detail(runtime, index, column, null, null, row);
            String tableName = column.getTableName();
            if (null == tableName || null == (table = (Table)tbls.get(tableName.toUpperCase()))) continue;
            table.addColumn(column);
        }
        return columns;
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, List<Table> tables) {
        return super.columns(runtime, random, greedy, catalog, schema, tables);
    }

    public <T extends Column> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) {
        if (null == meta) {
            meta = new Column();
        }
        return meta;
    }

    public <T extends Column> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return meta;
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        return super.tags(runtime, index, create, table, tags, set);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        return super.tags(runtime, create, tags, table, pattern);
    }

    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.primary(runtime, random, greedy, table);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryPrimaryRun(runtime, table);
    }

    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T primary, Table table, DataSet set) throws Exception {
        PrimaryMetadataAdapter config = this.primaryMetadataAdapter(runtime);
        for (DataRow row : set) {
            String col;
            if (null == primary) {
                primary = new PrimaryKey();
                primary.setName(row.getString(config.getNameRefers()));
                if (null == table) {
                    table = new Table(row.getString(config.getCatalogRefers()), row.getString(config.getSchemaRefers()), row.getString(config.getTableRefer()));
                }
                primary.setTable(table);
            }
            if (BasicUtil.isEmpty((Object)(col = row.getString(config.getColumnRefers())))) {
                throw new Exception("\u4e3b\u952e\u76f8\u5173\u5217\u540d\u5f02\u5e38,\u8bf7\u68c0\u67e5buildQueryPrimaryRun\u4e0eprimaryMetadataColumn");
            }
            Column column = primary.getColumn(col);
            if (null == column) {
                column = new Column(col);
            }
            column.setTable(table);
            String position = row.getString(config.getColumnPositionRefers());
            primary.setPosition(column, BasicUtil.parseInt((Object)position, (Integer)0));
            String order = row.getString(config.getColumnOrderRefers());
            if (BasicUtil.isNotEmpty((Object)order)) {
                column.setOrder(order);
            }
            primary.addColumn(column);
        }
        return primary;
    }

    public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T primary, Table table, DataSet set) throws Exception {
        return (T)super.detail(runtime, index, primary, table, set);
    }

    public PrimaryMetadataAdapter primaryMetadataAdapter(DataRuntime runtime) {
        return new PrimaryMetadataAdapter();
    }

    public PrimaryKey primary(DataRuntime runtime, Table table) throws Exception {
        return super.primary(runtime, table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        return super.foreigns(runtime, random, greedy, table);
    }

    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryForeignsRun(runtime, table);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        return super.foreigns(runtime, index, table, foreigns, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        return super.indexs(runtime, random, greedy, table, pattern);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, Table table, String pattern) {
        return super.indexs(runtime, random, table, pattern);
    }

    public List<Run> buildQueryIndexesRun(DataRuntime runtime, Table table, String name) {
        return super.buildQueryIndexesRun(runtime, table, name);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, int index, boolean create, Table table, List<T> indexs, DataSet set) throws Exception {
        return super.indexs(runtime, index, create, table, indexs, set);
    }

    public <T extends Index> List<T> indexs(DataRuntime runtime, boolean create, List<T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        return super.indexs(runtime, create, indexs, table, unique, approximate);
    }

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        Object datasource = null;
        Object con = null;
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    public <T extends Index> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        return (T)super.init(runtime, index, meta, table, row);
    }

    public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        return (T)super.detail(runtime, index, meta, table, row);
    }

    public IndexMetadataAdapter indexMetadataAdapter(DataRuntime runtime) {
        IndexMetadataAdapter adapter = super.indexMetadataAdapter(runtime);
        adapter.setNameRefer("Index Name");
        adapter.setTableRefer("By Tag,By Edge");
        adapter.setColumnRefer("Columns");
        return adapter;
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        List<Run> runs;
        List<T> constraints = null;
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        if (!greedy) {
            this.checkSchema(runtime, (Metadata)table);
        }
        if (null != (runs = this.buildQueryConstraintsRun(runtime, table, null, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block7: {
                    DataSet set = (DataSet)this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    try {
                        constraints = this.constraints(runtime, idx, true, table, constraints, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block7;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return constraints;
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        LinkedHashMap<String, T> constraints = null;
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        this.checkSchema(runtime, (Metadata)table);
        List<Run> runs = this.buildQueryConstraintsRun(runtime, table, null, pattern);
        if (null != runs) {
            int idx = 0;
            for (Run run : runs) {
                block6: {
                    DataSet set = (DataSet)this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    try {
                        constraints = this.constraints(runtime, idx, true, table, column, constraints, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block6;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return constraints;
    }

    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, Table table, Column column, String pattern) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE 1=1");
        String catalog = null;
        String schema = null;
        String tab = null;
        if (null != table) {
            catalog = table.getCatalogName();
            schema = table.getSchemaName();
            tab = table.getName();
        }
        if (BasicUtil.isNotEmpty(catalog)) {
            builder.append(" AND CONSTRAINT_CATALOG = '").append(catalog).append("'");
        }
        if (!this.empty(schema)) {
            builder.append(" AND CONSTRAINT_SCHEMA = '").append(schema).append("'");
        }
        if (BasicUtil.isNotEmpty((Object)tab)) {
            builder.append(" AND TABLE_NAME = '").append(tab).append("'");
        }
        return runs;
    }

    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, table, constraints, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, Column column, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("CONSTRAINT_NAME");
            if (null == name) continue;
            Constraint constraint = (Constraint)constraints.get(name.toUpperCase());
            if (null == constraint && create) {
                constraint = new Constraint();
                constraints.put(name.toUpperCase(), constraint);
            }
            String catalog = row.getString("CONSTRAINT_CATALOG");
            String schema = row.getString("CONSTRAINT_SCHEMA");
            constraint.setCatalog(catalog);
            constraint.setSchema(schema);
            if (null == table) {
                table = new Table(catalog, schema, row.getString("TABLE_NAME"));
            }
            constraint.setTable(table);
            constraint.setName(name);
            constraint.setType(row.getString("CONSTRAINT_TYPE"));
        }
        return constraints;
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        return super.triggers(runtime, random, greedy, table, events);
    }

    public List<Run> buildQueryTriggersRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        return super.buildQueryTriggersRun(runtime, table, events);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        return super.triggers(runtime, index, create, table, triggers, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        List procedures = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema || BasicUtil.isEmpty((Object)catalog.getName()) || BasicUtil.isEmpty((Object)schema.getName())) {
            Table tmp = new Table();
            this.checkSchema(runtime, (Metadata)tmp);
            if (null == catalog || BasicUtil.isEmpty((Object)catalog.getName())) {
                catalog = tmp.getCatalog();
            }
            if (null == schema || BasicUtil.isEmpty((Object)schema.getName())) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryProceduresRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = (DataSet)this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    try {
                        procedures = this.procedures(runtime, idx, true, procedures, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return procedures;
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        LinkedHashMap procedures = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema || BasicUtil.isEmpty((Object)catalog.getName()) || BasicUtil.isEmpty((Object)schema.getName())) {
            Table tmp = new Table();
            this.checkSchema(runtime, (Metadata)tmp);
            if (null == catalog || BasicUtil.isEmpty((Object)catalog.getName())) {
                catalog = tmp.getCatalog();
            }
            if (null == schema || BasicUtil.isEmpty((Object)schema.getName())) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryProceduresRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = (DataSet)this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    try {
                        procedures = this.procedures(runtime, idx, true, procedures, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return procedures;
    }

    public List<Run> buildQueryProceduresRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        return super.buildQueryProceduresRun(runtime, catalog, schema, pattern);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, procedures, set);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> procedures) throws Exception {
        return super.procedures(runtime, create, procedures);
    }

    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDdlsRun(runtime, procedure);
    }

    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        List functions = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema || BasicUtil.isEmpty((Object)catalog.getName()) || BasicUtil.isEmpty((Object)schema.getName())) {
            Table tmp = new Table();
            this.checkSchema(runtime, (Metadata)tmp);
            if (null == catalog || BasicUtil.isEmpty((Object)catalog.getName())) {
                catalog = tmp.getCatalog();
            }
            if (null == schema || BasicUtil.isEmpty((Object)schema.getName())) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryFunctionsRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = (DataSet)this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    try {
                        functions = this.functions(runtime, idx, true, functions, catalog, schema, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return functions;
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        List<Run> runs;
        LinkedHashMap functions = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == catalog || null == schema || BasicUtil.isEmpty((Object)catalog.getName()) || BasicUtil.isEmpty((Object)schema.getName())) {
            Table tmp = new Table();
            this.checkSchema(runtime, (Metadata)tmp);
            if (null == catalog || BasicUtil.isEmpty((Object)catalog.getName())) {
                catalog = tmp.getCatalog();
            }
            if (null == schema || BasicUtil.isEmpty((Object)schema.getName())) {
                schema = tmp.getSchema();
            }
        }
        if (null != (runs = this.buildQueryFunctionsRun(runtime, catalog, schema, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block8: {
                    DataSet set = (DataSet)this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey(new String[0]);
                    try {
                        functions = this.functions(runtime, idx, true, functions, catalog, schema, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block8;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return functions;
    }

    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, Catalog catalog, Schema schema, String name) {
        return super.buildQueryFunctionsRun(runtime, catalog, schema, name);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, catalog, schema, set);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, Catalog catalog, Schema schema, DataSet set) throws Exception {
        return super.functions(runtime, index, create, functions, catalog, schema, set);
    }

    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> functions) throws Exception {
        return super.functions(runtime, create, functions);
    }

    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return super.sequences(runtime, random, greedy, catalog, schema, pattern);
    }

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return super.sequences(runtime, random, catalog, schema, pattern);
    }

    public List<Run> buildQuerySequencesRun(DataRuntime runtime, Catalog catalog, Schema schema, String name) {
        return super.buildQuerySequencesRun(runtime, catalog, schema, name);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> sequences, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, sequences, set);
    }

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> sequences, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, sequences, set);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> sequences) throws Exception {
        return super.sequences(runtime, create, sequences);
    }

    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        return super.ddl(runtime, random, meta);
    }

    public List<Run> buildQueryDdlsRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildQueryDdlsRun(runtime, meta);
    }

    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, sequence, ddls, set);
    }

    public <T extends Metadata> T search(List<T> metas, Catalog catalog, Schema schema, String name) {
        return (T)super.search(metas, catalog, schema, name);
    }

    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return (T)super.schema(schemas, catalog, name);
    }

    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return (T)super.catalog(catalogs, name);
    }

    public <T extends Database> T database(List<T> databases, String name) {
        return (T)super.database(databases, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run) {
        if (null == run) {
            return false;
        }
        boolean result = false;
        String sql = run.getFinalUpdate();
        meta.addDdl(sql);
        if (BasicUtil.isNotEmpty((Object)sql)) {
            if (meta.execute()) {
                try {
                    this.update(runtime, random, null, null, null, run);
                }
                finally {
                    CacheProxy.clear();
                }
            }
            result = true;
        }
        return result;
    }

    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public String keyword(Metadata meta) {
        return super.keyword(meta);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE ").append(this.keyword((Metadata)meta)).append(" ");
        this.checkTableExists(runtime, builder, false);
        this.name(runtime, builder, (Metadata)meta);
        this.partitionOf(runtime, builder, meta);
        this.partitionFor(runtime, builder, meta);
        this.body(runtime, builder, meta);
        this.partitionBy(runtime, builder, meta);
        this.inherit(runtime, builder, meta);
        this.engine(runtime, builder, meta);
        this.charset(runtime, builder, meta);
        this.keys(runtime, builder, meta);
        this.distribution(runtime, builder, meta);
        this.materialize(runtime, builder, meta);
        this.property(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        runs.addAll(this.buildAppendColumnCommentRun(runtime, meta));
        runs.addAll(this.buildAppendPrimaryRun(runtime, meta));
        runs.addAll(this.buildAppendIndexRun(runtime, meta));
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, meta, columns);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(this.keyword((Metadata)meta)).append(" ");
        this.checkTableExists(runtime, builder, true);
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    public void checkPrimary(DataRuntime runtime, Table table) {
        super.checkPrimary(runtime, table);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        pks = null != primary ? primary.getColumns() : meta.primarys();
        if (!pks.isEmpty() && pks.size() > 1) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            Column.sort((LinkedHashMap)primary.getPositions(), (LinkedHashMap)pks);
            for (Column pk : pks.values()) {
                if (!first) {
                    builder.append(",");
                }
                this.delimiter(builder, pk.getName());
                String order = pk.getOrder();
                if (BasicUtil.isNotEmpty((Object)order)) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Table meta) {
        String params;
        String engine = meta.getEngine();
        if (BasicUtil.isNotEmpty((Object)engine)) {
            builder.append("\nENGINE = ").append(engine);
        }
        if (BasicUtil.isNotEmpty((Object)(params = meta.getEngineParameters()))) {
            builder.append(" ").append(params);
        }
        return builder;
    }

    public StringBuilder body(DataRuntime runtime, StringBuilder builder, Table meta) {
        LinkedHashMap columns = meta.getColumns();
        if ((null == columns || columns.isEmpty()) && BasicUtil.isEmpty((Object)meta.getInherit())) {
            return builder;
        }
        builder.append("(");
        this.columns(runtime, builder, meta);
        this.indexs(runtime, builder, meta);
        builder.append(")");
        return builder;
    }

    public StringBuilder columns(DataRuntime runtime, StringBuilder builder, Table meta) {
        LinkedHashMap columMap = meta.getColumns();
        Collection columns = null;
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        if (null != primary) {
            pks = primary.getColumns();
        } else {
            pks = meta.primarys();
            primary = new PrimaryKey();
            primary.setTable(meta);
            for (Column col : pks.values()) {
                primary.addColumn(col);
            }
            meta.setPrimaryKey(primary);
        }
        if (null == pks) {
            pks = new LinkedHashMap();
        }
        if (null != columMap && null != (columns = columMap.values()) && !columns.isEmpty()) {
            int idx = 0;
            for (Column column : columns) {
                TypeMetadata metadata = column.getTypeMetadata();
                if (null == metadata) {
                    metadata = this.typeMetadata(runtime, column);
                    column.setTypeMetadata(metadata);
                }
                if (pks.containsKey(column.getName().toUpperCase())) {
                    column.setNullable(Boolean.valueOf(false));
                }
                builder.append("\n\t");
                if (idx > 0) {
                    builder.append(",");
                }
                column.setAction(ACTION.DDL.COLUMN_ADD);
                this.delimiter(builder, column.getName()).append(" ");
                this.define(runtime, builder, column, ACTION.DDL.TABLE_CREATE);
                ++idx;
            }
            if (!pks.isEmpty()) {
                builder.append("\n\t");
                this.primary(runtime, builder, meta);
            }
        }
        return builder;
    }

    public StringBuilder indexs(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.indexs(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder keys(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.keys(runtime, builder, meta);
    }

    public StringBuilder distribution(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.distribution(runtime, builder, meta);
    }

    public StringBuilder materialize(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.materialize(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (null != meta.getProperty()) {
            builder.append(" ").append(meta.getProperty());
        }
        return builder;
    }

    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table.Partition partition = meta.getPartition();
        if (null == partition) {
            return builder;
        }
        if (null != meta.getMaster()) {
            return builder;
        }
        Table.Partition.TYPE type = partition.getType();
        if (null == type) {
            return builder;
        }
        builder.append(" PARTITION BY ").append(type.name()).append("(");
        LinkedHashMap columns = partition.getColumns();
        if (null != columns) {
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
        }
        builder.append(")");
        return builder;
    }

    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table master = meta.getMaster();
        if (null == master) {
            return builder;
        }
        builder.append(" PARTITION OF ");
        if (null == master) {
            throw new java.sql.SQLException("\u672a\u63d0\u4f9b Master Table");
        }
        this.name(runtime, builder, (Metadata)master);
        return builder;
    }

    public StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table master = meta.getMaster();
        if (null == master) {
            return builder;
        }
        Table.Partition partition = meta.getPartition();
        Table.Partition.TYPE type = null;
        if (null != partition) {
            type = partition.getType();
        }
        if (null == type && null != master.getPartition()) {
            type = master.getPartition().getType();
        }
        if (null == type) {
            return builder;
        }
        builder.append(" FOR VALUES");
        if (type == Table.Partition.TYPE.LIST) {
            List list = partition.getValues();
            if (null == list) {
                throw new java.sql.SQLException("\u672a\u63d0\u4f9b\u5206\u533a\u8868\u679a\u4e3e\u503c(Partition.list)");
            }
            builder.append(" IN(");
            boolean first = true;
            for (Object item : list) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                if (item instanceof Number) {
                    builder.append(item);
                    continue;
                }
                builder.append("'").append(item).append("'");
            }
            builder.append(")");
        } else if (type == Table.Partition.TYPE.RANGE) {
            Object from = partition.getMin();
            Object to = partition.getMax();
            if (BasicUtil.isEmpty((Object)from) || BasicUtil.isEmpty((Object)to)) {
                throw new java.sql.SQLException("\u672a\u63d0\u4f9b\u5206\u533a\u8868\u8303\u56f4\u503c(Partition.from/to)");
            }
            builder.append(" FROM (");
            if (from instanceof Number) {
                builder.append(from);
            } else {
                builder.append("'").append(from).append("'");
            }
            builder.append(")");
            builder.append(" TO (");
            if (to instanceof Number) {
                builder.append(to);
            } else {
                builder.append("'").append(to).append("'");
            }
            builder.append(")");
        } else if (type == Table.Partition.TYPE.HASH) {
            int modulus = partition.getModulus();
            if (modulus == 0) {
                throw new java.sql.SQLException("\u672a\u63d0\u4f9b\u5206\u533a\u8868MODULUS");
            }
            builder.append(" WITH(MODULUS ").append(modulus).append(",REMAINDER ").append(partition.getRemainder()).append(")");
        }
        return builder;
    }

    public StringBuilder inherit(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (BasicUtil.isNotEmpty((Object)meta.getInherit())) {
            LinkedHashMap columns = meta.getColumns();
            if (null == columns || columns.isEmpty()) {
                // empty if block
            }
            builder.append(" INHERITS(");
            this.name(runtime, builder, (Metadata)meta.getInherit());
            builder.append(")");
        }
        return builder;
    }

    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        this.buildCreateRunHead(runtime, builder, meta);
        this.buildCreateRunOption(runtime, builder, meta);
        builder.append(" AS \n").append(meta.getDefinition());
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        return runs;
    }

    public StringBuilder buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append("CREATE VIEW ");
        this.name(runtime, builder, (Metadata)meta);
        return builder;
    }

    public StringBuilder buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        return super.buildCreateRunOption(runtime, builder, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER VIEW ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" AS \n").append(meta.getDefinition());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(meta.getKeyword()).append(" ");
        this.checkViewExists(runtime, builder, true);
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
            this.name(runtime, builder, (Metadata)table);
        }
        this.addColumnGuide(runtime, builder, meta);
        this.delimiter(builder, meta.getName()).append(" ");
        this.define(runtime, builder, meta, ACTION.DDL.COLUMN_ADD);
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        return runs;
    }

    public List<Run> buildAddRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = (Column)meta.getUpdate();
        if (null != update) {
            List<Run> cmts;
            String ucomment;
            String comment;
            List<Run> nulls;
            int unullable;
            int nullable;
            List<Run> defs;
            List<Run> list;
            String uname;
            String name;
            if (null == update.getTable(false)) {
                update.setTable(meta.getTable(false));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(name = meta.getName()), (Object)(uname = update.getName())) && !uname.endsWith(ConfigTable.ALTER_COLUMN_TYPE_SUFFIX)) {
                runs.addAll(this.buildRenameRun(runtime, meta));
            }
            String type = this.type(runtime, null, meta).toString();
            String utype = this.type(runtime, null, update).toString();
            boolean exe = false;
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, meta);
                if (null != list) {
                    runs.addAll(list);
                    exe = true;
                }
            } else if ((meta.getPrecision() != update.getPrecision() || meta.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, meta))) {
                runs.addAll(list);
                exe = true;
            }
            Object def = meta.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef) && null != (defs = this.buildChangeDefaultRun(runtime, meta))) {
                runs.addAll(defs);
            }
            if ((nullable = meta.isNullable()) != (unullable = update.isNullable()) && null != (nulls = this.buildChangeNullableRun(runtime, meta))) {
                runs.addAll(nulls);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = meta.getComment()), (Object)(ucomment = update.getComment())) && null != (cmts = this.buildChangeCommentRun(runtime, meta))) {
                runs.addAll(cmts);
            }
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (meta instanceof Tag) {
            Tag tag = (Tag)meta;
            return this.buildDropRun(runtime, tag);
        }
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
            this.name(runtime, builder, (Metadata)table);
        }
        this.dropColumnGuide(runtime, builder, meta);
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Column meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" RENAME ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        builder.append(" ");
        this.name(runtime, builder, (Column)meta.getUpdate());
        meta.setName(((Column)meta.getUpdate()).getName());
        return runs;
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeTypeRun(runtime, meta);
    }

    public String alterColumnKeyword(DataRuntime runtime) {
        return super.alterColumnKeyword(runtime);
    }

    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        builder.append(" ADD ").append(meta.getKeyword()).append(" ");
        return builder;
    }

    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        builder.append(" DROP ").append(meta.getKeyword()).append(" ");
        return builder;
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeNullableRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta) throws Exception {
        return super.buildDropAutoIncrement(runtime, meta);
    }

    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.define(runtime, builder, meta, action);
    }

    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        int ignoreLength = -1;
        int ignorePrecision = -1;
        int ignoreScale = -1;
        String typeName = meta.getTypeName();
        TypeMetadata type = this.typeMetadata(runtime, meta);
        if (null != type) {
            if (!type.support()) {
                throw new RuntimeException("\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301:" + meta.getName() + " " + typeName);
            }
            typeName = type.getName();
        }
        ColumnMetadataAdapter adapter = this.columnMetadataAdapter(runtime, type);
        TypeMetadata.Config config = adapter.getTypeConfig();
        ignoreLength = config.ignoreLength();
        ignorePrecision = config.ignorePrecision();
        ignoreScale = config.ignoreScale();
        return this.type(runtime, builder, meta, typeName, ignoreLength, ignorePrecision, ignoreScale);
    }

    public StringBuilder aggregation(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.aggregation(runtime, builder, meta);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale) {
        return super.type(runtime, builder, meta, type, ignoreLength, ignorePrecision, ignoreScale);
    }

    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.nullable(runtime, builder, meta, action);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.defaultValue(runtime, builder, meta);
    }

    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.primary(runtime, builder, meta);
    }

    public StringBuilder unique(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.unique(runtime, builder, meta);
    }

    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.increment(runtime, builder, meta);
    }

    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.onupdate(runtime, builder, meta);
    }

    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.position(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.comment(runtime, builder, meta);
    }

    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" ADD TAG ");
        this.delimiter(builder, meta.getName()).append(" ");
        this.define(runtime, builder, (Column)meta, ACTION.DDL.COLUMN_ADD);
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Tag update = meta.getUpdate();
        if (null != update) {
            String ucomment;
            String comment;
            int unullable;
            int nullable;
            List<Run> list;
            String uname;
            String name = meta.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)(uname = update.getName())) && !uname.endsWith(ConfigTable.ALTER_COLUMN_TYPE_SUFFIX)) {
                runs.addAll(this.buildRenameRun(runtime, meta));
            }
            meta.setName(uname);
            String type = this.type(runtime, null, (Column)meta).toString();
            String utype = this.type(runtime, null, (Column)update).toString();
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, meta);
                if (null != list) {
                    runs.addAll(list);
                }
            } else if ((meta.getPrecision() != update.getPrecision() || meta.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, meta))) {
                runs.addAll(list);
            }
            Object def = meta.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef)) {
                runs.addAll(this.buildChangeDefaultRun(runtime, meta));
            }
            if ((nullable = meta.isNullable()) != (unullable = update.isNullable())) {
                runs.addAll(this.buildChangeNullableRun(runtime, meta));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = meta.getComment()), (Object)(ucomment = update.getComment()))) {
                runs.addAll(this.buildChangeCommentRun(runtime, meta));
            }
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" DROP ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
        this.name(runtime, builder, (Metadata)table);
        builder.append(" RENAME ").append(meta.getKeyword()).append(" ");
        this.delimiter(builder, meta.getName());
        builder.append(" ");
        this.name(runtime, builder, (Column)meta.getUpdate());
        return runs;
    }

    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta);
    }

    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeNullableRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta) throws Exception {
        return super.buildChangeTypeRun(runtime, meta);
    }

    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, origin, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (null != meta) {
            Table table = null;
            table = null != meta ? meta.getTable() : origin.getTable();
            ArrayList<Run> slices = new ArrayList<Run>();
            if (null != origin) {
                slices.addAll(this.buildDropRun(runtime, origin, true));
            }
            if (null != meta && !meta.isDrop()) {
                slices.addAll(this.buildAddRun(runtime, meta, true));
            }
            if (this.slice(true)) {
                if (!slices.isEmpty()) {
                    SimpleRun run = new SimpleRun(runtime);
                    StringBuilder builder = run.getBuilder();
                    builder.append("ALTER TABLE ");
                    this.name(runtime, builder, (Metadata)table);
                    boolean first = true;
                    for (Run item : slices) {
                        if (item.getBuilder().length() == 0) continue;
                        if (!first) {
                            builder.append(",");
                        }
                        builder.append((CharSequence)item.getBuilder());
                        first = false;
                    }
                    if (!first) {
                        runs.add((Run)run);
                    }
                }
            } else {
                runs.addAll(slices);
            }
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true));
        }
        builder.append(" DROP CONSTRAINT ");
        this.delimiter(builder, meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = meta.getColumns();
        if (null != columns && !columns.isEmpty()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true));
            builder.append(" ADD");
            if (BasicUtil.isNotEmpty((Object)meta.getName())) {
                builder.append(" CONSTRAINT ").append(meta.getName());
            }
            builder.append(" FOREIGN KEY (");
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
            builder.append(")");
            builder.append(" REFERENCES ").append(meta.getReference().getName()).append("(");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                this.name(runtime, builder, column.getReference());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta.getTable(true));
        builder.append(" DROP FOREIGN KEY ").append(meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendIndexRun(runtime, meta);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Index meta) throws Exception {
        Object name = meta.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "index_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE");
        if (meta.isUnique()) {
            builder.append(" UNIQUE");
        } else if (meta.isFulltext()) {
            builder.append(" FULLTEXT");
        } else if (meta.isSpatial()) {
            builder.append(" SPATIAL");
        }
        builder.append(" ").append(this.keyword((Metadata)meta)).append(" ");
        this.checkIndexExists(runtime, builder, false);
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" ON ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (Metadata)table);
        builder.append("(");
        int qty = 0;
        LinkedHashMap columns = meta.getColumns();
        Column.sort((LinkedHashMap)meta.getPositions(), (LinkedHashMap)columns);
        for (Column column : columns.values()) {
            if (qty > 0) {
                builder.append(",");
            }
            this.delimiter(builder, column.getName());
            Order.TYPE order = meta.getOrder(column.getName());
            if (BasicUtil.isNotEmpty((Object)order)) {
                builder.append(" ").append(order);
            }
            ++qty;
        }
        builder.append(")");
        this.type(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        List<Run> runs = this.buildDropRun(runtime, meta);
        Index update = (Index)meta.getUpdate();
        if (null != update) {
            runs.addAll(this.buildAddRun(runtime, update));
        } else {
            runs.addAll(this.buildAddRun(runtime, meta));
        }
        return runs;
    }

    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        if (meta.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)table);
            builder.append(" DROP CONSTRAINT ").append(meta.getName());
        } else {
            builder.append("DROP INDEX ").append(meta.getName());
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append(" ON ");
                this.name(runtime, builder, (Metadata)table);
            }
        }
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.type(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder checkIndexExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkIndexExists(runtime, builder, exists);
    }

    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        Object name = meta.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "constraint_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (Metadata)table);
        builder.append(" ADD CONSTRAINT ").append((String)name);
        if (meta.isUnique()) {
            builder.append(" UNIQUE");
        }
        builder.append("(");
        boolean first = true;
        Collection cols = meta.getColumns().values();
        for (Column column : cols) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            this.delimiter(builder, column.getName());
            String order = column.getOrder();
            if (!BasicUtil.isNotEmpty((Object)order)) continue;
            builder.append(" ").append(order);
        }
        builder.append(")");
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = meta.getTable(true);
        this.name(runtime, builder, (Metadata)table);
        builder.append(" DROP CONSTRAINT ").append(meta.getName());
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER CONSTRAINT ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, meta.getUpdate().getName());
        return runs;
    }

    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE TRIGGER ").append(meta.getName());
        builder.append(" ").append(meta.getTime().sql()).append(" ");
        List events = meta.getEvents();
        boolean first = true;
        for (Trigger.EVENT event : events) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append(event);
            first = false;
        }
        builder.append(" ON ");
        this.name(runtime, builder, (Metadata)meta.getTable(true));
        this.each(runtime, builder, meta);
        builder.append("\n").append(meta.getDefinition());
        return runs;
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP TRIGGER ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        builder.append("ALTER TRIGGER ");
        if (!this.empty((Metadata)catalog)) {
            this.name(runtime, builder, (Metadata)catalog).append(".");
        }
        if (!this.empty((Metadata)schema)) {
            this.name(runtime, builder, (Metadata)schema).append(".");
        }
        this.delimiter(builder, meta.getName());
        builder.append(" RENAME TO ");
        this.name(runtime, builder, meta.getUpdate());
        return runs;
    }

    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        if (meta.isEach()) {
            builder.append(" FOR EACH ROW ");
        } else {
            builder.append(" FOR EACH STATEMENT ");
        }
        return builder;
    }

    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP FUNCTION ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER FUNCTION ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, ((Function)meta.getUpdate()).getName());
        return runs;
    }

    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP SEQUENCE ");
        this.name(runtime, builder, (Metadata)meta);
        return runs;
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER SEQUENCE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        this.delimiter(builder, ((Sequence)meta.getUpdate()).getName());
        return runs;
    }

    protected DataSet select(DataRuntime runtime, String random, boolean system, ACTION.DML action, Table table, ConfigStore configs, Run run, String sql, List<Object> values) {
        return new DataSet();
    }

    public <T extends Column> T column(T column, List<T> columns) {
        for (Column item : columns) {
            if (!item.getIdentity().equals(column.getIdentity())) continue;
            return (T)item;
        }
        return null;
    }

    protected String insertValue(DataRuntime runtime, Run run, Object obj, boolean child, boolean placeholder, boolean alias, boolean scope, LinkedHashMap<String, Column> columns) {
        int batch = run.getBatch();
        StringBuilder builder = new StringBuilder();
        if (scope && batch <= 1) {
            builder.append("(");
        }
        int from = 1;
        if (obj instanceof DataRow) {
            from = 1;
        }
        run.setFrom(from);
        boolean first = true;
        for (Column column : columns.values()) {
            boolean place = placeholder;
            boolean src = false;
            String key = column.getName();
            if (!first && batch <= 1) {
                builder.append(",");
            }
            first = false;
            Object value = null;
            value = obj instanceof DataRow ? BeanUtil.getFieldValue((Object)obj, (String)key) : (obj instanceof Map ? ((Map)obj).get(key) : BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)));
            if (value != null) {
                if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                    place = false;
                } else if (value instanceof String) {
                    String str = (String)value;
                    if (BasicUtil.checkEl((String)str)) {
                        src = true;
                        place = false;
                        value = str.substring(2, str.length() - 1);
                        if (child && str.toUpperCase().contains(".NEXTVAL")) {
                            value = null;
                        }
                    } else if ("NULL".equals(str)) {
                        value = null;
                    }
                }
            }
            if (src) {
                builder.append(value);
            } else if (batch <= 1) {
                if (place) {
                    builder.append("?");
                    this.addRunValue(runtime, run, Compare.EQUAL, column, value);
                } else {
                    builder.append(this.write(runtime, column, value, false));
                }
            } else {
                this.addRunValue(runtime, run, Compare.EQUAL, column, value);
            }
            if (!alias || batch > 1) continue;
            builder.append(" AS ");
            this.delimiter(builder, key);
        }
        if (scope && batch <= 1) {
            builder.append(")");
        }
        return builder.toString();
    }

    public String concat(DataRuntime runtime, String ... args) {
        return null;
    }

    protected String dummy() {
        return "dual";
    }

    protected String pageLimit(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        Object sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = ((String)sql).replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = (String)sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = (String)sql + " LIMIT " + navi.getFirstRow() + "," + limit;
        }
        sql = this.compressCondition(runtime, (String)sql);
        return sql;
    }

    protected String pageLimitOffset(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        Object sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = ((String)sql).replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = (String)sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            sql = (String)sql + " LIMIT " + limit + " OFFSET " + navi.getFirstRow();
        }
        sql = this.compressCondition(runtime, (String)sql);
        return sql;
    }

    protected String pageRowNum(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append("SELECT ").append(cols).append(" FROM( \n");
            builder.append("SELECT TAB_I.*,ROWNUM AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append("\n").append(order);
            builder.append(")  TAB_I \n");
            builder.append(")  TAB_O WHERE PAGE_ROW_NUMBER_ >= ").append(first + 1L).append(" AND PAGE_ROW_NUMBER_ <= ").append(last + 1L);
        }
        return builder.toString();
    }

    protected String pageOffsetNext(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            builder.append(sql).append("\n").append(order);
            builder.append(" OFFSET ").append(first).append(" ROWS FETCH NEXT ").append(navi.getPageRows()).append(" ROWS ONLY");
        }
        return builder.toString();
    }

    protected String pageSkip(DataRuntime runtime, Run run) {
        PageNavi navi;
        OrderStore orders;
        Object sql = run.getBaseQuery();
        String cols = run.getQueryColumn();
        if (!"*".equals(cols)) {
            String reg = "(?i)^select[\\s\\S]+from";
            sql = ((String)sql).replaceAll(reg, "SELECT " + cols + " FROM ");
        }
        if (null != (orders = run.getOrderStore())) {
            sql = (String)sql + orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != (navi = run.getPageNavi())) {
            long limit = navi.getLastRow() - navi.getFirstRow() + 1L;
            if (limit < 0L) {
                limit = 0L;
            }
            String sub = ((String)sql).substring(((String)sql).toUpperCase().indexOf("SELECT") + 6);
            sql = "SELECT SKIP " + navi.getFirstRow() + " FIRST " + limit + sub;
        }
        return sql;
    }

    protected String pageTop(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        String order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0L && null != navi) {
            builder.append("SELECT TOP ").append(last + 1L).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append(order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append(order);
        } else {
            long rows = navi.getPageRows();
            if (rows * navi.getCurPage() > navi.getTotalRow()) {
                rows = navi.getTotalRow() % (long)navi.getPageRows();
            }
            String asc = order;
            String desc = order.replace("ASC", "<A_ORDER>");
            desc = desc.replace("DESC", "ASC");
            desc = desc.replace("<A_ORDER>", "DESC");
            builder.append("SELECT " + cols + " FROM (\n ");
            builder.append("SELECT TOP ").append(rows).append(" * FROM (\n");
            builder.append("SELECT TOP ").append((long)navi.getPageRows() * navi.getCurPage()).append(" * ");
            builder.append(" FROM (" + sql + ") AS T0 ").append(asc).append("\n");
            builder.append(") AS T1 ").append(desc).append("\n");
            builder.append(") AS T2").append(asc);
        }
        return builder.toString();
    }

    protected String pageRowNumber(DataRuntime runtime, Run run) {
        StringBuilder builder = new StringBuilder();
        String cols = run.getQueryColumn();
        PageNavi navi = run.getPageNavi();
        String sql = run.getBaseQuery();
        OrderStore orders = run.getOrderStore();
        long first = 0L;
        long last = 0L;
        Object order = "";
        if (null != orders) {
            order = orders.getRunText(this.getDelimiterFr() + this.getDelimiterTo());
        }
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        if (first == 0L && null != navi) {
            builder.append("SELECT TOP ").append(last + 1L).append(" " + cols + " FROM(\n");
            builder.append(sql).append("\n) AS _TAB_O \n");
            builder.append((String)order);
            return builder.toString();
        }
        if (null == navi) {
            builder.append(sql).append("\n").append((String)order);
        } else {
            if (BasicUtil.isEmpty((Object)order)) {
                order = "ORDER BY " + ConfigTable.DEFAULT_PRIMARY_KEY;
            }
            builder.append("SELECT " + cols + " FROM( \n");
            builder.append("SELECT _TAB_I.*,ROW_NUMBER() OVER(").append((String)order).append(") AS PAGE_ROW_NUMBER_ \n");
            builder.append("FROM( \n");
            builder.append(sql);
            builder.append(") AS _TAB_I \n");
            builder.append(") AS _TAB_O WHERE PAGE_ROW_NUMBER_ BETWEEN " + (first + 1L) + " AND " + (last + 1L));
        }
        return builder.toString();
    }

    protected String concatFun(DataRuntime runtime, String ... args) {
        Object result = "";
        if (null != args && args.length > 0) {
            result = "concat(";
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = (String)result + ",";
                }
                result = (String)result + arg;
            }
            result = (String)result + ")";
        }
        return result;
    }

    protected String concatOr(DataRuntime runtime, String ... args) {
        Object result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = (String)result + " || ";
                }
                result = (String)result + arg;
            }
        }
        return result;
    }

    protected String concatAdd(DataRuntime runtime, String ... args) {
        Object result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = (String)result + " + ";
                }
                result = (String)result + arg;
            }
        }
        return result;
    }

    protected String concatAnd(DataRuntime runtime, String ... args) {
        Object result = "";
        if (null != args && args.length > 0) {
            int size = args.length;
            for (int i = 0; i < size; ++i) {
                String arg = args[i];
                if (i > 0) {
                    result = (String)result + " & ";
                }
                result = (String)result + arg;
            }
        }
        return result;
    }

    private void queryTimeout(Statement statement, ConfigStore configs) {
        int timeout = ConfigStore.SQL_QUERY_TIMEOUT((ConfigStore)configs);
        if (timeout > 0) {
            try {
                statement.setQueryTimeout(timeout);
            }
            catch (Exception e) {
                log.warn("\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\u5f02\u5e38:{}", (Throwable)e);
            }
        }
    }

    private void updateTimeout(Statement statement, ConfigStore configs) {
        int timeout = ConfigStore.SQL_QUERY_TIMEOUT((ConfigStore)configs);
        if (timeout > 0) {
            try {
                statement.setQueryTimeout(timeout);
            }
            catch (Exception e) {
                log.warn("\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\u5f02\u5e38:{}", (Throwable)e);
            }
        }
    }

    static {
        types.put((Type)Table.TYPE.NORMAL, "BASE TABLE");
        types.put((Type)Table.TYPE.VIEW, "VIEW");
        types.put((Type)View.TYPE.NORMAL, "VIEW");
        types.put((Type)Metadata.TYPE.TABLE, "BASE TABLE");
        types.put((Type)Metadata.TYPE.VIEW, "VIEW");
    }
}

