/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.elasticsearch.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.datasource.DataSourceKeyMap;
import org.anyline.data.datasource.DatasourceHolder;
import org.anyline.data.elasticsearch.runtime.ElasticSearchRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.proxy.DatasourceHolderProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SpringContextUtil;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Component(value="anyline.data.datasource.holder.elasticsearch")
public class ElasticSearchDatasourceHolder
extends DatasourceHolder {
    private static Logger log = LoggerFactory.getLogger(ElasticSearchDatasourceHolder.class);

    public ElasticSearchDatasourceHolder() {
        DatasourceHolderProxy.reg(DataSource.class, (DatasourceHolder)this);
        DatasourceHolderProxy.reg(RestClient.class, (DatasourceHolder)this);
    }

    public static String reg(String key, String url, String user, String password) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", "ElasticSearchDataSource");
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        return ElasticSearchDatasourceHolder.reg(key, param);
    }

    public static String reg(String key, Map<String, Object> param, boolean override) throws Exception {
        String ds_id = ElasticSearchDatasourceHolder.inject(key, param, override);
        return ElasticSearchDatasourceHolder.init(key, ds_id, override);
    }

    public static String reg(String key, Map<String, Object> param) throws Exception {
        return ElasticSearchDatasourceHolder.reg(key, param, true);
    }

    public static RestClient reg(String key, RestClient client, boolean override) throws Exception {
        return ElasticSearchDatasourceHolder.init(key, client, override);
    }

    public static RestClient reg(String key, RestClient client) throws Exception {
        return ElasticSearchDatasourceHolder.init(key, client, false);
    }

    public static String reg(String key, String prefix, Environment env) {
        try {
            String url;
            if (BasicUtil.isNotEmpty((Object)prefix) && !((String)prefix).endsWith(".")) {
                prefix = (String)prefix + ".";
            }
            if (BasicUtil.isEmpty((Object)(url = (String)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"url", String.class, null)))) {
                return null;
            }
            String type = (String)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"type", String.class, null);
            if (null == type) {
                type = (String)ElasticSearchDatasourceHolder.value((Environment)env, (String)((String)prefix).substring(0, ((String)prefix).length() - key.length() - 1), (String)"type", String.class, null);
            }
            if (null == type || !type.contains("ElasticSearchDataSource")) {
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            String ds = ElasticSearchDatasourceHolder.inject(key, (String)prefix, map, env, true);
            if (null == ds) {
                return null;
            }
            ElasticSearchDatasourceHolder.init(key, ds, false);
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String inject(String key, Map params, boolean over) throws Exception {
        return ElasticSearchDatasourceHolder.inject(key, null, params, null, over);
    }

    private static String inject(String key, String prefix, Map<String, Object> params, Environment env, boolean override) throws Exception {
        HashMap cache = (HashMap)DatasourceHolder.params.get(key);
        if (null == cache) {
            cache = new HashMap();
            DatasourceHolder.params.put(key, cache);
        }
        ElasticSearchDatasourceHolder.check((String)key, (boolean)override);
        String url = (String)ElasticSearchDatasourceHolder.value(params, (String)"url", String.class, null);
        if (BasicUtil.isEmpty((Object)url)) {
            url = (String)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"url", String.class, null);
        }
        if (BasicUtil.isEmpty((Object)url)) {
            return null;
        }
        String type = (String)ElasticSearchDatasourceHolder.value(params, (String)"type", String.class, null);
        if (BasicUtil.isEmpty((Object)type)) {
            type = (String)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"type", String.class, null);
        }
        if (null == type || !type.contains("ElasticSearchDataSource")) {
            return null;
        }
        String datasource_id = "anyline.datasource." + key;
        try {
            String[] hosts = url.split(",");
            HttpHost[] posts = new HttpHost[hosts.length];
            int idx = 0;
            for (String host : hosts) {
                String[] tmps = host.split(":");
                String schema = tmps[0];
                String ip = tmps[1].replace("//", "");
                int port = BasicUtil.parseInt((Object)tmps[2], (Integer)9200);
                posts[idx++] = new HttpHost(ip, port, schema);
            }
            RestClient client = RestClient.builder((HttpHost[])posts).setRequestConfigCallback(requestConfigBuilder -> {
                requestConfigBuilder.setConnectTimeout(((Integer)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"connectTimeout", Integer.class, (Object)10000)).intValue());
                requestConfigBuilder.setSocketTimeout(((Integer)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"socketTimeout", Integer.class, (Object)10000)).intValue());
                requestConfigBuilder.setConnectionRequestTimeout(((Integer)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"connectionRequestTimeout", Integer.class, (Object)10000)).intValue());
                return requestConfigBuilder;
            }).setFailureListener(new RestClient.FailureListener(){

                public void onFailure(Node node) {
                    log.error("[ ElasticSearchClient ] >>  node :{}, host:{}, fail !", (Object)node.getName(), (Object)node.getHost());
                }
            }).setHttpClientConfigCallback(httpSyncClientBuilder -> {
                try {
                    SSLContext sslContext = SSLContexts.createDefault();
                    Registry sessionStrategyRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslContext)).build();
                    IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).build();
                    DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
                    Assert.notNull((Object)ioReactor, (String)"ioReactor init error");
                    PoolingNHttpClientConnectionManager poolConnManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, null, sessionStrategyRegistry, (DnsResolver)null);
                    poolConnManager.setMaxTotal(((Integer)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"maxTotalConnect", Integer.class, (Object)100)).intValue());
                    poolConnManager.setDefaultMaxPerRoute(((Integer)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"maxConnectPerRoute", Integer.class, (Object)10)).intValue());
                    httpSyncClientBuilder.setConnectionManager((NHttpClientConnectionManager)poolConnManager);
                    List<Header> headers = ElasticSearchDatasourceHolder.getDefaultHeaders();
                    httpSyncClientBuilder.setDefaultHeaders(headers);
                    httpSyncClientBuilder.setKeepAliveStrategy(ElasticSearchDatasourceHolder.connectionKeepAliveStrategy(null, (Integer)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"keepAliveTime", Integer.class, (Object)10)));
                    httpSyncClientBuilder.disableAuthCaching();
                }
                catch (IOReactorException e) {
                    log.error("ES\u7684Http\u5f02\u6b65\u8fde\u63a5\u6c60\u914d\u7f6e\u9519\u8bef", (Throwable)e);
                }
                String user = (String)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"user", String.class, null);
                String password = (String)ElasticSearchDatasourceHolder.value((Environment)env, (String)prefix, (String)"password", String.class, null);
                return ElasticSearchDatasourceHolder.getHttpAsyncClientBuilder(httpSyncClientBuilder, user, password);
            }).build();
            DefaultListableBeanFactory factory = (DefaultListableBeanFactory)SpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
            factory.registerSingleton(datasource_id, (Object)client);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][type:ElasticSearch][key:{}][msg:{}]", (Object)key, (Object)e.toString());
            return null;
        }
        return datasource_id;
    }

    private static String init(String key, String client, boolean override) throws Exception {
        if (null != client) {
            ElasticSearchDatasourceHolder.check((String)key, (boolean)override);
            Object bean = factory.getBean(client);
            if (bean instanceof RestClient) {
                ElasticSearchRuntimeHolder.reg(key, (RestClient)bean, null);
            }
        }
        return client;
    }

    private static RestClient init(String key, RestClient client, boolean override) throws Exception {
        if (null != client) {
            ElasticSearchDatasourceHolder.check((String)key, (boolean)override);
            ElasticSearchRuntimeHolder.reg(key, client, null);
        }
        return client;
    }

    public DataRuntime callTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return ElasticSearchDatasourceHolder.exeTemporary(datasource, database, adapter);
    }

    private static DataRuntime exeTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return ElasticSearchRuntimeHolder.temporary(datasource, database, adapter);
    }

    public static boolean validate(String ds) {
        return ElasticSearchDatasourceHolder.validate(RuntimeHolder.runtime((String)ds));
    }

    public static boolean validate() {
        return ElasticSearchDatasourceHolder.validate(RuntimeHolder.runtime());
    }

    public static boolean validate(DataRuntime runtime) {
        RestClient client = (RestClient)runtime.getProcessor();
        return ElasticSearchDatasourceHolder.validate(client);
    }

    public static boolean validate(RestClient client) {
        try {
            return ElasticSearchDatasourceHolder.exeValidate(client);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean exeValidate(RestClient client) {
        return client.isRunning();
    }

    public boolean callValidate(DataRuntime runtime) {
        return ElasticSearchDatasourceHolder.validate(runtime);
    }

    public boolean callHit(DataRuntime runtime) throws Exception {
        return ElasticSearchDatasourceHolder.validate(runtime);
    }

    public static void destroy(String datasource) {
        ElasticSearchDatasourceHolder.exeDestroy(datasource);
    }

    public void callDestroy(String datasource) {
        ElasticSearchDatasourceHolder.exeDestroy(datasource);
    }

    private static void exeDestroy(String datasource) {
        ElasticSearchRuntimeHolder.destroy(datasource);
    }

    public static List<String> copy() {
        return ElasticSearchDatasourceHolder.copy("default");
    }

    public static List<String> copy(String datasource) {
        DataRuntime runtime = RuntimeHolder.runtime((String)datasource);
        return ElasticSearchDatasourceHolder.copy(runtime);
    }

    public static List<String> copy(DataRuntime runtime) {
        return ElasticSearchDatasourceHolder.exeCopy(runtime);
    }

    public List<String> callCopy(DataRuntime runtime) {
        return ElasticSearchDatasourceHolder.exeCopy(runtime);
    }

    private static List<String> exeCopy(DataRuntime runtime) {
        ArrayList<String> list = new ArrayList<String>();
        AnylineService service = ServiceProxy.service((String)runtime.datasource());
        LinkedHashMap databases = service.metadata().databases();
        Map map = (Map)params.get(runtime.datasource());
        if (null == map) {
            log.warn("\u4e0d\u662f\u4eceanyline\u521b\u5efa\u7684\u6570\u636e\u6e90\u83b7\u53d6\u4e0d\u5230\u6570\u636e\u6e90\u53c2\u6570");
            return list;
        }
        for (String database : databases.keySet()) {
            HashMap<String, Object> copy_params = new HashMap<String, Object>();
            BeanUtil.copy(copy_params, (Map)map);
            String key = runtime.datasource() + "_" + database.toLowerCase();
            if (RuntimeHolder.contains((String)key)) {
                list.add(key);
                continue;
            }
            HashSet fields = DataSourceKeyMap.alias((String)"url");
            for (String field : fields) {
                String head;
                String db;
                String value = (String)copy_params.get(field);
                if (null == value || (db = (head = value.split("\\?")[0]).substring(head.lastIndexOf("/") + 1)) == null || db.equalsIgnoreCase(database)) continue;
                value = value.replace("/" + db, "/" + database);
                copy_params.put(field, value);
            }
            try {
                String id = ElasticSearchDatasourceHolder.reg(key, copy_params);
                if (null == id) continue;
                RuntimeHolder.runtime((String)key).origin(runtime.getKey());
                list.add(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private static List<Header> getDefaultHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("Connection", "Keep-Alive"));
        return headers;
    }

    private static HttpAsyncClientBuilder getHttpAsyncClientBuilder(HttpAsyncClientBuilder httpAsyncClientBuilder, String user, String password) {
        if (ObjectUtils.isEmpty((Object)user) || ObjectUtils.isEmpty((Object)password)) {
            return httpAsyncClientBuilder;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        return httpAsyncClientBuilder;
    }

    private static ConnectionKeepAliveStrategy connectionKeepAliveStrategy(Map<String, Integer> keepAliveTargetHost, int keepAliveTime) {
        return (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException ignore) {
                    log.error("\u89e3\u6790\u957f\u8fde\u63a5\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38", (Throwable)ignore);
                }
            }
            HttpHost target = (HttpHost)context.getAttribute("http.target_host");
            Optional<Map.Entry> any = Optional.ofNullable(keepAliveTargetHost).orElseGet(HashMap::new).entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(target.getHostName())).findAny();
            return any.map(en -> (long)((Integer)en.getValue()).intValue() * 1000L).orElse((long)keepAliveTime * 1000L);
        };
    }
}

