/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.elasticsearch.runtime;

import java.util.HashMap;
import java.util.Map;
import org.anyline.dao.init.springjdbc.DefaultDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.elasticsearch.adapter.ElasticSearchAdapter;
import org.anyline.data.elasticsearch.datasource.ElasticSearchDataSource;
import org.anyline.data.elasticsearch.runtime.ElasticSearchRuntime;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.proxy.RuntimeHolderProxy;
import org.anyline.service.init.DefaultService;
import org.elasticsearch.client.RestClient;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.stereotype.Component;

@Component(value="anyline.data.runtime.holder.elasticsearch")
public class ElasticSearchRuntimeHolder
extends RuntimeHolder {
    private static Map<String, RestClient> temporary = new HashMap<String, RestClient>();

    public ElasticSearchRuntimeHolder() {
        RuntimeHolderProxy.reg(RestClient.class, (RuntimeHolder)this);
        RuntimeHolderProxy.reg(ElasticSearchDataSource.class, (RuntimeHolder)this);
    }

    public static DataRuntime temporary(Object client, String database, DriverAdapter adapter) throws Exception {
        return ElasticSearchRuntimeHolder.exeTemporary(client, database, adapter);
    }

    public DataRuntime callTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return ElasticSearchRuntimeHolder.exeTemporary(datasource, database, adapter);
    }

    private static DataRuntime exeTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        ElasticSearchRuntime runtime = new ElasticSearchRuntime();
        if (null == adapter) {
            adapter = (DriverAdapter)factory.getBean(ElasticSearchAdapter.class);
        }
        if (!(datasource instanceof RestClient)) {
            throw new Exception("\u8bf7\u63d0\u4f9borg.elasticsearch.client.RestClient\u517c\u5bb9\u7c7b\u578b");
        }
        String key = "temporary_es";
        temporary.remove(key);
        runtime.setKey(key);
        runtime.setAdapter(adapter);
        RestClient client = (RestClient)datasource;
        runtime.setProcessor(client);
        temporary.put(key, client);
        log.warn("[\u521b\u5efa\u4e34\u65f6\u6570\u636e\u6e90][key:{}][type:{}]", (Object)key, (Object)datasource.getClass().getSimpleName());
        return runtime;
    }

    public static void reg(String key) {
        String datasource_key = "anyline.datasource." + key;
        RestClient client = (RestClient)factory.getBean(datasource_key, RestClient.class);
        ElasticSearchRuntimeHolder.reg(key, client, null);
    }

    public static ElasticSearchRuntime reg(String datasource, RestClient client, DriverAdapter adapter) {
        log.info("[create jdbc runtime][key:{}]", (Object)datasource);
        if (null == adapter) {
            adapter = (DriverAdapter)factory.getBean(ElasticSearchAdapter.class);
        }
        ElasticSearchRuntime runtime = new ElasticSearchRuntime(datasource, client, adapter);
        if (runtimes.containsKey(datasource)) {
            ElasticSearchRuntimeHolder.destroy(datasource);
        }
        runtimes.put(datasource, runtime);
        String dao_key = "anyline.dao." + datasource;
        String service_key = "anyline.service." + datasource;
        log.info("[instance service][data source:{}][instance id:{}]", (Object)datasource, (Object)service_key);
        BeanDefinitionBuilder daoBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultDao.class);
        daoBuilder.addPropertyValue("runtime", (Object)runtime);
        daoBuilder.setLazyInit(true);
        AbstractBeanDefinition daoDefinition = daoBuilder.getBeanDefinition();
        factory.registerBeanDefinition(dao_key, (BeanDefinition)daoDefinition);
        BeanDefinitionBuilder serviceBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultService.class);
        serviceBuilder.addPropertyReference("dao", dao_key);
        serviceBuilder.setLazyInit(true);
        AbstractBeanDefinition serviceDefinition = serviceBuilder.getBeanDefinition();
        factory.registerBeanDefinition(service_key, (BeanDefinition)serviceDefinition);
        return runtime;
    }

    public static void destroy(String key) {
        ElasticSearchRuntimeHolder.exeDestroy(key);
    }

    private static void exeDestroy(String key) {
        try {
            runtimes.remove(key);
            ElasticSearchRuntimeHolder.destroyBean((String)("anyline.service." + key));
            ElasticSearchRuntimeHolder.destroyBean((String)("anyline.dao." + key));
            ElasticSearchRuntimeHolder.destroyBean((String)("anyline.transaction." + key));
            ElasticSearchRuntimeHolder.destroyBean((String)("anyline.database." + key));
            log.warn("[\u6ce8\u9500\u6570\u636e\u6e90\u53ca\u76f8\u5173\u8d44\u6e90][key:{}]", (Object)key);
            Map runtimes = ElasticSearchRuntimeHolder.runtimes((String)key);
            for (String item : runtimes.keySet()) {
                ElasticSearchRuntimeHolder.destroy(item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void callDestroy(String key) {
        ElasticSearchRuntimeHolder.exeDestroy(key);
    }
}

