/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.elasticsearch.runtime;

import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.elasticsearch.entity.ElasticSearchDataRow;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.util.ConfigTable;
import org.elasticsearch.client.RestClient;

public class ElasticSearchRuntime
implements DataRuntime {
    private String origin;
    private String key;
    protected String feature;
    protected String version;
    protected DriverAdapter adapter;
    protected RestClient client;
    protected RuntimeHolder holder;
    protected String url;
    protected String driver;

    public ElasticSearchRuntime() {
        ConfigTable.DEFAULT_ELASTIC_SEARCH_ENTITY_CLASS = ElasticSearchDataRow.class;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getProcessor() {
        return this.client;
    }

    public void setProcessor(Object processor) {
        if (processor instanceof RestClient) {
            this.client = (RestClient)processor;
        }
    }

    public DriverAdapter getAdapter() {
        if (null == this.adapter) {
            String ds = this.key;
            this.adapter = DriverAdapterHolder.getAdapter((String)ds, (DataRuntime)this);
        }
        return this.adapter;
    }

    public String datasource() {
        return this.key;
    }

    public void setAdapter(DriverAdapter adapter) {
        this.adapter = adapter;
    }

    public ElasticSearchRuntime(String key, RestClient client, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(client);
        this.setAdapter(adapter);
    }

    public RestClient client() {
        return this.client;
    }

    public String origin() {
        return this.origin;
    }

    public void origin(String origin) {
        this.origin = origin;
    }

    public String getFeature(boolean connection) {
        if (null == this.feature && null != this.client) {
            this.feature = this.client.getClass().getName();
        }
        return this.feature;
    }

    public void setClient(RestClient client) {
        this.client = client;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public RuntimeHolder getHolder() {
        return this.holder;
    }

    public void setHolder(RuntimeHolder holder) {
        this.holder = holder;
    }
}

