/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.encrypt;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.anyline.util.Base64Util;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class RSAUtil {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";

    public static KeyPair create(int size) {
        KeyPairGenerator keys = null;
        try {
            keys = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        keys.initialize(size);
        KeyPair pair = keys.generateKeyPair();
        return pair;
    }

    public static KeyPair create() {
        return RSAUtil.create(1024);
    }

    public static String base64(Key key) {
        String base64 = null;
        base64 = Base64.encodeBase64URLSafeString((byte[])key.getEncoded());
        return base64;
    }

    public static RSAPublicKey createPublicKey(String base64) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)base64));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    public static RSAPrivateKey createPrivateKey(String base64) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)base64));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static String encrypt(String data, PublicKey key) throws Exception {
        try {
            RSAPublicKey publicKey = null;
            if (!(key instanceof RSAPublicKey)) {
                throw new Exception("\u8bf7\u63d0\u4f9bRRSAPublicKey");
            }
            publicKey = (RSAPublicKey)key;
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, publicKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new Exception("[\u516c\u94a5\u52a0\u5bc6\u5f02\u5e38][\u52a0\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    public static String encrypt(String data, String key) throws Exception {
        return RSAUtil.encrypt(data, RSAUtil.createPublicKey(key));
    }

    public static String decrypt(String data, PrivateKey key) throws Exception {
        try {
            RSAPrivateKey privateKey = null;
            if (!(key instanceof RSAPrivateKey)) {
                throw new Exception("\u8bf7\u63d0\u4f9bRSAPrivateKey");
            }
            privateKey = (RSAPrivateKey)key;
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, privateKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), privateKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new Exception("[\u79c1\u94a5\u89e3\u5bc6\u5f02\u5e38][\u89e3\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    public static String decrypt(String data, String key) throws Exception {
        return RSAUtil.decrypt(data, RSAUtil.createPrivateKey(key));
    }

    public static String encrypt(String data, RSAPrivateKey key) throws Exception {
        try {
            RSAPrivateKey privateKey = null;
            if (!(key instanceof RSAPrivateKey)) {
                throw new Exception("\u8bf7\u63d0\u4f9bRSAPrivateKey");
            }
            privateKey = key;
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, privateKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new Exception("[\u79c1\u94a5\u52a0\u5bc6\u5f02\u5e38][\u52a0\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    public static String decrypt(String data, RSAPublicKey key) throws Exception {
        try {
            RSAPublicKey publicKey = null;
            if (!(key instanceof RSAPublicKey)) {
                throw new Exception("\u8bf7\u63d0\u4f9bRRSAPublicKey");
            }
            publicKey = key;
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, publicKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), publicKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new Exception("[\u516c\u94a5\u89e3\u5bc6\u5f02\u5e38][\u89e3\u5bc6\u6570\u636e:" + data + "]", e);
        }
    }

    public static String sign(byte[] data, PrivateKey key) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(key);
        signature.update(data);
        return Base64Util.encode(signature.sign());
    }

    public static String sign(String data, String key) throws Exception {
        return RSAUtil.sign(data.getBytes(), (PrivateKey)RSAUtil.createPrivateKey(key));
    }

    public static String sign(String data, PrivateKey key) throws Exception {
        return RSAUtil.sign(data.getBytes(), key);
    }

    public static boolean verify(byte[] data, PublicKey key, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(key);
        signature.update(data);
        return signature.verify(Base64Util.decode(sign));
    }

    public static boolean verify(byte[] data, String key, String sign) throws Exception {
        return RSAUtil.verify(data, (PublicKey)RSAUtil.createPublicKey(key), sign);
    }

    public static boolean verify(String data, String key, String sign) throws Exception {
        return RSAUtil.verify(data.getBytes(), key, sign);
    }

    public static boolean verify(String data, PublicKey key, String sign) throws Exception {
        return RSAUtil.verify(data.getBytes(), key, sign);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKey createPrivateKey(File file) throws Exception {
        RSAPrivateKey privateKey = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            privateKey = RSAUtil.createPrivateKey(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPublicKey createPublicKey(File file) throws Exception {
        RSAPublicKey publicKey = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            publicKey = RSAUtil.createPublicKey(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
        return publicKey;
    }

    public static RSAPublicKey createPublicKey(InputStream is) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String readLine = null;
        while ((readLine = br.readLine()) != null) {
            if (readLine.charAt(0) == '-') continue;
            sb.append(readLine);
            sb.append('\r');
        }
        return RSAUtil.createPublicKey(sb.toString());
    }

    public static RSAPrivateKey createPrivateKey(InputStream is) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String readLine = null;
        while ((readLine = br.readLine()) != null) {
            if (readLine.charAt(0) == '-') continue;
            sb.append(readLine);
            sb.append('\r');
        }
        return RSAUtil.createPrivateKey(sb.toString());
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) throws Exception {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new Exception("[\u52a0\u5bc6\u5f02\u5e38][\u52a0\u89e3\u5bc6\u9600\u503c:" + maxBlock + "]", e);
        }
        byte[] result = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return result;
    }
}

