/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.anyline.util.BasicUtil;
import org.anyline.util.DateUtil;

public class IDCardUtil {
    private static Map<String, String> CODE_NM = new HashMap<String, String>();
    private static String[] CITY_CODE = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};

    public static boolean validate(String idcard) {
        if (idcard.length() == 15) {
            idcard = IDCardUtil.convertIdcarBy15bit(idcard);
        }
        return IDCardUtil.isValidate18Idcard(idcard);
    }

    private static boolean isValidate18Idcard(String idcard) {
        if (idcard.length() != 18) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        String idcard18Code = idcard.substring(17, 18);
        char[] c = null;
        String checkCode = "";
        if (!IDCardUtil.isDigital(idcard17)) {
            return false;
        }
        c = idcard17.toCharArray();
        if (null != c) {
            int[] bit = new int[idcard17.length()];
            bit = IDCardUtil.converCharToInt(c);
            int sum17 = 0;
            sum17 = IDCardUtil.getPowerSum(bit);
            checkCode = IDCardUtil.getCheckCodeBySum(sum17);
            if (null == checkCode) {
                return false;
            }
            if (!idcard18Code.equalsIgnoreCase(checkCode)) {
                return false;
            }
        }
        return true;
    }

    public static boolean validate15(String idcard) {
        if (idcard.length() != 15) {
            return false;
        }
        if (IDCardUtil.isDigital(idcard)) {
            String provinceid = idcard.substring(0, 2);
            String birthday = idcard.substring(6, 12);
            int year = Integer.parseInt(idcard.substring(6, 8));
            int month = Integer.parseInt(idcard.substring(8, 10));
            int day = Integer.parseInt(idcard.substring(10, 12));
            boolean flag = false;
            for (String id : CITY_CODE) {
                if (!id.equals(provinceid)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
            Date birthdate = null;
            try {
                birthdate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (birthdate == null || new Date().before(birthdate)) {
                return false;
            }
            GregorianCalendar curDay = new GregorianCalendar();
            int curYear = curDay.get(1);
            int year2bit = Integer.parseInt(String.valueOf(curYear).substring(2));
            if (year < 50 && year > year2bit) {
                return false;
            }
            if (month < 1 || month > 12) {
                return false;
            }
            boolean mflag = false;
            curDay.setTime(birthdate);
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    mflag = day >= 1 && day <= 31;
                    break;
                }
                case 2: {
                    if (curDay.isLeapYear(curDay.get(1))) {
                        mflag = day >= 1 && day <= 29;
                        break;
                    }
                    mflag = day >= 1 && day <= 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    boolean bl = mflag = day >= 1 && day <= 30;
                }
            }
            return mflag;
        }
        return false;
    }

    public static String convertIdcarBy15bit(String idcard) {
        String idcard17 = null;
        if (idcard.length() != 15) {
            return null;
        }
        if (IDCardUtil.isDigital(idcard)) {
            String birthday = idcard.substring(6, 12);
            Date birthdate = null;
            try {
                birthdate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Calendar cday = Calendar.getInstance();
            cday.setTime(birthdate);
            String year = String.valueOf(cday.get(1));
            idcard17 = idcard.substring(0, 6) + year + idcard.substring(8);
            char[] c = idcard17.toCharArray();
            String checkCode = "";
            if (null != c) {
                int[] bit = new int[idcard17.length()];
                bit = IDCardUtil.converCharToInt(c);
                int sum17 = 0;
                sum17 = IDCardUtil.getPowerSum(bit);
                checkCode = IDCardUtil.getCheckCodeBySum(sum17);
                if (null == checkCode) {
                    return null;
                }
                idcard17 = idcard17 + checkCode;
            }
        } else {
            return null;
        }
        return idcard17;
    }

    public static boolean isIdcard(String idcard) {
        return idcard == null || idcard.isEmpty() ? false : Pattern.matches("(^\\d{15}$)|(\\d{17}(?:\\d|x|X)$)", idcard);
    }

    public static boolean is15Idcard(String idcard) {
        return idcard == null || idcard.isEmpty() ? false : Pattern.matches("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$", idcard);
    }

    public static boolean is18Idcard(String idcard) {
        return Pattern.matches("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([\\d|x|X]{1})$", idcard);
    }

    private static boolean isDigital(String str) {
        return str == null || str.isEmpty() ? false : str.matches("^[0-9]*$");
    }

    private static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    private static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
            }
        }
        return checkCode;
    }

    private static int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }

    public static String getBirthday(String idcard) {
        if (!IDCardUtil.validate(idcard)) {
            return "";
        }
        String result = "";
        if (idcard.length() == 15) {
            idcard = IDCardUtil.convertIdcarBy15bit(idcard);
        }
        result = idcard.substring(6, 14);
        try {
            result = DateUtil.format(result, "yyyy-MM-dd");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getProvinceCode(String idcard) {
        if (!IDCardUtil.validate(idcard)) {
            return "";
        }
        String result = "";
        if (idcard.length() == 15) {
            idcard = IDCardUtil.convertIdcarBy15bit(idcard);
        }
        result = idcard.substring(0, 2);
        return result;
    }

    public static String getProvince(String idcard) {
        String result = IDCardUtil.getProvinceCode(idcard);
        if (BasicUtil.isEmpty((Object)result)) {
            return "";
        }
        if (BasicUtil.isEmpty((Object)(result = CODE_NM.get(result)))) {
            result = "";
        }
        return result;
    }

    public static String getSexCode(String idcard) {
        String id17;
        if (!IDCardUtil.validate(idcard)) {
            return "";
        }
        String result = "";
        if (idcard.length() == 15) {
            idcard = IDCardUtil.convertIdcarBy15bit(idcard);
        }
        result = Integer.parseInt(id17 = idcard.substring(16, 17)) % 2 != 0 ? "1" : "0";
        return result;
    }

    public static String getSex(String idcard) {
        String result = IDCardUtil.getSexCode(idcard);
        if (BasicUtil.isEmpty((Object)result)) {
            return "";
        }
        result = "1".equals(result) ? "\u7537" : "\u5973";
        return result;
    }

    public static int getAge(String idcard) {
        int age = -1;
        String birthday = IDCardUtil.getBirthday(idcard);
        if (BasicUtil.isNotEmpty(birthday)) {
            try {
                age = (int)DateUtil.diff(1, birthday);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return age;
    }

    static {
        CODE_NM.put("11", "\u5317\u4eac");
        CODE_NM.put("12", "\u5929\u6d25");
        CODE_NM.put("13", "\u6cb3\u5317");
        CODE_NM.put("14", "\u5c71\u897f");
        CODE_NM.put("15", "\u5185\u8499\u53e4");
        CODE_NM.put("21", "\u8fbd\u5b81");
        CODE_NM.put("22", "\u5409\u6797");
        CODE_NM.put("23", "\u9ed1\u9f99\u6c5f");
        CODE_NM.put("31", "\u4e0a\u6d77");
        CODE_NM.put("32", "\u6c5f\u82cf");
        CODE_NM.put("33", "\u6d59\u6c5f");
        CODE_NM.put("34", "\u5b89\u5fbd");
        CODE_NM.put("35", "\u798f\u5efa");
        CODE_NM.put("36", "\u6c5f\u897f");
        CODE_NM.put("37", "\u5c71\u4e1c");
        CODE_NM.put("41", "\u6cb3\u5357");
        CODE_NM.put("42", "\u6e56\u5317");
        CODE_NM.put("43", "\u6e56\u5357");
        CODE_NM.put("44", "\u5e7f\u4e1c");
        CODE_NM.put("45", "\u5e7f\u897f");
        CODE_NM.put("46", "\u6d77\u5357");
        CODE_NM.put("50", "\u91cd\u5e86");
        CODE_NM.put("51", "\u56db\u5ddd");
        CODE_NM.put("52", "\u8d35\u5dde");
        CODE_NM.put("53", "\u4e91\u5357");
        CODE_NM.put("54", "\u897f\u85cf");
        CODE_NM.put("61", "\u9655\u897f");
        CODE_NM.put("62", "\u7518\u8083");
        CODE_NM.put("63", "\u9752\u6d77");
        CODE_NM.put("64", "\u5b81\u590f");
        CODE_NM.put("65", "\u65b0\u7586");
        CODE_NM.put("71", "\u53f0\u6e7e");
        CODE_NM.put("81", "\u9999\u6e2f");
        CODE_NM.put("82", "\u6fb3\u95e8");
        CODE_NM.put("91", "\u56fd\u5916");
    }
}

