/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.metadata.Column;
import org.anyline.metadata.type.Convert;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.ConvertProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.CharUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.NumberUtil;
import org.anyline.util.encrypt.DESUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    public static ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);
    private static List<String> arr;

    private static ObjectMapper newObjectMapper(JsonInclude.Include include) {
        ObjectMapper result = new ObjectMapper();
        result.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        result.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        result.setSerializationInclusion(include);
        return result;
    }

    public static Object puarseFieldValue(Object value) {
        Object v = value;
        return v;
    }

    public static boolean setFieldValue(Object obj, Field field, Object value) {
        return BeanUtil.setFieldValue(obj, field, null, value);
    }

    public static boolean setFieldValue(Object obj, Field field, Object value, boolean alert) {
        return BeanUtil.setFieldValue(obj, field, null, value, alert);
    }

    public static Collection maps2object(Field field, Collection value) throws Exception {
        Class<?> clazz = field.getType();
        Collection list = null;
        Class itemClass = ClassUtil.getComponentClass(field);
        if (null == itemClass) {
            list = value;
        } else {
            list = (Collection)ClassUtil.newInstance(clazz);
            for (Object item : value) {
                if (!(item instanceof Map)) continue;
                Object oitem = BeanUtil.map2object((Map)item, itemClass, null, true, true, true, new String[0]);
                list.add(oitem);
            }
        }
        return list;
    }

    public static Map maps2object(Field field, Map value) throws Exception {
        Map map = (Map)value.getClass().newInstance();
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] args = pt.getActualTypeArguments();
            if (null != args && args.length > 1) {
                Class itemClass = (Class)args[1];
                for (Object key : value.keySet()) {
                    Object item = value.get(key);
                    if (!(item instanceof Map)) continue;
                    Object oitem = BeanUtil.map2object((Map)item, itemClass, null, true, true, true, new String[0]);
                    map.put(key, oitem);
                }
            }
        } else {
            map = value;
        }
        return map;
    }

    public static boolean setFieldValue(Object obj, Field field, Column metadata, Object value) {
        return BeanUtil.setFieldValue(obj, field, metadata, value, true);
    }

    public static Collection convertList(Object v, Class component) {
        Collection<Object> result;
        block10: {
            Object list;
            block9: {
                result = new ArrayList<Object>();
                if (v instanceof String) {
                    if ("concat".equalsIgnoreCase(ConfigTable.LIST2STRING_FORMAT)) {
                        String[] tmps = v.toString().split(",");
                        for (String tmp : tmps) {
                            result.add(tmp);
                        }
                    } else if ("json".equalsIgnoreCase(ConfigTable.LIST2STRING_FORMAT)) {
                        try {
                            JavaType type = JSON_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{component});
                            result = (Collection)JSON_MAPPER.readValue(v.toString(), type);
                        }
                        catch (Exception e) {
                            log.error("convert exception:", (Throwable)e);
                        }
                    }
                }
                if (!v.getClass().isArray()) break block9;
                for (Object item : list = (Object[])v) {
                    result.add(ConvertProxy.convert(item, component, false));
                }
                break block10;
            }
            if (!(v instanceof Collection)) break block10;
            list = (Collection)v;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                result.add(ConvertProxy.convert(item, component, false));
            }
        }
        return result;
    }

    public static boolean setFieldValue(Object obj, Field field, Column metadata, Object value, boolean alert) {
        if (null == field) {
            return false;
        }
        if (null != obj && Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        Object result = value;
        boolean compatible = true;
        String fieldType = field.getType().getSimpleName();
        Class<?> targetClass = field.getType();
        String type = fieldType.toLowerCase();
        TypeMetadata columnType = null;
        String columnTypeName = "";
        if (null != metadata) {
            columnType = metadata.getTypeMetadata();
            columnTypeName = metadata.getTypeName();
            if (null != columnTypeName) {
                columnTypeName = columnTypeName.toUpperCase();
            }
        }
        if (null != value && ClassUtil.isInSub(value.getClass(), targetClass)) {
            try {
                if (field.isAccessible()) {
                    field.set(obj, result);
                } else {
                    field.setAccessible(true);
                    field.set(obj, result);
                    field.setAccessible(false);
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String srcTypeKey = ClassUtil.type(value);
        String tarTypeKey = ClassUtil.type(field);
        Class componentClass = ClassUtil.getComponentClass(field);
        try {
            block31: {
                if (null != value) {
                    if (targetClass != Object.class && !srcTypeKey.equals(tarTypeKey)) {
                        Convert convert = ConvertProxy.getConvert(value.getClass(), targetClass);
                        try {
                            if (null == convert) {
                                if (targetClass.isArray()) {
                                    Collection converts = BeanUtil.convertList(value, componentClass);
                                    result = BeanUtil.collection2array(converts, componentClass);
                                } else if (ClassUtil.isInSub(targetClass, Collection.class)) {
                                    Collection list = (Collection)ClassUtil.newInstance(targetClass);
                                    Collection converts = BeanUtil.convertList(value, componentClass);
                                    list.addAll(converts);
                                    result = list;
                                } else if (ClassUtil.isInSub(targetClass, Map.class)) {
                                    Map map = (Map)ClassUtil.newInstance(targetClass);
                                    Class[] cls = ClassUtil.getComponentClasses(field);
                                    map = BeanUtil.object2map(map, value, null, cls[1]);
                                    result = map;
                                } else if (ClassUtil.isWrapClass(targetClass) && !targetClass.getName().startsWith("java")) {
                                    List<Field> fields = ClassUtil.getFields(targetClass, false, false);
                                    Object entity = ClassUtil.newInstance(targetClass);
                                    if (null != entity) {
                                        for (Field f : fields) {
                                            Object fv = BeanUtil.getFieldValue(result, f.getName());
                                            BeanUtil.setFieldValue(entity, f, fv);
                                        }
                                        result = entity;
                                    }
                                }
                                break block31;
                            }
                            result = ConvertProxy.convert(value, targetClass, false);
                        }
                        catch (Exception e) {
                            log.error("set field value exception:", (Throwable)e);
                        }
                    }
                } else if (type.equals("int") || type.equals("double") || type.equals("long") || type.equals("float") || type.equals("boolean") || type.equals("short") || type.equals("byte")) {
                    compatible = false;
                }
            }
            if (compatible) {
                if (field.isAccessible()) {
                    field.set(obj, result);
                } else {
                    field.setAccessible(true);
                    field.set(obj, result);
                    field.setAccessible(false);
                }
            }
        }
        catch (Exception e) {
            if (alert) {
                log.error("set field value exception:", (Throwable)e);
                log.error("[set field value][result:fail][field:{}({})] < [value:{}({})][column:{}][msg:{}]", new Object[]{field, tarTypeKey, result, srcTypeKey, columnType, e.toString()});
            }
            return false;
        }
        return true;
    }

    public static Double[] double2Double(double[] array) {
        if (null == array) {
            return null;
        }
        Double[] result = new Double[array.length];
        int idx = 0;
        for (double item : array) {
            result[idx++] = item;
        }
        return result;
    }

    public static double[] Double2double(Double[] array, double def) {
        if (null == array) {
            return null;
        }
        double[] result = new double[array.length];
        int idx = 0;
        for (Double item : array) {
            if (null == item) {
                item = def;
            }
            result[idx++] = item;
        }
        return result;
    }

    public static Long[] long2Long(long[] array) {
        if (null == array) {
            return null;
        }
        Long[] result = new Long[array.length];
        int idx = 0;
        for (long item : array) {
            result[idx++] = item;
        }
        return result;
    }

    public static long[] Long2long(Long[] array, long def) {
        if (null == array) {
            return null;
        }
        long[] result = new long[array.length];
        int idx = 0;
        for (Long item : array) {
            if (null == item) {
                item = def;
            }
            result[idx++] = item;
        }
        return result;
    }

    public static Integer[] int2Integer(int[] array) {
        if (null == array) {
            return null;
        }
        Integer[] result = new Integer[array.length];
        int idx = 0;
        for (int item : array) {
            result[idx++] = item;
        }
        return result;
    }

    public static int[] Integer2int(Integer[] array, int def) {
        if (null == array) {
            return null;
        }
        int[] result = new int[array.length];
        int idx = 0;
        for (Integer item : array) {
            if (null == item) {
                item = def;
            }
            result[idx++] = item;
        }
        return result;
    }

    public static Float[] float2Float(float[] array) {
        if (null == array) {
            return null;
        }
        Float[] result = new Float[array.length];
        int idx = 0;
        for (float item : array) {
            result[idx++] = Float.valueOf(item);
        }
        return result;
    }

    public static float[] Float2float(Float[] array, float def) {
        if (null == array) {
            return null;
        }
        float[] result = new float[array.length];
        int idx = 0;
        for (Float item : array) {
            if (null == item) {
                item = Float.valueOf(def);
            }
            result[idx++] = item.floatValue();
        }
        return result;
    }

    public static byte[] char2bytes(char[] chars) {
        Charset charset = StandardCharsets.ISO_8859_1;
        CharBuffer charBuffer = CharBuffer.allocate(chars.length);
        charBuffer.put(chars);
        charBuffer.flip();
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        return byteBuffer.array();
    }

    public static char[] byte2char(byte[] bytes) {
        Charset charset = StandardCharsets.ISO_8859_1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.flip();
        CharBuffer charBuffer = charset.decode(byteBuffer);
        return charBuffer.array();
    }

    public static boolean setFieldValue(Object obj, String field, Object value, boolean recursion, boolean alert) {
        if (null == obj || null == field) {
            return false;
        }
        if (obj instanceof Map) {
            Map tmp = (Map)obj;
            tmp.put(field, value);
        } else {
            Field f = ClassUtil.getField(obj.getClass(), field, recursion);
            if (null == f) {
                try {
                    Method method = obj.getClass().getMethod("set" + field.substring(0, 1).toUpperCase() + field.substring(1), value.getClass());
                    if (null != method) {
                        method.invoke(obj, value);
                    }
                }
                catch (Exception exception) {}
            } else {
                BeanUtil.setFieldValue(obj, f, value, alert);
            }
        }
        return true;
    }

    public static boolean setFieldValue(Object obj, String field, Object value, boolean recursion) {
        return BeanUtil.setFieldValue(obj, field, value, recursion, true);
    }

    public static boolean setFieldValue(Object obj, String field, Object value) {
        return BeanUtil.setFieldValue(obj, field, value, true);
    }

    public static Object getFieldValue(Object obj, Field field) {
        Object value = null;
        if (null == obj || null == field) {
            return null;
        }
        try {
            if (field.isAccessible()) {
                value = field.get(obj);
            } else {
                field.setAccessible(true);
                value = field.get(obj);
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static Object getFieldValue(Object obj, String field, boolean recursion) {
        if (null == obj) {
            return null;
        }
        Object value = null;
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            value = row.get(field);
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            value = map.get(field);
        } else if (obj instanceof Class) {
            Field f = ClassUtil.getField((Class)obj, field, recursion);
            value = BeanUtil.getFieldValue(obj, f);
        } else {
            Field f = ClassUtil.getField(obj.getClass(), field, recursion);
            if (null == f) {
                f = ClassUtil.getField(obj.getClass(), BeanUtil.camel(field), recursion);
            }
            value = BeanUtil.getFieldValue(obj, f);
        }
        return value;
    }

    public static Object getFieldValue(Object obj, String field) {
        return BeanUtil.getFieldValue(obj, field, false);
    }

    public static List<String> getMapKeys(Map map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : map.keySet()) {
            list.add(key.toString());
        }
        return list;
    }

    public static Map<String, Object> object2map(Object obj, String ... keys) {
        if (null == obj) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == keys || keys.length == 0) {
            if (obj instanceof Map) {
                Map tmp = (Map)obj;
                for (String key : tmp.keySet()) {
                    map.put(key, tmp.get(key));
                }
            } else {
                List<Field> fields = ClassUtil.getFields(obj.getClass());
                for (Field field : fields) {
                    String key = field.getName();
                    Object value = BeanUtil.getFieldValue(obj, field);
                    if (null == value) {
                        value = "";
                    }
                    map.put(key, value);
                }
            }
        } else {
            for (String key : keys) {
                Object value = null;
                if (obj instanceof Map) {
                    value = ((Map)obj).get(key);
                } else {
                    value = BeanUtil.getFieldValue(obj, key);
                    if (null == value) {
                        value = "";
                    }
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public static List<Map<String, Object>> list2maps(Collection<?> objs, String ... keys) {
        if (null == objs) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Object obj : objs) {
            list.add(BeanUtil.object2map(obj, keys));
        }
        return list;
    }

    public static void removeProperty(Collection<Object> objs, String ... keys) {
        if (null == keys || null == objs) {
            return;
        }
        for (String key : keys) {
            BeanUtil.removeProperty(objs, key);
        }
    }

    public static void removeProperty(Object obj, String key) {
        if (null == obj || null == key) {
            return;
        }
        if (obj instanceof Map) {
            ((Map)obj).remove(key);
        } else {
            BeanUtil.setFieldValue(obj, key, null);
        }
    }

    public static Collection<Object> fetch(Collection<Object> objs, String ... keys) {
        if (null == objs) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : objs) {
            list.add(BeanUtil.fetch(obj, keys));
        }
        return list;
    }

    public static Object fetch(Object obj, String ... keys) {
        if (null == obj) {
            return null;
        }
        Object result = null;
        try {
            result = obj.getClass().newInstance();
            if (null != keys) {
                for (String key : keys) {
                    Object value;
                    if (obj instanceof Map) {
                        value = ((Map)obj).get(key);
                        ((Map)obj).put(key, value);
                        continue;
                    }
                    value = BeanUtil.getFieldValue(obj, key);
                    BeanUtil.setFieldValue(obj, key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Collection<?> select(Collection<?> list, String ... params) {
        if (null == list || null == params || params.length == 0) {
            return list;
        }
        if (list instanceof DataSet) {
            return ((DataSet)list).getRows(params);
        }
        HashMap<String, String> kvs = new HashMap<String, String>();
        int len = params.length;
        int i = 0;
        while (i < len) {
            String p1 = params[i];
            if (BasicUtil.isEmpty((Object)p1)) {
                ++i;
                continue;
            }
            if (p1.contains(":")) {
                String[] ks = BeanUtil.parseKeyValue(p1);
                kvs.put(ks[0], ks[1]);
                ++i;
                continue;
            }
            if (i + 1 < len) {
                String p2 = params[i + 1];
                if (BasicUtil.isEmpty((Object)p2) || !p2.contains(":")) {
                    kvs.put(p1, p2);
                    i += 2;
                    continue;
                }
                String[] ks = BeanUtil.parseKeyValue(p2);
                kvs.put(ks[0], ks[1]);
                i += 2;
                continue;
            }
            ++i;
        }
        Object[] items = list.toArray();
        int size = list.size();
        for (i = size - 1; i >= 0; --i) {
            Object obj = items[i];
            boolean chk = true;
            for (String k : kvs.keySet()) {
                String v = (String)kvs.get(k);
                Object value = BeanUtil.getFieldValue(obj, k);
                if (null == v) {
                    if (null == value) continue;
                    chk = false;
                    break;
                }
                if (v.equals(String.valueOf(value))) continue;
                chk = false;
                break;
            }
            if (chk) continue;
            list.remove(obj);
        }
        return list;
    }

    public static Map<String, String> array2map(String ... params) {
        HashMap<String, String> map = new HashMap<String, String>();
        int len = params.length;
        int i = 0;
        while (i < len) {
            String p1 = params[i];
            if (BasicUtil.isEmpty((Object)p1)) {
                ++i;
                continue;
            }
            if (p1.contains(":")) {
                String[] ks = BeanUtil.parseKeyValue(p1);
                map.put(ks[0], ks[1]);
                ++i;
                continue;
            }
            if (i + 1 < len) {
                String p2 = params[i + 1];
                if (BasicUtil.isEmpty((Object)p2) || !p2.contains(":")) {
                    map.put(p1, p2);
                    i += 2;
                    continue;
                }
                String[] ks = BeanUtil.parseKeyValue(p2);
                map.put(ks[0], ks[1]);
                i += 2;
                continue;
            }
            ++i;
        }
        return map;
    }

    public static <T> T map2object(T obj, Map<String, ?> map, Class<T> clazz, Map metadatas, boolean recursion, boolean ignoreCase, boolean ignoreSplit, String ... keys) {
        try {
            if (null == obj) {
                if (Map.class.isAssignableFrom(clazz)) {
                    return (T)map;
                }
                if (Object.class == clazz) {
                    return (T)map;
                }
                obj = clazz == Map.class ? new HashMap() : clazz.newInstance();
            }
            Set<Map.Entry<String, ?>> es = map.entrySet();
            Iterator<Map.Entry<String, ?>> it = es.iterator();
            List<Field> fields = ClassUtil.getFields(clazz);
            while (it.hasNext()) {
                Map.Entry<String, ?> entry = it.next();
                String k = entry.getKey();
                Object v = entry.getValue();
                Field field = ClassUtil.getField(fields, k, ignoreCase, ignoreSplit);
                Column metadata = null;
                if (map instanceof DataRow) {
                    metadata = ((DataRow)map).getMetadata(k);
                }
                if (null == metadata && null != metadatas) {
                    metadata = (Column)metadatas.get(k.toUpperCase());
                }
                BeanUtil.setFieldValue(obj, field, metadata, v);
            }
            if (null != keys) {
                String[] stringArray = keys;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String key;
                    String f = key = stringArray[i];
                    String k = key;
                    String[] tmp = key.split(":");
                    if (tmp.length > 1) {
                        f = tmp[0];
                        k = tmp[1];
                    }
                    Object v = map.get(k);
                    BeanUtil.setFieldValue(obj, f, v, true);
                }
            }
        }
        catch (Exception e) {
            log.error("map2object exception:", (Throwable)e);
        }
        return obj;
    }

    public static <T> T map2object(Map<String, ?> map, Class<T> clazz, Map metadatas, boolean recursion, boolean ignoreCase, boolean ignoreSplit, String ... keys) {
        return BeanUtil.map2object(null, map, clazz, metadatas, recursion, ignoreCase, ignoreSplit, keys);
    }

    public static <T> T map2object(T obj, Map<String, ?> map, Class<T> clazz, Map metadatas, boolean recursion, boolean ignoreCase, boolean ignoreSplit, Map<Field, String> fields) {
        obj = BeanUtil.map2object(obj, map, clazz, metadatas, recursion, ignoreCase, ignoreSplit, new String[0]);
        for (Map.Entry<Field, String> item : fields.entrySet()) {
            Field field = item.getKey();
            String column = item.getValue();
            Object value = map.get(column);
            BeanUtil.setFieldValue(obj, field, value);
        }
        return obj;
    }

    public static <T> T map2object(Map<String, ?> map, Class<T> clazz, Map metadatas, boolean recursion, boolean ignoreCase, boolean ignoreSplit, Map<Field, String> fields) {
        return BeanUtil.map2object(null, map, clazz, metadatas, recursion, ignoreCase, ignoreSplit, fields);
    }

    public static <T> T map2object(Map<String, ?> map, Class<T> clazz, boolean recursion, boolean ignoreCase, boolean ignoreSplit, Map<Field, String> fields) {
        return BeanUtil.map2object(null, map, clazz, null, recursion, ignoreCase, ignoreSplit, fields);
    }

    public static <T> T map2object(T obj, Map<String, ?> map, Class<T> clazz, Map metadatas, Map<Field, String> fields) {
        return BeanUtil.map2object(obj, map, clazz, metadatas, false, false, false, fields);
    }

    public static <T> T map2object(T obj, Map<String, ?> map, Class<T> clazz, Map<Field, String> fields) {
        return BeanUtil.map2object(obj, map, clazz, null, false, false, false, fields);
    }

    public static <T> T map2object(Map<String, ?> map, Class<T> clazz, Map metadatas, Map<Field, String> fields) {
        return BeanUtil.map2object(null, map, clazz, metadatas, false, false, false, fields);
    }

    public static <T> T map2object(Map<String, ?> map, Class<T> clazz, Map<Field, String> fields) {
        return BeanUtil.map2object(null, map, clazz, null, false, false, false, fields);
    }

    public static <T> T map2object(T obj, Map<String, ?> map, Class<T> clazz, Map metadatas, String ... keys) {
        return BeanUtil.map2object(obj, map, clazz, metadatas, false, false, false, new String[0]);
    }

    public static <T> T map2object(T obj, Map<String, ?> map, Class<T> clazz, String ... keys) {
        return BeanUtil.map2object(obj, map, clazz, null, false, false, false, new String[0]);
    }

    public static <T> T map2object(Map<String, ?> map, Class<T> clazz, Map metadatas, String ... keys) {
        return BeanUtil.map2object(null, map, clazz, metadatas, false, false, false, new String[0]);
    }

    public static <T> T map2object(Map<String, ?> map, Class<T> clazz, String ... keys) {
        return BeanUtil.map2object(null, map, clazz, null, false, false, false, new String[0]);
    }

    public static <T> T json2oject(String json, Class<T> clazz, JsonInclude.Include include) {
        try {
            if (null != include) {
                return (T)BeanUtil.newObjectMapper(include).readValue(json, clazz);
            }
            return (T)JSON_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T json2oject(String json, Class<T> clazz) {
        return BeanUtil.json2oject(json, clazz, null);
    }

    public static String map2xml(Map<String, ?> map, boolean border, boolean order) {
        StringBuffer builder = new StringBuffer();
        if (border) {
            builder.append("<xml>");
        }
        if (order) {
            TreeMap sort = new TreeMap(map);
            Set es = sort.entrySet();
            for (Map.Entry entry : es) {
                String k = (String)entry.getKey();
                Object v = String.valueOf(entry.getValue());
                if ("null".equals(v)) {
                    v = "";
                }
                builder.append("<" + k + ">" + (String)v + "</" + k + ">");
            }
        } else {
            Set<Map.Entry<String, ?>> es = map.entrySet();
            for (Map.Entry<String, ?> entry : es) {
                String key = entry.getKey();
                Object value = String.valueOf(entry.getValue());
                if ("null".equals(value)) {
                    value = "";
                }
                builder.append("<").append(key).append(">").append((String)value).append("</").append(key).append(">");
            }
        }
        if (border) {
            builder.append("</xml>");
        }
        return builder.toString();
    }

    public static String map2xml(Map<String, ?> map) {
        return BeanUtil.map2xml(map, true, false);
    }

    public static String map2json(Map<String, ?> map) {
        return BeanUtil.object2json(map);
    }

    public static String map2json(Map<String, ?> map, JsonInclude.Include include) {
        return BeanUtil.object2json(map, include);
    }

    public static Map<String, Object> xml2map(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            Iterator itrProperty = root.elementIterator();
            while (itrProperty.hasNext()) {
                Element element = (Element)itrProperty.next();
                String key = element.getName();
                String value = element.getTextTrim();
                map.put(key, value);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String map2string(Map map, String join, String separator, boolean ignoreEmpty, boolean order) {
        StringBuilder result = new StringBuilder();
        Set es = null;
        if (order) {
            TreeMap wrap = new TreeMap(map);
            es = wrap.entrySet();
        } else {
            es = map.entrySet();
        }
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (ignoreEmpty && BasicUtil.isEmpty(v)) continue;
            if (v instanceof Collection) {
                ArrayList list = new ArrayList();
                list.addAll((Collection)v);
                Collections.sort(list);
                for (Object item : list) {
                    if (ignoreEmpty && BasicUtil.isEmpty(item)) continue;
                    if (result.length() > 0) {
                        result.append(separator);
                    }
                    result.append(k).append(join).append(item);
                }
                continue;
            }
            if (v instanceof String[]) {
                Object[] vals = (String[])v;
                Arrays.sort(vals);
                for (Object item : vals) {
                    if (ignoreEmpty && BasicUtil.isEmpty(item)) continue;
                    if (result.length() > 0) {
                        result.append(separator);
                    }
                    result.append(k).append(join).append((String)item);
                }
                continue;
            }
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(k).append(join).append(v);
        }
        return result.toString();
    }

    public static String map2string(Map map, boolean ignoreEmpty, boolean order) {
        return BeanUtil.map2string(map, "=", "&", ignoreEmpty, order);
    }

    public static String map2string(Map map) {
        return BeanUtil.map2string(map, "=", "&", true, true);
    }

    public static <T> T xml2object(String xml, Class<T> clazz, boolean recursion, boolean ignoreCase, boolean ignoreSplit) {
        return BeanUtil.xml2object(xml, clazz, null, recursion, ignoreCase, ignoreSplit);
    }

    public static <T> T xml2object(String xml, Class<T> clazz, Map columns, boolean recursion, boolean ignoreCase, boolean ignoreSplit) {
        T obj = null;
        try {
            Map<String, Object> map = BeanUtil.xml2map(xml);
            obj = BeanUtil.map2object(map, clazz, columns, recursion, ignoreCase, ignoreSplit, new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T> T xml2object(String xml, Class<T> clazz, Map columns, boolean recursion) {
        return BeanUtil.xml2object(xml, clazz, columns, recursion, false, false);
    }

    public static <T> T xml2object(String xml, Class<T> clazz, boolean recursion) {
        return BeanUtil.xml2object(xml, clazz, null, recursion, false, false);
    }

    public static <T> T xml2object(String xml, Class<T> clazz, Map columns) {
        return BeanUtil.xml2object(xml, clazz, columns, true);
    }

    public static <T> T xml2object(String xml, Class<T> clazz) {
        return BeanUtil.xml2object(xml, clazz, null, true);
    }

    public static String object2xml(Object obj) {
        if (null == obj) {
            return null;
        }
        StringBuffer builder = new StringBuffer();
        builder.append("<xml>");
        List<Field> fields = ClassUtil.getFields(obj.getClass());
        for (Field field : fields) {
            Object value = BeanUtil.getFieldValue(obj, field);
            if (null == value) {
                value = "";
            }
            builder.append("<").append(field.getName()).append(">").append(value).append("</").append(field.getName()).append(">");
        }
        builder.append("</xml>");
        return builder.toString();
    }

    public static Map<String, Object> object2map(Object obj) {
        if (null == obj) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Field> fields = ClassUtil.getFields(obj.getClass());
        for (Field field : fields) {
            Object value = BeanUtil.getFieldValue(obj, field);
            if (!ClassUtil.isJavaType(value)) {
                if (value instanceof Map) {
                    Map vmap = (Map)value;
                    for (Object k : vmap.keySet()) {
                        Object v = vmap.get(k);
                        if (!ClassUtil.isJavaType(v)) {
                            vmap.put(k, BeanUtil.object2map(v));
                            continue;
                        }
                        vmap.put(k, v);
                    }
                } else if (value instanceof Collection) {
                    Collection arrays = (Collection)value;
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                    for (Object item : arrays) {
                        if (!ClassUtil.isJavaType(item)) {
                            list.add(BeanUtil.object2map(item));
                            continue;
                        }
                        list.add((Map<String, Object>)item);
                    }
                    value = list;
                } else if (value.getClass().isArray()) {
                    ArrayList list = new ArrayList();
                    int len = Array.getLength(value);
                    for (int i = 0; i < len; ++i) {
                        Object item;
                        item = Array.get(value, i);
                        if (!ClassUtil.isJavaType(item)) {
                            item = BeanUtil.object2map(item);
                        }
                        list.add(item);
                    }
                    value = list;
                } else {
                    value = BeanUtil.object2map(value);
                }
            }
            map.put(field.getName(), value);
        }
        return map;
    }

    public static <K, V> Map<K, V> object2map(Object obj, List<K> keys) {
        return BeanUtil.object2map(new HashMap(), obj, keys, null);
    }

    public static <K, V> Map<K, V> object2map(Map map, Object obj) {
        return BeanUtil.object2map(map, obj, null, null);
    }

    public static <K, V> Map<K, V> object2map(Map map, Object obj, List<K> keys, Class<? extends V> valueClass) {
        if (null == obj) {
            return null;
        }
        if (null == keys || keys.isEmpty()) {
            if (obj instanceof Map) {
                try {
                    if (null == map) {
                        map = (Map)obj.getClass().newInstance();
                    }
                    Map objmap = (Map)obj;
                    for (Object key : objmap.keySet()) {
                        Object value = objmap.get(key);
                        if (null != valueClass && null != value) {
                            value = ConvertProxy.convert(value, valueClass, false);
                        }
                        map.put(key, value);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (null == map) {
                    map = new HashMap();
                }
                List<Field> fields = ClassUtil.getFields(obj.getClass());
                for (Field field : fields) {
                    Object value = BeanUtil.getFieldValue(obj, field);
                    if (null != valueClass && null != value) {
                        value = ConvertProxy.convert(value, valueClass, false);
                    }
                    map.put(field.getName(), value);
                }
            }
        } else {
            if (null == map) {
                map = new HashMap();
            }
            if (obj instanceof Map) {
                map = (Map)obj;
            } else {
                for (K key : keys) {
                    Object value = BeanUtil.getFieldValue(obj, key.toString());
                    if (null != valueClass && null != value) {
                        value = ConvertProxy.convert(value, valueClass, false);
                    }
                    map.put(key, value);
                }
            }
        }
        return map;
    }

    public static <T> List<Map<String, Object>> objects2maps(Collection<T> objs, List<String> keys) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (null != objs) {
            for (T obj : objs) {
                if (obj instanceof Map) {
                    HashMap item = new HashMap();
                    for (String key : keys) {
                        item.put(key, ((Map)obj).get(key));
                    }
                    maps.add(item);
                    continue;
                }
                maps.add(BeanUtil.object2map(obj, keys));
            }
        }
        return maps;
    }

    public static <T> List<Map<String, Object>> objects2maps(Collection<T> objs) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (null != objs) {
            for (T obj : objs) {
                if (obj instanceof Map) {
                    maps.add((Map)obj);
                    continue;
                }
                maps.add(BeanUtil.object2map(obj));
            }
        }
        return maps;
    }

    public static String object2json(Object obj, JsonInclude.Include include) {
        if (null != obj) {
            if (obj.getClass().getName().toUpperCase().contains("JSON")) {
                return obj.toString();
            }
            try {
                if (null != include) {
                    return BeanUtil.newObjectMapper(include).writeValueAsString(obj);
                }
                return JSON_MAPPER.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String object2json(Object obj) {
        return BeanUtil.object2json(obj, null);
    }

    public static Map<String, Object> param2map(String url, boolean empty, boolean decode, String charset) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != url) {
            String[] kvs;
            int index = url.indexOf("?");
            if (index != -1) {
                url = url.substring(index);
            }
            for (String kv : kvs = url.split("&")) {
                String k = null;
                String v = null;
                int idx = kv.indexOf("=");
                if (idx != -1) {
                    k = kv.substring(0, idx);
                    v = kv.substring(idx + 1);
                }
                if ("null".equals(v)) {
                    v = "";
                } else if ("NULL".equals(v)) {
                    v = null;
                }
                if (BasicUtil.isEmpty((Object)v) && !empty) continue;
                if (decode) {
                    v = BeanUtil.urlDecode(v, charset);
                }
                if (params.containsKey(k)) {
                    Object olds = params.get(k);
                    ArrayList vs = new ArrayList();
                    if (null == olds) {
                        vs.add(null);
                    } else if (olds instanceof String) {
                        vs.add(olds.toString());
                    } else if (olds instanceof ArrayList) {
                        vs = (ArrayList)olds;
                    }
                    vs.add(v);
                    params.put(k, vs);
                    continue;
                }
                params.put(k, v);
            }
        }
        return params;
    }

    public static String urlDecode(String src, String charset) {
        String result = null;
        if (null != src) {
            try {
                result = null == charset ? URLDecoder.decode(src) : URLDecoder.decode(src, charset);
            }
            catch (Exception e) {
                result = src;
            }
        }
        return result;
    }

    public static Map<String, Object> param2map(String url, boolean empty) {
        return BeanUtil.param2map(url, empty, false, "UTF-8");
    }

    public static Map<String, Object> param2map(String url, boolean empty, boolean decode) {
        return BeanUtil.param2map(url, empty, decode, "UTF-8");
    }

    public static List<Object> extract(Collection<?> list, String key) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (null != list) {
            for (Object obj : list) {
                Object value = BeanUtil.getFieldValue(obj, key);
                values.add(value);
            }
        }
        return values;
    }

    public static List<Map<String, Object>> extracts(Collection<?> list, String ... keys) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (null != list) {
            for (Object obj : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (null == keys) continue;
                for (String key : keys) {
                    Object value = BeanUtil.getFieldValue(obj, key);
                    map.put(key, value);
                }
                result.add(map);
            }
        }
        return result;
    }

    public static <T> Collection<T> distinct(Collection<T> list, String ... keys) {
        ArrayList<T> result = new ArrayList<T>();
        if (null != list) {
            for (T obj : list) {
                if (null == keys || keys.length == 0) {
                    if (result.contains(obj)) continue;
                    result.add(obj);
                    continue;
                }
                if (!BeanUtil.contain(result, obj, keys)) continue;
                result.add(obj);
            }
        }
        return result;
    }

    public static <T> Collection<T> distinct(Collection<T> list, List<String> keys) {
        ArrayList<T> result = new ArrayList<T>();
        if (null != list) {
            for (T obj : list) {
                if (null == keys || keys.size() == 0) {
                    if (result.contains(obj)) continue;
                    result.add(obj);
                    continue;
                }
                if (BeanUtil.contain(result, obj, keys)) continue;
                result.add(obj);
            }
        }
        return result;
    }

    public static <T> boolean contain(Collection<T> list, T obj, String ... keys) {
        for (T item : list) {
            if (!BeanUtil.equals(item, obj, new String[0])) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contain(Collection<T> list, T obj, List<String> keys) {
        for (T item : list) {
            if (!BeanUtil.equals(item, obj, keys)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean equals(T obj1, T obj2, List<String> keys) {
        if (null == keys || keys.isEmpty()) {
            if (null == obj1) {
                return null == obj2;
            }
            if (!ClassUtil.isPrimitiveClass(obj1)) {
                if (null == obj2) {
                    return false;
                }
                if (obj1.toString().equals(obj2.toString())) {
                    return true;
                }
            }
            return false;
        }
        for (String key : keys) {
            Object v2;
            Object v1 = BeanUtil.getFieldValue(obj1, key);
            if (BeanUtil.equals(v1, v2 = BeanUtil.getFieldValue(obj2, key), new String[0])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T obj1, T obj2, String ... keys) {
        return BeanUtil.equals(obj1, obj2, BeanUtil.array2list(new String[][]{keys}));
    }

    public static String concat(Collection<?> list, String field, String split, boolean required, boolean recursion) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Object item : list) {
                if (!required && BasicUtil.isEmpty(item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(BeanUtil.getFieldValue(item, field, recursion));
            }
        }
        return builder.toString();
    }

    public static String concat(Collection<?> list, String field, String split, boolean required) {
        return BeanUtil.concat(list, field, split, required, false);
    }

    public static String concat(Collection<?> list, String field, String split) {
        return BeanUtil.concat(list, field, split, false);
    }

    public static String concat(Collection<?> list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Object item : list) {
                if (!required && BasicUtil.isEmpty(item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(Collection<?> list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(Collection<?> list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(Collection<?> list) {
        return BeanUtil.concat(list, false);
    }

    public static <T> String concat(T[] list, String key, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (T item : list) {
                if (!required && BasicUtil.isEmpty(item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static <T> String concat(T[] list, String key, String split) {
        return BeanUtil.concat(list, key, split, false);
    }

    public static <T> String concat(T[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (T item : list) {
                if (!required && BasicUtil.isEmpty(item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static <T> String concat(T[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static <T> String concat(T[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static <T> String concat(T[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(Integer[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Integer item : list) {
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(Integer[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(Integer[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(Integer[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(Long[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Long item : list) {
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(Long[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(Long[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(Long[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(Double[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Double item : list) {
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(Double[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(Double[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(Double[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(Float[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Float item : list) {
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(Float[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(Float[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(Float[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(Short[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Short item : list) {
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(Short[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(Short[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(Short[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(Byte[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            for (Byte item : list) {
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(Byte[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(Byte[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(Byte[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(int[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            int[] nArray = list;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer item = nArray[i];
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(int[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(int[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(int[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(long[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            long[] lArray = list;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long item = lArray[i];
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(long[] list, String split) {
        return BeanUtil.concat(list, split);
    }

    public static String concat(long[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(long[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(double[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            double[] dArray = list;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double item = dArray[i];
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(double[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(double[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(double[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(float[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            float[] fArray = list;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float item = Float.valueOf(fArray[i]);
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(float[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(float[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(float[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(short[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            short[] sArray = list;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short item = sArray[i];
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(short[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(short[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(short[] list) {
        return BeanUtil.concat(list, false);
    }

    public static String concat(byte[] list, String split, boolean required) {
        StringBuilder builder = new StringBuilder();
        if (null != list) {
            byte[] byArray = list;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte item = byArray[i];
                if (!required && BasicUtil.isEmpty((Object)item)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String concat(byte[] list, String split) {
        return BeanUtil.concat(list, split, false);
    }

    public static String concat(byte[] list, boolean required) {
        return BeanUtil.concat(list, ",", required);
    }

    public static String concat(byte[] list) {
        return BeanUtil.concat(list, false);
    }

    public static List wrap(Collection list, String wrap) {
        ArrayList result = new ArrayList();
        for (Object obj : list) {
            if (null == obj) {
                result.add(null);
                continue;
            }
            if (BasicUtil.isNumber(obj)) {
                result.add(obj);
                continue;
            }
            result.add(wrap + String.valueOf(obj) + wrap);
        }
        return result;
    }

    public static List<String> toUpperCase(List<String> list) {
        return BeanUtil.toUpperCase(list, false);
    }

    public static List<String> toUpperCase(List<String> list, boolean update) {
        if (null == list) {
            return list;
        }
        ArrayList<String> result = null;
        if (!update) {
            result = new ArrayList();
            for (String value : list) {
                if (null != value) {
                    value = value.toUpperCase();
                }
                result.add(value);
            }
        } else {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                if (null == value) continue;
                result.set(i, value.toUpperCase());
            }
            result = list;
        }
        return result;
    }

    public static List<String> toLowerCase(List<String> list) {
        if (null != list) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String value = list.get(i);
                if (null == value) continue;
                list.set(i, value.toLowerCase());
            }
        }
        return list;
    }

    public static Object toUpperCaseKey(Object obj, String ... keys) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Date) {
            return obj;
        }
        if (obj instanceof Map) {
            obj = BeanUtil.toUpperCaseKey((Map)obj, keys);
        } else if (obj instanceof Collection) {
            obj = BeanUtil.toUpperCaseKey((Collection)obj, keys);
        }
        return obj;
    }

    public static Collection toUpperCaseKey(Collection con, String ... keys) {
        if (null == con) {
            return con;
        }
        for (Object obj : con) {
            Object object = BeanUtil.toUpperCaseKey(obj, keys);
        }
        return con;
    }

    public static Map<String, Object> toUpperCaseKey(Map<String, Object> map, String ... keys) {
        if (null == map) {
            return map;
        }
        List<String> ks = BeanUtil.getMapKeys(map);
        for (String k : ks) {
            if (null != keys && keys.length != 0 && !BasicUtil.containsString(keys, k)) continue;
            Object v = map.get(k);
            String key = k.toUpperCase();
            map.remove(k);
            map.put(key, v);
        }
        return map;
    }

    public static <T> T[] list2array(List<T> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(list.get(0).getClass(), list.size());
        int index = 0;
        for (T item : list) {
            result[index++] = item;
        }
        return result;
    }

    public static <T> T[] collection2array(Collection<T> list) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        Class clazz = ClassUtil.getComponentClass(list);
        Object[] result = (Object[])Array.newInstance(clazz, list.size());
        int index = 0;
        for (T item : list) {
            result[index++] = item;
        }
        return result;
    }

    public static <T> Object collection2array(Collection list, Class<T> clazz) {
        if (null == list || list.isEmpty()) {
            return null;
        }
        Object[] result = null;
        int size = list.size();
        if (clazz == Integer.TYPE) {
            int[] ints = new int[size];
            int index = 0;
            for (Object item : list) {
                ints[index++] = BasicUtil.parseInt(item, 0);
            }
            result = ints;
        } else if (clazz == Double.TYPE) {
            double[] doubles = new double[size];
            int index = 0;
            for (Object item : list) {
                doubles[index++] = BasicUtil.parseDouble(item, 0.0);
            }
            result = doubles;
        } else if (clazz == Float.TYPE) {
            float[] floats = new float[size];
            int index = 0;
            for (Object item : list) {
                floats[index++] = BasicUtil.parseFloat(item, Float.valueOf(0.0f)).floatValue();
            }
            result = floats;
        } else if (clazz == Long.TYPE) {
            long[] longs = new long[size];
            int index = 0;
            for (Object item : list) {
                longs[index++] = BasicUtil.parseLong(item, 0L);
            }
            result = longs;
        } else {
            Object[] array = (Object[])Array.newInstance(clazz, list.size());
            int index = 0;
            for (Object item : list) {
                array[index++] = ConvertProxy.convert(item, clazz, false);
            }
            result = array;
        }
        return result;
    }

    public static String list2string(List<?> list) {
        return "[" + BeanUtil.concat(list) + "]";
    }

    public static <T> String array2string(T[] array) {
        return "[" + BeanUtil.concat(array) + "]";
    }

    public static <T> T[] cut(T[] array, int fr, int to) {
        if (null == array || array.length == 0) {
            return array;
        }
        Object[] result = (Object[])Array.newInstance(array[0].getClass(), to - fr + 1);
        for (int i = fr; i <= to; ++i) {
            result[i - fr] = array[i];
        }
        return result;
    }

    public static byte[] cut(byte[] array, int fr, int to) {
        if (null == array || array.length == 0) {
            return array;
        }
        byte[] result = new byte[to - fr + 1];
        for (int i = fr; i <= to; ++i) {
            result[i - fr] = array[i];
        }
        return result;
    }

    public static short[] cut(short[] array, int fr, int to) {
        if (null == array || array.length == 0) {
            return array;
        }
        short[] result = new short[to - fr + 1];
        for (int i = fr; i <= to; ++i) {
            result[i - fr] = array[i];
        }
        return result;
    }

    public static int[] cut(int[] array, int fr, int to) {
        if (null == array || array.length == 0) {
            return array;
        }
        int[] result = new int[to - fr + 1];
        for (int i = fr; i <= to; ++i) {
            result[i - fr] = array[i];
        }
        return result;
    }

    public static byte[] fill(byte[] bytes, int len) {
        byte[] result = new byte[len];
        for (int i = 0; i < bytes.length && i < len; ++i) {
            result[len + i - bytes.length] = bytes[i];
        }
        return result;
    }

    public static Map<String, String> string2map(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (BasicUtil.isNotEmpty(str)) {
            String[] list;
            if (BasicUtil.checkEl(str)) {
                str = str.substring(2, str.length() - 1);
            } else if (str.startsWith("{") && str.endsWith("}")) {
                str = str.substring(1, str.length() - 1);
            }
            for (String item : list = str.split(",")) {
                String[] kv = item.split(":");
                if (kv.length == 2) {
                    String v;
                    String k = kv[0];
                    if (k.startsWith("\"") && k.endsWith("\"")) {
                        k = k.substring(1, k.length() - 1);
                    }
                    if ((v = kv[1]).startsWith("\"") && v.endsWith("\"")) {
                        v = v.substring(1, v.length() - 1);
                    }
                    map.put(k, v);
                    continue;
                }
                map.put(item.replace(":", ""), null);
            }
        }
        return map;
    }

    public static byte[] stream2bytes(InputStream is) throws Exception {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((len = is.read(b)) != -1) {
            bos.write(b, 0, len);
        }
        byte[] array = bos.toByteArray();
        bos.close();
        return array;
    }

    public static Map<String, String> createMap(String ... params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null != params) {
            int size = params.length;
            for (int i = 0; i < size - 1; i += 2) {
                String key = params[i];
                String value = params[i + 1];
                if (null == value) {
                    value = "";
                }
                result.put(key.toString(), value);
            }
        }
        return result;
    }

    public static void clearEmpty(Map<String, Object> map, boolean recursion) {
        if (null == map) {
            return;
        }
        List<String> keys = BasicUtil.getMapKeys(map);
        for (String key : keys) {
            Object value = map.get(key);
            if (!BasicUtil.isEmpty(recursion, value)) continue;
            map.remove(key);
        }
    }

    public static void clearEmpty(Map<String, Object> map) {
        BeanUtil.clearEmpty(map, true);
    }

    public static void clearEmpty(List<Object> list, boolean recursion) {
        if (null == list) {
            return;
        }
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!BasicUtil.isEmpty(recursion, list.get(i))) continue;
            list.remove(i);
        }
    }

    public static void clearEmpty(List<Object> list) {
        BeanUtil.clearEmpty(list, true);
    }

    public static <T> T[] union(T[] first, T[] ... rest) {
        int len = first.length;
        for (T[] array : rest) {
            len += array.length;
        }
        T[] result = Arrays.copyOf(first, len);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static int closest(short[] array, short value) {
        int index = 0;
        int dif = -1;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            int abs = Math.abs(array[i] - value);
            if (dif != -1 && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(Short[] array, short value) {
        int index = 0;
        int dif = -1;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            int abs = Math.abs(array[i] - value);
            if (dif != -1 && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(List<Short> array, short value) {
        int index = 0;
        int dif = -1;
        int len = array.size();
        for (int i = 0; i < len; ++i) {
            if (array.get(i) == value) {
                index = i;
                break;
            }
            int abs = Math.abs(array.get(i) - value);
            if (dif != -1 && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(int[] array, int value) {
        int index = 0;
        int dif = -1;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            int abs = Math.abs(array[i] - value);
            if (dif != -1 && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(Integer[] array, int value) {
        int index = 0;
        int dif = -1;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            int abs = Math.abs(array[i] - value);
            if (dif != -1 && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(List<Integer> array, int value) {
        int index = 0;
        int dif = -1;
        int len = array.size();
        for (int i = 0; i < len; ++i) {
            if (array.get(i) == value) {
                index = i;
                break;
            }
            int abs = Math.abs(array.get(i) - value);
            if (dif != -1 && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(long[] array, long value) {
        int index = 0;
        long dif = -1L;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            long abs = Math.abs(array[i] - value);
            if (dif != -1L && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(Long[] array, long value) {
        int index = 0;
        long dif = -1L;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            long abs = Math.abs(array[i] - value);
            if (dif != -1L && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(List<Long> array, long value) {
        int index = 0;
        long dif = -1L;
        int len = array.size();
        for (int i = 0; i < len; ++i) {
            if (array.get(i) == value) {
                index = i;
                break;
            }
            long abs = Math.abs(array.get(i) - value);
            if (dif != -1L && dif <= abs) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(float[] array, float value) {
        int index = 0;
        float dif = -1.0f;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            float abs = Math.abs(array[i] - value);
            if (dif != -1.0f && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(Float[] array, float value) {
        int index = 0;
        float dif = -1.0f;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i].floatValue() == value) {
                index = i;
                break;
            }
            float abs = Math.abs(array[i].floatValue() - value);
            if (dif != -1.0f && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(List<Float> array, float value) {
        int index = 0;
        float dif = -1.0f;
        int len = array.size();
        for (int i = 0; i < len; ++i) {
            if (array.get(i).floatValue() == value) {
                index = i;
                break;
            }
            float abs = Math.abs(array.get(i).floatValue() - value);
            if (dif != -1.0f && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(double[] array, double value) {
        int index = 0;
        double dif = -1.0;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            double abs = Math.abs(array[i] - value);
            if (dif != -1.0 && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(Double[] array, double value) {
        int index = 0;
        double dif = -1.0;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] == value) {
                index = i;
                break;
            }
            double abs = Math.abs(array[i] - value);
            if (dif != -1.0 && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(List<Double> array, double value) {
        int index = 0;
        double dif = -1.0;
        int len = array.size();
        for (int i = 0; i < len; ++i) {
            if (array.get(i) == value) {
                index = i;
                break;
            }
            double abs = Math.abs(array.get(i) - value);
            if (dif != -1.0 && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(BigDecimal[] array, BigDecimal value) {
        int index = 0;
        double dif = -1.0;
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            double abs = Math.abs(array[i].subtract(value).doubleValue());
            if (abs == 0.0) {
                index = i;
                break;
            }
            if (dif != -1.0 && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static int closest(List<BigDecimal> array, BigDecimal value) {
        int index = 0;
        double dif = -1.0;
        int len = array.size();
        for (int i = 0; i < len; ++i) {
            double abs = Math.abs(array.get(i).subtract(value).doubleValue());
            if (abs == 0.0) {
                index = i;
                break;
            }
            if (dif != -1.0 && !(dif > abs)) continue;
            dif = abs;
            index = i;
        }
        return index;
    }

    public static String parseFinalValue(Object obj, String key) {
        return BeanUtil.parseFinalValue(obj, key, "");
    }

    public static String parseFinalValue(Object obj, String key, String def) {
        if (null == obj) {
            return key;
        }
        String value = key;
        if (BasicUtil.isNotEmpty(key)) {
            if (key.contains("${")) {
                try {
                    List<String> ks = RegularUtil.fetch(key, "\\${\\w+\\}", Regular.MATCH_MODE.CONTAIN, 0);
                    for (String k : ks) {
                        Object v = BeanUtil.getFieldValue(obj, k.replace("${", "").replace("}", ""));
                        if (null == v) {
                            v = "";
                        }
                        value = value.replace(k, v.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Object val = BeanUtil.getFieldValue(obj, key);
                if (null != val) {
                    value = val.toString();
                }
            }
        }
        if (BasicUtil.isEmpty((Object)value) || value.equals(key)) {
            value = def;
        }
        return value;
    }

    public static <T> List<T> cuts(Collection<T> list, int begin, int end) {
        ArrayList<T> result = new ArrayList<T>();
        if (null != list) {
            if (begin <= 0) {
                begin = 0;
            }
            if (end < 0 || end >= list.size()) {
                end = list.size() - 1;
            }
        }
        int idx = 0;
        for (T obj : list) {
            if (idx >= begin && idx <= end) {
                result.add(obj);
            }
            if (++idx <= end) continue;
            break;
        }
        return result;
    }

    public static String camel_(String str) {
        Pattern pattern = Pattern.compile("(?<=[a-z0-9])([A-Z])");
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll("_$1").toLowerCase();
    }

    public static String camel(String key, boolean hold) {
        if (!key.contains("-") && !key.contains("_")) {
            return key;
        }
        String[] ks = key.split("_|-");
        Object sKey = null;
        for (String k : ks) {
            if (null == sKey) {
                sKey = k.toLowerCase();
                continue;
            }
            if (hold) {
                sKey = (String)sKey + "_";
            }
            sKey = (String)sKey + CharUtil.toUpperCaseHeader(k.toLowerCase());
        }
        return sKey;
    }

    public static String camel(String key) {
        return BeanUtil.camel(key, false);
    }

    public static String Camel(String key, boolean hold) {
        if (!key.contains("-") && !key.contains("_")) {
            return key;
        }
        String[] ks = key.split("_|-");
        Object sKey = null;
        for (String k : ks) {
            if (null == sKey) {
                sKey = CharUtil.toUpperCaseHeader(k.toLowerCase());
                continue;
            }
            if (hold) {
                sKey = (String)sKey + "_";
            }
            sKey = (String)sKey + CharUtil.toUpperCaseHeader(k.toLowerCase());
        }
        return sKey;
    }

    public static String Camel(String key) {
        return BeanUtil.Camel(key, false);
    }

    public static String[] parseKeyValue(String src) {
        if (BasicUtil.isEmpty((Object)src)) {
            return null;
        }
        int len = 2;
        String[] result = null;
        String key1 = src;
        String key2 = src;
        if (src.contains(":")) {
            String[] tmp = src.split(":");
            len = NumberUtil.max(len, tmp.length);
            result = new String[len];
            key1 = tmp[0];
            key2 = tmp.length > 1 ? tmp[1] : "";
            for (int i = 2; i < len; ++i) {
                result[i] = tmp[i];
            }
        } else {
            result = new String[]{key1, key2};
        }
        return result;
    }

    public static boolean isJson(Object json) {
        if (null == json) {
            return false;
        }
        try {
            JSON_MAPPER.readTree(json.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Object value(JsonNode json) {
        if (null == json) {
            return null;
        }
        if (json.isNull()) {
            return null;
        }
        if (json.isInt()) {
            return json.asInt();
        }
        if (json.isBoolean()) {
            return json.asBoolean();
        }
        if (json.isDouble()) {
            return json.asDouble();
        }
        if (json.isLong()) {
            return json.asLong();
        }
        return json.asText();
    }

    public static Object extract(Object src, boolean voluntary, String ... keys) {
        if (null == keys || keys.length == 0) {
            return null;
        }
        Object result = src;
        for (String key : keys) {
            if (null == result) continue;
            if (ClassUtil.isWrapClass(result) && !(result instanceof String)) {
                result = BeanUtil.getFieldValue(result, key);
                continue;
            }
            if (voluntary) {
                return result;
            }
            result = null;
        }
        return result;
    }

    public static Object extract(Object src, String ... keys) {
        return BeanUtil.extract(src, false, keys);
    }

    public static Object nvl(Object src, String ... keys) {
        Object value = null;
        if (null == src || null == keys) {
            return value;
        }
        for (String key : keys) {
            value = BeanUtil.getFieldValue(src, key);
            if (null == value) continue;
            return value;
        }
        return value;
    }

    public static Object evl(Object src, String ... keys) {
        Object value = null;
        if (null == src || null == keys) {
            return value;
        }
        for (String key : keys) {
            value = BeanUtil.getFieldValue(src, key);
            if (!BasicUtil.isNotEmpty(value)) continue;
            return value;
        }
        return value;
    }

    public static Object propertyNvl(Map<String, ?> map, String ... keys) {
        Object value = null;
        if (null == map || null == keys) {
            return value;
        }
        for (String key : keys) {
            value = map.get(key);
            if (null != value) {
                return value;
            }
            String[] ks = key.split("_");
            Object sKey = null;
            for (String k : ks) {
                sKey = null == sKey ? k : (String)sKey + CharUtil.toUpperCaseHeader(k);
            }
            value = map.get(sKey);
            if (null != value) {
                return value;
            }
            ks = key.split("-");
            sKey = null;
            for (String k : ks) {
                sKey = null == sKey ? k : (String)sKey + CharUtil.toUpperCaseHeader(k);
            }
            value = map.get(sKey);
            if (null == value) continue;
            return value;
        }
        return value;
    }

    public static void setFieldsValue(Object obj, Map<String, ?> map, boolean alert) {
        if (null != map && null != obj) {
            List<String> fields = ClassUtil.getFieldsName(obj.getClass());
            for (String field : fields) {
                Object value = BeanUtil.propertyNvl(map, field);
                if (!BasicUtil.isNotEmpty(value)) continue;
                BeanUtil.setFieldValue(obj, field, value, true, alert);
            }
        }
    }

    public static void setFieldsValue(Object obj, Map<String, ?> map) {
        BeanUtil.setFieldsValue(obj, map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object value) {
        byte[] rv = new byte[]{};
        if (value == null) {
            return rv;
        }
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(value);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] in) {
        Object rv = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            if (in != null) {
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
                is.close();
                bis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return rv;
    }

    public static List list(Object array) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (null != array) {
            if (array.getClass().isArray()) {
                int len = Array.getLength(array);
                for (int i = 0; i < len; ++i) {
                    list.add(Array.get(array, i));
                }
            } else if (array instanceof Collection) {
                Collection items = (Collection)array;
                for (Object item : items) {
                    list.add(item);
                }
            } else {
                list.add(array);
            }
        } else {
            list.add(array);
        }
        return list;
    }

    public static Object first(Object object) {
        Object value = null;
        if (null != object) {
            if (object instanceof Collection) {
                Collection list = (Collection)object;
                if (!list.isEmpty()) {
                    value = list.iterator().next();
                }
            } else if (object.getClass().isArray()) {
                int len = Array.getLength(object);
                if (len > 0) {
                    value = Array.get(object, 0);
                }
            } else {
                value = object;
            }
        }
        return value;
    }

    public static <T> List<T> array2list(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        if (null != arrays) {
            for (T[] array : arrays) {
                if (null == array) continue;
                for (T item : array) {
                    if (item instanceof Collection) {
                        list.addAll((Collection)item);
                        continue;
                    }
                    list.add(item);
                }
            }
        }
        return list;
    }

    public static <T> List<List<T>> descartes(List<List<T>> lists) {
        ArrayList<List<Object>> result = new ArrayList<List<T>>();
        if (null == lists || lists.size() == 0) {
            return result;
        }
        List<T> st = lists.get(0);
        for (T t : st) {
            ArrayList<T> tmp = new ArrayList<T>();
            tmp.add(t);
            result.add(tmp);
        }
        ArrayList store = new ArrayList();
        for (int i = 1; i < lists.size(); ++i) {
            List<T> r2 = lists.get(i);
            for (int j = 0; j < result.size(); ++j) {
                List rns = (List)result.get(j);
                for (int k = 0; k < r2.size(); ++k) {
                    ArrayList<T> mid = new ArrayList<T>();
                    mid.addAll(rns);
                    mid.add(r2.get(k));
                    store.add(mid);
                }
            }
            result = new ArrayList();
            result.addAll(store);
            store = new ArrayList();
        }
        return result;
    }

    public static <T> List<List<T>> descartes(List<T> ... lists) {
        return BeanUtil.descartes(BeanUtil.array2list(new List[][]{lists}));
    }

    public static <T> T[] merge(T[] array, T[] ... items) {
        Object[] result = null;
        int len = array.length;
        Class<?> clazz = null;
        if (null != items) {
            block0: for (T[] item : items) {
                if (null == item) continue;
                len += array.length;
                if (null != array || null != clazz) continue;
                for (T obj : item) {
                    if (null == obj) continue;
                    clazz = obj.getClass();
                    continue block0;
                }
            }
        }
        if (null != array) {
            result = Arrays.copyOf(array, len);
        } else if (null != clazz) {
            result = (Object[])Array.newInstance(clazz, len);
        } else {
            return null;
        }
        int offset = array.length;
        if (null != items) {
            for (T[] item : items) {
                if (null == item) continue;
                System.arraycopy(item, 0, result, offset, item.length);
                offset += item.length;
            }
        }
        return result;
    }

    public static <K, V> Map<K, V> merge(Map<K, V> ... maps) {
        HashMap result = new HashMap();
        if (null != maps) {
            for (Map<K, V> map : maps) {
                BeanUtil.join(result, map, true);
            }
        }
        return result;
    }

    public static <K, V> Map<K, V> join(Map<K, V> src, Map<K, V> copy, boolean over) {
        if (null == src) {
            src = new HashMap();
        }
        if (null != copy) {
            for (K key : copy.keySet()) {
                if (!over && src.containsKey(key)) continue;
                src.put(key, copy.get(key));
            }
        }
        return src;
    }

    public static <T> List<T> merge(Collection<T> list, T ... items) {
        ArrayList<T> result = new ArrayList<T>();
        if (null != list) {
            result.addAll(list);
        }
        if (null != items) {
            for (T item : items) {
                result.add(item);
            }
        }
        return result;
    }

    public static <T> List<T> merge(List<T> list, T ... items) {
        ArrayList<T> result = new ArrayList<T>();
        if (null != list) {
            result.addAll(list);
        }
        if (null != items) {
            for (T item : items) {
                result.add(item);
            }
        }
        return result;
    }

    public static <T> List<T> join(List<T> list, T ... items) {
        if (null == list) {
            list = new ArrayList<T>();
        }
        if (null != items) {
            for (T item : items) {
                list.add(item);
            }
        }
        return list;
    }

    public static <T> Collection<T> join(Collection<T> list, T ... items) {
        if (null == list) {
            list = new ArrayList<T>();
        }
        if (null != items) {
            for (T item : items) {
                list.add(item);
            }
        }
        return list;
    }

    public static <T> void join(boolean distinct, Collection<T> list, Collection<T> appends) {
        for (T append : appends) {
            if (distinct && BeanUtil.contains(list, append)) continue;
            list.add(append);
        }
    }

    public static <T> void join(boolean distinct, Collection<T> list, T ... appends) {
        for (T append : appends) {
            if (distinct && BeanUtil.contains(list, append)) continue;
            list.add(append);
        }
    }

    public static <T> boolean contains(Collection<T> list, Object item) {
        for (T i : list) {
            if (null == i && null == item) {
                return true;
            }
            if (null == i || !i.toString().equalsIgnoreCase(item.toString())) continue;
            return true;
        }
        return false;
    }

    public static String parseRuntimeValue(Object obj, String key) {
        return BeanUtil.parseRuntimeValue(obj, key, false);
    }

    public static String parseRuntimeValue(Object obj, String key, boolean encrypt) {
        if (null == obj) {
            return key;
        }
        String value = key;
        if (BasicUtil.isNotEmpty(key)) {
            if (key.contains("${")) {
                value = BeanUtil.parseFinalValue(obj, key);
            } else {
                Object val = BeanUtil.getFieldValue(obj, key);
                if (null != val) {
                    value = val.toString();
                    if (encrypt) {
                        value = DESUtil.encryptValue(value);
                    }
                } else {
                    value = null;
                }
            }
        }
        if (!ConfigTable.IS_DEBUG || log.isInfoEnabled()) {
            // empty if block
        }
        return value;
    }

    public static Map<String, Object> copy(Map<String, Object> into, Map<String, Object> copy, List<String> keys) {
        if (null == copy) {
            return into;
        }
        if (null != keys) {
            for (String key : keys) {
                String[] ks = BeanUtil.parseKeyValue(key);
                into.put(ks[0], copy.get(ks[1]));
            }
        }
        return into;
    }

    public static Map<String, Object> copy(Map<String, Object> into, Map<String, Object> copy, String ... keys) {
        if (null == copy) {
            return into;
        }
        if (null != keys) {
            for (String key : keys) {
                String[] ks = BeanUtil.parseKeyValue(key);
                into.put(ks[0], copy.get(ks[1]));
            }
        }
        return into;
    }

    public static Map<String, Object> copy(Map<String, Object> into, Map<String, Object> copy) {
        return BeanUtil.copy(into, copy, BeanUtil.getMapKeys(copy));
    }

    public static <T> T query(Collection<T> datas, Map<String, Object> kvs) {
        List<T> list = BeanUtil.querys(datas, 0, 1, kvs);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static <T> List<T> querys(Collection<T> datas, int begin, String ... params) {
        return BeanUtil.querys(datas, begin, 0, params);
    }

    public static <T> List<T> querys(Collection<T> datas, String ... params) {
        return BeanUtil.querys(datas, 0, params);
    }

    public static <T> List<T> querys(Collection<T> datas, int begin, int qty, String ... params) {
        HashMap<String, Object> kvs = new HashMap<String, Object>();
        int len = params.length;
        int i = 0;
        String srcFlagTag = "srcFlag";
        while (i < len) {
            String p1 = params[i];
            if (BasicUtil.isEmpty((Object)p1)) {
                ++i;
                continue;
            }
            if (p1.contains(":")) {
                String[] ks = BeanUtil.parseKeyValue(p1);
                kvs.put(ks[0], ks[1]);
                ++i;
                continue;
            }
            if (i + 1 < len) {
                String p2 = params[i + 1];
                if (BasicUtil.isEmpty((Object)p2) || !p2.contains(":")) {
                    kvs.put(p1, p2);
                    i += 2;
                    continue;
                }
                if (BasicUtil.checkEl(p2)) {
                    p2 = p2.substring(2, p2.length() - 1);
                    kvs.put(p1, p2);
                    kvs.put(p1 + srcFlagTag, "true");
                    i += 2;
                    continue;
                }
                String[] ks = BeanUtil.parseKeyValue(p2);
                kvs.put(ks[0], ks[1]);
                i += 2;
                continue;
            }
            ++i;
        }
        return BeanUtil.querys(datas, begin, qty, kvs);
    }

    public static <T> List<T> querys(Collection<T> datas, int begin, int qty, Map<String, Object> kvs) {
        ArrayList<T> set = new ArrayList<T>();
        String srcFlagTag = "srcFlag";
        for (T row : datas) {
            boolean chk = true;
            for (String k : kvs.keySet()) {
                boolean srcFlag = false;
                if (k.endsWith(srcFlagTag)) continue;
                String srcFlagValue = String.valueOf(kvs.get(k + srcFlagTag));
                if (BasicUtil.isNotEmpty(srcFlagValue)) {
                    srcFlag = true;
                }
                Object v = String.valueOf(kvs.get(k));
                Object value = BeanUtil.getFieldValue(row, k);
                if (null == v) {
                    if (null != value) {
                        chk = false;
                        break;
                    }
                    chk = true;
                    break;
                }
                if (null == value) {
                    chk = false;
                    break;
                }
                Object str = String.valueOf(value);
                str = ((String)str).toLowerCase();
                v = ((String)v).toLowerCase();
                if (srcFlag) {
                    v = "${" + (String)v + "}";
                }
                if (((String)v).equals(str)) continue;
                chk = false;
                break;
            }
            if (!chk) continue;
            set.add(row);
            if (qty <= 0 || set.size() < qty) continue;
            break;
        }
        return set;
    }

    private static String concatValue(Map<String, Object> row, String split) {
        StringBuilder builder = new StringBuilder();
        List<String> keys = BeanUtil.getMapKeys(row);
        for (String key : keys) {
            if (builder.length() > 0) {
                builder.append(split);
            }
            builder.append(row.get(key));
        }
        return builder.toString();
    }

    public static <T> List<Map<String, Object>> pivot(Collection<T> datas, List<String> pks, List<String> classKeys, List<String> valueKeys) {
        List<Map<String, Object>> result = BeanUtil.objects2maps(BeanUtil.distinct(datas, pks), pks);
        List<Map<String, Object>> classValues = BeanUtil.objects2maps(BeanUtil.distinct(datas, classKeys), classKeys);
        for (Map<String, Object> row : result) {
            for (Map<String, Object> classValue : classValues) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                BeanUtil.copy(params, row, pks);
                BeanUtil.copy(params, classValue);
                T valueRow = BeanUtil.query(datas, params);
                String finalKey = BeanUtil.concatValue(classValue, "-");
                if (null != valueKeys && !valueKeys.isEmpty()) {
                    if (valueKeys.size() == 1) {
                        if (null != valueRow) {
                            row.put(finalKey, BeanUtil.getFieldValue(valueRow, valueKeys.get(0)));
                            continue;
                        }
                        row.put(finalKey, null);
                        continue;
                    }
                    for (String valueKey : valueKeys) {
                        if (null != valueRow) {
                            row.put(finalKey + "-" + valueKey, BeanUtil.getFieldValue(valueRow, valueKey));
                            continue;
                        }
                        row.put(finalKey + "-" + valueKey, null);
                    }
                    continue;
                }
                if (null != valueRow) {
                    row.put(finalKey, valueRow);
                    continue;
                }
                row.put(finalKey, null);
            }
        }
        return result;
    }

    public static <T> List<Map<String, Object>> pivot(Collection<T> datas, String[] pks, String[] classKeys, String[] valueKeys) {
        return BeanUtil.pivot(datas, BeanUtil.array2list(new String[][]{pks}), BeanUtil.array2list(new String[][]{classKeys}), BeanUtil.array2list(new String[][]{valueKeys}));
    }

    public static <T> List<Map<String, Object>> pivot(Collection<T> datas, String pk, String classKey, String valueKey) {
        List<String> pks = BeanUtil.array2list(new String[][]{pk.trim().split(",")});
        List<String> classKeys = BeanUtil.array2list(new String[][]{classKey.trim().split(",")});
        List<String> valueKeys = BeanUtil.array2list(new String[][]{valueKey.trim().split(",")});
        return BeanUtil.pivot(datas, pks, classKeys, valueKeys);
    }

    public static <T> List<Map<String, Object>> pivot(Collection<T> datas, String pk, String classKey) {
        List<String> pks = BeanUtil.array2list(new String[][]{pk.trim().split(",")});
        List<String> classKeys = BeanUtil.array2list(new String[][]{classKey.trim().split(",")});
        ArrayList<String> valueKeys = new ArrayList<String>();
        return BeanUtil.pivot(datas, pks, classKeys, valueKeys);
    }

    public static <T> List<Map<String, Object>> pivot(Collection<T> datas, List<String> pks, List<String> classKeys, String ... valueKeys) {
        ArrayList<String> list = new ArrayList<String>();
        if (null != valueKeys) {
            for (String item : valueKeys) {
                list.add(item);
            }
        }
        return BeanUtil.pivot(datas, pks, classKeys, valueKeys);
    }

    private String concatValue(DataRow row, String split) {
        StringBuilder builder = new StringBuilder();
        List<String> keys = row.keys();
        for (String key : keys) {
            if (builder.length() > 0) {
                builder.append(split);
            }
            builder.append(row.getString(key));
        }
        return builder.toString();
    }

    private static String[] kvs(Map<String, Object> row) {
        List<String> keys = BeanUtil.getMapKeys(row);
        int size = keys.size();
        String[] kvs = new String[size * 2];
        for (int i = 0; i < size; ++i) {
            String k = keys.get(i);
            String value = null;
            Object v = row.get(k);
            if (null != v) {
                value = v.toString();
            }
            kvs[i * 2] = k;
            kvs[i * 2 + 1] = value;
        }
        return kvs;
    }

    public static List<String> distinct(Collection<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> check = new ArrayList<String>();
        if (null != list) {
            for (String item : list) {
                String upper = item.toUpperCase();
                if (check.contains(upper)) continue;
                result.add(item);
                check.add(upper);
            }
        }
        return result;
    }

    public static <T> List<List<T>> page(Collection<T> origin, int vol) {
        ArrayList<List<T>> list = new ArrayList<List<T>>();
        if (vol <= 0) {
            vol = 1;
        }
        int size = origin.size();
        int page = (size - 1) / vol + 1;
        for (int i = 0; i < page; ++i) {
            int fr = i * vol;
            int to = (i + 1) * vol - 1;
            if (i == page - 1) {
                to = size - 1;
            }
            List<T> item = BeanUtil.cuts(origin, fr, to);
            list.add(item);
        }
        return list;
    }

    public static <T> List<List<T>> split(Collection<T> origin, int page) {
        ArrayList<List<T>> list = new ArrayList<List<T>>();
        int size = origin.size();
        if (page <= 0) {
            page = 1;
        }
        if (page > size) {
            page = size;
        }
        int vol = size / page;
        int dif = size - vol * page;
        int fr = 0;
        int to = 0;
        for (int i = 0; i < page; ++i) {
            to = fr + vol - 1;
            if (dif > 0) {
                ++to;
                --dif;
            }
            if (to >= size) {
                to = size - 1;
            }
            List<T> item = BeanUtil.cuts(origin, fr, to);
            list.add(item);
            fr = to + 1;
        }
        return list;
    }

    public static List<String> removeAll(List<String> src, List<String> remove) {
        ArrayList<String> check = new ArrayList<String>();
        if (null != src) {
            remove = BeanUtil.toUpperCase(remove);
            for (String item : src) {
                if (null == item || !remove.contains(item.toUpperCase())) continue;
                check.add(item);
            }
            src.removeAll(check);
        }
        return src;
    }

    public static List<String> removeAll(List<String> src, String ... remove) {
        return BeanUtil.removeAll(src, BeanUtil.array2list(new String[][]{remove}));
    }

    public static <T> List<T> copy(Collection<T> list) {
        return BeanUtil.merge(list, new Object[0]);
    }

    public static <T> Collection<T> copy(Collection<T> tar, Collection<T> ... items) {
        if (null != tar && null != items) {
            for (Collection<T> item : items) {
                tar.addAll(item);
            }
        }
        return tar;
    }

    public static void copyFieldValueNvl(Object src, Object copy) {
        if (null == src || null == copy) {
            return;
        }
        List<Field> fields = ClassUtil.getFields(src.getClass());
        for (Field field : fields) {
            Object value = BeanUtil.getFieldValue(src, field);
            if (null != value) continue;
            value = BeanUtil.getFieldValue(copy, field);
            BeanUtil.setFieldValue(src, field, value);
        }
    }

    public static void copyFieldValue(Object to, Object copy) {
        List<Field> fields = ClassUtil.getFields(to.getClass(), false, false);
        for (Field field : fields) {
            BeanUtil.setFieldValue(to, field, BeanUtil.getFieldValue(copy, field));
        }
    }

    public static void copyFieldValueWithoutNull(Object to, Object copy) {
        List<Field> fields = ClassUtil.getFields(to.getClass());
        for (Field field : fields) {
            Object value = BeanUtil.getFieldValue(copy, field);
            if (null == value) continue;
            BeanUtil.setFieldValue(to, field, value);
        }
    }

    public static boolean checkIsNew(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            return row.isNew();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return !BasicUtil.isNotEmpty(map.get(ConfigTable.DEFAULT_PRIMARY_KEY)) && !BasicUtil.isNotEmpty(map.get(ConfigTable.DEFAULT_PRIMARY_KEY.toLowerCase())) && !BasicUtil.isNotEmpty(map.get(ConfigTable.DEFAULT_PRIMARY_KEY.toUpperCase()));
        }
        Map<String, Object> values = EntityAdapterProxy.primaryValues(obj);
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (!BasicUtil.isNotEmpty(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static Object value(Map map, String keys, Map<String, HashSet<String>> alias) {
        return BeanUtil.value(map, keys, alias, Object.class, null);
    }

    public static <T> T value(Map map, String keys, Map<String, HashSet<String>> alias, Class<T> clazz, T def) {
        Object result = null;
        String[] ks = keys.split(",");
        Object value = null;
        for (String key : ks) {
            HashSet<String> aliasList;
            value = map.get(key);
            if (null == value && null != (aliasList = alias.get(key))) {
                String item;
                Iterator<String> iterator = aliasList.iterator();
                while (iterator.hasNext() && null == (value = map.get(item = iterator.next()))) {
                }
            }
            if (null != value) break;
        }
        if (null != value) {
            result = ConvertProxy.convert(value, clazz, false);
        }
        if (null == result) {
            result = def;
        }
        return (T)result;
    }

    static {
        DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
        JSON_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        JSON_MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        JSON_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JSON_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        JSON_MAPPER.configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DATETIME_FORMATTER));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATETIME_FORMATTER));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
        JSON_MAPPER.registerModule((Module)javaTimeModule);
        JSON_MAPPER.setTimeZone(TimeZone.getDefault());
        arr = new ArrayList<String>();
    }
}

